/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.converter.v0_10_v1_0;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedHashMap;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.converter.MessageConversionException;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.protocol.v0_10.transport.DeliveryProperties;
import org.apache.qpid.server.protocol.v0_10.transport.MessageDeliveryMode;
import org.apache.qpid.server.protocol.v0_10.transport.MessageProperties;
import org.apache.qpid.server.protocol.v0_10.transport.ReplyTo;
import org.apache.qpid.server.protocol.v1_0.MessageConverter_to_1_0;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionEncoder;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedByte;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.server.protocol.v1_0.type.messaging.DataSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.EncodingRetainingSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Header;
import org.apache.qpid.server.protocol.v1_0.type.messaging.MessageAnnotations;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Properties;

@PluggableService
public class MessageConverter_0_10_to_1_0
extends MessageConverter_to_1_0<MessageTransferMessage> {
    public Class<MessageTransferMessage> getInputClass() {
        return MessageTransferMessage.class;
    }

    protected MessageMetaData_1_0 convertMetaData(MessageTransferMessage serverMessage, EncodingRetainingSection<?> bodySection, SectionEncoder sectionEncoder) {
        Properties props = new Properties();
        props.setCreationTime(new Date(serverMessage.getArrivalTime()));
        MessageProperties msgProps = serverMessage.getHeader().getMessageProperties();
        DeliveryProperties deliveryProps = serverMessage.getHeader().getDeliveryProperties();
        Header header = new Header();
        if (deliveryProps != null) {
            header.setDurable(Boolean.valueOf(deliveryProps.hasDeliveryMode() && deliveryProps.getDeliveryMode() == MessageDeliveryMode.PERSISTENT));
            if (deliveryProps.hasPriority()) {
                header.setPriority(UnsignedByte.valueOf((byte)((byte)deliveryProps.getPriority().getValue())));
            }
            if (deliveryProps.hasTtl()) {
                header.setTtl(UnsignedInteger.valueOf((long)deliveryProps.getTtl()));
            } else if (deliveryProps.hasExpiration()) {
                long ttl = Math.max(0L, deliveryProps.getExpiration() - serverMessage.getArrivalTime());
                header.setTtl(UnsignedInteger.valueOf((long)ttl));
            }
            if (deliveryProps.hasTimestamp()) {
                props.setCreationTime(new Date(deliveryProps.getTimestamp()));
            }
            String to = deliveryProps.getExchange();
            if (deliveryProps.getRoutingKey() != null) {
                String routingKey = deliveryProps.getRoutingKey();
                to = to != null && !"".equals(to) ? to + "/" + routingKey : routingKey;
            }
            props.setTo(to);
        }
        ApplicationProperties applicationProperties = null;
        String originalContentMimeType = null;
        if (msgProps != null) {
            LinkedHashMap applicationPropertiesMap;
            if (msgProps.hasContentEncoding() && !"gzip".equals(msgProps.getContentEncoding()) && bodySection instanceof DataSection) {
                props.setContentEncoding(Symbol.valueOf((String)msgProps.getContentEncoding()));
            }
            if (msgProps.hasCorrelationId()) {
                CharsetDecoder charsetDecoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                try {
                    String correlationIdAsString = charsetDecoder.decode(ByteBuffer.wrap(msgProps.getCorrelationId())).toString();
                    props.setCorrelationId((Object)correlationIdAsString);
                }
                catch (CharacterCodingException e) {
                    props.setCorrelationId((Object)new Binary(msgProps.getCorrelationId()));
                }
            }
            if (msgProps.hasMessageId()) {
                props.setMessageId((Object)msgProps.getMessageId());
            }
            if (msgProps.hasReplyTo()) {
                ReplyTo replyTo = msgProps.getReplyTo();
                String to = null;
                if (replyTo.hasExchange() && !"".equals(replyTo.getExchange())) {
                    to = replyTo.getExchange();
                }
                if (replyTo.hasRoutingKey()) {
                    to = to != null ? to + "/" + replyTo.getRoutingKey() : replyTo.getRoutingKey();
                }
                props.setReplyTo(to);
            }
            if (msgProps.hasContentType()) {
                originalContentMimeType = msgProps.getContentType();
                Symbol contentType = MessageConverter_to_1_0.getContentType((String)originalContentMimeType);
                props.setContentType(contentType);
            }
            if (msgProps.hasUserId()) {
                props.setUserId(new Binary(msgProps.getUserId()));
            }
            if ((applicationPropertiesMap = msgProps.getApplicationHeaders()) != null) {
                Object jmsxGroupSeq;
                if ((applicationPropertiesMap = new LinkedHashMap(applicationPropertiesMap)).containsKey("x-jms-type")) {
                    props.setSubject(String.valueOf(applicationPropertiesMap.get("x-jms-type")));
                    applicationPropertiesMap.remove("x-jms-type");
                }
                if (applicationPropertiesMap.containsKey("qpid.subject")) {
                    props.setSubject(String.valueOf(applicationPropertiesMap.get("qpid.subject")));
                    applicationPropertiesMap.remove("qpid.subject");
                }
                if (applicationPropertiesMap.containsKey("JMSXGroupID")) {
                    props.setGroupId(String.valueOf(applicationPropertiesMap.get("JMSXGroupID")));
                    applicationPropertiesMap.remove("JMSXGroupID");
                }
                if (applicationPropertiesMap.containsKey("JMSXGroupSeq") && (jmsxGroupSeq = applicationPropertiesMap.get("JMSXGroupSeq")) instanceof Integer) {
                    props.setGroupSequence(UnsignedInteger.valueOf((int)((Integer)jmsxGroupSeq)));
                    applicationPropertiesMap.remove("JMSXGroupSeq");
                }
                try {
                    applicationProperties = new ApplicationProperties(applicationPropertiesMap);
                }
                catch (IllegalArgumentException e) {
                    throw new MessageConversionException("Could not convert message from 0-10 to 1.0 because application headers conversion failed.", (Throwable)e);
                }
            }
        }
        MessageAnnotations messageAnnotation = MessageConverter_to_1_0.createMessageAnnotation(bodySection, originalContentMimeType);
        return new MessageMetaData_1_0(header.createEncodingRetainingSection(), null, messageAnnotation == null ? null : messageAnnotation.createEncodingRetainingSection(), props.createEncodingRetainingSection(), applicationProperties == null ? null : applicationProperties.createEncodingRetainingSection(), null, serverMessage.getArrivalTime(), bodySection.getEncodedSize());
    }

    public String getType() {
        return "v0-10 to v1-0";
    }
}

