/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.qpid.server.management.plugin.ManagementController;
import org.apache.qpid.server.management.plugin.ManagementException;
import org.apache.qpid.server.management.plugin.ManagementResponse;
import org.apache.qpid.server.management.plugin.controller.CategoryController;
import org.apache.qpid.server.management.plugin.controller.LegacyConfiguredObject;
import org.apache.qpid.server.management.plugin.controller.LegacyManagementController;
import org.apache.qpid.server.management.plugin.controller.TypeController;
import org.apache.qpid.server.management.plugin.controller.latest.LatestManagementControllerAdapter;
import org.apache.qpid.server.model.ConfiguredObject;

public abstract class GenericCategoryController
implements CategoryController {
    private final String _name;
    private final LegacyManagementController _managementController;
    private final ManagementController _nextVersionManagementController;
    private final String _defaultType;
    private final Map<String, TypeController> _typeControllers;
    private final Map<String, TypeController> _nextVersionTypeControllers;

    protected GenericCategoryController(LegacyManagementController managementController, ManagementController nextVersionManagementController, String name, String defaultType, Set<TypeController> typeControllers) {
        this._name = name;
        this._managementController = managementController;
        boolean isNextLatest = nextVersionManagementController != null && "8.0".equalsIgnoreCase(nextVersionManagementController.getVersion());
        this._nextVersionManagementController = isNextLatest ? new LatestManagementControllerAdapter(nextVersionManagementController) : nextVersionManagementController;
        this._defaultType = defaultType;
        this._typeControllers = typeControllers.stream().collect(Collectors.toMap(TypeController::getTypeName, c -> c));
        this._nextVersionTypeControllers = typeControllers.stream().collect(Collectors.toMap(TypeController::getNextVersionTypeName, c -> c));
    }

    @Override
    public String getCategory() {
        return this._name;
    }

    @Override
    public String getNextVersionCategory() {
        return this._name;
    }

    @Override
    public String getDefaultType() {
        return this._defaultType;
    }

    @Override
    public LegacyManagementController getManagementController() {
        return this._managementController;
    }

    @Override
    public Object get(ConfiguredObject<?> root, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        Object content = this._nextVersionManagementController.get(root, this.getNextVersionCategory(), path, this.convertQueryParametersToNextVersion(parameters));
        return this.convert(content);
    }

    @Override
    public LegacyConfiguredObject createOrUpdate(ConfiguredObject<?> root, List<String> path, Map<String, Object> attributes, boolean isPost) throws ManagementException {
        Map<String, Object> body = this.convertAttributesToNextVersion(root, path, attributes);
        Object configuredObject = this._nextVersionManagementController.createOrUpdate(root, this.getNextVersionCategory(), path, body, isPost);
        if (configuredObject instanceof LegacyConfiguredObject) {
            LegacyConfiguredObject object = (LegacyConfiguredObject)configuredObject;
            return this.convertFromNextVersion(object);
        }
        return null;
    }

    @Override
    public LegacyConfiguredObject convertFromNextVersion(LegacyConfiguredObject object) {
        TypeController controller = this.getTypeController(object);
        if (controller != null) {
            return controller.convertFromNextVersion(object);
        }
        return this.convertNextVersionLegacyConfiguredObject(object);
    }

    @Override
    public int delete(ConfiguredObject<?> root, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        return this._nextVersionManagementController.delete(root, this.getNextVersionCategory(), path, this.convertQueryParametersToNextVersion(parameters));
    }

    @Override
    public ManagementResponse invoke(ConfiguredObject<?> root, List<String> path, String operation, Map<String, Object> parameters, boolean isPost, boolean isSecure) throws ManagementException {
        Object result = this.get(root, path, Collections.emptyMap());
        if (result instanceof LegacyConfiguredObject) {
            LegacyConfiguredObject legacyConfiguredObject = (LegacyConfiguredObject)result;
            return legacyConfiguredObject.invoke(operation, parameters, isSecure);
        }
        throw ManagementException.createBadRequestManagementException(String.format("Configured object %s/%s is not found", this.getManagementController().getCategoryMapping(this.getCategory()), String.join((CharSequence)"/", path)));
    }

    @Override
    public Object getPreferences(ConfiguredObject<?> root, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        return this._nextVersionManagementController.getPreferences(root, this.getNextVersionCategory(), path, parameters);
    }

    @Override
    public void setPreferences(ConfiguredObject<?> root, List<String> path, Object preferences, Map<String, List<String>> parameters, boolean isPost) throws ManagementException {
        this._nextVersionManagementController.setPreferences(root, this.getNextVersionCategory(), path, preferences, parameters, isPost);
    }

    @Override
    public int deletePreferences(ConfiguredObject<?> root, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        return this._nextVersionManagementController.deletePreferences(root, this.getNextVersionCategory(), path, parameters);
    }

    protected abstract LegacyConfiguredObject convertNextVersionLegacyConfiguredObject(LegacyConfiguredObject var1);

    protected Map<String, List<String>> convertQueryParametersToNextVersion(Map<String, List<String>> parameters) {
        return parameters;
    }

    protected ManagementController getNextVersionManagementController() {
        return this._nextVersionManagementController;
    }

    protected Map<String, Object> convertAttributesToNextVersion(ConfiguredObject<?> root, List<String> path, Map<String, Object> attributes) {
        TypeController typeController = this.getTypeController(attributes);
        if (typeController != null) {
            return typeController.convertAttributesToNextVersion(root, path, attributes);
        }
        return attributes;
    }

    private Object convert(Object content) {
        if (content instanceof LegacyConfiguredObject) {
            return this.convertFromNextVersion((LegacyConfiguredObject)content);
        }
        if (content instanceof Collection) {
            Collection items = (Collection)content;
            return items.stream().filter(LegacyConfiguredObject.class::isInstance).map(LegacyConfiguredObject.class::cast).map(this::convertFromNextVersion).collect(Collectors.toList());
        }
        throw ManagementException.createInternalServerErrorManagementException("Unexpected data format from next version");
    }

    private TypeController getTypeController(Map<String, Object> attributes) {
        String type = (String)attributes.get("type");
        if (type == null) {
            type = this.getDefaultType();
        }
        if (type != null) {
            return this._typeControllers.get(type);
        }
        return null;
    }

    protected TypeController getTypeController(LegacyConfiguredObject object) {
        String type = (String)object.getAttribute("type");
        return this._nextVersionTypeControllers.get(type);
    }
}

