/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.policy;

import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.JmsSession;
import org.apache.qpid.jms.policy.JmsPrefetchPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsDefaultPrefetchPolicy
implements JmsPrefetchPolicy {
    public static final int MAX_PREFETCH_SIZE = Short.MAX_VALUE;
    public static final int DEFAULT_QUEUE_PREFETCH = 1000;
    public static final int DEFAULT_QUEUE_BROWSER_PREFETCH = 1000;
    public static final int DEFAULT_DURABLE_TOPIC_PREFETCH = 1000;
    public static final int DEFAULT_TOPIC_PREFETCH = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(JmsDefaultPrefetchPolicy.class);
    private int queuePrefetch;
    private int queueBrowserPrefetch;
    private int topicPrefetch;
    private int durableTopicPrefetch;
    private int maxPrefetchSize = Short.MAX_VALUE;

    public JmsDefaultPrefetchPolicy() {
        this.queuePrefetch = 1000;
        this.queueBrowserPrefetch = 1000;
        this.topicPrefetch = 1000;
        this.durableTopicPrefetch = 1000;
    }

    public JmsDefaultPrefetchPolicy(JmsDefaultPrefetchPolicy source) {
        this.queuePrefetch = source.getQueuePrefetch();
        this.queueBrowserPrefetch = source.getQueueBrowserPrefetch();
        this.topicPrefetch = source.getTopicPrefetch();
        this.durableTopicPrefetch = source.getDurableTopicPrefetch();
        this.maxPrefetchSize = source.getMaxPrefetchSize();
    }

    @Override
    public JmsDefaultPrefetchPolicy copy() {
        return new JmsDefaultPrefetchPolicy(this);
    }

    @Override
    public int getConfiguredPrefetch(JmsSession session, JmsDestination destination, boolean durable, boolean browser) {
        int prefetch = 0;
        prefetch = destination.isTopic() ? (durable ? this.getDurableTopicPrefetch() : this.getTopicPrefetch()) : (browser ? this.getQueueBrowserPrefetch() : this.getQueuePrefetch());
        return prefetch;
    }

    public int getDurableTopicPrefetch() {
        return this.durableTopicPrefetch;
    }

    public void setDurableTopicPrefetch(int durableTopicPrefetch) {
        this.durableTopicPrefetch = this.getMaxPrefetchLimit(durableTopicPrefetch);
    }

    public int getQueuePrefetch() {
        return this.queuePrefetch;
    }

    public void setQueuePrefetch(int queuePrefetch) {
        this.queuePrefetch = this.getMaxPrefetchLimit(queuePrefetch);
    }

    public int getQueueBrowserPrefetch() {
        return this.queueBrowserPrefetch;
    }

    public void setQueueBrowserPrefetch(int queueBrowserPrefetch) {
        this.queueBrowserPrefetch = this.getMaxPrefetchLimit(queueBrowserPrefetch);
    }

    public int getTopicPrefetch() {
        return this.topicPrefetch;
    }

    public void setTopicPrefetch(int topicPrefetch) {
        this.topicPrefetch = this.getMaxPrefetchLimit(topicPrefetch);
    }

    public int getMaxPrefetchSize() {
        return this.maxPrefetchSize;
    }

    public void setMaxPrefetchSize(int maxPrefetchSize) {
        this.maxPrefetchSize = maxPrefetchSize;
    }

    public void setAll(int prefetch) {
        this.durableTopicPrefetch = this.getMaxPrefetchLimit(prefetch);
        this.queueBrowserPrefetch = this.getMaxPrefetchLimit(prefetch);
        this.queuePrefetch = this.getMaxPrefetchLimit(prefetch);
        this.topicPrefetch = this.getMaxPrefetchLimit(prefetch);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.durableTopicPrefetch;
        result = 31 * result + this.maxPrefetchSize;
        result = 31 * result + this.queueBrowserPrefetch;
        result = 31 * result + this.queuePrefetch;
        result = 31 * result + this.topicPrefetch;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JmsDefaultPrefetchPolicy other = (JmsDefaultPrefetchPolicy)obj;
        return this.queuePrefetch == other.queuePrefetch && this.queueBrowserPrefetch == other.queueBrowserPrefetch && this.topicPrefetch == other.topicPrefetch && this.durableTopicPrefetch == other.durableTopicPrefetch;
    }

    private int getMaxPrefetchLimit(int value) {
        int result = Math.min(value, this.maxPrefetchSize);
        if (result < value) {
            LOG.warn("maximum prefetch limit has been reset from " + value + " to 32767");
        }
        return result;
    }
}

