/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.binder.segment.select.orderby.engine;

import java.util.LinkedList;
import org.apache.shardingsphere.sql.parser.binder.segment.select.groupby.GroupByContext;
import org.apache.shardingsphere.sql.parser.binder.segment.select.orderby.OrderByContext;
import org.apache.shardingsphere.sql.parser.binder.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.sql.parser.sql.constant.OrderDirection;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.SelectStatement;

public final class OrderByContextEngine {
    public OrderByContext createOrderBy(SelectStatement selectStatement, GroupByContext groupByContext) {
        if (!selectStatement.getOrderBy().isPresent() || ((OrderBySegment)selectStatement.getOrderBy().get()).getOrderByItems().isEmpty()) {
            OrderByContext orderByItems = this.createOrderByContextForDistinctRowWithoutGroupBy(selectStatement, groupByContext);
            return null != orderByItems ? orderByItems : new OrderByContext(groupByContext.getItems(), !groupByContext.getItems().isEmpty());
        }
        LinkedList<OrderByItem> orderByItems = new LinkedList<OrderByItem>();
        for (OrderByItemSegment each : ((OrderBySegment)selectStatement.getOrderBy().get()).getOrderByItems()) {
            OrderByItem orderByItem = new OrderByItem(each);
            if (each instanceof IndexOrderByItemSegment) {
                orderByItem.setIndex(((IndexOrderByItemSegment)each).getColumnIndex());
            }
            orderByItems.add(orderByItem);
        }
        return new OrderByContext(orderByItems, false);
    }

    private OrderByContext createOrderByContextForDistinctRowWithoutGroupBy(SelectStatement selectStatement, GroupByContext groupByContext) {
        if (groupByContext.getItems().isEmpty() && selectStatement.getProjections().isDistinctRow()) {
            int index = 0;
            LinkedList<OrderByItem> orderByItems = new LinkedList<OrderByItem>();
            for (ProjectionSegment projectionSegment : selectStatement.getProjections().getProjections()) {
                if (!(projectionSegment instanceof ColumnProjectionSegment)) continue;
                ColumnProjectionSegment columnProjectionSegment = (ColumnProjectionSegment)projectionSegment;
                ColumnOrderByItemSegment columnOrderByItemSegment = new ColumnOrderByItemSegment(columnProjectionSegment.getColumn(), OrderDirection.ASC);
                OrderByItem item = new OrderByItem((OrderByItemSegment)columnOrderByItemSegment);
                item.setIndex(index++);
                orderByItems.add(item);
            }
            if (!orderByItems.isEmpty()) {
                return new OrderByContext(orderByItems, true);
            }
        }
        return null;
    }
}

