/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth2;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.social.core.oauth2.OAuth2Code;
import org.apache.shindig.social.core.oauth2.OAuth2Exception;
import org.apache.shindig.social.core.oauth2.OAuth2NormalizedRequest;
import org.apache.shindig.social.core.oauth2.OAuth2NormalizedResponse;
import org.apache.shindig.social.core.oauth2.OAuth2Service;
import org.apache.shindig.social.core.oauth2.OAuth2Types;

public class OAuth2TokenHandler {
    private OAuth2Service service;

    public OAuth2TokenHandler(OAuth2Service service) {
        this.service = service;
    }

    public OAuth2NormalizedResponse handle(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            OAuth2NormalizedRequest normalizedReq = new OAuth2NormalizedRequest(request);
            this.service.authenticateClient(normalizedReq);
            this.service.validateRequestForAccessToken(normalizedReq);
            OAuth2Code accessToken = this.service.grantAccessToken(normalizedReq);
            OAuth2NormalizedResponse normalizedResp = new OAuth2NormalizedResponse();
            normalizedResp.setAccessToken(accessToken.getValue());
            normalizedResp.setTokenType(OAuth2Types.TokenFormat.BEARER.toString());
            normalizedResp.setExpiresIn(accessToken.getExpiration() - System.currentTimeMillis() + "");
            normalizedResp.setScope(OAuth2TokenHandler.listToString(accessToken.getScope()));
            normalizedResp.setStatus(200);
            normalizedResp.setBodyReturned(true);
            if (normalizedReq.getState() != null) {
                normalizedResp.setState(normalizedReq.getState());
            }
            return normalizedResp;
        }
        catch (OAuth2Exception oae) {
            return oae.getNormalizedResponse();
        }
    }

    @VisibleForTesting
    protected static String listToString(List<String> list) {
        if (list == null) {
            return "";
        }
        return Joiner.on((char)' ').join(list);
    }
}

