/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.sling.adapter.annotations.Adaptable;
import org.apache.sling.adapter.annotations.Adaptables;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.scannotation.AnnotationDB;

@Mojo(name="generate-adapter-metadata", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GenerateAdapterMetadataMojo
extends AbstractMojo {
    private static final int JSON_INDENTATION = 4;
    private static final String ADAPTABLE_DESC = "L" + Adaptable.class.getName().replace('.', '/') + ";";
    private static final String ADAPTABLES_DESC = "L" + Adaptables.class.getName().replace('.', '/') + ";";
    private static final String DEFAULT_CONDITION = "If the adaptable is a %s.";
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private File buildOutputDirectory;
    @Parameter(property="adapter.descriptor.name", defaultValue="SLING-INF/adapters.json")
    private String fileName;
    @Parameter(defaultValue="${project.build.directory}/adapter-plugin-generated", required=true, readonly=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    private static String getSimpleName(ClassNode clazz) {
        String internalName = clazz.name;
        int idx = internalName.lastIndexOf(47);
        if (idx == -1) {
            return internalName;
        }
        return internalName.substring(idx + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            JSONObject descriptor = new JSONObject();
            AnnotationDB annotationDb = new AnnotationDB();
            annotationDb.scanArchives(new URL[]{this.buildOutputDirectory.toURI().toURL()});
            HashSet<String> annotatedClassNames = new HashSet<String>();
            this.addAnnotatedClasses(annotationDb, annotatedClassNames, Adaptable.class);
            this.addAnnotatedClasses(annotationDb, annotatedClassNames, Adaptables.class);
            for (String annotatedClassName : annotatedClassNames) {
                ClassReader classReader;
                this.getLog().info((CharSequence)String.format("found adaptable annotation on %s", annotatedClassName));
                String pathToClassFile = annotatedClassName.replace('.', '/') + ".class";
                File classFile = new File(this.buildOutputDirectory, pathToClassFile);
                FileInputStream input = new FileInputStream(classFile);
                try {
                    classReader = new ClassReader((InputStream)input);
                }
                finally {
                    input.close();
                }
                ClassNode classNode = new ClassNode();
                classReader.accept((ClassVisitor)classNode, 7);
                List annotations = classNode.invisibleAnnotations;
                for (AnnotationNode annotation : annotations) {
                    if (ADAPTABLE_DESC.equals(annotation.desc)) {
                        this.parseAdaptableAnnotation(annotation, classNode, descriptor);
                        continue;
                    }
                    if (!ADAPTABLES_DESC.equals(annotation.desc)) continue;
                    this.parseAdaptablesAnnotation(annotation, classNode, descriptor);
                }
            }
            File outputFile = new File(this.outputDirectory, this.fileName);
            outputFile.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(outputFile);
            try {
                IOUtil.copy((String)descriptor.toString(4), (Writer)writer);
            }
            finally {
                IOUtil.close((Writer)writer);
            }
            this.addResource();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to generate metadata", (Exception)e);
        }
        catch (JSONException e) {
            throw new MojoExecutionException("Unable to generate metadata", (Exception)((Object)e));
        }
    }

    private void addAnnotatedClasses(AnnotationDB annotationDb, Set<String> annotatedClassNames, Class<? extends Annotation> clazz) {
        Set classNames = (Set)annotationDb.getAnnotationIndex().get(clazz.getName());
        if (classNames == null || classNames.isEmpty()) {
            this.getLog().debug((CharSequence)"No classes found with adaptable annotations.");
        } else {
            annotatedClassNames.addAll(classNames);
        }
    }

    private void addResource() {
        String ourRsrcPath = this.outputDirectory.getAbsolutePath();
        boolean found = false;
        Iterator rsrcIterator = this.project.getResources().iterator();
        while (!found && rsrcIterator.hasNext()) {
            Resource rsrc = (Resource)rsrcIterator.next();
            found = rsrc.getDirectory().equals(ourRsrcPath);
        }
        if (!found) {
            Resource resource = new Resource();
            resource.setDirectory(this.outputDirectory.getAbsolutePath());
            this.project.addResource(resource);
        }
    }

    private void parseAdaptablesAnnotation(AnnotationNode annotation, ClassNode classNode, JSONObject descriptor) throws JSONException {
        Iterator it = annotation.values.iterator();
        while (it.hasNext()) {
            Object name = it.next();
            Object value = it.next();
            if (!"value".equals(name)) continue;
            List annotations = (List)value;
            for (AnnotationNode innerAnnotation : annotations) {
                if (!ADAPTABLE_DESC.equals(innerAnnotation.desc)) continue;
                this.parseAdaptableAnnotation(innerAnnotation, classNode, descriptor);
            }
        }
    }

    private void parseAdaptableAnnotation(AnnotationNode annotation, ClassNode annotatedClass, JSONObject descriptor) throws JSONException {
        JSONObject adaptableDescription;
        String adaptableClassName = null;
        List adapters = null;
        List values = annotation.values;
        Iterator it = values.iterator();
        while (it.hasNext()) {
            Object name = it.next();
            Object value = it.next();
            if ("adaptableClass".equals(name)) {
                adaptableClassName = ((Type)value).getClassName();
                continue;
            }
            if (!"adapters".equals(name)) continue;
            adapters = (List)value;
        }
        if (adaptableClassName == null || adapters == null) {
            throw new IllegalArgumentException("Adaptable annotation is malformed. Expecting a classname and a list of adapter annotation.");
        }
        if (descriptor.has(adaptableClassName)) {
            adaptableDescription = descriptor.getJSONObject(adaptableClassName);
        } else {
            adaptableDescription = new JSONObject();
            descriptor.put(adaptableClassName, (Object)adaptableDescription);
        }
        for (AnnotationNode adapter : adapters) {
            this.parseAdapterAnnotation(adapter, annotatedClass, adaptableDescription);
        }
    }

    private void parseAdapterAnnotation(AnnotationNode annotation, ClassNode annotatedClass, JSONObject adaptableDescription) throws JSONException {
        String condition = null;
        List adapterClasses = null;
        List values = annotation.values;
        Iterator it = values.iterator();
        while (it.hasNext()) {
            Object name = it.next();
            Object value = it.next();
            if (StringUtils.isEmpty(condition)) {
                condition = String.format(DEFAULT_CONDITION, GenerateAdapterMetadataMojo.getSimpleName(annotatedClass));
            }
            if ("condition".equals(name)) {
                condition = (String)value;
                continue;
            }
            if (!"value".equals(name)) continue;
            adapterClasses = (List)value;
        }
        if (adapterClasses == null) {
            throw new IllegalArgumentException("Adapter annotation is malformed. Expecting a list of adapter classes");
        }
        for (Type adapterClass : adapterClasses) {
            adaptableDescription.accumulate(condition, (Object)adapterClass.getClassName());
        }
    }
}

