/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.bundlesupport.AbstractBundlePostMojo;
import org.apache.sling.maven.bundlesupport.deploy.BundleDeploymentMethod;
import org.apache.sling.maven.bundlesupport.deploy.DeployContext;
import org.apache.sling.maven.bundlesupport.fsresource.SlingInitialContentMounter;

abstract class AbstractBundleInstallMojo
extends AbstractBundlePostMojo {
    @Parameter(property="sling.usePut", defaultValue="false")
    protected boolean usePut;
    @Parameter(property="sling.deploy.method", required=false)
    protected BundleDeploymentMethod deploymentMethod;
    @Parameter(property="sling.mimeType", defaultValue="application/java-archive", required=true)
    protected String mimeType;
    @Parameter(property="sling.bundle.startlevel", defaultValue="20", required=true)
    private String bundleStartLevel;
    @Parameter(property="sling.bundle.start", defaultValue="true", required=true)
    private boolean bundleStart;
    @Parameter(property="sling.refreshPackages", defaultValue="true", required=true)
    private boolean refreshPackages;
    @Parameter(property="sling.mountByFS", defaultValue="false", required=true)
    private boolean mountByFS;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;

    protected abstract String getBundleFileName() throws MojoExecutionException;

    public void execute() throws MojoExecutionException {
        String bundleFileName = this.getBundleFileName();
        File bundleFile = new File(bundleFileName);
        if (!bundleFile.exists()) {
            this.getLog().info((CharSequence)(bundleFile + " does not exist, no uploading"));
            return;
        }
        String bundleName = this.getBundleSymbolicName(bundleFile);
        if (bundleName == null) {
            this.getLog().info((CharSequence)(bundleFile + " is not an OSGi Bundle, not uploading"));
            return;
        }
        String targetURL = this.getTargetURL();
        BundleDeploymentMethod deploymentMethod = this.getDeploymentMethod();
        this.getLog().info((CharSequence)("Installing Bundle " + bundleName + "(" + bundleFile + ") to " + targetURL + " via " + (Object)((Object)deploymentMethod)));
        deploymentMethod.execute().deploy(targetURL, bundleFile, bundleName, new DeployContext().log(this.getLog()).httpClient(this.getHttpClient()).failOnError(this.failOnError).bundleStartLevel(this.bundleStartLevel).bundleStart(this.bundleStart).mimeType(this.mimeType).refreshPackages(this.refreshPackages));
        if (this.mountByFS) {
            this.configure(this.getConsoleTargetURL(), bundleFile);
        }
    }

    protected void configure(String targetURL, File file) throws MojoExecutionException {
        new SlingInitialContentMounter(this.getLog(), this.getHttpClient(), this.project).mount(targetURL, file);
    }

    protected BundleDeploymentMethod getDeploymentMethod() throws MojoExecutionException {
        if (this.deploymentMethod == null) {
            if (this.usePut) {
                this.getLog().warn((CharSequence)"Using deprecated configuration parameter 'usePut=true', please instead use the new parameter 'deploymentMethod=WebDAV'!");
                return BundleDeploymentMethod.WebDAV;
            }
            return BundleDeploymentMethod.WebConsole;
        }
        return this.deploymentMethod;
    }
}

