/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.serviceusermapping.impl;

class Mapping
implements Comparable<Mapping> {
    static String SERVICENAME = ".serviceName";
    private final String serviceName;
    private final String subServiceName;
    private final String userName;

    Mapping(String spec) {
        int colon = spec.indexOf(58);
        int equals = spec.indexOf(61);
        if (colon == 0 || equals <= 0) {
            throw new IllegalArgumentException("serviceName is required");
        }
        if (equals == spec.length() - 1) {
            throw new IllegalArgumentException("userName is required");
        }
        if (colon + 1 == equals) {
            throw new IllegalArgumentException("serviceInfo must not be empty");
        }
        if (colon < 0 || colon > equals) {
            this.serviceName = spec.substring(0, equals);
            this.subServiceName = null;
        } else {
            this.serviceName = spec.substring(0, colon);
            this.subServiceName = spec.substring(colon + 1, equals);
        }
        this.userName = spec.substring(equals + 1);
    }

    String map(String serviceName, String subServiceName) {
        if (this.serviceName.equals(serviceName) && this.equals(this.subServiceName, subServiceName)) {
            return this.userName;
        }
        return null;
    }

    private boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public String toString() {
        return "Mapping [serviceName=" + this.serviceName + ", subServiceName=" + this.subServiceName + ", userName=" + this.userName + "]";
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getSubServiceName() {
        return this.subServiceName;
    }

    @Override
    public int compareTo(Mapping o) {
        if (o == null) {
            return -1;
        }
        int result = this.compare(this.serviceName, o.serviceName);
        if (result == 0) {
            result = this.compare(this.subServiceName, o.subServiceName);
        }
        return result;
    }

    private int compare(String str1, String str2) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        return str1.hashCode() - str2.hashCode();
    }
}

