/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.util.Utf8;
import org.apache.spark.sql.avro.IncompatibleSchemaException;
import org.apache.spark.sql.avro.IncompatibleSchemaException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0007\u000f\u0001eA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!AQ\u0006\u0001B\u0001B\u0003%a\u0006C\u00032\u0001\u0011\u0005!\u0007C\u00039\u0001\u0011\u0005\u0011\bC\u0004@\u0001\t\u0007I\u0011\u0002!\t\r\u0011\u0003\u0001\u0015!\u0003B\u000b\u0011)\u0005\u0001\u0002$\t\u0011Q\u0003\u0001R1A\u0005\nUCQA\u001a\u0001\u0005\n\u001dDQA\u001c\u0001\u0005\n=Dq!a\u0004\u0001\t\u0013\t\tB\u0001\bBmJ|7+\u001a:jC2L'0\u001a:\u000b\u0005=\u0001\u0012\u0001B1we>T!!\u0005\n\u0002\u0007M\fHN\u0003\u0002\u0014)\u0005)1\u000f]1sW*\u0011QCF\u0001\u0007CB\f7\r[3\u000b\u0003]\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g\u0003A\u0011xn\u001c;DCR\fG._:u)f\u0004X\r\u0005\u0002#K5\t1E\u0003\u0002%!\u0005)A/\u001f9fg&\u0011ae\t\u0002\t\t\u0006$\u0018\rV=qK\u0006a!o\\8u\u0003Z\u0014x\u000eV=qKB\u0011\u0011fK\u0007\u0002U)\u0011q\u0002F\u0005\u0003Y)\u0012aaU2iK6\f\u0017\u0001\u00038vY2\f'\r\\3\u0011\u0005my\u0013B\u0001\u0019\u001d\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtD\u0003B\u001a6m]\u0002\"\u0001\u000e\u0001\u000e\u00039AQ\u0001\t\u0003A\u0002\u0005BQa\n\u0003A\u0002!BQ!\f\u0003A\u00029\n\u0011b]3sS\u0006d\u0017N_3\u0015\u0005ij\u0004CA\u000e<\u0013\taDDA\u0002B]fDQAP\u0003A\u0002i\nAbY1uC2L8\u000f\u001e#bi\u0006\f\u0011bY8om\u0016\u0014H/\u001a:\u0016\u0003\u0005\u0003Ba\u0007\";u%\u00111\t\b\u0002\n\rVt7\r^5p]F\n!bY8om\u0016\u0014H/\u001a:!\u0005%\u0019uN\u001c<feR,'\u000fE\u0003\u001c\u000f&\u000b&(\u0003\u0002I9\tIa)\u001e8di&|gN\r\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000b1\"\u001a=qe\u0016\u001c8/[8og*\u0011a\nE\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0001k\u0013\u0002\u0013'B,7-[1mSj,GmR3ui\u0016\u00148\u000f\u0005\u0002\u001c%&\u00111\u000b\b\u0002\u0004\u0013:$\u0018A\u00053fG&l\u0017\r\\\"p]Z,'o]5p]N,\u0012A\u0016\t\u0003/\u000et!\u0001W1\u000f\u0005e\u0003gB\u0001.`\u001d\tYf,D\u0001]\u0015\ti\u0006$\u0001\u0004=e>|GOP\u0005\u0002/%\u0011QCF\u0005\u0003\u001fQI!A\u0019\u0016\u0002\u0017\r{gN^3sg&|gn]\u0005\u0003I\u0016\u0014\u0011\u0003R3dS6\fGnQ8om\u0016\u00148/[8o\u0015\t\u0011'&\u0001\u0007oK^\u001cuN\u001c<feR,'\u000fF\u0002iU2\u0004\"!\u001b\u0005\u000e\u0003\u0001AQa\u001b\u0006A\u0002\u0005\nAbY1uC2L8\u000f\u001e+za\u0016DQ!\u001c\u0006A\u0002!\n\u0001\"\u0019<s_RK\b/Z\u0001\u0013]\u0016<8\u000b\u001e:vGR\u001cuN\u001c<feR,'\u000fF\u0003q\u0003\u0003\tY\u0001\u0005\u0003\u001c\u0005F,\bC\u0001:t\u001b\u0005i\u0015B\u0001;N\u0005-Ie\u000e^3s]\u0006d'k\\<\u0011\u0005YlhBA<{\u001d\tA\u00060\u0003\u0002zU\u00059q-\u001a8fe&\u001c\u0017BA>}\u0003-9UM\\3sS\u000e$\u0015\r^1\u000b\u0005eT\u0013B\u0001@\u0000\u0005\u0019\u0011VmY8sI*\u00111\u0010 \u0005\b\u0003\u0007Y\u0001\u0019AA\u0003\u00039\u0019\u0017\r^1msN$8\u000b\u001e:vGR\u00042AIA\u0004\u0013\r\tIa\t\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007BBA\u0007\u0017\u0001\u0007\u0001&\u0001\u0006bmJ|7\u000b\u001e:vGR\f1C]3t_24XMT;mY\u0006\u0014G.\u001a+za\u0016$R\u0001KA\n\u0003+AQ!\u001c\u0007A\u0002!BQ!\f\u0007A\u00029\u0002")
public class AvroSerializer {
    private Conversions.DecimalConversion decimalConversions;
    private final Function1<Object, Object> converter;
    private volatile boolean bitmap$0;

    public Object serialize(Object catalystData) {
        return this.converter().apply(catalystData);
    }

    private Function1<Object, Object> converter() {
        return this.converter;
    }

    private Conversions.DecimalConversion decimalConversions$lzycompute() {
        AvroSerializer avroSerializer = this;
        synchronized (avroSerializer) {
            if (!this.bitmap$0) {
                this.decimalConversions = new Conversions.DecimalConversion();
                this.bitmap$0 = true;
            }
        }
        return this.decimalConversions;
    }

    private Conversions.DecimalConversion decimalConversions() {
        return !this.bitmap$0 ? this.decimalConversions$lzycompute() : this.decimalConversions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function2<SpecializedGetters, Object, Object> newConverter(DataType catalystType, Schema avroType) {
        Tuple2 tuple2 = new Tuple2((Object)catalystType, (Object)avroType.getType());
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (NullType$.MODULE$.equals(dataType) && Schema.Type.NULL.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$1(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BooleanType$.MODULE$.equals(dataType) && Schema.Type.BOOLEAN.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToBoolean((boolean)getter.getBoolean(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (ByteType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getByte(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (ShortType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getShort(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (IntegerType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getInt(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (LongType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (FloatType$.MODULE$.equals(dataType) && Schema.Type.FLOAT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToFloat((float)getter.getFloat(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (DoubleType$.MODULE$.equals(dataType) && Schema.Type.DOUBLE.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToDouble((double)getter.getDouble(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType d = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                if (Schema.Type.FIXED.equals(type)) {
                    LogicalType logicalType = avroType.getLogicalType();
                    LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale());
                    if (logicalType == null) {
                        if (decimal == null) return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$9(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    } else if (logicalType.equals(decimal)) {
                        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$9(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType d = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                if (Schema.Type.BYTES.equals(type)) {
                    LogicalType logicalType = avroType.getLogicalType();
                    LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale());
                    if (logicalType == null) {
                        if (decimal == null) return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$10(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    } else if (logicalType.equals(decimal)) {
                        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$10(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && Schema.Type.ENUM.equals(type)) {
                Set enumSymbols = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(avroType.getEnumSymbols()).asScala()).toSet();
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$11(enumSymbols, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && Schema.Type.STRING.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$12(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && Schema.Type.FIXED.equals(type)) {
                int size = avroType.getFixedSize();
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$13(size, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && Schema.Type.BYTES.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$14(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (DateType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getInt(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (TimestampType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                Function2 & Serializable & scala.Serializable intersect;
                LogicalType logicalType = avroType.getLogicalType();
                if (logicalType instanceof LogicalTypes.TimestampMillis) {
                    intersect = (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)AvroSerializer.$anonfun$newConverter$16(getter, BoxesRunTime.unboxToInt((Object)ordinal)));
                    return intersect;
                } else if (logicalType instanceof LogicalTypes.TimestampMicros) {
                    intersect = (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
                    return intersect;
                } else {
                    if (logicalType != null) throw new IncompatibleSchemaException(new StringBuilder(60).append("Cannot convert Catalyst Timestamp type to Avro logical type ").append(logicalType).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                    intersect = (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)AvroSerializer.$anonfun$newConverter$18(getter, BoxesRunTime.unboxToInt((Object)ordinal)));
                }
                return intersect;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType et = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                if (Schema.Type.ARRAY.equals(type)) {
                    Function2<SpecializedGetters, Object, Object> elementConverter = this.newConverter(et, this.resolveNullableType(avroType.getElementType(), containsNull));
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$19(containsNull, elementConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                }
            }
        }
        if (tuple2 != null) {
            DataType st = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (st instanceof StructType) {
                StructType structType = (StructType)st;
                if (Schema.Type.RECORD.equals(type)) {
                    Function1<InternalRow, GenericData.Record> structConverter = this.newStructConverter(structType, avroType);
                    int numFields = structType.length();
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$20(structConverter, numFields, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                }
            }
        }
        if (tuple2 == null) throw new IncompatibleSchemaException(new StringBuilder(33).append("Cannot convert Catalyst type ").append(catalystType).append(" to ").append(new StringBuilder(11).append("Avro type ").append(avroType).append(".").toString()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        DataType dataType = (DataType)tuple2._1();
        Schema.Type type = (Schema.Type)tuple2._2();
        if (!(dataType instanceof MapType)) throw new IncompatibleSchemaException(new StringBuilder(33).append("Cannot convert Catalyst type ").append(catalystType).append(" to ").append(new StringBuilder(11).append("Avro type ").append(avroType).append(".").toString()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        MapType mapType = (MapType)dataType;
        DataType kt = mapType.keyType();
        DataType vt = mapType.valueType();
        boolean valueContainsNull = mapType.valueContainsNull();
        if (!Schema.Type.MAP.equals(type)) throw new IncompatibleSchemaException(new StringBuilder(33).append("Cannot convert Catalyst type ").append(catalystType).append(" to ").append(new StringBuilder(11).append("Avro type ").append(avroType).append(".").toString()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        DataType dataType2 = kt;
        StringType$ stringType$ = StringType$.MODULE$;
        if (dataType2 == null) {
            if (stringType$ != null) {
                throw new IncompatibleSchemaException(new StringBuilder(33).append("Cannot convert Catalyst type ").append(catalystType).append(" to ").append(new StringBuilder(11).append("Avro type ").append(avroType).append(".").toString()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        } else if (!dataType2.equals(stringType$)) throw new IncompatibleSchemaException(new StringBuilder(33).append("Cannot convert Catalyst type ").append(catalystType).append(" to ").append(new StringBuilder(11).append("Avro type ").append(avroType).append(".").toString()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        Function2<SpecializedGetters, Object, Object> valueConverter = this.newConverter(vt, this.resolveNullableType(avroType.getValueType(), valueContainsNull));
        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$21(valueContainsNull, valueConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
    }

    private Function1<InternalRow, GenericData.Record> newStructConverter(StructType catalystStruct, Schema avroStruct) {
        Schema.Type type = avroStruct.getType();
        Schema.Type type2 = Schema.Type.RECORD;
        if ((type != null ? !type.equals(type2) : type2 != null) || avroStruct.getFields().size() != catalystStruct.length()) {
            throw new IncompatibleSchemaException(new StringBuilder(33).append("Cannot convert Catalyst type ").append(catalystStruct).append(" to ").append(new StringBuilder(11).append("Avro type ").append(avroStruct).append(".").toString()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        Seq fieldConverters = (Seq)((TraversableLike)catalystStruct.zip((GenIterable)JavaConverters$.MODULE$.asScalaBufferConverter(avroStruct.getFields()).asScala(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StructField f1 = (StructField)tuple2._1();
            Schema.Field f2 = (Schema.Field)tuple2._2();
            Function2<SpecializedGetters, Object, Object> function2 = this.newConverter(f1.dataType(), this.resolveNullableType(f2.schema(), f1.nullable()));
            return function2;
        }, Seq$.MODULE$.canBuildFrom());
        int numFields = catalystStruct.length();
        return (Function1 & Serializable & scala.Serializable)row -> {
            GenericData.Record result = new GenericData.Record(avroStruct);
            for (int i = 0; i < numFields; ++i) {
                if (row.isNullAt(i)) {
                    result.put(i, null);
                    continue;
                }
                result.put(i, ((Function2)fieldConverters.apply(i)).apply(row, (Object)BoxesRunTime.boxToInteger((int)i)));
            }
            return result;
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    private Schema resolveNullableType(Schema avroType, boolean nullable) {
        Schema schema;
        if (nullable) {
            Schema.Type type = avroType.getType();
            Schema.Type type2 = Schema.Type.NULL;
            if (type == null ? type2 != null : !type.equals(type2)) {
                Buffer fields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(avroType.getTypes()).asScala();
                Predef$.MODULE$.assert(fields.length() == 2);
                Buffer actualType = (Buffer)fields.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AvroSerializer.$anonfun$resolveNullableType$1(x$1)));
                Predef$.MODULE$.assert(actualType.length() == 1);
                schema = (Schema)actualType.head();
                return schema;
            }
        }
        schema = avroType;
        return schema;
    }

    public static final /* synthetic */ Null$ $anonfun$newConverter$1(SpecializedGetters getter, int ordinal) {
        return null;
    }

    public static final /* synthetic */ GenericFixed $anonfun$newConverter$9(AvroSerializer $this, DecimalType x55$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        Decimal decimal = getter.getDecimal(ordinal, x55$1.precision(), x55$1.scale());
        return $this.decimalConversions().toFixed(decimal.toJavaBigDecimal(), avroType$1, (LogicalType)LogicalTypes.decimal((int)x55$1.precision(), (int)x55$1.scale()));
    }

    public static final /* synthetic */ ByteBuffer $anonfun$newConverter$10(AvroSerializer $this, DecimalType x57$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        Decimal decimal = getter.getDecimal(ordinal, x57$1.precision(), x57$1.scale());
        return $this.decimalConversions().toBytes(decimal.toJavaBigDecimal(), avroType$1, (LogicalType)LogicalTypes.decimal((int)x57$1.precision(), (int)x57$1.scale()));
    }

    public static final /* synthetic */ GenericData.EnumSymbol $anonfun$newConverter$11(Set enumSymbols$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        String data = getter.getUTF8String(ordinal).toString();
        if (!enumSymbols$1.contains((Object)data)) {
            throw new IncompatibleSchemaException(new StringBuilder(49).append("Cannot write \"").append(data).append("\" since it's not defined in enum \"").append(enumSymbols$1.mkString("\", \"")).append("\"").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return new GenericData.EnumSymbol(avroType$1, data);
    }

    public static final /* synthetic */ Utf8 $anonfun$newConverter$12(SpecializedGetters getter, int ordinal) {
        return new Utf8(getter.getUTF8String(ordinal).getBytes());
    }

    public static final /* synthetic */ GenericData.Fixed $anonfun$newConverter$13(int size$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        byte[] data = getter.getBinary(ordinal);
        if (data.length != size$1) {
            throw new IncompatibleSchemaException(new StringBuilder(59).append("Cannot write ").append(data.length).append(" ").append((Object)(data.length > 1 ? "bytes" : "byte")).append(" of ").append("binary data into FIXED Type with size of ").append(new StringBuilder(1).append(size$1).append(" ").append((Object)(size$1 > 1 ? "bytes" : "byte")).toString()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return new GenericData.Fixed(avroType$1, data);
    }

    public static final /* synthetic */ ByteBuffer $anonfun$newConverter$14(SpecializedGetters getter, int ordinal) {
        return ByteBuffer.wrap(getter.getBinary(ordinal));
    }

    public static final /* synthetic */ long $anonfun$newConverter$16(SpecializedGetters getter, int ordinal) {
        return getter.getLong(ordinal) / 1000L;
    }

    public static final /* synthetic */ long $anonfun$newConverter$18(SpecializedGetters getter, int ordinal) {
        return getter.getLong(ordinal) / 1000L;
    }

    public static final /* synthetic */ List $anonfun$newConverter$19(boolean containsNull$1, Function2 elementConverter$1, SpecializedGetters getter, int ordinal) {
        ArrayData arrayData = getter.getArray(ordinal);
        int len = arrayData.numElements();
        Object[] result = new Object[len];
        for (int i = 0; i < len; ++i) {
            result[i] = containsNull$1 && arrayData.isNullAt(i) ? null : elementConverter$1.apply((Object)arrayData, (Object)BoxesRunTime.boxToInteger((int)i));
        }
        return Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)result));
    }

    public static final /* synthetic */ GenericData.Record $anonfun$newConverter$20(Function1 structConverter$1, int numFields$1, SpecializedGetters getter, int ordinal) {
        return (GenericData.Record)structConverter$1.apply((Object)getter.getStruct(ordinal, numFields$1));
    }

    public static final /* synthetic */ HashMap $anonfun$newConverter$21(boolean valueContainsNull$1, Function2 valueConverter$1, SpecializedGetters getter, int ordinal) {
        MapData mapData = getter.getMap(ordinal);
        int len = mapData.numElements();
        HashMap<String, Object> result = new HashMap<String, Object>(len);
        ArrayData keyArray = mapData.keyArray();
        ArrayData valueArray = mapData.valueArray();
        for (int i = 0; i < len; ++i) {
            String key = keyArray.getUTF8String(i).toString();
            Object object = valueContainsNull$1 && valueArray.isNullAt(i) ? result.put(key, null) : result.put(key, valueConverter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i)));
        }
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$resolveNullableType$1(Schema x$1) {
        Schema.Type type = x$1.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return type == null ? type2 != null : !type.equals(type2);
    }

    public AvroSerializer(DataType rootCatalystType, Schema rootAvroType, boolean nullable) {
        Function1 & Serializable & scala.Serializable intersect;
        Schema actualAvroType = this.resolveNullableType(rootAvroType, nullable);
        DataType dataType = rootCatalystType;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            intersect = this.newStructConverter(structType, actualAvroType);
        } else {
            SpecificInternalRow tmpRow = new SpecificInternalRow((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{rootCatalystType})));
            Function2<SpecializedGetters, Object, Object> converter = this.newConverter(rootCatalystType, actualAvroType);
            intersect = (Function1 & Serializable & scala.Serializable)data -> {
                tmpRow.update(0, data);
                return converter.apply((Object)tmpRow, (Object)BoxesRunTime.boxToInteger((int)0));
            };
        }
        Function1 & Serializable & scala.Serializable baseConverter = intersect;
        this.converter = nullable ? (Function1 & Serializable & scala.Serializable)data -> data == null ? null : baseConverter.apply(data) : baseConverter;
    }
}

