/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtract$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, regexp[, idx]) - Extracts a group that matches `regexp`.", examples="\n    Examples:\n      > SELECT _FUNC_('100-200', '(\\\\d+)-(\\\\d+)', 1);\n       100\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\tur!B\u0001\u0003\u0011\u0003y\u0011!\u0004*fO\u0016C\b/\u0012=ue\u0006\u001cGO\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001!\t\u0001\u0012#D\u0001\u0003\r\u0015\u0011\"\u0001#\u0001\u0014\u00055\u0011VmZ#ya\u0016CHO]1diN\u0019\u0011\u0003\u0006\u000e\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g!\t)2$\u0003\u0002\u001d-\ta1+\u001a:jC2L'0\u00192mK\")a$\u0005C\u0001?\u00051A(\u001b8jiz\"\u0012a\u0004\u0005\u0006CE!\tAI\u0001\u0010G\",7m[$s_V\u0004\u0018J\u001c3fqR\u00191EJ\u0016\u0011\u0005U!\u0013BA\u0013\u0017\u0005\u0011)f.\u001b;\t\u000b\u001d\u0002\u0003\u0019\u0001\u0015\u0002\u0015\u001d\u0014x.\u001e9D_VtG\u000f\u0005\u0002\u0016S%\u0011!F\u0006\u0002\u0004\u0013:$\b\"\u0002\u0017!\u0001\u0004A\u0013AC4s_V\u0004\u0018J\u001c3fq\"9a&EA\u0001\n\u0003{\u0013!B1qa2LHc\u0002\u0019\u0003\u0016\t]!\u0011\u0004\t\u0003!E2AA\u0005\u0002AeM)\u0011g\r\u001c:5A\u0011\u0001\u0003N\u0005\u0003k\t\u0011\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\u0001r'\u0003\u00029\u0005\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002\u0016u%\u00111H\u0006\u0002\b!J|G-^2u\u0011!i\u0014G!f\u0001\n\u0003q\u0014aB:vE*,7\r^\u000b\u0002\u007fA\u0011\u0001\u0003Q\u0005\u0003\u0003\n\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0011!\u0019\u0015G!E!\u0002\u0013y\u0014\u0001C:vE*,7\r\u001e\u0011\t\u0011\u0015\u000b$Q3A\u0005\u0002y\naA]3hKb\u0004\b\u0002C$2\u0005#\u0005\u000b\u0011B \u0002\u000fI,w-\u001a=qA!A\u0011*\rBK\u0002\u0013\u0005a(A\u0002jIbD\u0001bS\u0019\u0003\u0012\u0003\u0006IaP\u0001\u0005S\u0012D\b\u0005C\u0003\u001fc\u0011\u0005Q\n\u0006\u00031\u001d>\u0003\u0006\"B\u001fM\u0001\u0004y\u0004\"B#M\u0001\u0004y\u0004\"B%M\u0001\u0004y\u0004\"\u0002\u00102\t\u0003\u0011Fc\u0001\u0019T+\")A+\u0015a\u0001\u007f\u0005\t1\u000fC\u0003W#\u0002\u0007q(A\u0001s\u0011%A\u0016\u00071AA\u0002\u0013%\u0011,A\u0005mCN$(+Z4fqV\t!\f\u0005\u0002\\A6\tAL\u0003\u0002^=\u0006)A/\u001f9fg*\u0011q\fC\u0001\u0007k:\u001c\u0018MZ3\n\u0005\u0005d&AC+U\rb\u001aFO]5oO\"I1-\ra\u0001\u0002\u0004%I\u0001Z\u0001\u000eY\u0006\u001cHOU3hKb|F%Z9\u0015\u0005\r*\u0007b\u00024c\u0003\u0003\u0005\rAW\u0001\u0004q\u0012\n\u0004B\u000252A\u0003&!,\u0001\u0006mCN$(+Z4fq\u0002B#a\u001a6\u0011\u0005UY\u0017B\u00017\u0017\u0005%!(/\u00198tS\u0016tG\u000fC\u0005oc\u0001\u0007\t\u0019!C\u0005_\u00069\u0001/\u0019;uKJtW#\u00019\u0011\u0005EDX\"\u0001:\u000b\u0005M$\u0018!\u0002:fO\u0016D(BA;w\u0003\u0011)H/\u001b7\u000b\u0003]\fAA[1wC&\u0011\u0011P\u001d\u0002\b!\u0006$H/\u001a:o\u0011%Y\u0018\u00071AA\u0002\u0013%A0A\u0006qCR$XM\u001d8`I\u0015\fHCA\u0012~\u0011\u001d1'0!AA\u0002ADaa`\u0019!B\u0013\u0001\u0018\u0001\u00039biR,'O\u001c\u0011)\u0005yT\u0007bBA\u0003c\u0011\u0005\u0013qA\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\t\u0003\u0013\ty!!\u0005\u0002\u0016A\u0019Q#a\u0003\n\u0007\u00055aCA\u0002B]fDq\u0001VA\u0002\u0001\u0004\tI\u0001\u0003\u0005\u0002\u0014\u0005\r\u0001\u0019AA\u0005\u0003\u0005\u0001\bb\u0002,\u0002\u0004\u0001\u0007\u0011\u0011\u0002\u0005\b\u00033\tD\u0011IA\u000e\u0003!!\u0017\r^1UsB,WCAA\u000f!\u0011\ty\"a\t\u000e\u0005\u0005\u0005\"BA/\u0007\u0013\u0011\t)#!\t\u0003\u0011\u0011\u000bG/\u0019+za\u0016Dq!!\u000b2\t\u0003\nY#\u0001\u0006j]B,H\u000fV=qKN,\"!!\f\u0011\r\u0005=\u0012qHA#\u001d\u0011\t\t$a\u000f\u000f\t\u0005M\u0012\u0011H\u0007\u0003\u0003kQ1!a\u000e\u000f\u0003\u0019a$o\\8u}%\tq#C\u0002\u0002>Y\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002B\u0005\r#aA*fc*\u0019\u0011Q\b\f\u0011\t\u0005}\u0011qI\u0005\u0005\u0003\u0013\n\tC\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\"9\u0011QJ\u0019\u0005B\u0005=\u0013\u0001C2iS2$'/\u001a8\u0016\u0005\u0005E\u0003#BA\u0018\u0003\u007fy\u0004bBA+c\u0011\u0005\u0013qK\u0001\u000baJ,G\u000f^=OC6,WCAA-!\u0011\tY&!\u0019\u000f\u0007U\ti&C\u0002\u0002`Y\ta\u0001\u0015:fI\u00164\u0017\u0002BA2\u0003K\u0012aa\u0015;sS:<'bAA0-!9\u0011\u0011N\u0019\u0005R\u0005-\u0014!\u00033p\u000f\u0016t7i\u001c3f)\u0019\ti'!\u001f\u0002\u0004B!\u0011qNA;\u001b\t\t\tHC\u0002\u0002t\t\tqaY8eK\u001e,g.\u0003\u0003\u0002x\u0005E$\u0001C#yaJ\u001cu\u000eZ3\t\u0011\u0005m\u0014q\ra\u0001\u0003{\n1a\u0019;y!\u0011\ty'a \n\t\u0005\u0005\u0015\u0011\u000f\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011!\t))a\u001aA\u0002\u00055\u0014AA3w\u0011%\tI)MA\u0001\n\u0003\tY)\u0001\u0003d_BLHc\u0002\u0019\u0002\u000e\u0006=\u0015\u0011\u0013\u0005\t{\u0005\u001d\u0005\u0013!a\u0001\u007f!AQ)a\"\u0011\u0002\u0003\u0007q\b\u0003\u0005J\u0003\u000f\u0003\n\u00111\u0001@\u0011%\t)*MI\u0001\n\u0003\t9*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e%fA \u0002\u001c.\u0012\u0011Q\u0014\t\u0005\u0003?\u000bI+\u0004\u0002\u0002\"*!\u00111UAS\u0003%)hn\u00195fG.,GMC\u0002\u0002(Z\t!\"\u00198o_R\fG/[8o\u0013\u0011\tY+!)\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u00020F\n\n\u0011\"\u0001\u0002\u0018\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004\"CAZcE\u0005I\u0011AAL\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIMB\u0011\"a.2\u0003\u0003%\t%!/\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\f\u0005\u0003\u0002>\u0006\rWBAA`\u0015\r\t\tM^\u0001\u0005Y\u0006tw-\u0003\u0003\u0002d\u0005}\u0006\"CAdc\u0005\u0005I\u0011AAe\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005A\u0003\"CAgc\u0005\u0005I\u0011AAh\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0003\u0002R\"Aa-a3\u0002\u0002\u0003\u0007\u0001\u0006C\u0005\u0002VF\n\t\u0011\"\u0011\u0002X\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002ZB1\u00111\\Aq\u0003\u0013i!!!8\u000b\u0007\u0005}g#\u0001\u0006d_2dWm\u0019;j_:LA!a9\u0002^\nA\u0011\n^3sCR|'\u000fC\u0005\u0002hF\n\t\u0011\"\u0001\u0002j\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002l\u0006E\bcA\u000b\u0002n&\u0019\u0011q\u001e\f\u0003\u000f\t{w\u000e\\3b]\"Ia-!:\u0002\u0002\u0003\u0007\u0011\u0011\u0002\u0005\n\u0003k\f\u0014\u0011!C!\u0003o\fa!Z9vC2\u001cH\u0003BAv\u0003sD\u0011BZAz\u0003\u0003\u0005\r!!\u0003)\u001fE\niPa\u0001\u0003\u0006\t%!1\u0002B\b\u0005#\u00012\u0001EA\u0000\u0013\r\u0011\tA\u0001\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u00119!\u0001#`\rVs5i\u0018\u0015tiJd\u0003E]3hKb\u00048\f\f\u0011jIbl\u0016\u0006I\u0017!\u000bb$(/Y2ug\u0002\n\u0007e\u001a:pkB\u0004C\u000f[1uA5\fGo\u00195fg\u0002\u0002'/Z4fqB\u0004g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011i!\u0001*\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n\u0004\u0007M\u00173aA:C\u0006I\u0014)9r#7&K\u0017)9r#7&K\u0014-AEJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u00191a)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0003\u0014\u0005)\u0011GL\u001b/a!)Q(\fa\u0001\u007f!)Q)\fa\u0001\u007f!)\u0011*\fa\u0001\u007f!I!QD\t\u0002\u0002\u0013\u0005%qD\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\tC!\f\u0011\u000bU\u0011\u0019Ca\n\n\u0007\t\u0015bC\u0001\u0004PaRLwN\u001c\t\u0007+\t%rhP \n\u0007\t-bC\u0001\u0004UkBdWm\r\u0005\n\u0005_\u0011Y\"!AA\u0002A\n1\u0001\u001f\u00131\u0011%\u0011\u0019$EA\u0001\n\u0013\u0011)$A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u001c!\u0011\tiL!\u000f\n\t\tm\u0012q\u0018\u0002\u0007\u001f\nTWm\u0019;")
public class RegExpExtract
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression subject;
    private final Expression regexp;
    private final Expression idx;
    private transient UTF8String lastRegex;
    private transient Pattern pattern;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(RegExpExtract regExpExtract) {
        return RegExpExtract$.MODULE$.unapply(regExpExtract);
    }

    public static void checkGroupIndex(int n, int n2) {
        RegExpExtract$.MODULE$.checkGroupIndex(n, n2);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression subject() {
        return this.subject;
    }

    public Expression regexp() {
        return this.regexp;
    }

    public Expression idx() {
        return this.idx;
    }

    private UTF8String lastRegex() {
        return this.lastRegex;
    }

    private void lastRegex_$eq(UTF8String x$1) {
        this.lastRegex = x$1;
    }

    private Pattern pattern() {
        return this.pattern;
    }

    private void pattern_$eq(Pattern x$1) {
        this.pattern = x$1;
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r) {
        UTF8String uTF8String;
        Matcher m;
        if (!p.equals(this.lastRegex())) {
            this.lastRegex_$eq(((UTF8String)p).clone());
            this.pattern_$eq(Pattern.compile(this.lastRegex().toString()));
        }
        if ((m = this.pattern().matcher(s.toString())).find()) {
            MatchResult mr = m.toMatchResult();
            int index = BoxesRunTime.unboxToInt((Object)r);
            RegExpExtract$.MODULE$.checkGroupIndex(mr.groupCount(), index);
            String group = mr.group(index);
            uTF8String = group == null ? UTF8String.EMPTY_UTF8 : UTF8String.fromString((String)group);
        } else {
            uTF8String = UTF8String.EMPTY_UTF8;
        }
        return uTF8String;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.subject();
        Expression expression2 = this.regexp();
        Expression expression3 = this.idx();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public String prettyName() {
        return "regexp_extract";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String classNamePattern = Pattern.class.getCanonicalName();
        String classNameRegExpExtract = RegExpExtract.class.getCanonicalName();
        String matcher = ctx.freshName("matcher");
        String matchResult = ctx.freshName("matchResult");
        String termLastRegex = ctx.addMutableState("UTF8String", "lastRegex", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termPattern = ctx.addMutableState(classNamePattern, "pattern", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String setEvNotNull = this.nullable() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = false;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull()})) : "";
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)new Serializable(this, ev, classNamePattern, classNameRegExpExtract, matcher, matchResult, termLastRegex, termPattern, setEvNotNull){
            public static final long serialVersionUID = 0L;
            private final ExprCode ev$5;
            private final String classNamePattern$2;
            private final String classNameRegExpExtract$1;
            private final String matcher$2;
            private final String matchResult$1;
            private final String termLastRegex$2;
            private final String termPattern$2;
            private final String setEvNotNull$2;

            public final String apply(String subject, String regexp, String idx) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      if (!", ".equals(", ")) {\n        // regex value changed\n        ", " = ", ".clone();\n        ", " = ", ".compile(", ".toString());\n      }\n      java.util.regex.Matcher ", " =\n        ", ".matcher(", ".toString());\n      if (", ".find()) {\n        java.util.regex.MatchResult ", " = ", ".toMatchResult();\n        ", ".checkGroupIndex(", ".groupCount(), ", ");\n        if (", ".group(", ") == null) {\n          ", " = UTF8String.EMPTY_UTF8;\n        } else {\n          ", " = UTF8String.fromString(", ".group(", "));\n        }\n        ", "\n      } else {\n        ", " = UTF8String.EMPTY_UTF8;\n        ", "\n      }"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{regexp, this.termLastRegex$2, this.termLastRegex$2, regexp, this.termPattern$2, this.classNamePattern$2, this.termLastRegex$2, this.matcher$2, this.termPattern$2, subject, this.matcher$2, this.matchResult$1, this.matcher$2, this.classNameRegExpExtract$1, this.matchResult$1, idx, this.matchResult$1, idx, this.ev$5.value(), this.ev$5.value(), this.matchResult$1, idx, this.setEvNotNull$2, this.ev$5.value(), this.setEvNotNull$2}));
            }
            {
                this.ev$5 = ev$5;
                this.classNamePattern$2 = classNamePattern$2;
                this.classNameRegExpExtract$1 = classNameRegExpExtract$1;
                this.matcher$2 = matcher$2;
                this.matchResult$1 = matchResult$1;
                this.termLastRegex$2 = termLastRegex$2;
                this.termPattern$2 = termPattern$2;
                this.setEvNotNull$2 = setEvNotNull$2;
            }
        });
    }

    public RegExpExtract copy(Expression subject, Expression regexp, Expression idx) {
        return new RegExpExtract(subject, regexp, idx);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.idx();
    }

    @Override
    public String productPrefix() {
        return "RegExpExtract";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                expression = this.idx();
                break;
            }
            case 1: {
                expression = this.regexp();
                break;
            }
            case 0: {
                expression = this.subject();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpExtract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpExtract)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpExtract regExpExtract = (RegExpExtract)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpExtract.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpExtract.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.idx();
        Expression expression6 = regExpExtract.idx();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!regExpExtract.canEqual(this)) return false;
        return true;
    }

    public RegExpExtract(Expression subject, Expression regexp, Expression idx) {
        this.subject = subject;
        this.regexp = regexp;
        this.idx = idx;
        ExpectsInputTypes$class.$init$(this);
    }

    public RegExpExtract(Expression s, Expression r) {
        this(s, r, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

