/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.LDA$;
import org.apache.spark.ml.clustering.LDAModel$;
import org.apache.spark.ml.clustering.LDAParams;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.LocalLDAModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}h!\u0002\r\u001a\u0003\u0003!\u0003\u0002\u0003\u001e\u0001\u0005\u000b\u0007I\u0011I\u001e\t\u0011I\u0003!\u0011!Q\u0001\nqB\u0001\u0002\u0016\u0001\u0003\u0006\u0004%\t!\u0016\u0005\t7\u0002\u0011\t\u0011)A\u0005-\"IQ\f\u0001BC\u0002\u0013\u00051D\u0018\u0005\tM\u0002\u0011\t\u0011)A\u0005?\"1A\u000e\u0001C\u000175Da\u0001\u001e\u0001\u0007\u0002e)\bB\u0002@\u0001\r\u0003Ir\u0010\u0003\u0005\u0002\b\u0001!\taGA\u0005\u0011!\t9\u0002\u0001C\u00017\u0005e\u0001bBA\u000e\u0001\u0011\u0005\u0011Q\u0004\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003kAq!!\u0011\u0001\t\u0003\n\u0019\u0005C\u0004\u0002\f\u0002!\t%!$\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002$\"9\u00111\u0017\u0001\u0005\u0002\u0005U\u0006bBA`\u0001\u0019\u0005\u0011\u0011\u0019\u0005\b\u0003\u0017\u0004A\u0011AAg\u0011\u001d\ti\u000e\u0001C\u0001\u0003?Dq!a<\u0001\t\u0003\t\t\u0010C\u0004\u0002p\u0002!\t!!?\u0003\u00111#\u0015)T8eK2T!AG\u000e\u0002\u0015\rdWo\u001d;fe&twM\u0003\u0002\u001d;\u0005\u0011Q\u000e\u001c\u0006\u0003=}\tQa\u001d9be.T!\u0001I\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0013aA8sO\u000e\u00011#\u0002\u0001&W9\"\u0004c\u0001\u0014(S5\t1$\u0003\u0002)7\t)Qj\u001c3fYB\u0011!\u0006A\u0007\u00023A\u0011!\u0006L\u0005\u0003[e\u0011\u0011\u0002\u0014#B!\u0006\u0014\u0018-\\:\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005Ej\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005M\u0002$a\u0002'pO\u001eLgn\u001a\t\u0003kaj\u0011A\u000e\u0006\u0003om\tA!\u001e;jY&\u0011\u0011H\u000e\u0002\u000b\u001b2;&/\u001b;bE2,\u0017aA;jIV\tA\b\u0005\u0002>\r:\u0011a\b\u0012\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003\u000e\na\u0001\u0010:p_Rt$\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013\u0015A\u0002)sK\u0012,g-\u0003\u0002H\u0011\n11\u000b\u001e:j]\u001eT!!\u0012\")\u0007\u0005Q\u0005\u000b\u0005\u0002L\u001d6\tAJ\u0003\u0002N;\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005=c%!B*j]\u000e,\u0017%A)\u0002\u000bErcG\f\u0019\u0002\tULG\r\t\u0015\u0004\u0005)\u0003\u0016!\u0003<pG\u0006\u00147+\u001b>f+\u00051\u0006CA,Y\u001b\u0005\u0011\u0015BA-C\u0005\rIe\u000e\u001e\u0015\u0004\u0007)\u0003\u0016A\u0003<pG\u0006\u00147+\u001b>fA!\u001aAA\u0013)\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0016\u0003}\u0003\"\u0001Y2\u000e\u0003\u0005T!AY\u000f\u0002\u0007M\fH.\u0003\u0002eC\na1\u000b]1sWN+7o]5p]\"\u001aQA\u0013)\u0002\u001bM\u0004\u0018M]6TKN\u001c\u0018n\u001c8!Q\t1\u0001\u000e\u0005\u0002XS&\u0011!N\u0011\u0002\niJ\fgn]5f]RD3A\u0002&Q\u0003\u0019a\u0014N\\5u}Q!\u0011F\u001c9s\u0011\u0015Qt\u00011\u0001=Q\rq'\n\u0015\u0005\u0006)\u001e\u0001\rA\u0016\u0015\u0004a*\u0003\u0006\"B/\b\u0001\u0004y\u0006f\u0001:K!\u0006iq\u000e\u001c3M_\u000e\fG.T8eK2,\u0012A\u001e\t\u0003onl\u0011\u0001\u001f\u0006\u00035eT!A_\u000f\u0002\u000b5dG.\u001b2\n\u0005qD(!\u0004'pG\u0006dG\nR!N_\u0012,G\u000eK\u0002\t\u0015B\u000b\u0001bZ3u\u001b>$W\r\\\u000b\u0003\u0003\u0003\u00012a^A\u0002\u0013\tA\u0002\u0010K\u0002\n\u0015B\u000bAdZ3u\u000b\u001a4Wm\u0019;jm\u0016$unY\"p]\u000e,g\u000e\u001e:bi&|g.\u0006\u0002\u0002\fA)q+!\u0004\u0002\u0012%\u0019\u0011q\u0002\"\u0003\u000b\u0005\u0013(/Y=\u0011\u0007]\u000b\u0019\"C\u0002\u0002\u0016\t\u0013a\u0001R8vE2,\u0017AH4fi\u00163g-Z2uSZ,Gk\u001c9jG\u000e{gnY3oiJ\fG/[8o+\t\t\t\"\u0001\btKR4U-\u0019;ve\u0016\u001c8i\u001c7\u0015\t\u0005}\u0011\u0011E\u0007\u0002\u0001!1\u00111\u0005\u0007A\u0002q\nQA^1mk\u0016D3\u0001\u0004&Q\u0003]\u0019X\r\u001e+pa&\u001cG)[:ue&\u0014W\u000f^5p]\u000e{G\u000e\u0006\u0003\u0002 \u0005-\u0002BBA\u0012\u001b\u0001\u0007A\b\u000b\u0003\u000e\u0015\u0006=\u0012EAA\u0019\u0003\u0015\u0011dF\r\u00181\u0003\u001d\u0019X\r^*fK\u0012$B!a\b\u00028!9\u00111\u0005\bA\u0002\u0005e\u0002cA,\u0002<%\u0019\u0011Q\b\"\u0003\t1{gn\u001a\u0015\u0004\u001d)\u0003\u0016!\u0003;sC:\u001chm\u001c:n)\u0011\t)%a\u0019\u0011\t\u0005\u001d\u0013Q\f\b\u0005\u0003\u0013\nIF\u0004\u0003\u0002L\u0005]c\u0002BA'\u0003+rA!a\u0014\u0002T9\u0019q(!\u0015\n\u0003\tJ!\u0001I\u0011\n\u0005yy\u0012B\u00012\u001e\u0013\r\tY&Y\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty&!\u0019\u0003\u0013\u0011\u000bG/\u0019$sC6,'bAA.C\"9\u0011QM\bA\u0002\u0005\u001d\u0014a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003S\n\u0019\bE\u0003a\u0003W\ny'C\u0002\u0002n\u0005\u0014q\u0001R1uCN,G\u000f\u0005\u0003\u0002r\u0005MD\u0002\u0001\u0003\r\u0003k\n\u0019'!A\u0001\u0002\u000b\u0005\u0011q\u000f\u0002\u0004?\u0012\n\u0014\u0003BA=\u0003\u007f\u00022aVA>\u0013\r\tiH\u0011\u0002\b\u001d>$\b.\u001b8h!\r9\u0016\u0011Q\u0005\u0004\u0003\u0007\u0013%aA!os\"\"qBSADC\t\tI)A\u00033]Ar\u0003'A\bue\u0006t7OZ8s[N\u001b\u0007.Z7b)\u0011\ty)a'\u0011\t\u0005E\u0015qS\u0007\u0003\u0003'S1!!&b\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tI*a%\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002\u001eB\u0001\r!a$\u0002\rM\u001c\u0007.Z7bQ\r\u0001\"\nU\u0001\u001aKN$\u0018.\\1uK\u0012$unY\"p]\u000e,g\u000e\u001e:bi&|g.\u0006\u0002\u0002&B!\u0011qUAW\u001b\t\tIKC\u0002\u0002,n\ta\u0001\\5oC2<\u0017\u0002BAX\u0003S\u0013aAV3di>\u0014\b\u0006B\tK\u0003\u000f\u000bA\u0002^8qS\u000e\u001cX*\u0019;sSb,\"!a.\u0011\t\u0005\u001d\u0016\u0011X\u0005\u0005\u0003w\u000bIK\u0001\u0004NCR\u0014\u0018\u000e\u001f\u0015\u0005%)\u000b9)A\u0007jg\u0012K7\u000f\u001e:jEV$X\rZ\u000b\u0003\u0003\u0007\u00042aVAc\u0013\r\t9M\u0011\u0002\b\u0005>|G.Z1oQ\r\u0019\"\nU\u0001\u000eY><G*[6fY&Dwn\u001c3\u0015\t\u0005E\u0011q\u001a\u0005\b\u0003K\"\u0002\u0019AAia\u0011\t\u0019.a6\u0011\u000b\u0001\fY'!6\u0011\t\u0005E\u0014q\u001b\u0003\r\u00033\fy-!A\u0001\u0002\u000b\u0005\u0011q\u000f\u0002\u0004?\u0012\u0012\u0004\u0006\u0002\u000bK\u0003\u000f\u000bQ\u0002\\8h!\u0016\u0014\b\u000f\\3ySRLH\u0003BA\t\u0003CDq!!\u001a\u0016\u0001\u0004\t\u0019\u000f\r\u0003\u0002f\u0006%\b#\u00021\u0002l\u0005\u001d\b\u0003BA9\u0003S$A\"a;\u0002b\u0006\u0005\t\u0011!B\u0001\u0003o\u00121a\u0018\u00134Q\u0011)\"*a\"\u0002\u001d\u0011,7o\u0019:jE\u0016$v\u000e]5dgR!\u0011QIAz\u0011\u0019\t)P\u0006a\u0001-\u0006\u0001R.\u0019=UKJl7\u000fU3s)>\u0004\u0018n\u0019\u0015\u0004-)\u0003FCAA#Q\r9\"\n\u0015\u0015\u0004\u0001)\u0003\u0006")
public abstract class LDAModel
extends Model<LDAModel>
implements LDAParams,
MLWritable {
    private final String uid;
    private final int vocabSize;
    private final transient SparkSession sparkSession;
    private final IntParam k;
    private final DoubleArrayParam docConcentration;
    private final DoubleParam topicConcentration;
    private final String[] supportedOptimizers;
    private final Param<String> optimizer;
    private final Param<String> topicDistributionCol;
    private final DoubleParam learningOffset;
    private final DoubleParam learningDecay;
    private final DoubleParam subsamplingRate;
    private final BooleanParam optimizeDocConcentration;
    private final BooleanParam keepLastCheckpoint;
    private final IntParam checkpointInterval;
    private final LongParam seed;
    private final IntParam maxIter;
    private final Param<String> featuresCol;

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return LDAParams.getK$(this);
    }

    @Override
    public double[] getDocConcentration() {
        return LDAParams.getDocConcentration$(this);
    }

    @Override
    public org.apache.spark.ml.linalg.Vector getOldDocConcentration() {
        return LDAParams.getOldDocConcentration$(this);
    }

    @Override
    public double getTopicConcentration() {
        return LDAParams.getTopicConcentration$(this);
    }

    @Override
    public double getOldTopicConcentration() {
        return LDAParams.getOldTopicConcentration$(this);
    }

    @Override
    public String getOptimizer() {
        return LDAParams.getOptimizer$(this);
    }

    @Override
    public String getTopicDistributionCol() {
        return LDAParams.getTopicDistributionCol$(this);
    }

    @Override
    public double getLearningOffset() {
        return LDAParams.getLearningOffset$(this);
    }

    @Override
    public double getLearningDecay() {
        return LDAParams.getLearningDecay$(this);
    }

    @Override
    public double getSubsamplingRate() {
        return LDAParams.getSubsamplingRate$(this);
    }

    @Override
    public boolean getOptimizeDocConcentration() {
        return LDAParams.getOptimizeDocConcentration$(this);
    }

    @Override
    public boolean getKeepLastCheckpoint() {
        return LDAParams.getKeepLastCheckpoint$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return LDAParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public LDAOptimizer getOldOptimizer() {
        return LDAParams.getOldOptimizer$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final DoubleArrayParam docConcentration() {
        return this.docConcentration;
    }

    @Override
    public final DoubleParam topicConcentration() {
        return this.topicConcentration;
    }

    @Override
    public final String[] supportedOptimizers() {
        return this.supportedOptimizers;
    }

    @Override
    public final Param<String> optimizer() {
        return this.optimizer;
    }

    @Override
    public final Param<String> topicDistributionCol() {
        return this.topicDistributionCol;
    }

    @Override
    public final DoubleParam learningOffset() {
        return this.learningOffset;
    }

    @Override
    public final DoubleParam learningDecay() {
        return this.learningDecay;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final BooleanParam optimizeDocConcentration() {
        return this.optimizeDocConcentration;
    }

    @Override
    public final BooleanParam keepLastCheckpoint() {
        return this.keepLastCheckpoint;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$docConcentration_$eq(DoubleArrayParam x$1) {
        this.docConcentration = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$topicConcentration_$eq(DoubleParam x$1) {
        this.topicConcentration = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$supportedOptimizers_$eq(String[] x$1) {
        this.supportedOptimizers = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$optimizer_$eq(Param<String> x$1) {
        this.optimizer = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$topicDistributionCol_$eq(Param<String> x$1) {
        this.topicDistributionCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$learningOffset_$eq(DoubleParam x$1) {
        this.learningOffset = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$learningDecay_$eq(DoubleParam x$1) {
        this.learningDecay = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$optimizeDocConcentration_$eq(BooleanParam x$1) {
        this.optimizeDocConcentration = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$keepLastCheckpoint_$eq(BooleanParam x$1) {
        this.keepLastCheckpoint = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public int vocabSize() {
        return this.vocabSize;
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    public abstract LocalLDAModel oldLocalModel();

    public abstract org.apache.spark.mllib.clustering.LDAModel getModel();

    public double[] getEffectiveDocConcentration() {
        return this.getModel().docConcentration().toArray();
    }

    public double getEffectiveTopicConcentration() {
        return this.getModel().topicConcentration();
    }

    public LDAModel setFeaturesCol(String value) {
        return (LDAModel)this.set(this.featuresCol(), value);
    }

    public LDAModel setTopicDistributionCol(String value) {
        return (LDAModel)this.set(this.topicDistributionCol(), value);
    }

    public LDAModel setSeed(long value) {
        return (LDAModel)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.topicDistributionCol()))).nonEmpty()) {
            Function1<Vector, Vector> transformer = this.oldLocalModel().getTopicDistributionMethod();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
            public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1(LDAModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1(LDAModel $outer) {
                }
            }
            UserDefinedFunction t = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)v -> ((Vector)transformer.apply((Object)Vectors$.MODULE$.fromML((org.apache.spark.ml.linalg.Vector)v))).asML(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1(null)));
            dataset2 = dataset.withColumn(this.$(this.topicDistributionCol()), t.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.columnToVector(dataset, this.getFeaturesCol())}))).toDF();
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "LDAModel.transform was called without any output columns. Set an output column such as topicDistributionCol to produce results.");
            dataset2 = dataset.toDF();
        }
        return dataset2;
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public org.apache.spark.ml.linalg.Vector estimatedDocConcentration() {
        return VectorImplicits$.MODULE$.mllibVectorToMLVector(this.getModel().docConcentration());
    }

    public Matrix topicsMatrix() {
        return this.oldLocalModel().topicsMatrix().asML();
    }

    public abstract boolean isDistributed();

    public double logLikelihood(Dataset<?> dataset) {
        RDD<Tuple2<Object, Vector>> oldDataset = LDA$.MODULE$.getOldDataset(dataset, this.$(this.featuresCol()));
        return this.oldLocalModel().logLikelihood(oldDataset);
    }

    public double logPerplexity(Dataset<?> dataset) {
        RDD<Tuple2<Object, Vector>> oldDataset = LDA$.MODULE$.getOldDataset(dataset, this.$(this.featuresCol()));
        return this.oldLocalModel().logPerplexity(oldDataset);
    }

    public Dataset<Row> describeTopics(int maxTermsPerTopic) {
        Tuple3[] topics = (Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getModel().describeTopics(maxTermsPerTopic))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            int topic;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    topic = tuple22._2$mcI$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int[] termIndices = (int[])tuple2._1();
            double[] termWeights = (double[])tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)topic), (Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(termIndices)).toSeq(), (Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(termWeights)).toSeq());
            return tuple3;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))));
            }

            public Org_apache_spark_ml_clustering_LDAModel$$typecreator1$2(LDAModel $outer) {
            }
        }
        return this.sparkSession().createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])topics), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator1$2(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic", "termIndices", "termWeights"}));
    }

    public Dataset<Row> describeTopics() {
        return this.describeTopics(10);
    }

    public LDAModel(String uid, int vocabSize, SparkSession sparkSession) {
        this.uid = uid;
        this.vocabSize = vocabSize;
        this.sparkSession = sparkSession;
        HasFeaturesCol.$init$(this);
        HasMaxIter.$init$(this);
        HasSeed.$init$(this);
        HasCheckpointInterval.$init$(this);
        LDAParams.$init$(this);
        MLWritable.$init$(this);
    }
}

