/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.IOException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.evaluation.ClusteringEvaluator$;
import org.apache.spark.ml.evaluation.CosineSilhouette$;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.SquaredEuclideanSilhouette$;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\f\u0019\u0001\rB\u0001\"\u000f\u0001\u0003\u0006\u0004%\tE\u000f\u0005\t#\u0002\u0011\t\u0011)A\u0005w!)1\u000b\u0001C\u0001)\")1\u000b\u0001C\u00013\")1\f\u0001C!9\")A\r\u0001C!K\")1\u000e\u0001C\u0001Y\")\u0011\u000f\u0001C\u0001e\"9Q\u000f\u0001b\u0001\n\u00031\bBB>\u0001A\u0003%q\u000fC\u0003~\u0001\u0011\u0005!\b\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\t\u0003\u000f\u0001!\u0019!C\u0001m\"9\u0011q\u0002\u0001!\u0002\u00139\bBBA\n\u0001\u0011\u0005!\bC\u0004\u0002\u0018\u0001!\t!!\u0007\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"\u001d9\u0011Q\f\r\t\u0002\u0005}cAB\f\u0019\u0011\u0003\t\t\u0007\u0003\u0004T'\u0011\u0005\u0011Q\u000f\u0005\b\u0003o\u001aB\u0011IA=\u0011%\t\tiEA\u0001\n\u0013\t\u0019IA\nDYV\u001cH/\u001a:j]\u001e,e/\u00197vCR|'O\u0003\u0002\u001a5\u0005QQM^1mk\u0006$\u0018n\u001c8\u000b\u0005ma\u0012AA7m\u0015\tib$A\u0003ta\u0006\u00148N\u0003\u0002 A\u00051\u0011\r]1dQ\u0016T\u0011!I\u0001\u0004_J<7\u0001A\n\u0006\u0001\u0011B\u0003g\r\t\u0003K\u0019j\u0011\u0001G\u0005\u0003Oa\u0011\u0011\"\u0012<bYV\fGo\u001c:\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013AB:iCJ,GM\u0003\u0002.5\u0005)\u0001/\u0019:b[&\u0011qF\u000b\u0002\u0011\u0011\u0006\u001c\bK]3eS\u000e$\u0018n\u001c8D_2\u0004\"!K\u0019\n\u0005IR#A\u0004%bg\u001a+\u0017\r^;sKN\u001cu\u000e\u001c\t\u0003i]j\u0011!\u000e\u0006\u0003mi\tA!\u001e;jY&\u0011\u0001(\u000e\u0002\u0016\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:Xe&$\u0018M\u00197f\u0003\r)\u0018\u000eZ\u000b\u0002wA\u0011A(\u0012\b\u0003{\r\u0003\"AP!\u000e\u0003}R!\u0001\u0011\u0012\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0003\u0019\u0001&/\u001a3fM&\u0011ai\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011\u000b\u0005fA\u0001J\u001fB\u0011!*T\u0007\u0002\u0017*\u0011A\nH\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001(L\u0005\u0015\u0019\u0016N\\2fC\u0005\u0001\u0016!\u0002\u001a/g9\u0002\u0014\u0001B;jI\u0002B3AA%P\u0003\u0019a\u0014N\\5u}Q\u0011QK\u0016\t\u0003K\u0001AQ!O\u0002A\u0002mB3AV%PQ\r\u0019\u0011j\u0014\u000b\u0002+\"\u001aA!S(\u0002\t\r|\u0007/\u001f\u000b\u0003+vCQAX\u0003A\u0002}\u000bA\u0001]'baB\u0011\u0001-Y\u0007\u0002Y%\u0011!\r\f\u0002\t!\u0006\u0014\u0018-\\'ba\"\u001aQ!S(\u0002\u001d%\u001cH*\u0019:hKJ\u0014U\r\u001e;feV\ta\r\u0005\u0002hQ6\t\u0011)\u0003\u0002j\u0003\n9!i\\8mK\u0006t\u0007f\u0001\u0004J\u001f\u0006\u00012/\u001a;Qe\u0016$\u0017n\u0019;j_:\u001cu\u000e\u001c\u000b\u0003[:l\u0011\u0001\u0001\u0005\u0006_\u001e\u0001\raO\u0001\u0006m\u0006dW/\u001a\u0015\u0004\u000f%{\u0015AD:fi\u001a+\u0017\r^;sKN\u001cu\u000e\u001c\u000b\u0003[NDQa\u001c\u0005A\u0002mB3\u0001C%P\u0003)iW\r\u001e:jG:\u000bW.Z\u000b\u0002oB\u0019\u0001\r_\u001e\n\u0005ed#!\u0002)be\u0006l\u0007fA\u0005J\u001f\u0006YQ.\u001a;sS\u000et\u0015-\\3!Q\rQ\u0011jT\u0001\u000eO\u0016$X*\u001a;sS\u000et\u0015-\\3)\u0007-Iu*A\u0007tKRlU\r\u001e:jG:\u000bW.\u001a\u000b\u0004[\u0006\r\u0001\"B8\r\u0001\u0004Y\u0004f\u0001\u0007J\u001f\u0006yA-[:uC:\u001cW-T3bgV\u0014X\r\u000b\u0003\u000e\u0013\u0006-\u0011EAA\u0007\u0003\u0015\u0011d\u0006\u000e\u00181\u0003A!\u0017n\u001d;b]\u000e,W*Z1tkJ,\u0007\u0005\u000b\u0003\u000f\u0013\u0006-\u0011AE4fi\u0012K7\u000f^1oG\u0016lU-Y:ve\u0016DCaD%\u0002\f\u0005\u00112/\u001a;ESN$\u0018M\\2f\u001b\u0016\f7/\u001e:f)\ri\u00171\u0004\u0005\u0006_B\u0001\ra\u000f\u0015\u0005!%\u000bY!\u0001\u0005fm\u0006dW/\u0019;f)\u0011\t\u0019#!\u000b\u0011\u0007\u001d\f)#C\u0002\u0002(\u0005\u0013a\u0001R8vE2,\u0007bBA\u0016#\u0001\u0007\u0011QF\u0001\bI\u0006$\u0018m]3ua\u0011\ty#a\u0010\u0011\r\u0005E\u0012qGA\u001e\u001b\t\t\u0019DC\u0002\u00026q\t1a]9m\u0013\u0011\tI$a\r\u0003\u000f\u0011\u000bG/Y:fiB!\u0011QHA \u0019\u0001!A\"!\u0011\u0002*\u0005\u0005\t\u0011!B\u0001\u0003\u0007\u00121a\u0018\u00132#\u0011\t)%a\u0013\u0011\u0007\u001d\f9%C\u0002\u0002J\u0005\u0013qAT8uQ&tw\rE\u0002h\u0003\u001bJ1!a\u0014B\u0005\r\te.\u001f\u0015\u0004#%{\u0005f\u0001\u0001J\u001f\"\u001a\u0001!a\u0016\u0011\u0007)\u000bI&C\u0002\u0002\\-\u0013A\"\u0012=qKJLW.\u001a8uC2\f1c\u00117vgR,'/\u001b8h\u000bZ\fG.^1u_J\u0004\"!J\n\u0014\u000fM\t\u0019'!\u001b\u0002pA\u0019q-!\u001a\n\u0007\u0005\u001d\u0014I\u0001\u0004B]f\u0014VM\u001a\t\u0005i\u0005-T+C\u0002\u0002nU\u0012Q\u0003R3gCVdG\u000fU1sC6\u001c(+Z1eC\ndW\rE\u0002h\u0003cJ1!a\u001dB\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\ty&\u0001\u0003m_\u0006$GcA+\u0002|!1\u0011QP\u000bA\u0002m\nA\u0001]1uQ\"\u001aQ#S(\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u000b\u0003B!a\"\u0002\u00126\u0011\u0011\u0011\u0012\u0006\u0005\u0003\u0017\u000bi)\u0001\u0003mC:<'BAAH\u0003\u0011Q\u0017M^1\n\t\u0005M\u0015\u0011\u0012\u0002\u0007\u001f\nTWm\u0019;)\u0007MIu\nK\u0002\u0013\u0013>\u0003")
public class ClusteringEvaluator
extends Evaluator
implements HasPredictionCol,
HasFeaturesCol,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> metricName;
    private final Param<String> distanceMeasure;
    private final Param<String> featuresCol;
    private final Param<String> predictionCol;

    public static ClusteringEvaluator load(String string) {
        return ClusteringEvaluator$.MODULE$.load(string);
    }

    public static MLReader<ClusteringEvaluator> read() {
        return ClusteringEvaluator$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public ClusteringEvaluator copy(ParamMap pMap) {
        return (ClusteringEvaluator)this.defaultCopy(pMap);
    }

    @Override
    public boolean isLargerBetter() {
        return true;
    }

    public ClusteringEvaluator setPredictionCol(String value) {
        return (ClusteringEvaluator)this.set(this.predictionCol(), value);
    }

    public ClusteringEvaluator setFeaturesCol(String value) {
        return (ClusteringEvaluator)this.set(this.featuresCol(), value);
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public ClusteringEvaluator setMetricName(String value) {
        return (ClusteringEvaluator)this.set(this.metricName(), value);
    }

    public Param<String> distanceMeasure() {
        return this.distanceMeasure;
    }

    public String getDistanceMeasure() {
        return this.$(this.distanceMeasure());
    }

    public ClusteringEvaluator setDistanceMeasure(String value) {
        return (ClusteringEvaluator)this.set(this.distanceMeasure(), value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public double evaluate(Dataset<?> dataset) {
        SchemaUtils$.MODULE$.validateVectorCompatibleColumn(dataset.schema(), this.$(this.featuresCol()));
        SchemaUtils$.MODULE$.checkNumericType(dataset.schema(), this.$(this.predictionCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        Column vectorCol = DatasetUtils$.MODULE$.columnToVector(dataset, this.$(this.featuresCol()));
        Dataset df = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.predictionCol())), vectorCol.as(this.$(this.featuresCol()), dataset.schema().apply(this.$(this.featuresCol())).metadata())}));
        Tuple2 tuple2 = new Tuple2((Object)this.$(this.metricName()), (Object)this.$(this.distanceMeasure()));
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String string2 = (String)tuple2._2();
            if ("silhouette".equals(string) && "squaredEuclidean".equals(string2)) {
                return SquaredEuclideanSilhouette$.MODULE$.computeSilhouetteScore(df, this.$(this.predictionCol()), this.$(this.featuresCol()));
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String string3 = (String)tuple2._2();
            if ("silhouette".equals(string) && "cosine".equals(string3)) {
                return CosineSilhouette$.MODULE$.computeSilhouetteScore(df, this.$(this.predictionCol()), this.$(this.featuresCol()));
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String mn = (String)tuple2._1();
        String dm = (String)tuple2._2();
        throw new IllegalArgumentException(new StringBuilder(33).append("No support for metric ").append(mn).append(", distance ").append(dm).toString());
    }

    public ClusteringEvaluator(String uid) {
        this.uid = uid;
        HasPredictionCol.$init$(this);
        HasFeaturesCol.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Function1 allowedParams = ParamValidators$.MODULE$.inArray(new String[]{"silhouette"});
        this.metricName = new Param(this, "metricName", "metric name in evaluation (silhouette)", allowedParams);
        String[] availableValues = (String[])((Object[])new String[]{"squaredEuclidean", "cosine"});
        Function1 allowedParams2 = ParamValidators$.MODULE$.inArray(availableValues);
        this.distanceMeasure = new Param(this, "distanceMeasure", new StringBuilder(51).append("distance measure in evaluation. Supported options: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])availableValues)).mkString("'", "', '", "'")).toString(), allowedParams2);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("silhouette"), this.distanceMeasure().$minus$greater("squaredEuclidean")}));
    }

    public ClusteringEvaluator() {
        this(Identifiable$.MODULE$.randomUID("cluEval"));
    }
}

