/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.evaluation.CosineSilhouette$;
import org.apache.spark.ml.evaluation.Silhouette;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class CosineSilhouette$
extends Silhouette {
    public static CosineSilhouette$ MODULE$;
    private final String normalizedFeaturesColName;

    static {
        new CosineSilhouette$();
    }

    public Map<Object, Tuple2<Vector, Object>> computeClusterStats(Dataset<Row> df, String featuresCol, String predictionCol) {
        int numFeatures = this.getNumberOfFeatures(df, featuresCol);
        RDD clustersStatsRDD = RDD$.MODULE$.rddToPairRDDFunctions(df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(predictionCol).cast((DataType)DoubleType$.MODULE$), functions$.MODULE$.col(this.normalizedFeaturesColName)})).rdd().map((Function1 & Serializable & scala.Serializable)row -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)row.getDouble(0)), row.getAs(1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Double$.MODULE$).aggregateByKey((Object)new Tuple2((Object)Vectors$.MODULE$.zeros(numFeatures).toDense(), (Object)BoxesRunTime.boxToLong((long)0L)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            long numOfPoints;
            DenseVector normalizedFeaturesSum;
            Vector normalizedFeatures;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 == null) break block2;
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    normalizedFeatures = (Vector)tuple2._2();
                    if (tuple22 == null) break block2;
                    normalizedFeaturesSum = (DenseVector)tuple22._1();
                    numOfPoints = tuple22._2$mcJ$sp();
                    if (normalizedFeaturesSum != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            DenseVector denseVector = normalizedFeaturesSum;
            long l = numOfPoints;
            BLAS$.MODULE$.axpy(1.0, normalizedFeatures, (Vector)denseVector);
            Tuple2 tuple2 = new Tuple2((Object)denseVector, (Object)BoxesRunTime.boxToLong((long)(l + 1L)));
            return tuple2;
        }, (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            long numOfPoints1;
            DenseVector normalizedFeaturesSum1;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$2, x1$2);
                    if (tuple22 == null) break block2;
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple23 == null) break block2;
                    normalizedFeaturesSum1 = (DenseVector)tuple23._1();
                    numOfPoints1 = tuple23._2$mcJ$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            DenseVector normalizedFeaturesSum2 = (DenseVector)tuple2._1();
            long numOfPoints2 = tuple2._2$mcJ$sp();
            BLAS$.MODULE$.axpy(1.0, (Vector)normalizedFeaturesSum2, (Vector)normalizedFeaturesSum1);
            Tuple2 tuple24 = new Tuple2((Object)normalizedFeaturesSum1, (Object)BoxesRunTime.boxToLong((long)(numOfPoints1 + numOfPoints2)));
            return tuple24;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return RDD$.MODULE$.rddToPairRDDFunctions(clustersStatsRDD, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Double$.MODULE$).collectAsMap().toMap(Predef$.MODULE$.$conforms());
    }

    public double computeSilhouetteCoefficient(Broadcast<Map<Object, Tuple2<Vector, Object>>> broadcastedClustersMap, Vector normalizedFeatures, double clusterId) {
        return this.pointSilhouetteCoefficient((Set<Object>)((scala.collection.immutable.MapLike)broadcastedClustersMap.value()).keySet(), clusterId, ((Tuple2)((MapLike)broadcastedClustersMap.value()).apply((Object)BoxesRunTime.boxToDouble((double)clusterId)))._2$mcJ$sp(), (Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable & scala.Serializable)targetClusterId -> CosineSilhouette$.compute$2(targetClusterId, broadcastedClustersMap, normalizedFeatures));
    }

    public double computeSilhouetteScore(Dataset<?> dataset, String predictionCol, String featuresCol) {
        public final class Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator2$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator2$2() {
            }
        }
        public final class Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator1$2() {
            }
        }
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        UserDefinedFunction normalizeFeatureUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> {
            Vector vector;
            double norm = Vectors$.MODULE$.norm(features, 2.0);
            Vector vector2 = features;
            if (vector2 instanceof DenseVector) {
                DenseVector denseVector = (DenseVector)vector2;
                vector = Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(denseVector.values())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$6 -> x$6 / norm, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            } else if (vector2 instanceof SparseVector) {
                SparseVector sparseVector = (SparseVector)vector2;
                vector = Vectors$.MODULE$.sparse(sparseVector.size(), sparseVector.indices(), (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sparseVector.values())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$7 -> x$7 / norm, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            } else {
                throw new MatchError((Object)vector2);
            }
            return vector;
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator1$2()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator2$2()));
        Dataset dfWithNormalizedFeatures = dataset.withColumn(this.normalizedFeaturesColName, normalizeFeatureUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(featuresCol)})));
        Map<Object, Tuple2<Vector, Object>> clustersStatsMap = this.computeClusterStats((Dataset<Row>)dfWithNormalizedFeatures, featuresCol, predictionCol);
        Predef$.MODULE$.assert(clustersStatsMap.size() > 1, (Function0 & Serializable & scala.Serializable)() -> "Number of clusters must be greater than one.");
        Broadcast bClustersStatsMap = dataset.sparkSession().sparkContext().broadcast(clustersStatsMap, ClassTag$.MODULE$.apply(Map.class));
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator3$1() {
            }
        }
        UserDefinedFunction computeSilhouetteCoefficientUDF = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(x$8, x$9) -> BoxesRunTime.boxToDouble((double)CosineSilhouette$.MODULE$.computeSilhouetteCoefficient((Broadcast<Map<Object, Tuple2<Vector, Object>>>)bClustersStatsMap, x$8, BoxesRunTime.unboxToDouble((Object)x$9))), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator3$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
        double silhouetteScore = this.overallScore((Dataset<Row>)dfWithNormalizedFeatures, computeSilhouetteCoefficientUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.normalizedFeaturesColName), functions$.MODULE$.col(predictionCol).cast((DataType)DoubleType$.MODULE$)})));
        bClustersStatsMap.destroy();
        return silhouetteScore;
    }

    private static final double compute$2(double targetClusterId, Broadcast broadcastedClustersMap$2, Vector normalizedFeatures$1) {
        Tuple2 tuple2 = (Tuple2)((MapLike)broadcastedClustersMap$2.value()).apply((Object)BoxesRunTime.boxToDouble((double)targetClusterId));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector normalizedFeatureSum = (Vector)tuple2._1();
        long numOfPoints = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)normalizedFeatureSum, (Object)BoxesRunTime.boxToLong((long)numOfPoints));
        Tuple2 tuple23 = tuple22;
        Vector normalizedFeatureSum2 = (Vector)tuple23._1();
        long numOfPoints2 = tuple23._2$mcJ$sp();
        return 1.0 - BLAS$.MODULE$.dot(normalizedFeatures$1, normalizedFeatureSum2) / (double)numOfPoints2;
    }

    private CosineSilhouette$() {
        MODULE$ = this;
        this.normalizedFeaturesColName = "normalizedFeatures";
    }
}

