/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.recommendation;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.recommendation.ALSModel$;
import org.apache.spark.ml.recommendation.ALSModelParams;
import org.apache.spark.ml.recommendation.TopByKeyAggregator;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.BoundedPriorityQueue;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\rMa\u0001B\u00193\u0001uB\u0001\"\u0014\u0001\u0003\u0006\u0004%\tE\u0014\u0005\tK\u0002\u0011\t\u0011)A\u0005\u001f\"Aq\r\u0001BC\u0002\u0013\u0005\u0001\u000e\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003j\u0011!\u0001\bA!b\u0001\n\u0003\t\b\"CA\u0004\u0001\t\u0005\t\u0015!\u0003s\u0011%\t\t\u0002\u0001BC\u0002\u0013\u0005\u0011\u000fC\u0005\u0002\u0014\u0001\u0011\t\u0011)A\u0005e\"A\u0011q\u0003\u0001\u0005\u0002Q\nI\u0002C\u0004\u0002(\u0001!\t!!\u000b\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u00111\b\u0001\u0005\u0002\u0005u\u0002bBA$\u0001\u0011\u0005\u0011\u0011\n\u0005\n\u0003'\u0002!\u0019!C\u0005\u0003+B\u0001\"a\u0019\u0001A\u0003%\u0011q\u000b\u0005\b\u0003K\u0002A\u0011IA4\u0011\u001d\t\u0019\n\u0001C!\u0003+Cq!!+\u0001\t\u0003\nY\u000bC\u0004\u0002D\u0002!\t%!2\t\u000f\u0005M\u0007\u0001\"\u0001\u0002V\"9\u0011Q\u001c\u0001\u0005\u0002\u0005}\u0007bBA{\u0001\u0011\u0005\u0011q\u001f\u0005\b\u0003\u007f\u0004A\u0011\u0001B\u0001\u0011\u001d\u0011\u0019\u0002\u0001C\u0005\u0005+AqAa\u000b\u0001\t\u0013\u0011i\u0003C\u0004\u0003D\u0001!IA!\u0012\t\u0013\tM\u0004!%A\u0005\n\tUta\u0002BFe!\u0005!Q\u0012\u0004\u0007cIB\tAa$\t\u000f\u0005]Q\u0004\"\u0001\u0003$\"I!QU\u000fC\u0002\u0013%!q\u0015\u0005\t\u0005ok\u0002\u0015!\u0003\u0003*\"I!\u0011X\u000fC\u0002\u0013%!q\u0015\u0005\t\u0005wk\u0002\u0015!\u0003\u0003*\"Q!QX\u000fC\u0002\u0013\u0015!Ga0\t\u0011\t\rW\u0004)A\u0007\u0005\u0003DqA!2\u001e\t\u0003\u00129\rC\u0004\u0003Rv!\tEa5\u0007\u000f\tmW\u0004A\u000f\u0003^\"I!q\\\u0014\u0003\u0002\u0003\u0006IA\u0011\u0005\b\u0003/9C\u0011\u0001Bq\u0011\u001d\u0011Io\nC)\u0005W4aA!>\u001e\t\t]\bbBA\fW\u0011\u0005!\u0011 \u0005\n\u0005{\\#\u0019!C\u0005\u0005OC\u0001Ba@,A\u0003%!\u0011\u0016\u0005\b\u0005#\\C\u0011IB\u0001\u0011%\u0019)!HA\u0001\n\u0013\u00199A\u0001\u0005B\u0019Nku\u000eZ3m\u0015\t\u0019D'\u0001\bsK\u000e|W.\\3oI\u0006$\u0018n\u001c8\u000b\u0005U2\u0014AA7m\u0015\t9\u0004(A\u0003ta\u0006\u00148N\u0003\u0002:u\u00051\u0011\r]1dQ\u0016T\u0011aO\u0001\u0004_J<7\u0001A\n\u0005\u0001y\"u\tE\u0002@\u0001\nk\u0011\u0001N\u0005\u0003\u0003R\u0012Q!T8eK2\u0004\"a\u0011\u0001\u000e\u0003I\u0002\"aQ#\n\u0005\u0019\u0013$AD!M'6{G-\u001a7QCJ\fWn\u001d\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015R\nA!\u001e;jY&\u0011A*\u0013\u0002\u000b\u001b2;&/\u001b;bE2,\u0017aA;jIV\tq\n\u0005\u0002Q3:\u0011\u0011k\u0016\t\u0003%Vk\u0011a\u0015\u0006\u0003)r\na\u0001\u0010:p_Rt$\"\u0001,\u0002\u000bM\u001c\u0017\r\\1\n\u0005a+\u0016A\u0002)sK\u0012,g-\u0003\u0002[7\n11\u000b\u001e:j]\u001eT!\u0001W+)\u0007\u0005i6\r\u0005\u0002_C6\tqL\u0003\u0002am\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\t|&!B*j]\u000e,\u0017%\u00013\u0002\u000bErCG\f\u0019\u0002\tULG\r\t\u0015\u0004\u0005u\u001b\u0017\u0001\u0002:b].,\u0012!\u001b\t\u0003U.l\u0011!V\u0005\u0003YV\u00131!\u00138uQ\r\u0019QlY\u0001\u0006e\u0006t7\u000e\t\u0015\u0004\tu\u001b\u0017aC;tKJ4\u0015m\u0019;peN,\u0012A\u001d\t\u0004g\u0006\u0005aB\u0001;~\u001d\t)8P\u0004\u0002wu:\u0011q/\u001f\b\u0003%bL\u0011aO\u0005\u0003siJ!a\u000e\u001d\n\u0005q4\u0014aA:rY&\u0011ap`\u0001\ba\u0006\u001c7.Y4f\u0015\tah'\u0003\u0003\u0002\u0004\u0005\u0015!!\u0003#bi\u00064%/Y7f\u0015\tqx0\u0001\u0007vg\u0016\u0014h)Y2u_J\u001c\b\u0005K\u0002\u0007\u0003\u0017\u00012A[A\u0007\u0013\r\ty!\u0016\u0002\niJ\fgn]5f]R\f1\"\u001b;f[\u001a\u000b7\r^8sg\u0006a\u0011\u000e^3n\r\u0006\u001cGo\u001c:tA!\u001a\u0001\"a\u0003\u0002\rqJg.\u001b;?)%\u0011\u00151DA\u0010\u0003G\t)\u0003C\u0003N\u0013\u0001\u0007q\n\u000b\u0003\u0002\u001cu\u001b\u0007\"B4\n\u0001\u0004I\u0007\u0006BA\u0010;\u000eDQ\u0001]\u0005A\u0002IDa!!\u0005\n\u0001\u0004\u0011\u0018AC:fiV\u001bXM]\"pYR!\u00111FA\u0017\u001b\u0005\u0001\u0001BBA\u0018\u0015\u0001\u0007q*A\u0003wC2,X\rK\u0002\u000b;\u000e\f!b]3u\u0013R,WnQ8m)\u0011\tY#a\u000e\t\r\u0005=2\u00021\u0001PQ\rYQlY\u0001\u0011g\u0016$\bK]3eS\u000e$\u0018n\u001c8D_2$B!a\u000b\u0002@!1\u0011q\u0006\u0007A\u0002=CC\u0001D/\u0002D\u0005\u0012\u0011QI\u0001\u0006c9\u001ad\u0006M\u0001\u0015g\u0016$8i\u001c7e'R\f'\u000f^*ue\u0006$XmZ=\u0015\t\u0005-\u00121\n\u0005\u0007\u0003_i\u0001\u0019A()\t5i\u0016qJ\u0011\u0003\u0003#\nQA\r\u00183]A\nq\u0001\u001d:fI&\u001cG/\u0006\u0002\u0002XA!\u0011\u0011LA0\u001b\t\tYFC\u0002\u0002^}\f1\"\u001a=qe\u0016\u001c8/[8og&!\u0011\u0011MA.\u0005M)6/\u001a:EK\u001aLg.\u001a3Gk:\u001cG/[8o\u0003!\u0001(/\u001a3jGR\u0004\u0013!\u0003;sC:\u001chm\u001c:n)\r\u0011\u0018\u0011\u000e\u0005\b\u0003W\u0002\u0002\u0019AA7\u0003\u001d!\u0017\r^1tKR\u0004D!a\u001c\u0002|A1\u0011\u0011OA:\u0003oj\u0011a`\u0005\u0004\u0003kz(a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003s\nY\b\u0004\u0001\u0005\u0019\u0005u\u0014\u0011NA\u0001\u0002\u0003\u0015\t!a \u0003\u0007}#\u0013'\u0005\u0003\u0002\u0002\u0006\u001d\u0005c\u00016\u0002\u0004&\u0019\u0011QQ+\u0003\u000f9{G\u000f[5oOB\u0019!.!#\n\u0007\u0005-UKA\u0002B]fDC\u0001E/\u0002\u0010\u0006\u0012\u0011\u0011S\u0001\u0006e9\u0002d\u0006M\u0001\u0010iJ\fgn\u001d4pe6\u001c6\r[3nCR!\u0011qSAR!\u0011\tI*a(\u000e\u0005\u0005m%bAAO\u007f\u0006)A/\u001f9fg&!\u0011\u0011UAN\u0005)\u0019FO];diRK\b/\u001a\u0005\b\u0003K\u000b\u0002\u0019AAL\u0003\u0019\u00198\r[3nC\"\"\u0011#XA\"\u0003\u0011\u0019w\u000e]=\u0015\u0007\t\u000bi\u000bC\u0004\u00020J\u0001\r!!-\u0002\u000b\u0015DHO]1\u0011\t\u0005M\u0016\u0011X\u0007\u0003\u0003kS1!a.5\u0003\u0015\u0001\u0018M]1n\u0013\u0011\tY,!.\u0003\u0011A\u000b'/Y7NCBDCAE/\u0002@\u0006\u0012\u0011\u0011Y\u0001\u0006c9*d\u0006M\u0001\u0006oJLG/Z\u000b\u0003\u0003\u000f\u00042\u0001SAe\u0013\r\tY-\u0013\u0002\t\u001b2;&/\u001b;fe\"\"1#XAhC\t\t\t.A\u00032]Yr\u0003'\u0001\u000bsK\u000e|W.\\3oI\u001a{'/\u00117m+N,'o\u001d\u000b\u0004e\u0006]\u0007BBAm)\u0001\u0007\u0011.\u0001\u0005ok6LE/Z7tQ\u0011!R,a\u0014\u0002-I,7m\\7nK:$gi\u001c:Vg\u0016\u00148+\u001e2tKR$RA]Aq\u0003[Dq!a\u001b\u0016\u0001\u0004\t\u0019\u000f\r\u0003\u0002f\u0006%\bCBA9\u0003g\n9\u000f\u0005\u0003\u0002z\u0005%H\u0001DAv\u0003C\f\t\u0011!A\u0003\u0002\u0005}$aA0%e!1\u0011\u0011\\\u000bA\u0002%DC!F/\u0002r\u0006\u0012\u00111_\u0001\u0006e9\u001ad\u0006M\u0001\u0015e\u0016\u001cw.\\7f]\u00124uN]!mY&#X-\\:\u0015\u0007I\fI\u0010\u0003\u0004\u0002|Z\u0001\r![\u0001\t]VlWk]3sg\"\"a#XA(\u0003Y\u0011XmY8n[\u0016tGMR8s\u0013R,WnU;cg\u0016$H#\u0002:\u0003\u0004\t=\u0001bBA6/\u0001\u0007!Q\u0001\u0019\u0005\u0005\u000f\u0011Y\u0001\u0005\u0004\u0002r\u0005M$\u0011\u0002\t\u0005\u0003s\u0012Y\u0001\u0002\u0007\u0003\u000e\t\r\u0011\u0011!A\u0001\u0006\u0003\tyHA\u0002`IMBa!a?\u0018\u0001\u0004I\u0007\u0006B\f^\u0003c\fQcZ3u'>,(oY3GC\u000e$xN]*vEN,G\u000fF\u0004s\u0005/\u0011\u0019Ca\n\t\u000f\u0005-\u0004\u00041\u0001\u0003\u001aA\"!1\u0004B\u0010!\u0019\t\t(a\u001d\u0003\u001eA!\u0011\u0011\u0010B\u0010\t1\u0011\tCa\u0006\u0002\u0002\u0003\u0005)\u0011AA@\u0005\ryF\u0005\u000e\u0005\u0007\u0005KA\u0002\u0019\u0001:\u0002\u000f\u0019\f7\r^8sg\"1!\u0011\u0006\rA\u0002=\u000baaY8mk6t\u0017a\u0004:fG>lW.\u001a8e\r>\u0014\u0018\t\u001c7\u0015\u0017I\u0014yCa\r\u00038\tm\"q\b\u0005\u0007\u0005cI\u0002\u0019\u0001:\u0002\u0015M\u00148MR1di>\u00148\u000f\u0003\u0004\u00036e\u0001\rA]\u0001\u000bIN$h)Y2u_J\u001c\bB\u0002B\u001d3\u0001\u0007q*A\bte\u000e|U\u000f\u001e9vi\u000e{G.^7o\u0011\u0019\u0011i$\u0007a\u0001\u001f\u0006yAm\u001d;PkR\u0004X\u000f^\"pYVlg\u000e\u0003\u0004\u0003Be\u0001\r![\u0001\u0004]Vl\u0017\u0001\u00032m_\u000e\\\u0017NZ=\u0015\r\t\u001d#1\u000eB8!\u0019\t\t(a\u001d\u0003JA1!1\nB*\u00053rAA!\u0014\u0003R9\u0019!Ka\u0014\n\u0003YK!A`+\n\t\tU#q\u000b\u0002\u0004'\u0016\f(B\u0001@V!\u0019Q'1L5\u0003`%\u0019!QL+\u0003\rQ+\b\u000f\\33!\u0015Q'\u0011\rB3\u0013\r\u0011\u0019'\u0016\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004U\n\u001d\u0014b\u0001B5+\n)a\t\\8bi\"9!Q\u0005\u000eA\u0002\t5\u0004CBA9\u0003g\u0012I\u0006\u0003\u0005\u0003ri\u0001\n\u00111\u0001j\u0003%\u0011Gn\\2l'&TX-\u0001\ncY>\u001c7.\u001b4zI\u0011,g-Y;mi\u0012\u0012TC\u0001B<U\rI'\u0011P\u0016\u0003\u0005w\u0002BA! \u0003\u00066\u0011!q\u0010\u0006\u0005\u0005\u0003\u0013\u0019)A\u0005v]\u000eDWmY6fI*\u0011\u0001-V\u0005\u0005\u0005\u000f\u0013yHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016DC\u0001A/\u0002D\u0005A\u0011\tT*N_\u0012,G\u000e\u0005\u0002D;M9QD!%\u0003\u0018\nu\u0005c\u00016\u0003\u0014&\u0019!QS+\u0003\r\u0005s\u0017PU3g!\u0011A%\u0011\u0014\"\n\u0007\tm\u0015J\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016\u00042A\u001bBP\u0013\r\u0011\t+\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0005\u001b\u000b1AT1O+\t\u0011I\u000b\u0005\u0003\u0003,\nUVB\u0001BW\u0015\u0011\u0011yK!-\u0002\t1\fgn\u001a\u0006\u0003\u0005g\u000bAA[1wC&\u0019!L!,\u0002\t9\u000bg\nI\u0001\u0005\tJ|\u0007/A\u0003Ee>\u0004\b%\u0001\u000ftkB\u0004xN\u001d;fI\u000e{G\u000eZ*uCJ$8\u000b\u001e:bi\u0016<\u0017.Z:\u0016\u0005\t\u0005\u0007#\u00026\u0003b\t%\u0016!H:vaB|'\u000f^3e\u0007>dGm\u0015;beR\u001cFO]1uK\u001eLWm\u001d\u0011\u0002\tI,\u0017\rZ\u000b\u0003\u0005\u0013\u0004B\u0001\u0013Bf\u0005&\u0019!QZ%\u0003\u00115c%+Z1eKJDC!J/\u0002P\u0006!An\\1e)\r\u0011%Q\u001b\u0005\u0007\u0005/4\u0003\u0019A(\u0002\tA\fG\u000f\u001b\u0015\u0005Mu\u000byM\u0001\bB\u0019Nku\u000eZ3m/JLG/\u001a:\u0014\u0007\u001d\n9-\u0001\u0005j]N$\u0018M\\2f)\u0011\u0011\u0019Oa:\u0011\u0007\t\u0015x%D\u0001\u001e\u0011\u0019\u0011y.\u000ba\u0001\u0005\u0006A1/\u0019<f\u00136\u0004H\u000e\u0006\u0003\u0003n\nM\bc\u00016\u0003p&\u0019!\u0011_+\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0005/T\u0003\u0019A(\u0003\u001d\u0005c5+T8eK2\u0014V-\u00193feN\u00191F!3\u0015\u0005\tm\bc\u0001BsW\u0005I1\r\\1tg:\u000bW.Z\u0001\u000bG2\f7o\u001d(b[\u0016\u0004Cc\u0001\"\u0004\u0004!1!q[\u0018A\u0002=\u000b1B]3bIJ+7o\u001c7wKR\u00111\u0011\u0002\t\u0005\u0005W\u001bY!\u0003\u0003\u0004\u000e\t5&AB(cU\u0016\u001cG\u000f\u000b\u0003\u001e;\u0006=\u0007\u0006\u0002\u000f^\u0003\u001f\u0004")
public class ALSModel
extends Model<ALSModel>
implements ALSModelParams,
MLWritable {
    private final String uid;
    private final int rank;
    private final transient Dataset<Row> userFactors;
    private final transient Dataset<Row> itemFactors;
    private final UserDefinedFunction predict;
    private final Param<String> userCol;
    private final Param<String> itemCol;
    private final UserDefinedFunction checkedCast;
    private final Param<String> coldStartStrategy;
    private final Param<String> predictionCol;

    public static ALSModel load(String string) {
        return ALSModel$.MODULE$.load(string);
    }

    public static MLReader<ALSModel> read() {
        return ALSModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public String getUserCol() {
        return ALSModelParams.getUserCol$(this);
    }

    @Override
    public String getItemCol() {
        return ALSModelParams.getItemCol$(this);
    }

    @Override
    public String getColdStartStrategy() {
        return ALSModelParams.getColdStartStrategy$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public Param<String> userCol() {
        return this.userCol;
    }

    @Override
    public Param<String> itemCol() {
        return this.itemCol;
    }

    @Override
    public UserDefinedFunction checkedCast() {
        return this.checkedCast;
    }

    @Override
    public Param<String> coldStartStrategy() {
        return this.coldStartStrategy;
    }

    @Override
    public void org$apache$spark$ml$recommendation$ALSModelParams$_setter_$userCol_$eq(Param<String> x$1) {
        this.userCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$recommendation$ALSModelParams$_setter_$itemCol_$eq(Param<String> x$1) {
        this.itemCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$recommendation$ALSModelParams$_setter_$checkedCast_$eq(UserDefinedFunction x$1) {
        this.checkedCast = x$1;
    }

    @Override
    public void org$apache$spark$ml$recommendation$ALSModelParams$_setter_$coldStartStrategy_$eq(Param<String> x$1) {
        this.coldStartStrategy = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public int rank() {
        return this.rank;
    }

    public Dataset<Row> userFactors() {
        return this.userFactors;
    }

    public Dataset<Row> itemFactors() {
        return this.itemFactors;
    }

    public ALSModel setUserCol(String value) {
        return (ALSModel)this.set(this.userCol(), value);
    }

    public ALSModel setItemCol(String value) {
        return (ALSModel)this.set(this.itemCol(), value);
    }

    public ALSModel setPredictionCol(String value) {
        return (ALSModel)this.set(this.predictionCol(), value);
    }

    public ALSModel setColdStartStrategy(String value) {
        return (ALSModel)this.set(this.coldStartStrategy(), value);
    }

    private UserDefinedFunction predict() {
        return this.predict;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        this.transformSchema(dataset.schema());
        Dataset predictions = dataset.join(this.userFactors(), this.checkedCast().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{dataset.apply(this.$(this.userCol()))})).$eq$eq$eq((Object)this.userFactors().apply("id")), "left").join(this.itemFactors(), this.checkedCast().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{dataset.apply(this.$(this.itemCol()))})).$eq$eq$eq((Object)this.itemFactors().apply("id")), "left").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{dataset.apply("*"), this.predict().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.userFactors().apply("features"), this.itemFactors().apply("features")})).as(this.$(this.predictionCol()))}));
        String string = this.getColdStartStrategy();
        String string2 = ALSModel$.MODULE$.org$apache$spark$ml$recommendation$ALSModel$$Drop();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            dataset2 = predictions.na().drop("all", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$(this.predictionCol())})));
        } else {
            String string4 = ALSModel$.MODULE$.org$apache$spark$ml$recommendation$ALSModel$$NaN();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                dataset2 = predictions;
            } else {
                throw new MatchError((Object)string);
            }
        }
        return dataset2;
    }

    @Override
    public StructType transformSchema(StructType schema) {
        SchemaUtils$.MODULE$.checkNumericType(schema, this.$(this.userCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        SchemaUtils$.MODULE$.checkNumericType(schema, this.$(this.itemCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        return SchemaUtils$.MODULE$.appendColumn(schema, this.$(this.predictionCol()), (DataType)FloatType$.MODULE$, SchemaUtils$.MODULE$.appendColumn$default$4());
    }

    @Override
    public ALSModel copy(ParamMap extra) {
        ALSModel copied = new ALSModel(this.uid(), this.rank(), this.userFactors(), this.itemFactors());
        return (ALSModel)((Model)this.copyValues(copied, extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new ALSModelWriter(this);
    }

    public Dataset<Row> recommendForAllUsers(int numItems) {
        return this.recommendForAll(this.userFactors(), this.itemFactors(), this.$(this.userCol()), this.$(this.itemCol()), numItems);
    }

    public Dataset<Row> recommendForUserSubset(Dataset<?> dataset, int numItems) {
        Dataset<Row> srcFactorSubset = this.getSourceFactorSubset(dataset, this.userFactors(), this.$(this.userCol()));
        return this.recommendForAll(srcFactorSubset, this.itemFactors(), this.$(this.userCol()), this.$(this.itemCol()), numItems);
    }

    public Dataset<Row> recommendForAllItems(int numUsers) {
        return this.recommendForAll(this.itemFactors(), this.userFactors(), this.$(this.itemCol()), this.$(this.userCol()), numUsers);
    }

    public Dataset<Row> recommendForItemSubset(Dataset<?> dataset, int numUsers) {
        Dataset<Row> srcFactorSubset = this.getSourceFactorSubset(dataset, this.itemFactors(), this.$(this.itemCol()));
        return this.recommendForAll(srcFactorSubset, this.userFactors(), this.$(this.itemCol()), this.$(this.userCol()), numUsers);
    }

    private Dataset<Row> getSourceFactorSubset(Dataset<?> dataset, Dataset<Row> factors, String column) {
        return factors.join(dataset.select(column, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), factors.apply("id").$eq$eq$eq((Object)dataset.apply(column)), "left_semi").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{factors.apply("id"), factors.apply("features")}));
    }

    private Dataset<Row> recommendForAll(Dataset<Row> srcFactors, Dataset<Row> dstFactors, String srcOutputColumn, String dstOutputColumn, int num) {
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator13$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator13$1(ALSModel $outer) {
            }
        }
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator4$1(ALSModel $outer) {
            }
        }
        Dataset<Seq<Tuple2<Object, float[]>>> srcFactorsBlocked = this.blockify((Dataset<Tuple2<Object, float[]>>)srcFactors.as(srcFactors.sparkSession().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator4$1(null)))), this.blockify$default$2());
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator5$1(ALSModel $outer) {
            }
        }
        Dataset<Seq<Tuple2<Object, float[]>>> dstFactorsBlocked = this.blockify((Dataset<Tuple2<Object, float[]>>)dstFactors.as(srcFactors.sparkSession().implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator5$1(null)))), this.blockify$default$2());
        JavaUniverse $u3 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        JavaUniverse $u4 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator9$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator9$1(ALSModel $outer) {
            }
        }
        Dataset ratings = srcFactorsBlocked.crossJoin(dstFactorsBlocked).as(srcFactors.sparkSession().implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator9$1(null)))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq srcIter = (Seq)tuple2._1();
            Seq dstIter = (Seq)tuple2._2();
            int m = srcIter.size();
            int n = scala.math.package$.MODULE$.min(dstIter.size(), num);
            Tuple3[] output = new Tuple3[m * n];
            IntRef i = IntRef.create((int)0);
            BoundedPriorityQueue pq = new BoundedPriorityQueue(num, package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToFloat((float)ALSModel.$anonfun$recommendForAll$2(x$1)), (Ordering)Ordering.Float$.MODULE$));
            srcIter.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ALSModel.$anonfun$recommendForAll$3(this, dstIter, pq, output, i, x0$2);
                return BoxedUnit.UNIT;
            });
            Seq seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])output)).toSeq();
            return seq;
        }, srcFactors.sparkSession().implicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator13$1(null))));
        TopByKeyAggregator topKAggregator = new TopByKeyAggregator(num, package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToFloat((float)ALSModel.$anonfun$recommendForAll$6(x$2)), (Ordering)Ordering.Float$.MODULE$), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Float());
        JavaUniverse $u5 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator17$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator17$1(ALSModel $outer) {
            }
        }
        Dataset recs = ratings.as(srcFactors.sparkSession().implicits().newProductEncoder(((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator17$1(null)))).groupByKey((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ALSModel.$anonfun$recommendForAll$7(x$3)), srcFactors.sparkSession().implicits().newIntEncoder()).agg(topKAggregator.toColumn()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "recommendations"}));
        ArrayType arrayType = ArrayType$.MODULE$.apply((DataType)new StructType().add(dstOutputColumn, (DataType)IntegerType$.MODULE$).add("rating", (DataType)FloatType$.MODULE$));
        return recs.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{srcFactors.sparkSession().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).as(srcOutputColumn), srcFactors.sparkSession().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"recommendations"}))).$((Seq)Nil$.MODULE$).cast((DataType)arrayType)}));
    }

    private Dataset<Seq<Tuple2<Object, float[]>>> blockify(Dataset<Tuple2<Object, float[]>> factors, int blockSize) {
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator3$1(ALSModel $outer) {
            }
        }
        return factors.mapPartitions((Function1 & Serializable & scala.Serializable)x$4 -> x$4.grouped(blockSize), factors.sparkSession().implicits().newSequenceEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator3$1(null))));
    }

    private int blockify$default$2() {
        return 4096;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ float $anonfun$predict$1(ALSModel $this, Seq featuresA, Seq featuresB) {
        float f;
        if (featuresA != null && featuresB != null) {
            void var3_3;
            float dotProduct = 0.0f;
            for (int i = 0; i < $this.rank(); ++i) {
                dotProduct += BoxesRunTime.unboxToFloat((Object)featuresA.apply(i)) * BoxesRunTime.unboxToFloat((Object)featuresB.apply(i));
            }
            f = var3_3;
        } else {
            f = Float.NaN;
        }
        return f;
    }

    public static final /* synthetic */ float $anonfun$recommendForAll$2(Tuple2 x$1) {
        return BoxesRunTime.unboxToFloat((Object)x$1._2());
    }

    public static final /* synthetic */ void $anonfun$recommendForAll$5(Tuple3[] output$1, IntRef i$1, int srcId$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            int dstId = tuple2._1$mcI$sp();
            float score = BoxesRunTime.unboxToFloat((Object)tuple2._2());
            output$1[i$1.elem] = new Tuple3((Object)BoxesRunTime.boxToInteger((int)srcId$1), (Object)BoxesRunTime.boxToInteger((int)dstId), (Object)BoxesRunTime.boxToFloat((float)score));
            ++i$1.elem;
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$recommendForAll$3(ALSModel $this, Seq dstIter$1, BoundedPriorityQueue pq$1, Tuple3[] output$1, IntRef i$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int srcId = tuple2._1$mcI$sp();
        float[] srcFactor = (float[])tuple2._2();
        dstIter$1.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int dstId = tuple2._1$mcI$sp();
            float[] dstFactor = (float[])tuple2._2();
            float score = BLAS$.MODULE$.f2jBLAS().sdot($this.rank(), srcFactor, 1, dstFactor, 1);
            BoundedPriorityQueue boundedPriorityQueue = pq$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)dstId)), (Object)BoxesRunTime.boxToFloat((float)score)));
            return boundedPriorityQueue;
        });
        pq$1.foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            ALSModel.$anonfun$recommendForAll$5(output$1, i$1, srcId, x0$4);
            return BoxedUnit.UNIT;
        });
        pq$1.clear();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ float $anonfun$recommendForAll$6(Tuple2 x$2) {
        return BoxesRunTime.unboxToFloat((Object)x$2._2());
    }

    public static final /* synthetic */ int $anonfun$recommendForAll$7(Tuple3 x$3) {
        return BoxesRunTime.unboxToInt((Object)x$3._1());
    }

    public ALSModel(String uid, int rank, Dataset<Row> userFactors, Dataset<Row> itemFactors) {
        this.uid = uid;
        this.rank = rank;
        this.userFactors = userFactors;
        this.itemFactors = itemFactors;
        HasPredictionCol.$init$(this);
        ALSModelParams.$init$(this);
        MLWritable.$init$(this);
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator1$1(ALSModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator2$1(ALSModel $outer) {
            }
        }
        this.predict = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(featuresA, featuresB) -> BoxesRunTime.boxToFloat((float)ALSModel.$anonfun$predict$1(this, featuresA, featuresB)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Float(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator2$1(null)));
    }

    public static class ALSModelReader
    extends MLReader<ALSModel> {
        private final String className = ALSModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public ALSModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            DefaultFormats$ format = DefaultFormats$.MODULE$;
            int rank = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(metadata.metadata()).$bslash("rank")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            String userPath = new Path(path, "userFactors").toString();
            Dataset userFactors = this.sparkSession().read().format("parquet").load(userPath);
            String itemPath = new Path(path, "itemFactors").toString();
            Dataset itemFactors = this.sparkSession().read().format("parquet").load(itemPath);
            ALSModel model = new ALSModel(metadata.uid(), rank, (Dataset<Row>)userFactors, (Dataset<Row>)itemFactors);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class ALSModelWriter
    extends MLWriter {
        private final ALSModel instance;

        @Override
        public void saveImpl(String path) {
            Tuple2 extraMetadata = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rank"), (Object)BoxesRunTime.boxToInteger((int)this.instance.rank()));
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), (Option<JsonAST.JObject>)new Some((Object)JsonDSL$.MODULE$.pair2jvalue(extraMetadata, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            String userPath = new Path(path, "userFactors").toString();
            this.instance.userFactors().write().format("parquet").save(userPath);
            String itemPath = new Path(path, "itemFactors").toString();
            this.instance.itemFactors().write().format("parquet").save(itemPath);
        }

        public ALSModelWriter(ALSModel instance) {
            this.instance = instance;
        }
    }
}

