/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasVarianceCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.DecisionTreeRegressor$;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.DecisionTreeRegressorParams;
import org.apache.spark.ml.tree.TreeRegressorParams;
import org.apache.spark.ml.tree.impl.RandomForest$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t=a\u0001\u0002\u000e\u001c\u0001\u0019B\u0001B\u0011\u0001\u0003\u0006\u0004%\te\u0011\u0005\t5\u0002\u0011\t\u0011)A\u0005\t\")A\f\u0001C\u0001;\")A\f\u0001C\u0001C\")1\r\u0001C!I\")Q\u000e\u0001C!]\")\u0011\u000f\u0001C!e\")Q\u000f\u0001C!m\")A\u0010\u0001C!{\"9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0001bBA\b\u0001\u0011\u0005\u0013\u0011\u0003\u0005\b\u0003/\u0001A\u0011IA\r\u0011\u001d\ty\u0002\u0001C!\u0003CAq!!\r\u0001\t\u0003\t\u0019\u0004C\u0004\u0002>\u0001!\t&a\u0010\t\u0011\u0005u\u0002\u0001\"\u0001\u001e\u0003SB\u0001\"!)\u0001\t\u0003i\u00121\u0015\u0005\b\u0003_\u0003A\u0011IAY\u000f\u001d\t9m\u0007E\u0001\u0003\u00134aAG\u000e\t\u0002\u0005-\u0007B\u0002/\u0015\t\u0003\ty\u000eC\u0005\u0002bR\u0011\r\u0011\"\u0002\u0002d\"A\u00111\u001e\u000b!\u0002\u001b\t)\u000fC\u0004\u0002nR!\t%a<\t\u0013\u0005]H#!A\u0005\n\u0005e(!\u0006#fG&\u001c\u0018n\u001c8Ue\u0016,'+Z4sKN\u001cxN\u001d\u0006\u00039u\t!B]3he\u0016\u001c8/[8o\u0015\tqr$\u0001\u0002nY*\u0011\u0001%I\u0001\u0006gB\f'o\u001b\u0006\u0003E\r\na!\u00199bG\",'\"\u0001\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u00019c\u0007\u0010\t\u0006Q%Z\u0013gM\u0007\u0002;%\u0011!&\b\u0002\n!J,G-[2u_J\u0004\"\u0001L\u0018\u000e\u00035R!AL\u000f\u0002\r1Lg.\u00197h\u0013\t\u0001TF\u0001\u0004WK\u000e$xN\u001d\t\u0003e\u0001i\u0011a\u0007\t\u0003eQJ!!N\u000e\u00037\u0011+7-[:j_:$&/Z3SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\t9$(D\u00019\u0015\tIT$\u0001\u0003ue\u0016,\u0017BA\u001e9\u0005m!UmY5tS>tGK]3f%\u0016<'/Z:t_J\u0004\u0016M]1ngB\u0011Q\bQ\u0007\u0002})\u0011q(H\u0001\u0005kRLG.\u0003\u0002B}\t)B)\u001a4bk2$\b+\u0019:b[N<&/\u001b;bE2,\u0017aA;jIV\tA\t\u0005\u0002F\u001d:\u0011a\t\u0014\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013\u0016\na\u0001\u0010:p_Rt$\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S\u0015A\u0002)sK\u0012,g-\u0003\u0002P!\n11\u000b\u001e:j]\u001eT!!\u0014&)\u0007\u0005\u0011\u0006\f\u0005\u0002T-6\tAK\u0003\u0002V?\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005]#&!B*j]\u000e,\u0017%A-\u0002\u000bErCG\f\u0019\u0002\tULG\r\t\u0015\u0004\u0005IC\u0016A\u0002\u001fj]&$h\b\u0006\u00022=\")!i\u0001a\u0001\t\"\u001aaL\u0015-)\u0007\r\u0011\u0006\fF\u00012Q\r!!\u000bW\u0001\fg\u0016$X*\u0019=EKB$\b\u000e\u0006\u0002fM6\t\u0001\u0001C\u0003h\u000b\u0001\u0007\u0001.A\u0003wC2,X\r\u0005\u0002jU6\t!*\u0003\u0002l\u0015\n\u0019\u0011J\u001c;)\u0007\u0015\u0011\u0006,\u0001\u0006tKRl\u0015\r\u001f\"j]N$\"!Z8\t\u000b\u001d4\u0001\u0019\u00015)\u0007\u0019\u0011\u0006,\u0001\ftKRl\u0015N\\%ogR\fgnY3t!\u0016\u0014hj\u001c3f)\t)7\u000fC\u0003h\u000f\u0001\u0007\u0001\u000eK\u0002\b%b\u000bab]3u\u001b&t\u0017J\u001c4p\u000f\u0006Lg\u000e\u0006\u0002fo\")q\r\u0003a\u0001qB\u0011\u0011._\u0005\u0003u*\u0013a\u0001R8vE2,\u0007f\u0001\u0005S1\u0006\u00012/\u001a;NCblU-\\8ss&sWJ\u0011\u000b\u0003KzDQaZ\u0005A\u0002!D3!\u0003*Y\u0003=\u0019X\r^\"bG\",gj\u001c3f\u0013\u0012\u001cHcA3\u0002\u0006!1qM\u0003a\u0001\u0003\u000f\u00012![A\u0005\u0013\r\tYA\u0013\u0002\b\u0005>|G.Z1oQ\rQ!\u000bW\u0001\u0016g\u0016$8\t[3dWB|\u0017N\u001c;J]R,'O^1m)\r)\u00171\u0003\u0005\u0006O.\u0001\r\u0001\u001b\u0015\u0004\u0017IC\u0016aC:fi&k\u0007/\u001e:jif$2!ZA\u000e\u0011\u00159G\u00021\u0001EQ\ra!\u000bW\u0001\bg\u0016$8+Z3e)\r)\u00171\u0005\u0005\u0007O6\u0001\r!!\n\u0011\u0007%\f9#C\u0002\u0002*)\u0013A\u0001T8oO\"\"QBUA\u0017C\t\ty#A\u00032]Yr\u0003'\u0001\btKR4\u0016M]5b]\u000e,7i\u001c7\u0015\u0007\u0015\f)\u0004C\u0003h\u001d\u0001\u0007A\t\u000b\u0003\u000f%\u0006e\u0012EAA\u001e\u0003\u0015\u0011d\u0006\r\u00181\u0003\u0015!(/Y5o)\r\u0019\u0014\u0011\t\u0005\b\u0003\u0007z\u0001\u0019AA#\u0003\u001d!\u0017\r^1tKR\u0004D!a\u0012\u0002XA1\u0011\u0011JA(\u0003'j!!a\u0013\u000b\u0007\u00055s$A\u0002tc2LA!!\u0015\u0002L\t9A)\u0019;bg\u0016$\b\u0003BA+\u0003/b\u0001\u0001\u0002\u0007\u0002Z\u0005\u0005\u0013\u0011!A\u0001\u0006\u0003\tYFA\u0002`IE\nB!!\u0018\u0002dA\u0019\u0011.a\u0018\n\u0007\u0005\u0005$JA\u0004O_RD\u0017N\\4\u0011\u0007%\f)'C\u0002\u0002h)\u00131!\u00118z)\u001d\u0019\u00141NAD\u0003;Cq!!\u001c\u0011\u0001\u0004\ty'\u0001\u0003eCR\f\u0007CBA9\u0003o\nY(\u0004\u0002\u0002t)\u0019\u0011QO\u0010\u0002\u0007I$G-\u0003\u0003\u0002z\u0005M$a\u0001*E\tB!\u0011QPAB\u001b\t\tyHC\u0002\u0002\u0002v\tqAZ3biV\u0014X-\u0003\u0003\u0002\u0006\u0006}$\u0001\u0004'bE\u0016dW\r\u001a)pS:$\bbBAE!\u0001\u0007\u00111R\u0001\f_2$7\u000b\u001e:bi\u0016<\u0017\u0010\u0005\u0003\u0002\u000e\u0006eUBAAH\u0015\u0011\t\t*a%\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0015\rI\u0014Q\u0013\u0006\u0004\u0003/{\u0012!B7mY&\u0014\u0017\u0002BAN\u0003\u001f\u0013\u0001b\u0015;sCR,w-\u001f\u0005\u0007\u0003?\u0003\u0002\u0019\u0001#\u0002+\u0019,\u0017\r^;sKN+(m]3u'R\u0014\u0018\r^3hs\u0006qq-\u001a;PY\u0012\u001cFO]1uK\u001eLH\u0003BAF\u0003KCq!a*\u0012\u0001\u0004\tI+A\ndCR,wm\u001c:jG\u0006dg)Z1ukJ,7\u000fE\u0003F\u0003WC\u0007.C\u0002\u0002.B\u00131!T1q\u0003\u0011\u0019w\u000e]=\u0015\u0007E\n\u0019\fC\u0004\u00026J\u0001\r!a.\u0002\u000b\u0015DHO]1\u0011\t\u0005e\u0016qX\u0007\u0003\u0003wS1!!0\u001e\u0003\u0015\u0001\u0018M]1n\u0013\u0011\t\t-a/\u0003\u0011A\u000b'/Y7NCBD3A\u0005*YQ\r\u0001!\u000bW\u0001\u0016\t\u0016\u001c\u0017n]5p]R\u0013X-\u001a*fOJ,7o]8s!\t\u0011DcE\u0004\u0015\u0003\u001b\f\u0019.!7\u0011\u0007%\fy-C\u0002\u0002R*\u0013a!\u00118z%\u00164\u0007\u0003B\u001f\u0002VFJ1!a6?\u0005U!UMZ1vYR\u0004\u0016M]1ngJ+\u0017\rZ1cY\u0016\u00042![An\u0013\r\tiN\u0013\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0003\u0013\f1c];qa>\u0014H/\u001a3J[B,(/\u001b;jKN,\"!!:\u0011\t%\f9\u000fR\u0005\u0004\u0003ST%!B!se\u0006L\u0018\u0001F:vaB|'\u000f^3e\u00136\u0004XO]5uS\u0016\u001c\b%\u0001\u0003m_\u0006$GcA\u0019\u0002r\"1\u00111\u001f\rA\u0002\u0011\u000bA\u0001]1uQ\"\"\u0001DUA\u001d\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005m\b\u0003BA\u007f\u0005\u000fi!!a@\u000b\t\t\u0005!1A\u0001\u0005Y\u0006twM\u0003\u0002\u0003\u0006\u0005!!.\u0019<b\u0013\u0011\u0011I!a@\u0003\r=\u0013'.Z2uQ\r!\"\u000b\u0017\u0015\u0004'IC\u0006")
public class DecisionTreeRegressor
extends Predictor<Vector, DecisionTreeRegressor, DecisionTreeRegressionModel>
implements DecisionTreeRegressorParams,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> varianceCol;
    private final Param<String> impurity;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final LongParam seed;
    private final IntParam checkpointInterval;

    public static DecisionTreeRegressor load(String string) {
        return DecisionTreeRegressor$.MODULE$.load(string);
    }

    public static String[] supportedImpurities() {
        return DecisionTreeRegressor$.MODULE$.supportedImpurities();
    }

    public static MLReader<DecisionTreeRegressor> read() {
        return DecisionTreeRegressor$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$DecisionTreeRegressorParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return DecisionTreeRegressorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final String getVarianceCol() {
        return HasVarianceCol.getVarianceCol$(this);
    }

    @Override
    public final String getImpurity() {
        return TreeRegressorParams.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeRegressorParams.getOldImpurity$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    @Override
    public final Param<String> varianceCol() {
        return this.varianceCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasVarianceCol$_setter_$varianceCol_$eq(Param<String> x$1) {
        this.varianceCol = x$1;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeRegressorParams$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public DecisionTreeRegressor setMaxDepth(int value) {
        return (DecisionTreeRegressor)this.set(this.maxDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public DecisionTreeRegressor setMaxBins(int value) {
        return (DecisionTreeRegressor)this.set(this.maxBins(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public DecisionTreeRegressor setMinInstancesPerNode(int value) {
        return (DecisionTreeRegressor)this.set(this.minInstancesPerNode(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public DecisionTreeRegressor setMinInfoGain(double value) {
        return (DecisionTreeRegressor)this.set(this.minInfoGain(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public DecisionTreeRegressor setMaxMemoryInMB(int value) {
        return (DecisionTreeRegressor)this.set(this.maxMemoryInMB(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public DecisionTreeRegressor setCacheNodeIds(boolean value) {
        return (DecisionTreeRegressor)this.set(this.cacheNodeIds(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    @Override
    public DecisionTreeRegressor setCheckpointInterval(int value) {
        return (DecisionTreeRegressor)this.set(this.checkpointInterval(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public DecisionTreeRegressor setImpurity(String value) {
        return (DecisionTreeRegressor)this.set(this.impurity(), value);
    }

    @Override
    public DecisionTreeRegressor setSeed(long value) {
        return (DecisionTreeRegressor)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    public DecisionTreeRegressor setVarianceCol(String value) {
        return (DecisionTreeRegressor)this.set(this.varianceCol(), value);
    }

    @Override
    public DecisionTreeRegressionModel train(Dataset<?> dataset) {
        return (DecisionTreeRegressionModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            Map<Object, Object> categoricalFeatures = MetadataUtils$.MODULE$.getCategoricalFeatures(dataset.schema().apply(this.$(this.featuresCol())));
            RDD<LabeledPoint> oldDataset = this.extractLabeledPoints(dataset);
            Strategy strategy = this.getOldStrategy(categoricalFeatures);
            instr.logPipelineStage(this);
            instr.logDataset(oldDataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])this.params()));
            RDD<LabeledPoint> x$1 = oldDataset;
            Strategy x$2 = strategy;
            int x$3 = 1;
            String x$4 = "all";
            long x$5 = BoxesRunTime.unboxToLong((Object)this.$(this.seed()));
            Some x$6 = new Some(instr);
            Some x$7 = new Some((Object)this.uid());
            boolean x$8 = RandomForest$.MODULE$.run$default$7();
            DecisionTreeModel[] trees = RandomForest$.MODULE$.run(x$1, x$2, x$3, x$4, x$5, (Option<Instrumentation>)x$6, x$8, (Option<String>)x$7);
            return (DecisionTreeRegressionModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trees)).head();
        });
    }

    public DecisionTreeRegressionModel train(RDD<LabeledPoint> data, Strategy oldStrategy, String featureSubsetStrategy) {
        return (DecisionTreeRegressionModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            instr.logPipelineStage(this);
            instr.logDataset(data);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])this.params()));
            RDD x$1 = data;
            Strategy x$2 = oldStrategy;
            int x$3 = 1;
            String x$4 = featureSubsetStrategy;
            long x$5 = BoxesRunTime.unboxToLong((Object)this.$(this.seed()));
            Some x$6 = new Some(instr);
            Some x$7 = new Some((Object)this.uid());
            boolean x$8 = RandomForest$.MODULE$.run$default$7();
            DecisionTreeModel[] trees = RandomForest$.MODULE$.run((RDD<LabeledPoint>)x$1, x$2, x$3, x$4, x$5, (Option<Instrumentation>)x$6, x$8, (Option<String>)x$7);
            return (DecisionTreeRegressionModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trees)).head();
        });
    }

    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, 0, Algo$.MODULE$.Regression(), this.getOldImpurity(), 1.0);
    }

    @Override
    public DecisionTreeRegressor copy(ParamMap extra) {
        return (DecisionTreeRegressor)this.defaultCopy(extra);
    }

    public DecisionTreeRegressor(String uid) {
        this.uid = uid;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeRegressorParams.$init$(this);
        HasVarianceCol.$init$(this);
        DecisionTreeRegressorParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
    }

    public DecisionTreeRegressor() {
        this(Identifiable$.MODULE$.randomUID("dtr"));
    }
}

