/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.LBFGSB;
import breeze.optimize.LBFGSB$;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.WeightedLeastSquares;
import org.apache.spark.ml.optim.WeightedLeastSquares$;
import org.apache.spark.ml.optim.WeightedLeastSquares$Auto$;
import org.apache.spark.ml.optim.WeightedLeastSquaresModel;
import org.apache.spark.ml.optim.aggregator.HuberAggregator;
import org.apache.spark.ml.optim.aggregator.LeastSquaresAggregator;
import org.apache.spark.ml.optim.loss.DifferentiableRegularization;
import org.apache.spark.ml.optim.loss.L2Regularization;
import org.apache.spark.ml.optim.loss.RDDLossFunction;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasLoss;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.LinearRegression$;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.ml.regression.LinearRegressionParams;
import org.apache.spark.ml.regression.LinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.Regressor;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.Instrumentation$loggerTags$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.OptionalInstrumentation$;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tua\u0001B\u0014)\u0001MB\u0001\"\u0015\u0001\u0003\u0006\u0004%\tE\u0015\u0005\tS\u0002\u0011\t\u0011)A\u0005'\")1\u000e\u0001C\u0001Y\")1\u000e\u0001C\u0001a\")A\u000f\u0001C\u0001k\")a\u0010\u0001C\u0001\u007f\"9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0001bBA\f\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003?\u0001A\u0011AA\u0011\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!!\u000e\u0001\t\u0003\t9\u0004C\u0004\u0002B\u0001!\t!a\u0011\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003bBA1\u0001\u0011\u0005\u00111\r\u0005\b\u0003S\u0002A\u0011KA6\u0011\u001d\t)\n\u0001C!\u0003/;q!!,)\u0011\u0003\tyK\u0002\u0004(Q!\u0005\u0011\u0011\u0017\u0005\u0007WN!\t!!2\t\u000f\u0005\u001d7\u0003\"\u0011\u0002J\"I\u0011\u0011[\nC\u0002\u0013\u0005\u00111\u001b\u0005\t\u0003/\u001c\u0002\u0015!\u0003\u0002&!Q\u00111\\\nC\u0002\u0013\u0005\u0001&!8\t\u0011\u000558\u0003)A\u0005\u0003?D!\"a<\u0014\u0005\u0004%\t\u0001KAo\u0011!\t\tp\u0005Q\u0001\n\u0005}\u0007BCAz'\t\u0007I\u0011\u0001\u0015\u0002^\"A\u0011Q_\n!\u0002\u0013\ty\u000e\u0003\u0006\u0002xN\u0011\r\u0011\"\u0001)\u0003sD\u0001B!\u0001\u0014A\u0003%\u00111 \u0005\u000b\u0005\u0007\u0019\"\u0019!C\u0001Q\u0005u\u0007\u0002\u0003B\u0003'\u0001\u0006I!a8\t\u0015\t\u001d1C1A\u0005\u0002!\ni\u000e\u0003\u0005\u0003\nM\u0001\u000b\u0011BAp\u0011)\u0011Ya\u0005b\u0001\n\u0003A\u0013\u0011 \u0005\t\u0005\u001b\u0019\u0002\u0015!\u0003\u0002|\"I!qB\n\u0002\u0002\u0013%!\u0011\u0003\u0002\u0011\u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:T!!\u000b\u0016\u0002\u0015I,wM]3tg&|gN\u0003\u0002,Y\u0005\u0011Q\u000e\u001c\u0006\u0003[9\nQa\u001d9be.T!a\f\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0014aA8sO\u000e\u00011#\u0002\u00015\u0005\u0016[\u0005#B\u001b7qyzT\"\u0001\u0015\n\u0005]B#!\u0003*fOJ,7o]8s!\tID(D\u0001;\u0015\tY$&\u0001\u0004mS:\fGnZ\u0005\u0003{i\u0012aAV3di>\u0014\bCA\u001b\u0001!\t)\u0004)\u0003\u0002BQ\t)B*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007CA\u001bD\u0013\t!\u0005F\u0001\fMS:,\u0017M\u001d*fOJ,7o]5p]B\u000b'/Y7t!\t1\u0015*D\u0001H\u0015\tA%&\u0001\u0003vi&d\u0017B\u0001&H\u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016\u0004\"\u0001T(\u000e\u00035S!A\u0014\u0017\u0002\u0011%tG/\u001a:oC2L!\u0001U'\u0003\u000f1{wmZ5oO\u0006\u0019Q/\u001b3\u0016\u0003M\u0003\"\u0001V/\u000f\u0005U[\u0006C\u0001,Z\u001b\u00059&B\u0001-3\u0003\u0019a$o\\8u})\t!,A\u0003tG\u0006d\u0017-\u0003\u0002]3\u00061\u0001K]3eK\u001aL!AX0\u0003\rM#(/\u001b8h\u0015\ta\u0016\fK\u0002\u0002C\u001e\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u0017\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002gG\n)1+\u001b8dK\u0006\n\u0001.A\u00032]Mr\u0003'\u0001\u0003vS\u0012\u0004\u0003f\u0001\u0002bO\u00061A(\u001b8jiz\"\"AP7\t\u000bE\u001b\u0001\u0019A*)\u00075\fw\rK\u0002\u0004C\u001e$\u0012A\u0010\u0015\u0004\t\u0005\u0014\u0018%A:\u0002\u000bErCG\f\u0019\u0002\u0017M,GOU3h!\u0006\u0014\u0018-\u001c\u000b\u0003m^l\u0011\u0001\u0001\u0005\u0006q\u0016\u0001\r!_\u0001\u0006m\u0006dW/\u001a\t\u0003unl\u0011!W\u0005\u0003yf\u0013a\u0001R8vE2,\u0007fA\u0003bO\u0006y1/\u001a;GSRLe\u000e^3sG\u0016\u0004H\u000fF\u0002w\u0003\u0003Aa\u0001\u001f\u0004A\u0002\u0005\r\u0001c\u0001>\u0002\u0006%\u0019\u0011qA-\u0003\u000f\t{w\u000e\\3b]\"\"a!YA\u0006C\t\ti!A\u00032]Ur\u0003'\u0001\ntKR\u001cF/\u00198eCJ$\u0017N_1uS>tGc\u0001<\u0002\u0014!1\u0001p\u0002a\u0001\u0003\u0007ACaB1\u0002\f\u0005\u00112/\u001a;FY\u0006\u001cH/[2OKR\u0004\u0016M]1n)\r1\u00181\u0004\u0005\u0006q\"\u0001\r!\u001f\u0015\u0004\u0011\u0005\u0014\u0018AC:fi6\u000b\u00070\u0013;feR\u0019a/a\t\t\raL\u0001\u0019AA\u0013!\rQ\u0018qE\u0005\u0004\u0003SI&aA%oi\"\u001a\u0011\"Y4\u0002\rM,G\u000fV8m)\r1\u0018\u0011\u0007\u0005\u0006q*\u0001\r!\u001f\u0015\u0004\u0015\u0005\u0014\u0018\u0001D:fi^+\u0017n\u001a5u\u0007>dGc\u0001<\u0002:!)\u0001p\u0003a\u0001'\"\"1\"YA\u001fC\t\ty$A\u00032]Yr\u0003'A\u0005tKR\u001cv\u000e\u001c<feR\u0019a/!\u0012\t\u000bad\u0001\u0019A*)\t1\t\u0017QH\u0001\u0014g\u0016$\u0018iZ4sK\u001e\fG/[8o\t\u0016\u0004H\u000f\u001b\u000b\u0004m\u00065\u0003B\u0002=\u000e\u0001\u0004\t)\u0003\u000b\u0003\u000eC\u0006E\u0013EAA*\u0003\u0015\u0011d&\r\u00181\u0003\u001d\u0019X\r\u001e'pgN$2A^A-\u0011\u0015Ah\u00021\u0001TQ\u0011q\u0011-!\u0018\"\u0005\u0005}\u0013!\u0002\u001a/g9\u0002\u0014AC:fi\u0016\u00038/\u001b7p]R\u0019a/!\u001a\t\u000ba|\u0001\u0019A=)\t=\t\u0017QL\u0001\u0006iJ\f\u0017N\u001c\u000b\u0004\u007f\u00055\u0004bBA8!\u0001\u0007\u0011\u0011O\u0001\bI\u0006$\u0018m]3ua\u0011\t\u0019(a!\u0011\r\u0005U\u00141PA@\u001b\t\t9HC\u0002\u0002z1\n1a]9m\u0013\u0011\ti(a\u001e\u0003\u000f\u0011\u000bG/Y:fiB!\u0011\u0011QAB\u0019\u0001!A\"!\"\u0002n\u0005\u0005\t\u0011!B\u0001\u0003\u000f\u00131a\u0018\u00132#\u0011\tI)a$\u0011\u0007i\fY)C\u0002\u0002\u000ef\u0013qAT8uQ&tw\rE\u0002{\u0003#K1!a%Z\u0005\r\te._\u0001\u0005G>\u0004\u0018\u0010F\u0002?\u00033Cq!a'\u0012\u0001\u0004\ti*A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002 \u0006\u0015VBAAQ\u0015\r\t\u0019KK\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0003O\u000b\tK\u0001\u0005QCJ\fW.T1qQ\r\t\u0012M\u001d\u0015\u0004\u0001\u0005<\u0017\u0001\u0005'j]\u0016\f'OU3he\u0016\u001c8/[8o!\t)4cE\u0004\u0014\u0003g\u000bI,a0\u0011\u0007i\f),C\u0002\u00028f\u0013a!\u00118z%\u00164\u0007\u0003\u0002$\u0002<zJ1!!0H\u0005U!UMZ1vYR\u0004\u0016M]1ngJ+\u0017\rZ1cY\u0016\u00042A_Aa\u0013\r\t\u0019-\u0017\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0003_\u000bA\u0001\\8bIR\u0019a(a3\t\r\u00055W\u00031\u0001T\u0003\u0011\u0001\u0018\r\u001e5)\tU\t\u0017QH\u0001\u001f\u001b\u0006CvLR#B)V\u0013ViU0G\u001fJ{fj\u0014*N\u00032{6k\u0014'W\u000bJ+\"!!\n)\tY\t\u0017\u0011K\u0001 \u001b\u0006CvLR#B)V\u0013ViU0G\u001fJ{fj\u0014*N\u00032{6k\u0014'W\u000bJ\u0003\u0003\u0006B\fb\u0003#\nA!Q;u_V\u0011\u0011q\u001c\t\u0005\u0003C\fY/\u0004\u0002\u0002d*!\u0011Q]At\u0003\u0011a\u0017M\\4\u000b\u0005\u0005%\u0018\u0001\u00026bm\u0006L1AXAr\u0003\u0015\tU\u000f^8!\u0003\u0019quN]7bY\u00069aj\u001c:nC2\u0004\u0013!\u0002'C\r\u001e\u001b\u0016A\u0002'C\r\u001e\u001b\u0006%\u0001\ttkB\u0004xN\u001d;fIN{GN^3sgV\u0011\u00111 \t\u0006u\u0006u\u0018q\\\u0005\u0004\u0003\u007fL&!B!se\u0006L\u0018!E:vaB|'\u000f^3e'>dg/\u001a:tA\u0005a1+];be\u0016$WI\u001d:pe\u0006i1+];be\u0016$WI\u001d:pe\u0002\nQ\u0001S;cKJ\fa\u0001S;cKJ\u0004\u0013aD:vaB|'\u000f^3e\u0019>\u001c8/Z:\u0002!M,\b\u000f]8si\u0016$Gj\\:tKN\u0004\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0005\u0011\t\u0005\u0005(QC\u0005\u0005\u0005/\t\u0019O\u0001\u0004PE*,7\r\u001e\u0015\u0005'\u0005\fi\u0004\u000b\u0003\u0013C\u0006u\u0002")
public class LinearRegression
extends Regressor<Vector, LinearRegression, LinearRegressionModel>
implements LinearRegressionParams,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> solver;
    private final Param<String> loss;
    private final DoubleParam epsilon;
    private final IntParam aggregationDepth;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    public static int MAX_FEATURES_FOR_NORMAL_SOLVER() {
        return LinearRegression$.MODULE$.MAX_FEATURES_FOR_NORMAL_SOLVER();
    }

    public static LinearRegression load(String string) {
        return LinearRegression$.MODULE$.load(string);
    }

    public static MLReader<LinearRegression> read() {
        return LinearRegression$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$regression$LinearRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public double getEpsilon() {
        return LinearRegressionParams.getEpsilon$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LinearRegressionParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final String getLoss() {
        return HasLoss.getLoss$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam.getElasticNetParam$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final Param<String> loss() {
        return this.loss;
    }

    @Override
    public final DoubleParam epsilon() {
        return this.epsilon;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$loss_$eq(Param<String> x$1) {
        this.loss = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$epsilon_$eq(DoubleParam x$1) {
        this.epsilon = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasLoss$_setter_$loss_$eq(Param<String> x$1) {
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LinearRegression setRegParam(double value) {
        return (LinearRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setFitIntercept(boolean value) {
        return (LinearRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearRegression setStandardization(boolean value) {
        return (LinearRegression)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearRegression setElasticNetParam(double value) {
        return (LinearRegression)this.set(this.elasticNetParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setMaxIter(int value) {
        return (LinearRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LinearRegression setTol(double value) {
        return (LinearRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setWeightCol(String value) {
        return (LinearRegression)this.set(this.weightCol(), value);
    }

    public LinearRegression setSolver(String value) {
        return (LinearRegression)this.set(this.solver(), value);
    }

    public LinearRegression setAggregationDepth(int value) {
        return (LinearRegression)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    public LinearRegression setLoss(String value) {
        return (LinearRegression)this.set(this.loss(), value);
    }

    public LinearRegression setEpsilon(double value) {
        return (LinearRegression)this.set(this.epsilon(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public LinearRegressionModel train(Dataset<?> dataset) {
        LinearRegressionModel linearRegressionModel;
        Object object = new Object();
        try {
            linearRegressionModel = (LinearRegressionModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
                double d;
                double d2;
                double d3;
                double[] dArray;
                Vector vector;
                LBFGS lBFGS;
                RDDLossFunction rDDLossFunction;
                None$ none$;
                double d4;
                RDD instances;
                int numFeatures;
                block54: {
                    block55: {
                        numFeatures = ((Vector)((Row)dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).first()).getAs(0)).size();
                        Column w = !this.isDefined(this.weightCol()) || this.$(this.weightCol()).isEmpty() ? functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)) : functions$.MODULE$.col(this.$(this.weightCol()));
                        instances = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), w, functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                            double d;
                            double d2;
                            Object features;
                            block3: {
                                Row row;
                                block2: {
                                    row = x0$1;
                                    Some some = Row$.MODULE$.unapplySeq(row);
                                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block2;
                                    Object label = ((SeqLike)some.get()).apply(0);
                                    Object weight = ((SeqLike)some.get()).apply(1);
                                    features = ((SeqLike)some.get()).apply(2);
                                    if (!(label instanceof Double)) break block2;
                                    d2 = BoxesRunTime.unboxToDouble((Object)label);
                                    if (!(weight instanceof Double)) break block2;
                                    d = BoxesRunTime.unboxToDouble((Object)weight);
                                    if (features instanceof Vector) break block3;
                                }
                                throw new MatchError((Object)row);
                            }
                            Vector vector = (Vector)features;
                            Instance instance = new Instance(d2, d, vector);
                            return instance;
                        }, ClassTag$.MODULE$.apply(Instance.class));
                        instr.logPipelineStage(this);
                        instr.logDataset(dataset);
                        instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.featuresCol(), this.weightCol(), this.predictionCol(), this.solver(), this.tol(), this.elasticNetParam(), this.fitIntercept(), this.maxIter(), this.regParam(), this.standardization(), this.aggregationDepth(), this.loss(), this.epsilon()}));
                        instr.logNumFeatures(numFeatures);
                        String string = this.$(this.loss());
                        String string2 = LinearRegression$.MODULE$.SquaredError();
                        if (string != null ? !string.equals(string2) : string2 != null) break block54;
                        String string3 = this.$(this.solver());
                        String string4 = LinearRegression$.MODULE$.Auto();
                        if (!(string3 != null ? !string3.equals(string4) : string4 != null) && numFeatures <= WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES()) break block55;
                        String string5 = this.$(this.solver());
                        String string6 = LinearRegression$.MODULE$.Normal();
                        if (string5 != null ? !string5.equals(string6) : string6 != null) break block54;
                    }
                    WeightedLeastSquares optimizer = new WeightedLeastSquares(BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())), BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())), BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())), true, WeightedLeastSquares$Auto$.MODULE$, BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())));
                    WeightedLeastSquaresModel model = optimizer.fit((RDD<Instance>)instances, OptionalInstrumentation$.MODULE$.create((Instrumentation)instr));
                    LinearRegressionModel lrModel = this.copyValues(new LinearRegressionModel(this.uid(), (Vector)model.coefficients(), model.intercept()), this.copyValues$default$2());
                    Tuple2<LinearRegressionModel, String> tuple2 = lrModel.findSummaryModelAndPredictionCol();
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    LinearRegressionModel summaryModel = (LinearRegressionModel)tuple2._1();
                    String predictionColName = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)summaryModel, (Object)predictionColName);
                    Tuple2 tuple23 = tuple22;
                    LinearRegressionModel summaryModel2 = (LinearRegressionModel)tuple23._1();
                    String predictionColName2 = (String)tuple23._2();
                    LinearRegressionTrainingSummary trainingSummary = new LinearRegressionTrainingSummary(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), summaryModel2, model.diagInvAtWA().toArray(), model.objectiveHistory());
                    throw new NonLocalReturnControl(object, (Object)lrModel.setSummary((Option<LinearRegressionTrainingSummary>)new Some((Object)trainingSummary)));
                }
                StorageLevel storageLevel = dataset.storageLevel();
                StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
                boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
                Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
                Function2 & Serializable & scala.Serializable seqOp = (Function2 & Serializable & scala.Serializable)(c, instance) -> new Tuple2((Object)((MultivariateOnlineSummarizer)c._1()).add(VectorImplicits$.MODULE$.mlVectorToMLlibVector(instance.features()), instance.weight()), (Object)((MultivariateOnlineSummarizer)c._2()).add(VectorImplicits$.MODULE$.mlVectorToMLlibVector(Vectors$.MODULE$.dense(instance.label(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), instance.weight()));
                Function2 & Serializable & scala.Serializable combOp = (Function2 & Serializable & scala.Serializable)(c1, c2) -> new Tuple2((Object)((MultivariateOnlineSummarizer)c1._1()).merge((MultivariateOnlineSummarizer)c2._1()), (Object)((MultivariateOnlineSummarizer)c1._2()).merge((MultivariateOnlineSummarizer)c2._2()));
                Tuple2 tuple2 = (Tuple2)instances.treeAggregate((Object)new Tuple2((Object)new MultivariateOnlineSummarizer(), (Object)new MultivariateOnlineSummarizer()), (Function2)seqOp, (Function2)combOp, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(Tuple2.class));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                MultivariateOnlineSummarizer featuresSummarizer = (MultivariateOnlineSummarizer)tuple2._1();
                MultivariateOnlineSummarizer ySummarizer = (MultivariateOnlineSummarizer)tuple2._2();
                Tuple2 tuple24 = new Tuple2((Object)featuresSummarizer, (Object)ySummarizer);
                Tuple2 tuple25 = tuple24;
                MultivariateOnlineSummarizer featuresSummarizer2 = (MultivariateOnlineSummarizer)tuple25._1();
                MultivariateOnlineSummarizer ySummarizer2 = (MultivariateOnlineSummarizer)tuple25._2();
                double yMean = ySummarizer2.mean().apply(0);
                double rawYStd = package$.MODULE$.sqrt(ySummarizer2.variance().apply(0));
                instr.logNumExamples(ySummarizer2.count());
                instr.logNamedValue(Instrumentation$loggerTags$.MODULE$.meanOfLabels(), yMean);
                instr.logNamedValue(Instrumentation$loggerTags$.MODULE$.varianceOfLabels(), rawYStd);
                if (rawYStd == 0.0) {
                    if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) || yMean == 0.0) {
                        if (yMean == 0.0) {
                            instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(143).append("Mean and standard deviation of the label are zero, so the ").append("coefficients and the intercept will all be zero; as a result, training is not ").append("needed.").toString());
                        } else {
                            instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(164).append("The standard deviation of the label is zero, so the coefficients ").append("will be zeros and the intercept will be the mean of the label; as a result, ").append("training is not needed.").toString());
                        }
                        Object object2 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
                        Vector coefficients = Vectors$.MODULE$.sparse(numFeatures, (Seq)Seq$.MODULE$.empty());
                        double intercept = yMean;
                        LinearRegressionModel model = this.copyValues(new LinearRegressionModel(this.uid(), coefficients, intercept), this.copyValues$default$2());
                        Tuple2<LinearRegressionModel, String> tuple26 = model.findSummaryModelAndPredictionCol();
                        if (tuple26 == null) {
                            throw new MatchError(tuple26);
                        }
                        LinearRegressionModel summaryModel = (LinearRegressionModel)tuple26._1();
                        String predictionColName = (String)tuple26._2();
                        Tuple2 tuple27 = new Tuple2((Object)summaryModel, (Object)predictionColName);
                        Tuple2 tuple28 = tuple27;
                        LinearRegressionModel summaryModel3 = (LinearRegressionModel)tuple28._1();
                        String predictionColName3 = (String)tuple28._2();
                        LinearRegressionTrainingSummary trainingSummary = new LinearRegressionTrainingSummary(summaryModel3.transform(dataset), predictionColName3, this.$(this.labelCol()), this.$(this.featuresCol()), model, new double[]{0.0}, new double[]{0.0});
                        throw new NonLocalReturnControl(object, (Object)model.setSummary((Option<LinearRegressionTrainingSummary>)new Some((Object)trainingSummary)));
                    }
                    Predef$.MODULE$.require(BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0, (Function0 & Serializable & scala.Serializable)() -> "The standard deviation of the label is zero. Model cannot be regularized.");
                    instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append("The standard deviation of the label is zero. ").append("Consider setting fitIntercept=true.").toString());
                }
                double yStd = rawYStd > 0.0 ? rawYStd : package$.MODULE$.abs(yMean);
                double[] featuresMean = featuresSummarizer2.mean().toArray();
                double[] featuresStd = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featuresSummarizer2.variance().toArray())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.sqrt(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                Broadcast bcFeaturesMean = instances.context().broadcast((Object)featuresMean, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
                Broadcast bcFeaturesStd = instances.context().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
                if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures).exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> featuresStd[i] == 0.0 && featuresMean[i] != 0.0)) {
                    instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fitting LinearRegressionModel without intercept on dataset with constant nonzero column, Spark MLlib outputs zero coefficients for constant nonzero columns. This behavior is the same as R glmnet but different from LIBSVM.");
                }
                String string = this.$(this.loss());
                String string7 = LinearRegression$.MODULE$.SquaredError();
                String string8 = string;
                if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                    d4 = BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) / yStd;
                } else {
                    String string9 = LinearRegression$.MODULE$.Huber();
                    String string10 = string;
                    if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                        d4 = BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
                    } else {
                        throw new MatchError((Object)string);
                    }
                }
                double effectiveRegParam = d4;
                double effectiveL1RegParam = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) * effectiveRegParam;
                double effectiveL2RegParam = (1.0 - BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam()))) * effectiveRegParam;
                JFunction1.mcDI.sp & Serializable & scala.Serializable getFeaturesStd = (JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> j >= 0 && j < numFeatures ? featuresStd[j] : 0.0;
                if (effectiveL2RegParam != 0.0) {
                    JFunction1.mcZI.sp & Serializable & scala.Serializable shouldApply = (JFunction1.mcZI.sp & Serializable & scala.Serializable)idx -> idx >= 0 && idx < numFeatures;
                    none$ = new Some((Object)new L2Regularization(effectiveL2RegParam, (Function1<Object, Object>)shouldApply, (Option<Function1<Object, Object>>)(BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())) ? None$.MODULE$ : new Some((Object)getFeaturesStd))));
                } else {
                    none$ = None$.MODULE$;
                }
                None$ regularization = none$;
                String string11 = this.$(this.loss());
                String string12 = LinearRegression$.MODULE$.SquaredError();
                String string13 = string11;
                if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                    Function1 & Serializable & scala.Serializable getAggregatorFunc = (Function1 & Serializable & scala.Serializable)x$4 -> new LeastSquaresAggregator(yStd, yMean, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), (Broadcast<double[]>)bcFeaturesStd, (Broadcast<double[]>)bcFeaturesMean, (Broadcast<Vector>)x$4);
                    rDDLossFunction = new RDDLossFunction(instances, getAggregatorFunc, (Option<DifferentiableRegularization<Vector>>)regularization, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(Instance.class), ClassTag$.MODULE$.apply(LeastSquaresAggregator.class));
                } else {
                    String string14 = LinearRegression$.MODULE$.Huber();
                    String string15 = string11;
                    if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                        Function1 & Serializable & scala.Serializable getAggregatorFunc = (Function1 & Serializable & scala.Serializable)x$5 -> new HuberAggregator(BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToDouble((Object)this.$(this.epsilon())), (Broadcast<double[]>)bcFeaturesStd, (Broadcast<Vector>)x$5);
                        rDDLossFunction = new RDDLossFunction(instances, getAggregatorFunc, (Option<DifferentiableRegularization<Vector>>)regularization, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(Instance.class), ClassTag$.MODULE$.apply(HuberAggregator.class));
                    } else {
                        throw new MatchError((Object)string11);
                    }
                }
                RDDLossFunction costFun = rDDLossFunction;
                String string16 = this.$(this.loss());
                String string17 = LinearRegression$.MODULE$.SquaredError();
                String string18 = string16;
                if (!(string17 != null ? !string17.equals(string18) : string18 != null)) {
                    LBFGS lBFGS2;
                    if (BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0 || effectiveRegParam == 0.0) {
                        lBFGS2 = new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space_Double());
                    } else {
                        boolean standardizationParam = BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization()));
                        lBFGS2 = new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, LinearRegression.effectiveL1RegFun$1(standardizationParam, effectiveL1RegParam, featuresStd), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space_Double());
                    }
                    lBFGS = lBFGS2;
                } else {
                    String string19 = LinearRegression$.MODULE$.Huber();
                    String string20 = string16;
                    if (!(string19 != null ? !string19.equals(string20) : string20 != null)) {
                        int dim = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? numFeatures + 2 : numFeatures + 1;
                        DenseVector lowerBounds = DenseVector$.MODULE$.apply(Array$.MODULE$.fill(dim, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Double$.MODULE$.MinValue(), ClassTag$.MODULE$.Double()));
                        lowerBounds.update$mcD$sp(dim - 1, Double.MIN_VALUE);
                        DenseVector upperBounds = DenseVector$.MODULE$.apply(Array$.MODULE$.fill(dim, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Double.MAX_VALUE, ClassTag$.MODULE$.Double()));
                        lBFGS = new LBFGSB(lowerBounds, upperBounds, BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), LBFGSB$.MODULE$.$lessinit$greater$default$6(), LBFGSB$.MODULE$.$lessinit$greater$default$7());
                    } else {
                        throw new MatchError((Object)string16);
                    }
                }
                LBFGS optimizer = lBFGS;
                String string21 = this.$(this.loss());
                String string22 = LinearRegression$.MODULE$.SquaredError();
                String string23 = string21;
                if (!(string22 != null ? !string22.equals(string23) : string23 != null)) {
                    vector = Vectors$.MODULE$.zeros(numFeatures);
                } else {
                    String string24 = LinearRegression$.MODULE$.Huber();
                    String string25 = string21;
                    if (!(string24 != null ? !string24.equals(string25) : string25 != null)) {
                        int dim = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? numFeatures + 2 : numFeatures + 1;
                        vector = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(dim, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()));
                    } else {
                        throw new MatchError((Object)string21);
                    }
                }
                Vector initialValues = vector;
                Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction(costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)initialValues.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
                ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
                FirstOrderMinimizer.State state = null;
                while (states.hasNext()) {
                    state = (FirstOrderMinimizer.State)states.next();
                    arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
                }
                if (state == null) {
                    String msg = new StringBuilder(8).append(optimizer.getClass().getName()).append(" failed.").toString();
                    instr.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
                    throw new SparkException(msg);
                }
                bcFeaturesMean.destroy(false);
                bcFeaturesStd.destroy(false);
                double[] parameters = (double[])((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double()).clone();
                String string26 = this.$(this.loss());
                String string27 = LinearRegression$.MODULE$.SquaredError();
                String string28 = string26;
                if (!(string27 != null ? !string27.equals(string28) : string28 != null)) {
                    dArray = parameters;
                } else {
                    String string29 = LinearRegression$.MODULE$.Huber();
                    String string30 = string26;
                    if (!(string29 != null ? !string29.equals(string30) : string30 != null)) {
                        dArray = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(parameters)).slice(0, numFeatures);
                    } else {
                        throw new MatchError((Object)string26);
                    }
                }
                double[] rawCoefficients = dArray;
                int i2 = 0;
                int len = rawCoefficients.length;
                String string31 = this.$(this.loss());
                String string32 = LinearRegression$.MODULE$.SquaredError();
                String string33 = string31;
                if (!(string32 != null ? !string32.equals(string33) : string33 != null)) {
                    d3 = yStd;
                } else {
                    String string34 = LinearRegression$.MODULE$.Huber();
                    String string35 = string31;
                    if (!(string34 != null ? !string34.equals(string35) : string35 != null)) {
                        d3 = 1.0;
                    } else {
                        throw new MatchError((Object)string31);
                    }
                }
                double multiplier = d3;
                while (i2 < len) {
                    int n = i2;
                    rawCoefficients[n] = rawCoefficients[n] * (featuresStd[i2] != 0.0 ? multiplier / featuresStd[i2] : 0.0);
                    ++i2;
                }
                if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
                    double d5;
                    String string36 = this.$(this.loss());
                    String string37 = LinearRegression$.MODULE$.SquaredError();
                    String string38 = string36;
                    if (!(string37 != null ? !string37.equals(string38) : string38 != null)) {
                        d5 = yMean - BLAS$.MODULE$.dot(Vectors$.MODULE$.dense(rawCoefficients), Vectors$.MODULE$.dense(featuresMean));
                    } else {
                        String string39 = LinearRegression$.MODULE$.Huber();
                        String string40 = string36;
                        if (!(string39 != null ? !string39.equals(string40) : string40 != null)) {
                            d5 = parameters[numFeatures];
                        } else {
                            throw new MatchError((Object)string36);
                        }
                    }
                    d2 = d5;
                } else {
                    d2 = 0.0;
                }
                double interceptValue = d2;
                String string41 = this.$(this.loss());
                String string42 = LinearRegression$.MODULE$.SquaredError();
                String string43 = string41;
                if (!(string42 != null ? !string42.equals(string43) : string43 != null)) {
                    d = 1.0;
                } else {
                    String string44 = LinearRegression$.MODULE$.Huber();
                    String string45 = string41;
                    if (!(string44 != null ? !string44.equals(string45) : string45 != null)) {
                        d = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(parameters)).last());
                    } else {
                        throw new MatchError((Object)string41);
                    }
                }
                double scaleValue = d;
                Tuple4 tuple4 = new Tuple4((Object)Vectors$.MODULE$.dense(rawCoefficients).compressed(), (Object)BoxesRunTime.boxToDouble((double)interceptValue), (Object)BoxesRunTime.boxToDouble((double)scaleValue), arrayBuilder.result());
                if (tuple4 == null) {
                    throw new MatchError((Object)tuple4);
                }
                Vector coefficients = (Vector)tuple4._1();
                double intercept = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                double scale = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                double[] objectiveHistory = (double[])tuple4._4();
                Tuple4 tuple42 = new Tuple4((Object)coefficients, (Object)BoxesRunTime.boxToDouble((double)intercept), (Object)BoxesRunTime.boxToDouble((double)scale), (Object)objectiveHistory);
                Tuple4 tuple43 = tuple42;
                Vector coefficients2 = (Vector)tuple43._1();
                double intercept2 = BoxesRunTime.unboxToDouble((Object)tuple43._2());
                double scale2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
                double[] objectiveHistory2 = (double[])tuple43._4();
                Object object3 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
                LinearRegressionModel model = this.copyValues(new LinearRegressionModel(this.uid(), coefficients2, intercept2, scale2), this.copyValues$default$2());
                Tuple2<LinearRegressionModel, String> tuple29 = model.findSummaryModelAndPredictionCol();
                if (tuple29 == null) {
                    throw new MatchError(tuple29);
                }
                LinearRegressionModel summaryModel = (LinearRegressionModel)tuple29._1();
                String predictionColName = (String)tuple29._2();
                Tuple2 tuple210 = new Tuple2((Object)summaryModel, (Object)predictionColName);
                Tuple2 tuple211 = tuple210;
                LinearRegressionModel summaryModel4 = (LinearRegressionModel)tuple211._1();
                String predictionColName4 = (String)tuple211._2();
                LinearRegressionTrainingSummary trainingSummary = new LinearRegressionTrainingSummary(summaryModel4.transform(dataset), predictionColName4, this.$(this.labelCol()), this.$(this.featuresCol()), model, new double[]{0.0}, objectiveHistory2);
                return model.setSummary((Option<LinearRegressionTrainingSummary>)new Some((Object)trainingSummary));
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                linearRegressionModel = (LinearRegressionModel)ex.value();
            }
            throw ex;
        }
        return linearRegressionModel;
    }

    @Override
    public LinearRegression copy(ParamMap extra) {
        return (LinearRegression)this.defaultCopy(extra);
    }

    private static final Function1 effectiveL1RegFun$1(boolean standardizationParam$1, double effectiveL1RegParam$1, double[] featuresStd$1) {
        return (JFunction1.mcDI.sp & Serializable & scala.Serializable)index -> standardizationParam$1 ? effectiveL1RegParam$1 : (featuresStd$1[index] != 0.0 ? effectiveL1RegParam$1 / featuresStd$1[index] : 0.0);
    }

    public LinearRegression(String uid) {
        this.uid = uid;
        HasRegParam.$init$(this);
        HasElasticNetParam.$init$(this);
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasFitIntercept.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasSolver.$init$(this);
        HasAggregationDepth.$init$(this);
        HasLoss.$init$(this);
        LinearRegressionParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.regParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.standardization().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.elasticNetParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.solver().$minus$greater(LinearRegression$.MODULE$.Auto())}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.aggregationDepth().$minus$greater(BoxesRunTime.boxToInteger((int)2))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.loss().$minus$greater(LinearRegression$.MODULE$.SquaredError())}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.epsilon().$minus$greater(BoxesRunTime.boxToDouble((double)1.35))}));
    }

    public LinearRegression() {
        this(Identifiable$.MODULE$.randomUID("linReg"));
    }
}

