/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasLoss;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.LinearRegressionModel$;
import org.apache.spark.ml.regression.LinearRegressionParams;
import org.apache.spark.ml.regression.LinearRegressionSummary;
import org.apache.spark.ml.regression.LinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.GeneralMLWritable;
import org.apache.spark.ml.util.GeneralMLWriter;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.VersionUtils$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001B\u0012%\u0001=B\u0001\u0002\u0012\u0001\u0003\u0006\u0004%\t%\u0012\u0005\t9\u0002\u0011\t\u0011)A\u0005\r\"Aa\f\u0001BC\u0002\u0013\u0005q\f\u0003\u0005d\u0001\t\u0005\t\u0015!\u00035\u0011!)\u0007A!b\u0001\n\u00031\u0007\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011B4\t\u0011A\u0004!Q1A\u0005\u0002\u0019D\u0001\u0002\u001e\u0001\u0003\u0002\u0003\u0006Ia\u001a\u0005\u0007m\u0002!\tAJ<\t\u000fY\u0004A\u0011\u0001\u0014\u0002\u0002!I\u0011\u0011\u0002\u0001A\u0002\u0013%\u00111\u0002\u0005\n\u00033\u0001\u0001\u0019!C\u0005\u00037A\u0001\"a\n\u0001A\u0003&\u0011Q\u0002\u0005\n\u0003S\u0001!\u0019!C!\u0003WA\u0001\"a\r\u0001A\u0003%\u0011Q\u0006\u0005\b\u0003k\u0001A\u0011AA\u001c\u0011!\ty\u0004\u0001C\u0001I\u0005\u0005\u0003bBA$\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003'\u0002A\u0011AA+\u0011!\t9\t\u0001C\u0001I\u0005%\u0005bBAI\u0001\u0011\u0005\u00131\u0013\u0005\b\u00033\u0003A\u0011IAN\u0011\u001d\ty\u000b\u0001C!\u0003c;q!!1%\u0011\u0003\t\u0019M\u0002\u0004$I!\u0005\u0011Q\u0019\u0005\u0007mf!\t!!7\t\u000f\u0005m\u0017\u0004\"\u0011\u0002^\"9\u0011q]\r\u0005B\u0005%hABAy3\u0011\t\u0019\u0010\u0003\u0004w;\u0011\u0005\u0011Q\u001f\u0005\n\u0003wl\"\u0019!C\u0005\u0003{D\u0001B!\u0004\u001eA\u0003%\u0011q \u0005\b\u0003OlB\u0011\tB\b\u0011%\u0011\u0019\"GA\u0001\n\u0013\u0011)BA\u000bMS:,\u0017M\u001d*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\u00152\u0013A\u0003:fOJ,7o]5p]*\u0011q\u0005K\u0001\u0003[2T!!\u000b\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u0005-b\u0013AB1qC\u000eDWMC\u0001.\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001g\u000f \u0011\tE\u0012DGO\u0007\u0002I%\u00111\u0007\n\u0002\u0010%\u0016<'/Z:tS>tWj\u001c3fYB\u0011Q\u0007O\u0007\u0002m)\u0011qGJ\u0001\u0007Y&t\u0017\r\\4\n\u0005e2$A\u0002,fGR|'\u000f\u0005\u00022\u0001A\u0011\u0011\u0007P\u0005\u0003{\u0011\u0012a\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8QCJ\fWn\u001d\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003\u001a\nA!\u001e;jY&\u00111\t\u0011\u0002\u0012\u000f\u0016tWM]1m\u001b2;&/\u001b;bE2,\u0017aA;jIV\ta\t\u0005\u0002H!:\u0011\u0001J\u0014\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017:\na\u0001\u0010:p_Rt$\"A'\u0002\u000bM\u001c\u0017\r\\1\n\u0005=c\u0015A\u0002)sK\u0012,g-\u0003\u0002R%\n11\u000b\u001e:j]\u001eT!a\u0014')\u0007\u0005!&\f\u0005\u0002V16\taK\u0003\u0002XQ\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005e3&!B*j]\u000e,\u0017%A.\u0002\u000bErCG\f\u0019\u0002\tULG\r\t\u0015\u0004\u0005QS\u0016\u0001D2pK\u001a4\u0017nY5f]R\u001cX#\u0001\u001b)\u0007\r!\u0016-I\u0001c\u0003\u0015\u0011d\u0006\r\u00181\u00035\u0019w.\u001a4gS\u000eLWM\u001c;tA!\u001aA\u0001V1\u0002\u0013%tG/\u001a:dKB$X#A4\u0011\u0005!LW\"\u0001'\n\u0005)d%A\u0002#pk\ndW\rK\u0002\u0006)2\f\u0013!\\\u0001\u0006c9\u001ad\u0006M\u0001\u000bS:$XM]2faR\u0004\u0003f\u0001\u0004UY\u0006)1oY1mK\"\u001aq\u0001\u0016:\"\u0003M\fQA\r\u00184]A\naa]2bY\u0016\u0004\u0003f\u0001\u0005Ue\u00061A(\u001b8jiz\"RA\u000f={yzDQ\u0001R\u0005A\u0002\u0019C3\u0001\u001f+[\u0011\u0015q\u0016\u00021\u00015Q\rQH+\u0019\u0005\u0006K&\u0001\ra\u001a\u0015\u0004yRc\u0007\"\u00029\n\u0001\u00049\u0007f\u0001@UeR9!(a\u0001\u0002\u0006\u0005\u001d\u0001\"\u0002#\u000b\u0001\u00041\u0005\"\u00020\u000b\u0001\u0004!\u0004\"B3\u000b\u0001\u00049\u0017a\u0004;sC&t\u0017N\\4Tk6l\u0017M]=\u0016\u0005\u00055\u0001#\u00025\u0002\u0010\u0005M\u0011bAA\t\u0019\n1q\n\u001d;j_:\u00042!MA\u000b\u0013\r\t9\u0002\n\u0002 \u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:$&/Y5oS:<7+^7nCJL\u0018a\u0005;sC&t\u0017N\\4Tk6l\u0017M]=`I\u0015\fH\u0003BA\u000f\u0003G\u00012\u0001[A\u0010\u0013\r\t\t\u0003\u0014\u0002\u0005+:LG\u000fC\u0005\u0002&1\t\t\u00111\u0001\u0002\u000e\u0005\u0019\u0001\u0010J\u0019\u0002!Q\u0014\u0018-\u001b8j]\u001e\u001cV/\\7bef\u0004\u0013a\u00038v[\u001a+\u0017\r^;sKN,\"!!\f\u0011\u0007!\fy#C\u0002\u000221\u00131!\u00138u\u00031qW/\u001c$fCR,(/Z:!\u0003\u001d\u0019X/\\7bef,\"!a\u0005)\tA!\u00161H\u0011\u0003\u0003{\tQ!\r\u00186]A\n!b]3u'VlW.\u0019:z)\u0011\t\u0019%!\u0012\u000e\u0003\u0001Aq!!\u000e\u0012\u0001\u0004\ti!\u0001\u0006iCN\u001cV/\\7bef,\"!a\u0013\u0011\u0007!\fi%C\u0002\u0002P1\u0013qAQ8pY\u0016\fg\u000e\u000b\u0003\u0013)\u0006m\u0012\u0001C3wC2,\u0018\r^3\u0015\t\u0005]\u0013Q\f\t\u0004c\u0005e\u0013bAA.I\t9B*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\*v[6\f'/\u001f\u0005\b\u0003?\u001a\u0002\u0019AA1\u0003\u001d!\u0017\r^1tKR\u0004D!a\u0019\u0002tA1\u0011QMA6\u0003_j!!a\u001a\u000b\u0007\u0005%\u0004&A\u0002tc2LA!!\u001c\u0002h\t9A)\u0019;bg\u0016$\b\u0003BA9\u0003gb\u0001\u0001\u0002\u0007\u0002v\u0005u\u0013\u0011!A\u0001\u0006\u0003\t9HA\u0002`II\nB!!\u001f\u0002\u0000A\u0019\u0001.a\u001f\n\u0007\u0005uDJA\u0004O_RD\u0017N\\4\u0011\u0007!\f\t)C\u0002\u0002\u00042\u00131!\u00118zQ\r\u0019B+Y\u0001!M&tGmU;n[\u0006\u0014\u00180T8eK2\fe\u000e\u001a)sK\u0012L7\r^5p]\u000e{G\u000e\u0006\u0002\u0002\fB)\u0001.!$;\r&\u0019\u0011q\u0012'\u0003\rQ+\b\u000f\\33\u0003\u001d\u0001(/\u001a3jGR$2aZAK\u0011\u0019\t9*\u0006a\u0001i\u0005Aa-Z1ukJ,7/\u0001\u0003d_BLHc\u0001\u001e\u0002\u001e\"9\u0011q\u0014\fA\u0002\u0005\u0005\u0016!B3yiJ\f\u0007\u0003BAR\u0003Sk!!!*\u000b\u0007\u0005\u001df%A\u0003qCJ\fW.\u0003\u0003\u0002,\u0006\u0015&\u0001\u0003)be\u0006lW*\u00199)\u0007Y!&,A\u0003xe&$X-\u0006\u0002\u00024B\u0019q(!.\n\u0007\u0005]\u0006IA\bHK:,'/\u00197N\u0019^\u0013\u0018\u000e^3sQ\u00119B+a/\"\u0005\u0005u\u0016!B\u0019/m9\u0002\u0004f\u0001\u0001UY\u0006)B*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007CA\u0019\u001a'\u001dI\u0012qYAg\u0003'\u00042\u0001[Ae\u0013\r\tY\r\u0014\u0002\u0007\u0003:L(+\u001a4\u0011\t}\nyMO\u0005\u0004\u0003#\u0004%AC'M%\u0016\fG-\u00192mKB\u0019\u0001.!6\n\u0007\u0005]GJ\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002D\u0006!!/Z1e+\t\ty\u000e\u0005\u0003@\u0003CT\u0014bAAr\u0001\nAQ\n\u0014*fC\u0012,'\u000f\u000b\u0003\u001c)\u0006m\u0016\u0001\u00027pC\u0012$2AOAv\u0011\u0019\ti\u000f\ba\u0001\r\u0006!\u0001/\u0019;iQ\u0011aB+a/\u000371Kg.Z1s%\u0016<'/Z:tS>tWj\u001c3fYJ+\u0017\rZ3s'\ri\u0012q\u001c\u000b\u0003\u0003o\u00042!!?\u001e\u001b\u0005I\u0012!C2mCN\u001ch*Y7f+\t\ty\u0010\u0005\u0003\u0003\u0002\t-QB\u0001B\u0002\u0015\u0011\u0011)Aa\u0002\u0002\t1\fgn\u001a\u0006\u0003\u0005\u0013\tAA[1wC&\u0019\u0011Ka\u0001\u0002\u0015\rd\u0017m]:OC6,\u0007\u0005F\u0002;\u0005#Aa!!<\"\u0001\u00041\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0006\u0011\t\t\u0005!\u0011D\u0005\u0005\u00057\u0011\u0019A\u0001\u0004PE*,7\r\u001e\u0015\u00053Q\u000bY\f\u000b\u0003\u0019)\u0006m\u0006")
public class LinearRegressionModel
extends RegressionModel<Vector, LinearRegressionModel>
implements LinearRegressionParams,
GeneralMLWritable {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final double scale;
    private Option<LinearRegressionTrainingSummary> trainingSummary;
    private final int numFeatures;
    private final Param<String> solver;
    private final Param<String> loss;
    private final DoubleParam epsilon;
    private final IntParam aggregationDepth;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    public static LinearRegressionModel load(String string) {
        return LinearRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<LinearRegressionModel> read() {
        return LinearRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$regression$LinearRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public double getEpsilon() {
        return LinearRegressionParams.getEpsilon$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LinearRegressionParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final String getLoss() {
        return HasLoss.getLoss$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam.getElasticNetParam$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final Param<String> loss() {
        return this.loss;
    }

    @Override
    public final DoubleParam epsilon() {
        return this.epsilon;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$loss_$eq(Param<String> x$1) {
        this.loss = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$epsilon_$eq(DoubleParam x$1) {
        this.epsilon = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasLoss$_setter_$loss_$eq(Param<String> x$1) {
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public double scale() {
        return this.scale;
    }

    private Option<LinearRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<LinearRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public LinearRegressionTrainingSummary summary() {
        return (LinearRegressionTrainingSummary)this.trainingSummary().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException("No training summary available for this LinearRegressionModel");
        });
    }

    public LinearRegressionModel setSummary(Option<LinearRegressionTrainingSummary> summary) {
        this.trainingSummary_$eq(summary);
        return this;
    }

    public boolean hasSummary() {
        return this.trainingSummary().isDefined();
    }

    public LinearRegressionSummary evaluate(Dataset<?> dataset) {
        Tuple2<LinearRegressionModel, String> tuple2 = this.findSummaryModelAndPredictionCol();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LinearRegressionModel summaryModel = (LinearRegressionModel)tuple2._1();
        String predictionColName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)summaryModel, (Object)predictionColName);
        Tuple2 tuple23 = tuple22;
        LinearRegressionModel summaryModel2 = (LinearRegressionModel)tuple23._1();
        String predictionColName2 = (String)tuple23._2();
        return new LinearRegressionSummary(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), summaryModel2, new double[]{0.0});
    }

    public Tuple2<LinearRegressionModel, String> findSummaryModelAndPredictionCol() {
        Tuple2 tuple2;
        String string = this.$(this.predictionCol());
        if ("".equals(string)) {
            String predictionColName = new StringBuilder(11).append("prediction_").append(UUID.randomUUID().toString()).toString();
            tuple2 = new Tuple2(this.copy(ParamMap$.MODULE$.empty()).setPredictionCol(predictionColName), (Object)predictionColName);
        } else {
            tuple2 = new Tuple2((Object)this, (Object)string);
        }
        return tuple2;
    }

    @Override
    public double predict(Vector features) {
        return BLAS$.MODULE$.dot(features, this.coefficients()) + this.intercept();
    }

    @Override
    public LinearRegressionModel copy(ParamMap extra) {
        LinearRegressionModel newModel = this.copyValues(new LinearRegressionModel(this.uid(), this.coefficients(), this.intercept()), extra);
        return (LinearRegressionModel)newModel.setSummary(this.trainingSummary()).setParent(this.parent());
    }

    @Override
    public GeneralMLWriter write() {
        return new GeneralMLWriter(this);
    }

    public LinearRegressionModel(String uid, Vector coefficients, double intercept, double scale) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        this.scale = scale;
        HasRegParam.$init$(this);
        HasElasticNetParam.$init$(this);
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasFitIntercept.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasSolver.$init$(this);
        HasAggregationDepth.$init$(this);
        HasLoss.$init$(this);
        LinearRegressionParams.$init$(this);
        MLWritable.$init$(this);
        this.trainingSummary = None$.MODULE$;
        this.numFeatures = coefficients.size();
    }

    public LinearRegressionModel(String uid, Vector coefficients, double intercept) {
        this(uid, coefficients, intercept, 1.0);
    }

    public static class LinearRegressionModelReader
    extends MLReader<LinearRegressionModel> {
        private final String className = LinearRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LinearRegressionModel load(String path) {
            LinearRegressionModel linearRegressionModel;
            DefaultParamsReader.Metadata metadata;
            block10: {
                Vector vector;
                double d;
                Object scale;
                block12: {
                    Row row;
                    block11: {
                        Dataset data;
                        block7: {
                            double d2;
                            Object coefficients;
                            block9: {
                                Row row2;
                                block8: {
                                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                                    String dataPath = new Path(path, "data").toString();
                                    data = this.sparkSession().read().format("parquet").load(dataPath);
                                    Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    int majorVersion = tuple2._1$mcI$sp();
                                    int minorVersion = tuple2._2$mcI$sp();
                                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(majorVersion, minorVersion);
                                    Tuple2.mcII.sp sp3 = sp2;
                                    int majorVersion2 = sp3._1$mcI$sp();
                                    int minorVersion2 = sp3._2$mcI$sp();
                                    if (majorVersion2 >= 2 && (majorVersion2 != 2 || minorVersion2 > 2)) break block7;
                                    row2 = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).head();
                                    Some some = Row$.MODULE$.unapplySeq(row2);
                                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block8;
                                    Object intercept = ((SeqLike)some.get()).apply(0);
                                    coefficients = ((SeqLike)some.get()).apply(1);
                                    if (!(intercept instanceof Double)) break block8;
                                    d2 = BoxesRunTime.unboxToDouble((Object)intercept);
                                    if (coefficients instanceof Vector) break block9;
                                }
                                throw new MatchError((Object)row2);
                            }
                            Vector vector2 = (Vector)coefficients;
                            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)d2), (Object)vector2);
                            Tuple2 tuple22 = tuple2;
                            double intercept = tuple22._1$mcD$sp();
                            Vector coefficients2 = (Vector)tuple22._2();
                            linearRegressionModel = new LinearRegressionModel(metadata.uid(), coefficients2, intercept);
                            break block10;
                        }
                        row = (Row)data.select("intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients", "scale"})).head();
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block11;
                        Object intercept = ((SeqLike)some.get()).apply(0);
                        Object coefficients = ((SeqLike)some.get()).apply(1);
                        scale = ((SeqLike)some.get()).apply(2);
                        if (!(intercept instanceof Double)) break block11;
                        d = BoxesRunTime.unboxToDouble((Object)intercept);
                        if (!(coefficients instanceof Vector)) break block11;
                        vector = (Vector)coefficients;
                        if (scale instanceof Double) break block12;
                    }
                    throw new MatchError((Object)row);
                }
                double d3 = BoxesRunTime.unboxToDouble((Object)scale);
                Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)d), (Object)vector, (Object)BoxesRunTime.boxToDouble((double)d3));
                Tuple3 tuple32 = tuple3;
                double intercept = BoxesRunTime.unboxToDouble((Object)tuple32._1());
                Vector coefficients = (Vector)tuple32._2();
                double scale2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
                linearRegressionModel = new LinearRegressionModel(metadata.uid(), coefficients, intercept, scale2);
            }
            LinearRegressionModel model = linearRegressionModel;
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }
}

