/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.classification.ClassificationModel;
import org.apache.spark.mllib.classification.LogisticRegressionModel$;
import org.apache.spark.mllib.classification.impl.GLMClassificationModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.pmml.PMMLExportable;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.apache.spark.mllib.util.Saveable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001\u0002\u0010 \u0001)B\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0005\u0013\u0005\n1\u0002\u0011\t\u0011)A\u0005\u0013fC\u0001b\u0017\u0001\u0003\u0006\u0004%\t\u0005\u0018\u0005\nC\u0002\u0011\t\u0011)A\u0005;\nD\u0001\u0002\u001a\u0001\u0003\u0006\u0004%\t!\u001a\u0005\tY\u0002\u0011\t\u0011)A\u0005M\"Aa\u000e\u0001BC\u0002\u0013\u0005Q\r\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003g\u0011\u0015\u0011\b\u0001\"\u0001t\u0011\u001dq\bA1A\u0005\n\u0015Daa \u0001!\u0002\u00131\u0007\"CA\u0001\u0001\t\u0007I\u0011BA\u0002\u0011!\tY\u0001\u0001Q\u0001\n\u0005\u0015\u0001B\u0002:\u0001\t\u0003\ti\u0001C\u0005\u0002\u0016\u0001\u0001\r\u0011\"\u0003\u0002\u0018!I\u0011q\u0004\u0001A\u0002\u0013%\u0011\u0011\u0005\u0005\t\u0003[\u0001\u0001\u0015)\u0003\u0002\u001a!9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0002bBA\u001d\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003{\u0001A\u0011AA \u0011\u001d\t\u0019\u0005\u0001C)\u0003\u000bBq!!\u0015\u0001\t\u0003\n\u0019\u0006C\u0004\u0002~\u0001!\t&a \t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\u001e9\u00111R\u0010\t\u0002\u00055eA\u0002\u0010 \u0011\u0003\ty\t\u0003\u0004s5\u0011\u0005\u0011Q\u0014\u0005\b\u0003?SB\u0011IAQ\u0011%\tIKGA\u0001\n\u0013\tYKA\fM_\u001eL7\u000f^5d%\u0016<'/Z:tS>tWj\u001c3fY*\u0011\u0001%I\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\t\u00113%A\u0003nY2L'M\u0003\u0002%K\u0005)1\u000f]1sW*\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0007\u0001\u0019b\u0001A\u00162km\n\u0005C\u0001\u00170\u001b\u0005i#B\u0001\u0018\"\u0003)\u0011Xm\u001a:fgNLwN\\\u0005\u0003a5\u0012acR3oKJ\fG.\u001b>fI2Kg.Z1s\u001b>$W\r\u001c\t\u0003eMj\u0011aH\u0005\u0003i}\u00111c\u00117bgNLg-[2bi&|g.T8eK2\u0004\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"\u0001P \u000e\u0003uR!AP\u0011\u0002\tU$\u0018\u000e\\\u0005\u0003\u0001v\u0012\u0001bU1wK\u0006\u0014G.\u001a\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t\u0006\nA\u0001]7nY&\u0011ai\u0011\u0002\u000f!6kE*\u0012=q_J$\u0018M\u00197f\u0003\u001d9X-[4iiN,\u0012!\u0013\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019\u0006\na\u0001\\5oC2<\u0017B\u0001(L\u0005\u00191Vm\u0019;pe\"\u001a\u0011\u0001\u0015,\u0011\u0005E#V\"\u0001*\u000b\u0005M\u001b\u0013AC1o]>$\u0018\r^5p]&\u0011QK\u0015\u0002\u0006'&t7-Z\u0011\u0002/\u0006)\u0011G\f\u0019/a\u0005Aq/Z5hQR\u001c\b%\u0003\u0002H_!\u001a!\u0001\u0015,\u0002\u0013%tG/\u001a:dKB$X#A/\u0011\u0005Yr\u0016BA08\u0005\u0019!u.\u001e2mK\"\u001a1\u0001\u0015,\u0002\u0015%tG/\u001a:dKB$\b%\u0003\u0002\\_!\u001aA\u0001\u0015,\u0002\u00179,XNR3biV\u0014Xm]\u000b\u0002MB\u0011agZ\u0005\u0003Q^\u00121!\u00138uQ\r)\u0001K[\u0011\u0002W\u0006)\u0011GL\u001a/a\u0005aa.^7GK\u0006$XO]3tA!\u001aa\u0001\u00156\u0002\u00159,Xn\u00117bgN,7\u000fK\u0002\b!*\f1B\\;n\u00072\f7o]3tA!\u001a\u0001\u0002\u00156\u0002\rqJg.\u001b;?)\u0015!Xo^=|!\t\u0011\u0004\u0001C\u0003H\u0013\u0001\u0007\u0011\nK\u0002v!ZCQaW\u0005A\u0002uC3a\u001e)W\u0011\u0015!\u0017\u00021\u0001gQ\rI\bK\u001b\u0005\u0006]&\u0001\rA\u001a\u0015\u0004wBS\u0007fA\u0005QU\u0006\u0001B-\u0019;b/&$\bNQ5bgNK'0Z\u0001\u0012I\u0006$\u0018mV5uQ\nK\u0017m]*ju\u0016\u0004\u0013\u0001D<fS\u001eDGo]!se\u0006LXCAA\u0003!\u00111\u0014qA/\n\u0007\u0005%qGA\u0003BeJ\f\u00170A\u0007xK&<\u0007\u000e^:BeJ\f\u0017\u0010\t\u000b\u0006i\u0006=\u0011\u0011\u0003\u0005\u0006\u000f:\u0001\r!\u0013\u0005\u00067:\u0001\r!\u0018\u0015\u0004\u001dA3\u0016!\u0003;ie\u0016\u001c\bn\u001c7e+\t\tI\u0002\u0005\u00037\u00037i\u0016bAA\u000fo\t1q\n\u001d;j_:\fQ\u0002\u001e5sKNDw\u000e\u001c3`I\u0015\fH\u0003BA\u0012\u0003S\u00012ANA\u0013\u0013\r\t9c\u000e\u0002\u0005+:LG\u000fC\u0005\u0002,A\t\t\u00111\u0001\u0002\u001a\u0005\u0019\u0001\u0010J\u0019\u0002\u0015QD'/Z:i_2$\u0007%\u0001\u0007tKR$\u0006N]3tQ>dG\r\u0006\u0003\u00024\u0005UR\"\u0001\u0001\t\r\u0005U!\u00031\u0001^Q\r\u0011\u0002KV\u0001\rO\u0016$H\u000b\u001b:fg\"|G\u000e\u001a\u0015\u0004'AS\u0017AD2mK\u0006\u0014H\u000b\u001b:fg\"|G\u000e\u001a\u000b\u0003\u0003gA3\u0001\u0006)W\u00031\u0001(/\u001a3jGR\u0004v.\u001b8u)\u001di\u0016qIA&\u0003\u001fBa!!\u0013\u0016\u0001\u0004I\u0015A\u00033bi\u0006l\u0015\r\u001e:jq\"1\u0011QJ\u000bA\u0002%\u000bAb^3jO\"$X*\u0019;sSbDQaW\u000bA\u0002u\u000bAa]1wKR1\u00111EA+\u0003CBq!a\u0016\u0017\u0001\u0004\tI&\u0001\u0002tGB!\u00111LA/\u001b\u0005\u0019\u0013bAA0G\ta1\u000b]1sW\u000e{g\u000e^3yi\"9\u00111\r\fA\u0002\u0005\u0015\u0014\u0001\u00029bi\"\u0004B!a\u001a\u0002v9!\u0011\u0011NA9!\r\tYgN\u0007\u0003\u0003[R1!a\u001c*\u0003\u0019a$o\\8u}%\u0019\u00111O\u001c\u0002\rA\u0013X\rZ3g\u0013\u0011\t9(!\u001f\u0003\rM#(/\u001b8h\u0015\r\t\u0019h\u000e\u0015\u0004-AS\u0017!\u00044pe6\fGOV3sg&|g.\u0006\u0002\u0002f\u0005AAo\\*ue&tw\r\u0006\u0002\u0002f!\"\u0001\u0001UADC\t\tI)A\u00031]ar\u0003'A\fM_\u001eL7\u000f^5d%\u0016<'/Z:tS>tWj\u001c3fYB\u0011!GG\n\u00075\u0005E\u0015qS\u001b\u0011\u0007Y\n\u0019*C\u0002\u0002\u0016^\u0012a!\u00118z%\u00164\u0007\u0003\u0002\u001f\u0002\u001aRL1!a'>\u0005\u0019au.\u00193feR\u0011\u0011QR\u0001\u0005Y>\fG\rF\u0003u\u0003G\u000b)\u000bC\u0004\u0002Xq\u0001\r!!\u0017\t\u000f\u0005\rD\u00041\u0001\u0002f!\u001aA\u0004\u00156\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003[\u0003B!a,\u0002:6\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000b),\u0001\u0003mC:<'BAA\\\u0003\u0011Q\u0017M^1\n\t\u0005m\u0016\u0011\u0017\u0002\u0007\u001f\nTWm\u0019;)\u0007i\u0001&\u000eK\u0002\u001a!*\u0004")
public class LogisticRegressionModel
extends GeneralizedLinearModel
implements ClassificationModel,
Saveable,
PMMLExportable {
    private final int numFeatures;
    private final int numClasses;
    private final int dataWithBiasSize;
    private final double[] weightsArray;
    private Option<Object> threshold;

    public static LogisticRegressionModel load(SparkContext sparkContext, String string) {
        return LogisticRegressionModel$.MODULE$.load(sparkContext, string);
    }

    @Override
    public void toPMML(String localPath) {
        PMMLExportable.toPMML$((PMMLExportable)this, localPath);
    }

    @Override
    public void toPMML(SparkContext sc, String path) {
        PMMLExportable.toPMML$(this, sc, path);
    }

    @Override
    public void toPMML(OutputStream outputStream) {
        PMMLExportable.toPMML$((PMMLExportable)this, outputStream);
    }

    @Override
    public String toPMML() {
        return PMMLExportable.toPMML$(this);
    }

    @Override
    public JavaRDD<Double> predict(JavaRDD<Vector> testData) {
        return ClassificationModel.predict$(this, testData);
    }

    @Override
    public Vector weights() {
        return super.weights();
    }

    @Override
    public double intercept() {
        return super.intercept();
    }

    public int numFeatures() {
        return this.numFeatures;
    }

    public int numClasses() {
        return this.numClasses;
    }

    private int dataWithBiasSize() {
        return this.dataWithBiasSize;
    }

    private double[] weightsArray() {
        return this.weightsArray;
    }

    private Option<Object> threshold() {
        return this.threshold;
    }

    private void threshold_$eq(Option<Object> x$1) {
        this.threshold = x$1;
    }

    public LogisticRegressionModel setThreshold(double threshold) {
        this.threshold_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)threshold)));
        return this;
    }

    public Option<Object> getThreshold() {
        return this.threshold();
    }

    public LogisticRegressionModel clearThreshold() {
        this.threshold_$eq((Option<Object>)None$.MODULE$);
        return this;
    }

    @Override
    public double predictPoint(Vector dataMatrix, Vector weightMatrix, double intercept) {
        double d;
        Predef$.MODULE$.require(dataMatrix.size() == this.numFeatures());
        if (this.numClasses() == 2) {
            double d2;
            double margin = BLAS$.MODULE$.dot(weightMatrix, dataMatrix) + intercept;
            double score = 1.0 / (1.0 + package$.MODULE$.exp(-margin));
            Option<Object> option = this.threshold();
            if (option instanceof Some) {
                Some some = (Some)option;
                double t = BoxesRunTime.unboxToDouble((Object)some.value());
                d2 = score > t ? 1.0 : 0.0;
            } else if (None$.MODULE$.equals(option)) {
                d2 = score;
            } else {
                throw new MatchError(option);
            }
            d = d2;
        } else {
            IntRef bestClass = IntRef.create((int)0);
            DoubleRef maxMargin = DoubleRef.create((double)0.0);
            boolean withBias = dataMatrix.size() + 1 == this.dataWithBiasSize();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numClasses() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                block1: {
                    DoubleRef margin = DoubleRef.create((double)0.0);
                    dataMatrix.foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(index, value) -> {
                        block0: {
                            if (value == 0.0) break block0;
                            margin$1.elem += value * this.weightsArray()[i * this.dataWithBiasSize() + index];
                        }
                    });
                    if (withBias) {
                        margin.elem += this.weightsArray()[i * this.dataWithBiasSize() + dataMatrix.size()];
                    }
                    if (!(margin.elem > maxMargin$1.elem)) break block1;
                    maxMargin$1.elem = margin.elem;
                    bestClass$1.elem = i + 1;
                }
            });
            d = bestClass.elem;
        }
        return d;
    }

    @Override
    public void save(SparkContext sc, String path) {
        GLMClassificationModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.getClass().getName(), this.numFeatures(), this.numClasses(), this.weights(), this.intercept(), this.threshold());
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    @Override
    public String toString() {
        return new StringBuilder(29).append(super.toString()).append(", numClasses = ").append(this.numClasses()).append(", threshold = ").append(this.threshold().getOrElse((Function0 & Serializable & scala.Serializable)() -> "None")).toString();
    }

    public LogisticRegressionModel(Vector weights, double intercept, int numFeatures, int numClasses) {
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        super(weights, intercept);
        ClassificationModel.$init$(this);
        PMMLExportable.$init$(this);
        if (numClasses == 2) {
            Predef$.MODULE$.require(weights.size() == numFeatures, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("LogisticRegressionModel with numClasses = 2 was given non-matching values:").append(new StringBuilder(36).append(" numFeatures = ").append(this.numFeatures()).append(", but weights.size = ").append(this.weights().size()).toString()).toString());
        } else {
            int weightsSizeWithoutIntercept = (numClasses - 1) * numFeatures;
            int weightsSizeWithIntercept = (numClasses - 1) * (numFeatures + 1);
            Predef$.MODULE$.require(weights.size() == weightsSizeWithoutIntercept || weights.size() == weightsSizeWithIntercept, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("LogisticRegressionModel.load with numClasses = ").append(this.numClasses()).append(" and numFeatures = ").append(this.numFeatures()).append(new StringBuilder(48).append(" expected weights of length ").append(weightsSizeWithoutIntercept).append(" (without intercept)").toString()).append(new StringBuilder(22).append(" or ").append(weightsSizeWithIntercept).append(" (with intercept),").toString()).append(new StringBuilder(33).append(" but was given weights of length ").append(this.weights().size()).toString()).toString());
        }
        this.dataWithBiasSize = weights.size() / (numClasses - 1);
        Vector vector = weights;
        if (!(vector instanceof DenseVector)) {
            throw new IllegalArgumentException(new StringBuilder(49).append("weights only supports dense vector but got type ").append(weights.getClass()).append(".").toString());
        }
        DenseVector denseVector = (DenseVector)vector;
        double[] dArray = denseVector.values();
        this.weightsArray = dArray;
        this.threshold = new Some((Object)BoxesRunTime.boxToDouble((double)0.5));
    }

    public LogisticRegressionModel(Vector weights, double intercept) {
        this(weights, intercept, weights.size(), 2);
    }
}

