/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001\u0002\u000f\u001e\u0001!B\u0001\u0002\u000f\u0001\u0003\u0002\u0004%I!\u000f\u0005\t{\u0001\u0011\t\u0019!C\u0005}!AA\t\u0001B\u0001B\u0003&!\b\u0003\u0005F\u0001\t\u0005\r\u0011\"\u0003G\u0011!\u0011\u0006A!a\u0001\n\u0013\u0019\u0006\u0002C+\u0001\u0005\u0003\u0005\u000b\u0015B$\t\u000bY\u0003A\u0011B,\t\u000bY\u0003A\u0011\u0001/\t\u000bY\u0003A\u0011A4\t\u000b-\u0004A\u0011\u00017\t\u000b=\u0004A\u0011A\u001d\t\u000bE\u0004A\u0011\u0001:\t\u000bU\u0004A\u0011\u0001$\t\u000b]\u0004A\u0011\u0001=\b\u000f\u0005eQ\u0004#\u0001\u0002\u001c\u00191A$\bE\u0001\u0003;AaA\u0016\t\u0005\u0002\u0005}\u0001\"CA\u0011!\t\u0007I\u0011A\u000fG\u0011\u001d\t\u0019\u0003\u0005Q\u0001\n\u001dC\u0011\"!\n\u0011\u0005\u0004%\t!\b$\t\u000f\u0005\u001d\u0002\u0003)A\u0005\u000f\"Q\u0011\u0011\u0006\tC\u0002\u0013\u0005Q$a\u000b\t\u0011\u0005u\u0002\u0003)A\u0005\u0003[Aq!a\u0010\u0011\t\u0003\t\t\u0005C\u0004\u0002@A!\t!!\u0013\t\u000f\u0005}\u0002\u0003\"\u0001\u0002R!I\u00111\f\t\u0002\u0002\u0013%\u0011Q\f\u0002\u000b\u001d\u0006Lg/\u001a\"bs\u0016\u001c(B\u0001\u0010 \u00039\u0019G.Y:tS\u001aL7-\u0019;j_:T!\u0001I\u0011\u0002\u000b5dG.\u001b2\u000b\u0005\t\u001a\u0013!B:qCJ\\'B\u0001\u0013&\u0003\u0019\t\u0007/Y2iK*\ta%A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001S=\u0012\u0004C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g\r\u0005\u0002+a%\u0011\u0011g\u000b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0005\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003oQ\u0012q\u0001T8hO&tw-\u0001\u0004mC6\u0014G-Y\u000b\u0002uA\u0011!fO\u0005\u0003y-\u0012a\u0001R8vE2,\u0017A\u00037b[\n$\u0017m\u0018\u0013fcR\u0011qH\u0011\t\u0003U\u0001K!!Q\u0016\u0003\tUs\u0017\u000e\u001e\u0005\b\u0007\n\t\t\u00111\u0001;\u0003\rAH%M\u0001\bY\u0006l'\rZ1!\u0003%iw\u000eZ3m)f\u0004X-F\u0001H!\tAuJ\u0004\u0002J\u001bB\u0011!jK\u0007\u0002\u0017*\u0011AjJ\u0001\u0007yI|w\u000e\u001e \n\u00059[\u0013A\u0002)sK\u0012,g-\u0003\u0002Q#\n11\u000b\u001e:j]\u001eT!AT\u0016\u0002\u001b5|G-\u001a7UsB,w\fJ3r)\tyD\u000bC\u0004D\u000b\u0005\u0005\t\u0019A$\u0002\u00155|G-\u001a7UsB,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u00041j[\u0006CA-\u0001\u001b\u0005i\u0002\"\u0002\u001d\b\u0001\u0004Q\u0004\"B#\b\u0001\u00049EC\u0001-^\u0011\u0015A\u0004\u00021\u0001;Q\rAq,\u001a\t\u0003A\u000el\u0011!\u0019\u0006\u0003E\u0006\n!\"\u00198o_R\fG/[8o\u0013\t!\u0017MA\u0003TS:\u001cW-I\u0001g\u0003\u0015\td\u0006\u000e\u00181)\u0005A\u0006fA\u0005`S\u0006\n!.A\u00031]er\u0003'A\u0005tKRd\u0015-\u001c2eCR\u0011\u0001,\u001c\u0005\u0006q)\u0001\rA\u000f\u0015\u0004\u0015}K\u0017!C4fi2\u000bWN\u00193bQ\rYq,Z\u0001\rg\u0016$Xj\u001c3fYRK\b/\u001a\u000b\u00031NDQ!\u0012\u0007A\u0002\u001dC3\u0001D0f\u000319W\r^'pI\u0016dG+\u001f9fQ\riq,Z\u0001\u0004eVtGCA=}!\tI&0\u0003\u0002|;\tya*Y5wK\n\u000b\u00170Z:N_\u0012,G\u000eC\u0003~\u001d\u0001\u0007a0\u0001\u0003eCR\f\u0007#B@\u0002\u0006\u0005%QBAA\u0001\u0015\r\t\u0019!I\u0001\u0004e\u0012$\u0017\u0002BA\u0004\u0003\u0003\u00111A\u0015#E!\u0011\tY!!\u0005\u000e\u0005\u00055!bAA\b?\u0005Q!/Z4sKN\u001c\u0018n\u001c8\n\t\u0005M\u0011Q\u0002\u0002\r\u0019\u0006\u0014W\r\\3e!>Lg\u000e\u001e\u0015\u0004\u001d}K\u0007f\u0001\u0001`S\u0006Qa*Y5wK\n\u000b\u00170Z:\u0011\u0005e\u00032c\u0001\t*_Q\u0011\u00111D\u0001\f\u001bVdG/\u001b8p[&\fG.\u0001\u0007Nk2$\u0018N\\8nS\u0006d\u0007%A\u0005CKJtw.\u001e7mS\u0006Q!)\u001a:o_VdG.\u001b\u0011\u0002'M,\b\u000f]8si\u0016$Wj\u001c3fYRK\b/Z:\u0016\u0005\u00055\u0002#BA\u0018\u0003s9UBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u0013%lW.\u001e;bE2,'bAA\u001cW\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0012\u0011\u0007\u0002\u0004'\u0016$\u0018\u0001F:vaB|'\u000f^3e\u001b>$W\r\u001c+za\u0016\u001c\b%A\u0003ue\u0006Lg\u000eF\u0002z\u0003\u0007Ba!!\u0012\u0019\u0001\u0004q\u0018!B5oaV$\bf\u0001\r`SR)\u00110a\u0013\u0002N!1\u0011QI\rA\u0002yDQ\u0001O\rA\u0002iB3!G0j)\u001dI\u00181KA+\u0003/Ba!!\u0012\u001b\u0001\u0004q\b\"\u0002\u001d\u001b\u0001\u0004Q\u0004\"B#\u001b\u0001\u00049\u0005f\u0001\u000e`K\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\u0006\u0005\u0003\u0002b\u0005-TBAA2\u0015\u0011\t)'a\u001a\u0002\t1\fgn\u001a\u0006\u0003\u0003S\nAA[1wC&!\u0011QNA2\u0005\u0019y%M[3di\"\u001a\u0001cX5)\u0007=y\u0016\u000e")
public class NaiveBayes
implements scala.Serializable,
Logging {
    private double lambda;
    private String modelType;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static NaiveBayesModel train(RDD<LabeledPoint> rDD, double d, String string) {
        return NaiveBayes$.MODULE$.train(rDD, d, string);
    }

    public static NaiveBayesModel train(RDD<LabeledPoint> rDD, double d) {
        return NaiveBayes$.MODULE$.train(rDD, d);
    }

    public static NaiveBayesModel train(RDD<LabeledPoint> rDD) {
        return NaiveBayes$.MODULE$.train(rDD);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private double lambda() {
        return this.lambda;
    }

    private void lambda_$eq(double x$1) {
        this.lambda = x$1;
    }

    private String modelType() {
        return this.modelType;
    }

    private void modelType_$eq(String x$1) {
        this.modelType = x$1;
    }

    public NaiveBayes setLambda(double lambda) {
        Predef$.MODULE$.require(lambda >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Smoothing parameter must be nonnegative but got ").append(lambda).toString());
        this.lambda_$eq(lambda);
        return this;
    }

    public double getLambda() {
        return this.lambda();
    }

    public NaiveBayes setModelType(String modelType) {
        Predef$.MODULE$.require(NaiveBayes$.MODULE$.supportedModelTypes().contains((Object)modelType), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("NaiveBayes was created with an unknown modelType: ").append(modelType).append(".").toString());
        this.modelType_$eq(modelType);
        return this;
    }

    public String getModelType() {
        return this.modelType();
    }

    public NaiveBayesModel run(RDD<LabeledPoint> data) {
        public final class Org_apache_spark_mllib_classification_NaiveBayes$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_mllib_classification_NaiveBayes$$typecreator5$1(NaiveBayes $outer) {
            }
        }
        SparkSession spark = SparkSession$.MODULE$.builder().sparkContext(data.context()).getOrCreate();
        org.apache.spark.ml.classification.NaiveBayes nb = new org.apache.spark.ml.classification.NaiveBayes().setModelType(this.modelType()).setSmoothing(this.lambda());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(NaiveBayes.class.getClassLoader());
        Dataset dataset = spark.implicits().rddToDatasetHolder(data.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LabeledPoint labeledPoint = x0$1;
            if (labeledPoint == null) {
                throw new MatchError((Object)labeledPoint);
            }
            double label = labeledPoint.label();
            Vector features = labeledPoint.features();
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)label), (Object)features.asML());
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_classification_NaiveBayes$$typecreator5$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label", "features"}));
        org.apache.spark.ml.classification.NaiveBayesModel newModel = nb.trainWithLabelCheck(dataset, false);
        double[] pi = newModel.pi().toArray();
        double[][] theta = (double[][])Array$.MODULE$.fill(newModel.numClasses(), newModel.numFeatures(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
        newModel.theta().foreachActive((Function3 & Serializable & scala.Serializable)(x0$2, x1$1, x2$1) -> {
            NaiveBayes.$anonfun$run$3(theta, BoxesRunTime.unboxToInt((Object)x0$2), BoxesRunTime.unboxToInt((Object)x1$1), BoxesRunTime.unboxToDouble((Object)x2$1));
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(newModel.oldLabels() != null, (Function0 & Serializable & scala.Serializable)() -> "The underlying ML NaiveBayes training does not produce labels.");
        return new NaiveBayesModel(newModel.oldLabels(), pi, theta, this.modelType());
    }

    public static final /* synthetic */ void $anonfun$run$3(double[][] theta$1, int x0$2, int x1$1, double x2$1) {
        double v;
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)x0$2), (Object)BoxesRunTime.boxToInteger((int)x1$1), (Object)BoxesRunTime.boxToDouble((double)x2$1));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int i = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int j = BoxesRunTime.unboxToInt((Object)tuple3._2());
        theta$1[i][j] = v = BoxesRunTime.unboxToDouble((Object)tuple3._3());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public NaiveBayes(double lambda, String modelType) {
        this.lambda = lambda;
        this.modelType = modelType;
        Logging.$init$((Logging)this);
    }

    public NaiveBayes(double lambda) {
        this(lambda, NaiveBayes$.MODULE$.Multinomial());
    }

    public NaiveBayes() {
        this(1.0, NaiveBayes$.MODULE$.Multinomial());
    }
}

