/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.classification.ClassificationModel;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.classification.NaiveBayesModel$;
import org.apache.spark.mllib.classification.NaiveBayesModel$SaveLoadV2_0$;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\ref\u0001\u00026l\u0001YD!\"!\u0006\u0001\u0005\u000b\u0007I\u0011AA\f\u0011)\t9\u0004\u0001B\u0001B\u0003%\u0011\u0011\u0004\u0005\u000b\u0003w\u0001!Q1A\u0005\u0002\u0005]\u0001BCA\"\u0001\t\u0005\t\u0015!\u0003\u0002\u001a!Q\u0011q\t\u0001\u0003\u0006\u0004%\t!!\u0013\t\u0015\u0005=\u0003A!A!\u0002\u0013\tY\u0005\u0003\u0006\u0002T\u0001\u0011)\u0019!C\u0001\u0003+B!\"a\u001d\u0001\u0005\u0003\u0005\u000b\u0011BA,\u0011!\t9\b\u0001C\u0001_\u0006e\u0004\"CAG\u0001\t\u0007I\u0011BAH\u0011!\ti\n\u0001Q\u0001\n\u0005E\u0005\"CAP\u0001\t\u0007I\u0011BAQ\u0011!\tI\u000b\u0001Q\u0001\n\u0005\r\u0006\u0002CA<\u0001\u0011\u0005Q.a+\t\u0011\u0005]\u0004\u0001\"\u0001n\u0003gCA\"!4\u0001!\u0003\u0005\u0019\u0011)A\u0005\u0003\u001fD\u0011\"!8\u0001\u0005\u0004%I!a8\t\u0011\u0005\u0005\b\u0001)A\u0005\u0003+D\u0011\"a9\u0001\u0005\u0004%I!!:\t\u0011\u0005\u001d\b\u0001)A\u0005\u00037Dq!!;\u0001\t\u0003\nY\u000fC\u0004\u0002j\u0002!\tEa\u0002\t\u000f\t5\u0001\u0001\"\u0001\u0003\u0010!9!Q\u0002\u0001\u0005\u0002\te\u0001b\u0002B\u0010\u0001\u0011%!\u0011\u0005\u0005\b\u0005K\u0001A\u0011\u0002B\u0014\u0011\u001d\u0011Y\u0003\u0001C\u0005\u0005[AqAa\r\u0001\t\u0003\u0012)\u0004C\u0004\u0003T\u0001!\t&!\u0016\b\u000f\t]3\u000e#\u0001\u0003Z\u00191!n\u001bE\u0001\u00057Bq!a\u001e \t\u0003\u0011\u0019g\u0002\u0005\u0003f}A\t!\u001cB4\r!\u0011Yg\bE\u0001[\n5\u0004bBA<E\u0011\u0005!q\u000e\u0005\b\u0005c\u0012C\u0011AA+\u0011\u001d\u0011\u0019H\tC\u0001\u0003+2aA!\u001e#\u0001\n]\u0004BCA\u000bM\tU\r\u0011\"\u0001\u0002\u0018!Q\u0011q\u0007\u0014\u0003\u0012\u0003\u0006I!!\u0007\t\u0015\u0005mbE!f\u0001\n\u0003\t9\u0002\u0003\u0006\u0002D\u0019\u0012\t\u0012)A\u0005\u00033A!\"a\u0012'\u0005+\u0007I\u0011AA%\u0011)\tyE\nB\tB\u0003%\u00111\n\u0005\u000b\u0003'2#Q3A\u0005\u0002\u0005U\u0003BCA:M\tE\t\u0015!\u0003\u0002X!9\u0011q\u000f\u0014\u0005\u0002\t}\u0004\"\u0003BGM\u0005\u0005I\u0011\u0001BH\u0011%\u0011IJJI\u0001\n\u0003\u0011Y\nC\u0005\u00030\u001a\n\n\u0011\"\u0001\u0003\u001c\"I!\u0011\u0017\u0014\u0012\u0002\u0013\u0005!1\u0017\u0005\n\u0005o3\u0013\u0013!C\u0001\u0005sC\u0011B!0'\u0003\u0003%\tEa0\t\u0013\t\u0015g%!A\u0005\u0002\t\u001d\u0007\"\u0003BhM\u0005\u0005I\u0011\u0001Bi\u0011%\u0011iNJA\u0001\n\u0003\u0012y\u000eC\u0005\u0003n\u001a\n\t\u0011\"\u0001\u0003p\"I!\u0011 \u0014\u0002\u0002\u0013\u0005#1 \u0005\n\u0005{4\u0013\u0011!C!\u0005\u007fD\u0011b!\u0001'\u0003\u0003%\tea\u0001\b\u0013\r\u001d!%!A\t\u0002\r%a!\u0003B;E\u0005\u0005\t\u0012AB\u0006\u0011\u001d\t9H\u0010C\u0001\u00073A\u0011B!@?\u0003\u0003%)Ea@\t\u0013\rma(!A\u0005\u0002\u000eu\u0001\"CB\u0014}\u0005\u0005I\u0011QB\u0015\u0011%\u00199DPA\u0001\n\u0013\u0019I\u0004C\u0004\u00034\t\"\ta!\u0011\t\u000f\r-#\u0005\"\u0001\u0004N\u001dA1QK\u0010\t\u00025\u001c9F\u0002\u0005\u0004Z}A\t!\\B.\u0011\u001d\t9h\u0012C\u0001\u0007;BqA!\u001dH\t\u0003\t)\u0006C\u0004\u0003t\u001d#\t!!\u0016\u0007\r\tUt\tQB0\u0011)\t)b\u0013BK\u0002\u0013\u0005\u0011q\u0003\u0005\u000b\u0003oY%\u0011#Q\u0001\n\u0005e\u0001BCA\u001e\u0017\nU\r\u0011\"\u0001\u0002\u0018!Q\u00111I&\u0003\u0012\u0003\u0006I!!\u0007\t\u0015\u0005\u001d3J!f\u0001\n\u0003\tI\u0005\u0003\u0006\u0002P-\u0013\t\u0012)A\u0005\u0003\u0017Bq!a\u001eL\t\u0003\u0019\t\u0007C\u0005\u0003\u000e.\u000b\t\u0011\"\u0001\u0004n!I!\u0011T&\u0012\u0002\u0013\u0005!1\u0014\u0005\n\u0005_[\u0015\u0013!C\u0001\u00057C\u0011B!-L#\u0003%\tAa-\t\u0013\tu6*!A\u0005B\t}\u0006\"\u0003Bc\u0017\u0006\u0005I\u0011\u0001Bd\u0011%\u0011ymSA\u0001\n\u0003\u0019)\bC\u0005\u0003^.\u000b\t\u0011\"\u0011\u0003`\"I!Q^&\u0002\u0002\u0013\u00051\u0011\u0010\u0005\n\u0005s\\\u0015\u0011!C!\u0005wD\u0011B!@L\u0003\u0003%\tEa@\t\u0013\r\u00051*!A\u0005B\rut!CB\u0004\u000f\u0006\u0005\t\u0012ABA\r%\u0011)hRA\u0001\u0012\u0003\u0019\u0019\tC\u0004\u0002x\u0001$\taa#\t\u0013\tu\b-!A\u0005F\t}\b\"CB\u000eA\u0006\u0005I\u0011QBG\u0011%\u00199\u0003YA\u0001\n\u0003\u001b)\nC\u0005\u00048\u0001\f\t\u0011\"\u0003\u0004:!9!1G$\u0005\u0002\r\u0005\u0006bBB&\u000f\u0012\u00051\u0011\u0016\u0005\b\u0007\u0017zB\u0011IBX\u0011%\u00199dHA\u0001\n\u0013\u0019IDA\bOC&4XMQ1zKNlu\u000eZ3m\u0015\taW.\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u00059|\u0017!B7mY&\u0014'B\u00019r\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00118/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0006\u0019qN]4\u0004\u0001M9\u0001a^?\u0002\u0004\u0005%\u0001C\u0001=|\u001b\u0005I(\"\u0001>\u0002\u000bM\u001c\u0017\r\\1\n\u0005qL(AB!osJ+g\r\u0005\u0002\u007f\u007f6\t1.C\u0002\u0002\u0002-\u00141c\u00117bgNLg-[2bi&|g.T8eK2\u00042\u0001_A\u0003\u0013\r\t9!\u001f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011qB7\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003'\tiA\u0001\u0005TCZ,\u0017M\u00197f\u0003\u0019a\u0017MY3mgV\u0011\u0011\u0011\u0004\t\u0006q\u0006m\u0011qD\u0005\u0004\u0003;I(!B!se\u0006L\bc\u0001=\u0002\"%\u0019\u00111E=\u0003\r\u0011{WO\u00197fQ\u0015\t\u0011qEA\u001a!\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u0017_\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u00121\u0006\u0002\u0006'&t7-Z\u0011\u0003\u0003k\tQ!\r\u00181]A\nq\u0001\\1cK2\u001c\b\u0005K\u0003\u0003\u0003O\t\u0019$\u0001\u0002qS\"*1!a\n\u0002@\u0005\u0012\u0011\u0011I\u0001\u0006a9Jd\u0006M\u0001\u0004a&\u0004\u0003&\u0002\u0003\u0002(\u0005}\u0012!\u0002;iKR\fWCAA&!\u0015A\u00181DA\rQ\u0015)\u0011qEA \u0003\u0019!\b.\u001a;bA!*a!a\n\u0002@\u0005IQn\u001c3fYRK\b/Z\u000b\u0003\u0003/\u0002B!!\u0017\u0002h9!\u00111LA2!\r\ti&_\u0007\u0003\u0003?R1!!\u0019v\u0003\u0019a$o\\8u}%\u0019\u0011QM=\u0002\rA\u0013X\rZ3g\u0013\u0011\tI'a\u001b\u0003\rM#(/\u001b8h\u0015\r\t)'\u001f\u0015\u0006\u000f\u0005\u001d\u0012qN\u0011\u0003\u0003c\nQ!\r\u00185]A\n!\"\\8eK2$\u0016\u0010]3!Q\u0015A\u0011qEA8\u0003\u0019a\u0014N\\5u}QQ\u00111PA?\u0003\u0003\u000b))!#\u0011\u0005y\u0004\u0001bBA\u000b\u0013\u0001\u0007\u0011\u0011\u0004\u0015\u0007\u0003{\n9#a\r\t\u000f\u0005m\u0012\u00021\u0001\u0002\u001a!2\u0011\u0011QA\u0014\u0003\u007fAq!a\u0012\n\u0001\u0004\tY\u0005\u000b\u0004\u0002\u0006\u0006\u001d\u0012q\b\u0005\b\u0003'J\u0001\u0019AA,Q\u0019\tI)a\n\u0002p\u0005A\u0001/\u001b,fGR|'/\u0006\u0002\u0002\u0012B!\u00111SAM\u001b\t\t)JC\u0002\u0002\u00186\fa\u0001\\5oC2<\u0017\u0002BAN\u0003+\u00131\u0002R3og\u00164Vm\u0019;pe\u0006I\u0001/\u001b,fGR|'\u000fI\u0001\fi\",G/Y'biJL\u00070\u0006\u0002\u0002$B!\u00111SAS\u0013\u0011\t9+!&\u0003\u0017\u0011+gn]3NCR\u0014\u0018\u000e_\u0001\ri\",G/Y'biJL\u0007\u0010\t\u000b\t\u0003w\ni+a,\u00022\"9\u0011Q\u0003\bA\u0002\u0005e\u0001bBA\u001e\u001d\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003\u000fr\u0001\u0019AA&)!\tY(!.\u0002H\u0006%\u0007bBA\u000b\u001f\u0001\u0007\u0011q\u0017\t\u0007\u0003s\u000b\u0019-a\b\u000e\u0005\u0005m&\u0002BA_\u0003\u007f\u000bA\u0001\\1oO*\u0011\u0011\u0011Y\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002F\u0006m&\u0001C%uKJ\f'\r\\3\t\u000f\u0005mr\u00021\u0001\u00028\"9\u0011qI\bA\u0002\u0005-\u0007CBA]\u0003\u0007\f9,A\u0002yII\u0002r\u0001_Ai\u0003+\fY.C\u0002\u0002Tf\u0014a\u0001V;qY\u0016\u0014\u0004#\u0002=\u0002X\u0006\r\u0016bAAms\n1q\n\u001d;j_:\u0004R\u0001_Al\u0003#\u000b!\u0003\u001e5fi\u0006l\u0015N\\;t\u001d\u0016<G\u000b[3uCV\u0011\u0011Q[\u0001\u0014i\",G/Y'j]V\u001ch*Z4UQ\u0016$\u0018\rI\u0001\f]\u0016<G\u000b[3uCN+X.\u0006\u0002\u0002\\\u0006aa.Z4UQ\u0016$\u0018mU;nA\u00059\u0001O]3eS\u000e$H\u0003BAw\u0003s\u0004b!a<\u0002v\u0006}QBAAy\u0015\r\t\u0019p\\\u0001\u0004e\u0012$\u0017\u0002BA|\u0003c\u00141A\u0015#E\u0011\u001d\tY0\u0006a\u0001\u0003{\f\u0001\u0002^3ti\u0012\u000bG/\u0019\t\u0007\u0003_\f)0a@\u0011\t\u0005M%\u0011A\u0005\u0005\u0005\u0007\t)J\u0001\u0004WK\u000e$xN\u001d\u0015\u0006+\u0005\u001d\u00121\u0007\u000b\u0005\u0003?\u0011I\u0001C\u0004\u0002|Z\u0001\r!a@)\u000bY\t9#a\r\u0002)A\u0014X\rZ5diB\u0013xNY1cS2LG/[3t)\u0011\tiP!\u0005\t\u000f\u0005mx\u00031\u0001\u0002~\"*q#a\n\u0003\u0016\u0005\u0012!qC\u0001\u0006c9*d\u0006\r\u000b\u0005\u0003\u007f\u0014Y\u0002C\u0004\u0002|b\u0001\r!a@)\u000ba\t9C!\u0006\u0002-5,H\u000e^5o_6L\u0017\r\\\"bY\u000e,H.\u0019;j_:$B!!%\u0003$!9\u00111`\rA\u0002\u0005}\u0018\u0001\u00062fe:|W\u000f\u001c7j\u0007\u0006d7-\u001e7bi&|g\u000e\u0006\u0003\u0002\u0012\n%\u0002bBA~5\u0001\u0007\u0011q`\u0001\u0017a>\u001cH/\u001a:j_J\u0004&o\u001c2bE&d\u0017\u000e^5fgR!\u0011\u0011\u0013B\u0018\u0011\u001d\u0011\td\u0007a\u0001\u0003#\u000bq\u0001\\8h!J|'-\u0001\u0003tCZ,GC\u0002B\u001c\u0005{\u0011I\u0005E\u0002y\u0005sI1Aa\u000fz\u0005\u0011)f.\u001b;\t\u000f\t}B\u00041\u0001\u0003B\u0005\u00111o\u0019\t\u0005\u0005\u0007\u0012)%D\u0001p\u0013\r\u00119e\u001c\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\b\u0005\u0017b\u0002\u0019AA,\u0003\u0011\u0001\u0018\r\u001e5)\u000bq\t9Ca\u0014\"\u0005\tE\u0013!B\u0019/g9\u0002\u0014!\u00044pe6\fGOV3sg&|g\u000eK\u0003\u0001\u0003O\ty$A\bOC&4XMQ1zKNlu\u000eZ3m!\tqxd\u0005\u0004 o\nu\u00131\u0001\t\u0007\u0003\u0017\u0011y&a\u001f\n\t\t\u0005\u0014Q\u0002\u0002\u0007\u0019>\fG-\u001a:\u0015\u0005\te\u0013\u0001D*bm\u0016du.\u00193We}\u0003\u0004c\u0001B5E5\tqD\u0001\u0007TCZ,Gj\\1e-Jz\u0006g\u0005\u0002#oR\u0011!qM\u0001\u0012i\"L7OR8s[\u0006$h+\u001a:tS>t\u0017!\u0004;iSN\u001cE.Y:t\u001d\u0006lWM\u0001\u0003ECR\f7C\u0002\u0014x\u0005s\n\u0019\u0001E\u0002y\u0005wJ1A! z\u0005\u001d\u0001&o\u001c3vGR$\"B!!\u0003\u0006\n\u001d%\u0011\u0012BF!\r\u0011\u0019IJ\u0007\u0002E!9\u0011QC\u0018A\u0002\u0005e\u0001bBA\u001e_\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003\u000fz\u0003\u0019AA&\u0011\u001d\t\u0019f\fa\u0001\u0003/\nAaY8qsRQ!\u0011\u0011BI\u0005'\u0013)Ja&\t\u0013\u0005U\u0001\u0007%AA\u0002\u0005e\u0001\"CA\u001eaA\u0005\t\u0019AA\r\u0011%\t9\u0005\rI\u0001\u0002\u0004\tY\u0005C\u0005\u0002TA\u0002\n\u00111\u0001\u0002X\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BOU\u0011\tIBa(,\u0005\t\u0005\u0006\u0003\u0002BR\u0005Wk!A!*\u000b\t\t\u001d&\u0011V\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\fz\u0013\u0011\u0011iK!*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\u0017\u0016\u0005\u0003\u0017\u0012y*\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tm&\u0006BA,\u0005?\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001Ba!\u0011\tILa1\n\t\u0005%\u00141X\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005\u0013\u00042\u0001\u001fBf\u0013\r\u0011i-\u001f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005'\u0014I\u000eE\u0002y\u0005+L1Aa6z\u0005\r\te.\u001f\u0005\n\u00057<\u0014\u0011!a\u0001\u0005\u0013\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001Bq!\u0019\u0011\u0019O!;\u0003T6\u0011!Q\u001d\u0006\u0004\u0005OL\u0018AC2pY2,7\r^5p]&!!1\u001eBs\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\tE(q\u001f\t\u0004q\nM\u0018b\u0001B{s\n9!i\\8mK\u0006t\u0007\"\u0003Bns\u0005\u0005\t\u0019\u0001Bj\u0003!A\u0017m\u001d5D_\u0012,GC\u0001Be\u0003!!xn\u0015;sS:<GC\u0001Ba\u0003\u0019)\u0017/^1mgR!!\u0011_B\u0003\u0011%\u0011Y\u000ePA\u0001\u0002\u0004\u0011\u0019.\u0001\u0003ECR\f\u0007c\u0001BB}M)ah!\u0004\u0002\u0004Aq1qBB\u000b\u00033\tI\"a\u0013\u0002X\t\u0005UBAB\t\u0015\r\u0019\u0019\"_\u0001\beVtG/[7f\u0013\u0011\u00199b!\u0005\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0006\u0002\u0004\n\u0005)\u0011\r\u001d9msRQ!\u0011QB\u0010\u0007C\u0019\u0019c!\n\t\u000f\u0005U\u0011\t1\u0001\u0002\u001a!9\u00111H!A\u0002\u0005e\u0001bBA$\u0003\u0002\u0007\u00111\n\u0005\b\u0003'\n\u0005\u0019AA,\u0003\u001d)h.\u00199qYf$Baa\u000b\u00044A)\u00010a6\u0004.AY\u0001pa\f\u0002\u001a\u0005e\u00111JA,\u0013\r\u0019\t$\u001f\u0002\u0007)V\u0004H.\u001a\u001b\t\u0013\rU\")!AA\u0002\t\u0005\u0015a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019Y\u0004\u0005\u0003\u0002:\u000eu\u0012\u0002BB \u0003w\u0013aa\u00142kK\u000e$H\u0003\u0003B\u001c\u0007\u0007\u001a)ea\u0012\t\u000f\t}B\t1\u0001\u0003B!9!1\n#A\u0002\u0005]\u0003bBB%\t\u0002\u0007!\u0011Q\u0001\u0005I\u0006$\u0018-\u0001\u0003m_\u0006$GCBA>\u0007\u001f\u001a\t\u0006C\u0004\u0003@\u0015\u0003\rA!\u0011\t\u000f\t-S\t1\u0001\u0002X!*Q)a\n\u0003P\u0005a1+\u0019<f\u0019>\fGMV\u0019`aA\u0019!\u0011N$\u0003\u0019M\u000bg/\u001a'pC\u00124\u0016g\u0018\u0019\u0014\u0005\u001d;HCAB,'\u0019YuO!\u001f\u0002\u0004QA11MB4\u0007S\u001aY\u0007E\u0002\u0004f-k\u0011a\u0012\u0005\b\u0003+\u0011\u0006\u0019AA\r\u0011\u001d\tYD\u0015a\u0001\u00033Aq!a\u0012S\u0001\u0004\tY\u0005\u0006\u0005\u0004d\r=4\u0011OB:\u0011%\t)b\u0015I\u0001\u0002\u0004\tI\u0002C\u0005\u0002<M\u0003\n\u00111\u0001\u0002\u001a!I\u0011qI*\u0011\u0002\u0003\u0007\u00111\n\u000b\u0005\u0005'\u001c9\bC\u0005\u0003\\f\u000b\t\u00111\u0001\u0003JR!!\u0011_B>\u0011%\u0011YnWA\u0001\u0002\u0004\u0011\u0019\u000e\u0006\u0003\u0003r\u000e}\u0004\"\u0003Bn=\u0006\u0005\t\u0019\u0001Bj!\r\u0019)\u0007Y\n\u0006A\u000e\u0015\u00151\u0001\t\r\u0007\u001f\u00199)!\u0007\u0002\u001a\u0005-31M\u0005\u0005\u0007\u0013\u001b\tBA\tBEN$(/Y2u\rVt7\r^5p]N\"\"a!!\u0015\u0011\r\r4qRBI\u0007'Cq!!\u0006d\u0001\u0004\tI\u0002C\u0004\u0002<\r\u0004\r!!\u0007\t\u000f\u0005\u001d3\r1\u0001\u0002LQ!1qSBP!\u0015A\u0018q[BM!%A81TA\r\u00033\tY%C\u0002\u0004\u001ef\u0014a\u0001V;qY\u0016\u001c\u0004\"CB\u001bI\u0006\u0005\t\u0019AB2)!\u00119da)\u0004&\u000e\u001d\u0006b\u0002B M\u0002\u0007!\u0011\t\u0005\b\u0005\u00172\u0007\u0019AA,\u0011\u001d\u0019IE\u001aa\u0001\u0007G\"b!a\u001f\u0004,\u000e5\u0006b\u0002B O\u0002\u0007!\u0011\t\u0005\b\u0005\u0017:\u0007\u0019AA,)\u0019\tYh!-\u00044\"9!q\b5A\u0002\t\u0005\u0003b\u0002B&Q\u0002\u0007\u0011q\u000b\u0015\u0006?\u0005\u001d\"q\n\u0015\u0006=\u0005\u001d\"q\n")
public class NaiveBayesModel
implements ClassificationModel,
Saveable {
    private final double[] labels;
    private final double[] pi;
    private final double[][] theta;
    private final String modelType;
    private final DenseVector piVector;
    private final DenseMatrix thetaMatrix;
    private final /* synthetic */ Tuple2 x$2;
    private final Option<DenseMatrix> thetaMinusNegTheta;
    private final Option<DenseVector> negThetaSum;

    public static NaiveBayesModel load(SparkContext sparkContext, String string) {
        return NaiveBayesModel$.MODULE$.load(sparkContext, string);
    }

    @Override
    public JavaRDD<Double> predict(JavaRDD<Vector> testData) {
        return ClassificationModel.predict$(this, testData);
    }

    public double[] labels() {
        return this.labels;
    }

    public double[] pi() {
        return this.pi;
    }

    public double[][] theta() {
        return this.theta;
    }

    public String modelType() {
        return this.modelType;
    }

    private DenseVector piVector() {
        return this.piVector;
    }

    private DenseMatrix thetaMatrix() {
        return this.thetaMatrix;
    }

    private Option<DenseMatrix> thetaMinusNegTheta() {
        return this.thetaMinusNegTheta;
    }

    private Option<DenseVector> negThetaSum() {
        return this.negThetaSum;
    }

    @Override
    public RDD<Object> predict(RDD<Vector> testData) {
        Broadcast bcModel = testData.context().broadcast((Object)this, ClassTag$.MODULE$.apply(NaiveBayesModel.class));
        return testData.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            NaiveBayesModel model = (NaiveBayesModel)bcModel.value();
            return iter.map((Function1 & Serializable & scala.Serializable)testData -> BoxesRunTime.boxToDouble((double)model.predict(testData)));
        }, testData.mapPartitions$default$2(), ClassTag$.MODULE$.Double());
    }

    @Override
    public double predict(Vector testData) {
        double d;
        String string = this.modelType();
        String string2 = NaiveBayes$.MODULE$.Multinomial();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            d = this.labels()[this.multinomialCalculation(testData).argmax()];
        } else {
            String string4 = NaiveBayes$.MODULE$.Bernoulli();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                d = this.labels()[this.bernoulliCalculation(testData).argmax()];
            } else {
                throw new MatchError((Object)string);
            }
        }
        return d;
    }

    public RDD<Vector> predictProbabilities(RDD<Vector> testData) {
        Broadcast bcModel = testData.context().broadcast((Object)this, ClassTag$.MODULE$.apply(NaiveBayesModel.class));
        return testData.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            NaiveBayesModel model = (NaiveBayesModel)bcModel.value();
            return iter.map((Function1 & Serializable & scala.Serializable)testData -> model.predictProbabilities((Vector)testData));
        }, testData.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Vector.class));
    }

    public Vector predictProbabilities(Vector testData) {
        DenseVector denseVector;
        String string = this.modelType();
        String string2 = NaiveBayes$.MODULE$.Multinomial();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            denseVector = this.posteriorProbabilities(this.multinomialCalculation(testData));
        } else {
            String string4 = NaiveBayes$.MODULE$.Bernoulli();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                denseVector = this.posteriorProbabilities(this.bernoulliCalculation(testData));
            } else {
                throw new MatchError((Object)string);
            }
        }
        return denseVector;
    }

    /*
     * WARNING - void declaration
     */
    private DenseVector multinomialCalculation(Vector testData) {
        void var2_2;
        DenseVector prob = this.thetaMatrix().multiply(testData);
        BLAS$.MODULE$.axpy(1.0, (Vector)this.piVector(), (Vector)prob);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private DenseVector bernoulliCalculation(Vector testData) {
        void var2_2;
        testData.foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(x$3, value) -> {
            if (value != 0.0 && value != 1.0) {
                throw new SparkException(new StringBuilder(64).append("Bernoulli naive Bayes requires 0 or 1 feature values but found ").append(testData).append(".").toString());
            }
        });
        DenseVector prob = ((Matrix)this.thetaMinusNegTheta().get()).multiply(testData);
        BLAS$.MODULE$.axpy(1.0, (Vector)this.piVector(), (Vector)prob);
        BLAS$.MODULE$.axpy(1.0, (Vector)this.negThetaSum().get(), (Vector)prob);
        return var2_2;
    }

    private DenseVector posteriorProbabilities(DenseVector logProb) {
        double[] logProbArray = logProb.toArray();
        double maxLog = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(logProbArray)).max((Ordering)Ordering.Double$.MODULE$));
        double[] scaledProbs = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(logProbArray)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)lp -> package$.MODULE$.exp(lp - maxLog), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double probSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(scaledProbs)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return new DenseVector((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(scaledProbs)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$4 -> x$4 / probSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    @Override
    public void save(SparkContext sc, String path) {
        SaveLoadV2_0.Data data = new SaveLoadV2_0.Data(this.labels(), this.pi(), this.theta(), this.modelType());
        NaiveBayesModel$SaveLoadV2_0$.MODULE$.save(sc, path, data);
    }

    @Override
    public String formatVersion() {
        return "2.0";
    }

    public NaiveBayesModel(double[] labels, double[] pi, double[][] theta, String modelType) {
        Tuple2 tuple2;
        this.labels = labels;
        this.pi = pi;
        this.theta = theta;
        this.modelType = modelType;
        ClassificationModel.$init$(this);
        this.piVector = new DenseVector(pi);
        this.thetaMatrix = new DenseMatrix(labels.length, theta[0].length, (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])theta)).flatten((Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), ClassTag$.MODULE$.Double()), true);
        Predef$.MODULE$.require(NaiveBayes$.MODULE$.supportedModelTypes().contains((Object)modelType), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Invalid modelType ").append(this.modelType()).append(". Supported modelTypes are ").append(NaiveBayes$.MODULE$.supportedModelTypes()).append(".").toString());
        String string = modelType;
        String string2 = NaiveBayes$.MODULE$.Multinomial();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        } else {
            String string4 = NaiveBayes$.MODULE$.Bernoulli();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                Matrix negTheta = this.thetaMatrix().map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)value -> package$.MODULE$.log(1.0 - package$.MODULE$.exp(value)));
                DenseVector ones = new DenseVector((double[])Array$.MODULE$.fill(this.thetaMatrix().numCols(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()));
                Matrix thetaMinusNegTheta = this.thetaMatrix().map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)value -> value - package$.MODULE$.log(1.0 - package$.MODULE$.exp(value)));
                tuple2 = new Tuple2((Object)Option$.MODULE$.apply((Object)thetaMinusNegTheta), (Object)Option$.MODULE$.apply((Object)((DenseMatrix)negTheta).multiply(ones)));
            } else {
                throw new UnknownError(new StringBuilder(20).append("Invalid modelType: ").append(modelType).append(".").toString());
            }
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Option thetaMinusNegTheta = (Option)tuple22._1();
        Option negThetaSum = (Option)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)thetaMinusNegTheta, (Object)negThetaSum);
        this.x$2 = tuple23;
        this.thetaMinusNegTheta = (Option)this.x$2._1();
        this.negThetaSum = (Option)this.x$2._2();
    }

    public NaiveBayesModel(double[] labels, double[] pi, double[][] theta) {
        this(labels, pi, theta, NaiveBayes$.MODULE$.Multinomial());
    }

    public NaiveBayesModel(Iterable<Object> labels, Iterable<Object> pi, Iterable<Iterable<Object>> theta) {
        this((double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(labels).asScala()).toArray(ClassTag$.MODULE$.Double()), (double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(pi).asScala()).toArray(ClassTag$.MODULE$.Double()), (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(theta).asScala()).toArray(ClassTag$.MODULE$.apply(Iterable.class)))).map((Function1)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final double[] apply(Iterable<Object> x$1) {
                return (double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$1).asScala()).toArray(ClassTag$.MODULE$.Double());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))));
    }
}

