/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.NumericOps;
import breeze.linalg.normalize$;
import breeze.storage.Zero;
import java.io.Serializable;
import java.util.Random;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.PartitionStrategy;
import org.apache.spark.graphx.TripletFields;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.util.PeriodicGraphCheckpointer;
import org.apache.spark.mllib.clustering.DistributedLDAModel;
import org.apache.spark.mllib.clustering.DistributedLDAModel$;
import org.apache.spark.mllib.clustering.LDA;
import org.apache.spark.mllib.clustering.LDA$;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0012%\u0005=BQA\u000f\u0001\u0005\u0002mBq!\u0010\u0001A\u0002\u0013%a\bC\u0004C\u0001\u0001\u0007I\u0011B\"\t\r%\u0003\u0001\u0015)\u0003@\u0011\u0015Q\u0005\u0001\"\u0001?\u0011\u0015!\u0006\u0001\"\u0001V\u0011!I\u0006\u00011A\u0005\u0002\u0011R\u0006\u0002C6\u0001\u0001\u0004%\t\u0001\n7\t\r9\u0004\u0001\u0015)\u0003\\\u0011!y\u0007\u00011A\u0005\u0002\u0011\u0002\b\u0002\u0003;\u0001\u0001\u0004%\t\u0001J;\t\r]\u0004\u0001\u0015)\u0003r\u0011!A\b\u00011A\u0005\u0002\u0011\u0002\b\u0002C=\u0001\u0001\u0004%\t\u0001\n>\t\rq\u0004\u0001\u0015)\u0003r\u0011!i\b\u00011A\u0005\u0002\u0011r\bBCA\u0003\u0001\u0001\u0007I\u0011\u0001\u0013\u0002\b!9\u00111\u0002\u0001!B\u0013y\b\"CA\u0007\u0001\u0001\u0007I\u0011\u0001\u0013\u007f\u0011)\ty\u0001\u0001a\u0001\n\u0003!\u0013\u0011\u0003\u0005\b\u0003+\u0001\u0001\u0015)\u0003\u0000\u0011%\t9\u0002\u0001a\u0001\n\u0003!\u0003\u000f\u0003\u0006\u0002\u001a\u0001\u0001\r\u0011\"\u0001%\u00037Aq!a\b\u0001A\u0003&\u0011\u000fC\u0005\u0002\"\u0001\u0001\r\u0011\"\u0003\u0002$!I\u0011\u0011\u0007\u0001A\u0002\u0013%\u00111\u0007\u0005\t\u0003o\u0001\u0001\u0015)\u0003\u0002&!A\u0011\u0011\b\u0001\u0005B\u0011\nY\u0004C\u0004\u0002p\u0001!\t\u0005J\u001e\t\u0015\u0005E\u0004\u00011A\u0005\u0002\u0011\n\u0019\b\u0003\u0006\u0002v\u0001\u0001\r\u0011\"\u0001%\u0003oBq!a\u001f\u0001A\u0003&\u0011\rC\u0004\u0002~\u0001!I!a \t\u0011\u0005\u0005\u0005\u0001\"\u0011%\u0003\u0007\u0013a\"R'M\t\u0006{\u0005\u000f^5nSj,'O\u0003\u0002&M\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005\u001dB\u0013!B7mY&\u0014'BA\u0015+\u0003\u0015\u0019\b/\u0019:l\u0015\tYC&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002[\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\r\u001c\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\r\u0005s\u0017PU3g!\t9\u0004(D\u0001%\u0013\tIDE\u0001\u0007M\t\u0006{\u0005\u000f^5nSj,'/\u0001\u0004=S:LGO\u0010\u000b\u0002yA\u0011q\u0007A\u0001\u0013W\u0016,\u0007\u000fT1ti\u000eCWmY6q_&tG/F\u0001@!\t\t\u0004)\u0003\u0002Be\t9!i\\8mK\u0006t\u0017AF6fKBd\u0015m\u001d;DQ\u0016\u001c7\u000e]8j]R|F%Z9\u0015\u0005\u0011;\u0005CA\u0019F\u0013\t1%G\u0001\u0003V]&$\bb\u0002%\u0004\u0003\u0003\u0005\raP\u0001\u0004q\u0012\n\u0014aE6fKBd\u0015m\u001d;DQ\u0016\u001c7\u000e]8j]R\u0004\u0013!F4fi.+W\r\u001d'bgR\u001c\u0005.Z2la>Lg\u000e\u001e\u0015\u0004\u000b1\u0013\u0006CA'Q\u001b\u0005q%BA()\u0003)\tgN\\8uCRLwN\\\u0005\u0003#:\u0013QaU5oG\u0016\f\u0013aU\u0001\u0006e9\u0002d\u0006M\u0001\u0016g\u0016$8*Z3q\u0019\u0006\u001cHo\u00115fG.\u0004x.\u001b8u)\t1v+D\u0001\u0001\u0011\u0015id\u00011\u0001@Q\r1AJU\u0001\u0006OJ\f\u0007\u000f[\u000b\u00027B!AlX1i\u001b\u0005i&B\u00010)\u0003\u00199'/\u00199iq&\u0011\u0001-\u0018\u0002\u0006\u000fJ\f\u0007\u000f\u001b\t\u0003E\u0016t!aN2\n\u0005\u0011$\u0013a\u0001'E\u0003&\u0011am\u001a\u0002\f)>\u0004\u0018nY\"pk:$8O\u0003\u0002eIA\u0011!-[\u0005\u0003U\u001e\u0014!\u0002V8lK:\u001cu.\u001e8u\u0003%9'/\u00199i?\u0012*\u0017\u000f\u0006\u0002E[\"9\u0001\nCA\u0001\u0002\u0004Y\u0016AB4sCBD\u0007%A\u0001l+\u0005\t\bCA\u0019s\u0013\t\u0019(GA\u0002J]R\fQa[0%KF$\"\u0001\u0012<\t\u000f![\u0011\u0011!a\u0001c\u0006\u00111\u000eI\u0001\nm>\u001c\u0017MY*ju\u0016\fQB^8dC\n\u001c\u0016N_3`I\u0015\fHC\u0001#|\u0011\u001dAe\"!AA\u0002E\f!B^8dC\n\u001c\u0016N_3!\u0003A!wnY\"p]\u000e,g\u000e\u001e:bi&|g.F\u0001\u0000!\r\t\u0014\u0011A\u0005\u0004\u0003\u0007\u0011$A\u0002#pk\ndW-\u0001\u000be_\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]~#S-\u001d\u000b\u0004\t\u0006%\u0001b\u0002%\u0012\u0003\u0003\u0005\ra`\u0001\u0012I>\u001c7i\u001c8dK:$(/\u0019;j_:\u0004\u0013A\u0005;pa&\u001c7i\u001c8dK:$(/\u0019;j_:\fa\u0003^8qS\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]~#S-\u001d\u000b\u0004\t\u0006M\u0001b\u0002%\u0015\u0003\u0003\u0005\ra`\u0001\u0014i>\u0004\u0018nY\"p]\u000e,g\u000e\u001e:bi&|g\u000eI\u0001\u0013G\",7m\u001b9pS:$\u0018J\u001c;feZ\fG.\u0001\fdQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006dw\fJ3r)\r!\u0015Q\u0004\u0005\b\u0011^\t\t\u00111\u0001r\u0003M\u0019\u0007.Z2la>Lg\u000e^%oi\u0016\u0014h/\u00197!\u0003E9'/\u00199i\u0007\",7m\u001b9pS:$XM]\u000b\u0003\u0003K\u0001b!a\n\u0002.\u0005DWBAA\u0015\u0015\r\tY#X\u0001\u0005kRLG.\u0003\u0003\u00020\u0005%\"!\u0007)fe&|G-[2He\u0006\u0004\bn\u00115fG.\u0004x.\u001b8uKJ\fQc\u001a:ba\"\u001c\u0005.Z2la>Lg\u000e^3s?\u0012*\u0017\u000fF\u0002E\u0003kA\u0001\u0002\u0013\u000e\u0002\u0002\u0003\u0007\u0011QE\u0001\u0013OJ\f\u0007\u000f[\"iK\u000e\\\u0007o\\5oi\u0016\u0014\b%\u0001\u0006j]&$\u0018.\u00197ju\u0016$R\u0001PA\u001f\u0003KBq!a\u0010\u001d\u0001\u0004\t\t%\u0001\u0003e_\u000e\u001c\bCBA\"\u0003\u0013\ni%\u0004\u0002\u0002F)\u0019\u0011q\t\u0015\u0002\u0007I$G-\u0003\u0003\u0002L\u0005\u0015#a\u0001*E\tB9\u0011'a\u0014\u0002T\u0005e\u0013bAA)e\t1A+\u001e9mKJ\u00022!MA+\u0013\r\t9F\r\u0002\u0005\u0019>tw\r\u0005\u0003\u0002\\\u0005\u0005TBAA/\u0015\r\tyFJ\u0001\u0007Y&t\u0017\r\\4\n\t\u0005\r\u0014Q\f\u0002\u0007-\u0016\u001cGo\u001c:\t\u000f\u0005\u001dD\u00041\u0001\u0002j\u0005\u0019A\u000eZ1\u0011\u0007]\nY'C\u0002\u0002n\u0011\u00121\u0001\u0014#B\u0003\u0011qW\r\u001f;\u0002#\u001ddwNY1m)>\u0004\u0018n\u0019+pi\u0006d7/F\u0001b\u0003U9Gn\u001c2bYR{\u0007/[2U_R\fGn]0%KF$2\u0001RA=\u0011\u001dAu$!AA\u0002\u0005\f!c\u001a7pE\u0006dGk\u001c9jGR{G/\u00197tA\u0005A2m\\7qkR,w\t\\8cC2$v\u000e]5d)>$\u0018\r\\:\u0015\u0003\u0005\f1bZ3u\u0019\u0012\u000bUj\u001c3fYR!\u0011QQAF!\r9\u0014qQ\u0005\u0004\u0003\u0013##\u0001\u0003'E\u00036{G-\u001a7\t\u000f\u00055%\u00051\u0001\u0002\u0010\u0006q\u0011\u000e^3sCRLwN\u001c+j[\u0016\u001c\b\u0003B\u0019\u0002\u0012~L1!a%3\u0005\u0015\t%O]1zQ\r\u0001\u0011q\u0013\t\u0004\u001b\u0006e\u0015bAAN\u001d\naA)\u001a<fY>\u0004XM]!qS\"\"\u0001\u0001TAPC\t\t\t+A\u00032]Qr\u0003\u0007")
public final class EMLDAOptimizer
implements LDAOptimizer {
    private boolean keepLastCheckpoint = true;
    private Graph<DenseVector<Object>, Object> graph = null;
    private int k = 0;
    private int vocabSize = 0;
    private double docConcentration = 0.0;
    private double topicConcentration = 0.0;
    private int checkpointInterval = 10;
    private PeriodicGraphCheckpointer<DenseVector<Object>, Object> graphCheckpointer = null;
    private DenseVector<Object> globalTopicTotals = null;

    private boolean keepLastCheckpoint() {
        return this.keepLastCheckpoint;
    }

    private void keepLastCheckpoint_$eq(boolean x$1) {
        this.keepLastCheckpoint = x$1;
    }

    public boolean getKeepLastCheckpoint() {
        return this.keepLastCheckpoint();
    }

    public EMLDAOptimizer setKeepLastCheckpoint(boolean keepLastCheckpoint) {
        this.keepLastCheckpoint_$eq(keepLastCheckpoint);
        return this;
    }

    public Graph<DenseVector<Object>, Object> graph() {
        return this.graph;
    }

    public void graph_$eq(Graph<DenseVector<Object>, Object> x$1) {
        this.graph = x$1;
    }

    public int k() {
        return this.k;
    }

    public void k_$eq(int x$1) {
        this.k = x$1;
    }

    public int vocabSize() {
        return this.vocabSize;
    }

    public void vocabSize_$eq(int x$1) {
        this.vocabSize = x$1;
    }

    public double docConcentration() {
        return this.docConcentration;
    }

    public void docConcentration_$eq(double x$1) {
        this.docConcentration = x$1;
    }

    public double topicConcentration() {
        return this.topicConcentration;
    }

    public void topicConcentration_$eq(double x$1) {
        this.topicConcentration = x$1;
    }

    public int checkpointInterval() {
        return this.checkpointInterval;
    }

    public void checkpointInterval_$eq(int x$1) {
        this.checkpointInterval = x$1;
    }

    private PeriodicGraphCheckpointer<DenseVector<Object>, Object> graphCheckpointer() {
        return this.graphCheckpointer;
    }

    private void graphCheckpointer_$eq(PeriodicGraphCheckpointer<DenseVector<Object>, Object> x$1) {
        this.graphCheckpointer = x$1;
    }

    @Override
    public EMLDAOptimizer initialize(RDD<Tuple2<Object, Vector>> docs, LDA lda) {
        double docConcentration = lda.getDocConcentration();
        double topicConcentration = lda.getTopicConcentration();
        int k = lda.getK();
        Predef$.MODULE$.require(docConcentration > 1.0 || docConcentration == -1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("LDA docConcentration must be").append(new StringBuilder(57).append(" > 1.0 (or -1 for auto) for EM Optimizer, but was set to ").append(docConcentration).toString()).toString());
        Predef$.MODULE$.require(topicConcentration > 1.0 || topicConcentration == -1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("LDA topicConcentration ").append(new StringBuilder(64).append("must be > 1.0 (or -1 for auto) for EM Optimizer, but was set to ").append(topicConcentration).toString()).toString());
        this.docConcentration_$eq(docConcentration == (double)-1 ? 50.0 / (double)k + 1.0 : docConcentration);
        this.topicConcentration_$eq(topicConcentration == (double)-1 ? 1.1 : topicConcentration);
        long randomSeed = lda.getSeed();
        RDD edges = docs.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            long l;
            Vector termCounts;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    long docID = tuple2._1$mcJ$sp();
                    termCounts = (Vector)tuple2._2();
                    l = docID;
                    if (termCounts != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Vector vector = termCounts;
            Iterator iterator = vector.asBreeze().activeIterator().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EMLDAOptimizer.$anonfun$initialize$4(x$1))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int term = tuple2._1$mcI$sp();
                double cnt = tuple2._2$mcD$sp();
                Edge.mcD.sp sp2 = new Edge.mcD.sp(l, LDA$.MODULE$.term2index(term), cnt);
                return sp2;
            });
            return iterator;
        }, ClassTag$.MODULE$.apply(Edge.class));
        RDD verticesTMP = edges.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(x0$3, x1$1) -> EMLDAOptimizer.$anonfun$initialize$6(randomSeed, k, BoxesRunTime.unboxToInt((Object)x0$3), x1$1), edges.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
        RDD docTermVertices = RDD$.MODULE$.rddToPairRDDFunctions(verticesTMP, ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(DenseVector.class), (Ordering)Ordering.Long$.MODULE$).reduceByKey((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> (DenseVector)x$2.$plus(x$3, DenseVector$.MODULE$.canAddD()));
        this.graph_$eq((Graph<DenseVector<Object>, Object>)Graph$.MODULE$.apply(docTermVertices, edges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(DenseVector.class), ClassTag$.MODULE$.apply(Double.TYPE)).partitionBy((PartitionStrategy)PartitionStrategy.EdgePartition1D$.MODULE$));
        this.k_$eq(k);
        this.vocabSize_$eq(((Vector)((Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])docs.take(1))).head())._2()).size());
        this.checkpointInterval_$eq(lda.getCheckpointInterval());
        this.graphCheckpointer_$eq((PeriodicGraphCheckpointer<DenseVector<Object>, Object>)new PeriodicGraphCheckpointer(this.checkpointInterval(), this.graph().vertices().sparkContext()));
        this.graphCheckpointer().update(this.graph());
        this.globalTopicTotals_$eq(this.computeGlobalTopicTotals());
        return this;
    }

    @Override
    public EMLDAOptimizer next() {
        Predef$.MODULE$.require(this.graph() != null, (Function0 & Serializable & scala.Serializable)() -> "graph is null, EMLDAOptimizer not initialized.");
        double eta = this.topicConcentration();
        int W = this.vocabSize();
        double alpha = this.docConcentration();
        DenseVector<Object> N_k = this.globalTopicTotals();
        Function1 & Serializable & scala.Serializable sendMsg = (Function1 & Serializable & scala.Serializable)edgeContext -> {
            EMLDAOptimizer.$anonfun$next$2(N_k, W, eta, alpha, edgeContext);
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable mergeMsg = (Function2 & Serializable & scala.Serializable)(m0, m1) -> {
            DenseVector sum = m0._1$mcZ$sp() ? (DenseVector)((NumericOps)m0._2()).$plus$eq(m1._2(), DenseVector$.MODULE$.canAddIntoD()) : (m1._1$mcZ$sp() ? (DenseVector)((NumericOps)m1._2()).$plus$eq(m0._2(), DenseVector$.MODULE$.canAddIntoD()) : (DenseVector)((NumericOps)m0._2()).$plus(m1._2(), DenseVector$.MODULE$.canAddD()));
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)sum);
        };
        Graph<DenseVector<Object>, Object> qual$1 = this.graph();
        Function1 & Serializable & scala.Serializable x$1 = sendMsg;
        Function2 & Serializable & scala.Serializable x$2 = mergeMsg;
        TripletFields x$3 = qual$1.aggregateMessages$default$3();
        VertexRDD docTopicDistributions = qual$1.aggregateMessages((Function1)x$1, (Function2)x$2, x$3, ClassTag$.MODULE$.apply(Tuple2.class)).mapValues((Function1 & Serializable & scala.Serializable)x$4 -> (DenseVector)x$4._2(), ClassTag$.MODULE$.apply(DenseVector.class));
        Graph newGraph = Graph$.MODULE$.apply((RDD)docTopicDistributions, (RDD)this.graph().edges(), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(DenseVector.class), ClassTag$.MODULE$.apply(Double.TYPE));
        this.graph_$eq((Graph<DenseVector<Object>, Object>)newGraph);
        this.graphCheckpointer().update((Object)newGraph);
        this.globalTopicTotals_$eq(this.computeGlobalTopicTotals());
        return this;
    }

    public DenseVector<Object> globalTopicTotals() {
        return this.globalTopicTotals;
    }

    public void globalTopicTotals_$eq(DenseVector<Object> x$1) {
        this.globalTopicTotals = x$1;
    }

    private DenseVector<Object> computeGlobalTopicTotals() {
        int numTopics = this.k();
        return (DenseVector)RDD$.MODULE$.rddToPairRDDFunctions((RDD)this.graph().vertices().filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)LDA$.MODULE$.isTermVertex(v))), ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(DenseVector.class), (Ordering)Ordering.Long$.MODULE$).values().fold((Object)DenseVector$.MODULE$.zeros$mDc$sp(numTopics, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> (DenseVector)x$5.$plus$eq(x$6, DenseVector$.MODULE$.canAddIntoD()));
    }

    @Override
    public LDAModel getLDAModel(double[] iterationTimes) {
        String[] stringArray;
        Predef$.MODULE$.require(this.graph() != null, (Function0 & Serializable & scala.Serializable)() -> "graph is null, EMLDAOptimizer not initialized.");
        if (this.keepLastCheckpoint()) {
            this.graphCheckpointer().deleteAllCheckpointsButLast();
            stringArray = this.graphCheckpointer().getAllCheckpointFiles();
        } else {
            this.graphCheckpointer().deleteAllCheckpoints();
            stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        String[] checkpointFiles = stringArray;
        return new DistributedLDAModel(this.graph(), this.globalTopicTotals(), this.k(), this.vocabSize(), Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(this.k(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> this.docConcentration(), ClassTag$.MODULE$.Double())), this.topicConcentration(), iterationTimes, DistributedLDAModel$.MODULE$.defaultGammaShape(), checkpointFiles);
    }

    public static final /* synthetic */ boolean $anonfun$initialize$4(Tuple2 x$1) {
        return x$1._2$mcD$sp() != 0.0;
    }

    public static final /* synthetic */ Iterator $anonfun$initialize$6(long randomSeed$1, int k$1, int x0$3, Iterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$3), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int partIndex = tuple2._1$mcI$sp();
        Iterator partEdges = (Iterator)tuple2._2();
        Random random = new Random((long)partIndex + randomSeed$1);
        Iterator iterator = partEdges.flatMap((Function1 & Serializable & scala.Serializable)edge -> {
            DenseVector gamma = (DenseVector)normalize$.MODULE$.apply((Object)DenseVector$.MODULE$.fill(k$1, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> random.nextDouble(), ClassTag$.MODULE$.Double()), (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()));
            DenseVector sum = (DenseVector)gamma.$times((Object)BoxesRunTime.boxToDouble((double)edge.attr$mcD$sp()), DenseVector$.MODULE$.dv_s_Op_Double_OpMulMatrix());
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)edge.srcId()), (Object)sum), new Tuple2((Object)BoxesRunTime.boxToLong((long)edge.dstId()), (Object)sum)}));
        });
        return iterator;
    }

    public static final /* synthetic */ void $anonfun$next$2(DenseVector N_k$1, int W$1, double eta$1, double alpha$1, EdgeContext edgeContext) {
        double N_wj = BoxesRunTime.unboxToDouble((Object)edgeContext.attr());
        DenseVector scaledTopicDistribution = (DenseVector)LDA$.MODULE$.computePTopic((DenseVector<Object>)((DenseVector)edgeContext.srcAttr()), (DenseVector<Object>)((DenseVector)edgeContext.dstAttr()), (DenseVector<Object>)N_k$1, W$1, eta$1, alpha$1).$times$eq((Object)BoxesRunTime.boxToDouble((double)N_wj), DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpMulScalar());
        edgeContext.sendToDst((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)scaledTopicDistribution));
        edgeContext.sendToSrc((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)scaledTopicDistribution));
    }
}

