/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.DistanceMeasure$;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.clustering.LocalKMeans$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.DoubleAccumulator;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeqLike;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\rb\u0001B!C\u00015C\u0001\"\u0018\u0001\u0003\u0002\u0004%IA\u0018\u0005\tE\u0002\u0011\t\u0019!C\u0005G\"A\u0011\u000e\u0001B\u0001B\u0003&q\f\u0003\u0005k\u0001\t\u0005\r\u0011\"\u0003_\u0011!Y\u0007A!a\u0001\n\u0013a\u0007\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0015B0\t\u0011=\u0004!\u00111A\u0005\nAD\u0001\u0002 \u0001\u0003\u0002\u0004%I! \u0005\t\u007f\u0002\u0011\t\u0011)Q\u0005c\"I\u0011\u0011\u0001\u0001\u0003\u0002\u0004%IA\u0018\u0005\u000b\u0003\u0007\u0001!\u00111A\u0005\n\u0005\u0015\u0001\"CA\u0005\u0001\t\u0005\t\u0015)\u0003`\u0011)\tY\u0001\u0001BA\u0002\u0013%\u0011Q\u0002\u0005\u000b\u0003+\u0001!\u00111A\u0005\n\u0005]\u0001BCA\u000e\u0001\t\u0005\t\u0015)\u0003\u0002\u0010!Q\u0011Q\u0004\u0001\u0003\u0002\u0004%I!a\b\t\u0015\u0005\u001d\u0002A!a\u0001\n\u0013\tI\u0003\u0003\u0006\u0002.\u0001\u0011\t\u0011)Q\u0005\u0003CA\u0011\"a\f\u0001\u0005\u0003\u0007I\u0011\u00029\t\u0015\u0005E\u0002A!a\u0001\n\u0013\t\u0019\u0004C\u0005\u00028\u0001\u0011\t\u0011)Q\u0005c\"9\u0011\u0011\b\u0001\u0005\n\u0005m\u0002bBA\u001d\u0001\u0011%\u0011q\n\u0005\b\u0003s\u0001A\u0011AA8\u0011\u0019\t\u0019\b\u0001C\u0001=\"9\u00111\u0010\u0001\u0005\u0002\u0005u\u0004BBAC\u0001\u0011\u0005a\fC\u0004\u0002\n\u0002!\t!a#\t\r\u0005E\u0005\u0001\"\u0001q\u0011\u001d\t)\n\u0001C\u0001\u0003/Ca!!(\u0001\t\u0003q\u0006bBAY\u0001\u0011\u0005\u00111\u0017\u0005\u0007\u0003\u0003\u0004A\u0011\u00010\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\"9\u0011Q\u001a\u0001\u0005\u0002\u00055\u0001bBAi\u0001\u0011\u0005\u00111\u001b\u0005\b\u00033\u0004A\u0011AA\u0010\u0011\u001d\ti\u000e\u0001C\u0001\u0003?Da!!:\u0001\t\u0003\u0001\bbBAw\u0001\u0011\u0005\u0011q\u001e\u0005\n\u0003k\u0004\u0001\u0019!C\u0005\u0003oD\u0011B!\u0002\u0001\u0001\u0004%IAa\u0002\t\u0011\t-\u0001\u0001)Q\u0005\u0003sDqA!\u0004\u0001\t\u0003\u0011y\u0001C\u0004\u0003\u0018\u0001!\tA!\u0007\t\u0011\t]\u0001\u0001\"\u0001G\u0005sAqAa\u0015\u0001\t\u0013\u0011)\u0006C\u0004\u0003d\u0001!IA!\u001a\t\u0011\t=\u0004\u0001\"\u0001C\u0005c:qA!!C\u0011\u0003\u0011\u0019I\u0002\u0004B\u0005\"\u0005!Q\u0011\u0005\b\u0003s\u0019D\u0011\u0001BD\u0011%\u0011Ii\rb\u0001\n\u0003\u0011Y\t\u0003\u0005\u0003\u001eN\u0002\u000b\u0011\u0002BG\u0011%\u0011\tk\rb\u0001\n\u0003\u0011Y\t\u0003\u0005\u0003&N\u0002\u000b\u0011\u0002BG\u0011\u001d\u0011Ik\rC\u0001\u0005WCqA!+4\t\u0003\u0011I\fC\u0004\u0003*N\"\tA!2\t\u000f\t%6\u0007\"\u0001\u0003`\"9!\u0011V\u001a\u0005\u0002\t=\bb\u0002BUg\u0011\u0005!\u0011 \u0005\t\u0007\u000f\u0019D\u0011\u0001$\u0004\n!I1QC\u001a\u0002\u0002\u0013%1q\u0003\u0002\u0007\u00176+\u0017M\\:\u000b\u0005\r#\u0015AC2mkN$XM]5oO*\u0011QIR\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f\"\u000bQa\u001d9be.T!!\u0013&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0015aA8sO\u000e\u00011\u0003\u0002\u0001O)^\u0003\"a\u0014*\u000e\u0003AS\u0011!U\u0001\u0006g\u000e\fG.Y\u0005\u0003'B\u0013a!\u00118z%\u00164\u0007CA(V\u0013\t1\u0006K\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0005\u0002Y76\t\u0011L\u0003\u0002[\r\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002]3\n9Aj\\4hS:<\u0017!A6\u0016\u0003}\u0003\"a\u00141\n\u0005\u0005\u0004&aA%oi\u0006)1n\u0018\u0013fcR\u0011Am\u001a\t\u0003\u001f\u0016L!A\u001a)\u0003\tUs\u0017\u000e\u001e\u0005\bQ\n\t\t\u00111\u0001`\u0003\rAH%M\u0001\u0003W\u0002\nQ\"\\1y\u0013R,'/\u0019;j_:\u001c\u0018!E7bq&#XM]1uS>t7o\u0018\u0013fcR\u0011A-\u001c\u0005\bQ\u0016\t\t\u00111\u0001`\u00039i\u0017\r_%uKJ\fG/[8og\u0002\n!#\u001b8ji&\fG.\u001b>bi&|g.T8eKV\t\u0011\u000f\u0005\u0002ss:\u00111o\u001e\t\u0003iBk\u0011!\u001e\u0006\u0003m2\u000ba\u0001\u0010:p_Rt\u0014B\u0001=Q\u0003\u0019\u0001&/\u001a3fM&\u0011!p\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a\u0004\u0016AF5oSRL\u0017\r\\5{CRLwN\\'pI\u0016|F%Z9\u0015\u0005\u0011t\bb\u00025\t\u0003\u0003\u0005\r!]\u0001\u0014S:LG/[1mSj\fG/[8o\u001b>$W\rI\u0001\u0014S:LG/[1mSj\fG/[8o'R,\u0007o]\u0001\u0018S:LG/[1mSj\fG/[8o'R,\u0007o]0%KF$2\u0001ZA\u0004\u0011\u001dA7\"!AA\u0002}\u000bA#\u001b8ji&\fG.\u001b>bi&|gn\u0015;faN\u0004\u0013aB3qg&dwN\\\u000b\u0003\u0003\u001f\u00012aTA\t\u0013\r\t\u0019\u0002\u0015\u0002\u0007\t>,(\r\\3\u0002\u0017\u0015\u00048/\u001b7p]~#S-\u001d\u000b\u0004I\u0006e\u0001\u0002\u00035\u000f\u0003\u0003\u0005\r!a\u0004\u0002\u0011\u0015\u00048/\u001b7p]\u0002\nAa]3fIV\u0011\u0011\u0011\u0005\t\u0004\u001f\u0006\r\u0012bAA\u0013!\n!Aj\u001c8h\u0003!\u0019X-\u001a3`I\u0015\fHc\u00013\u0002,!A\u0001.EA\u0001\u0002\u0004\t\t#A\u0003tK\u0016$\u0007%A\beSN$\u0018M\\2f\u001b\u0016\f7/\u001e:f\u0003M!\u0017n\u001d;b]\u000e,W*Z1tkJ,w\fJ3r)\r!\u0017Q\u0007\u0005\bQR\t\t\u00111\u0001r\u0003A!\u0017n\u001d;b]\u000e,W*Z1tkJ,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0011\u0003{\t\t%a\u0011\u0002F\u0005\u001d\u0013\u0011JA&\u0003\u001b\u00022!a\u0010\u0001\u001b\u0005\u0011\u0005\"B/\u0017\u0001\u0004y\u0006\"\u00026\u0017\u0001\u0004y\u0006\"B8\u0017\u0001\u0004\t\bBBA\u0001-\u0001\u0007q\fC\u0004\u0002\fY\u0001\r!a\u0004\t\u000f\u0005ua\u00031\u0001\u0002\"!1\u0011q\u0006\fA\u0002E$b\"!\u0010\u0002R\u0005M\u0013QKA,\u00033\nY\u0006C\u0003^/\u0001\u0007q\fC\u0003k/\u0001\u0007q\fC\u0003p/\u0001\u0007\u0011\u000f\u0003\u0004\u0002\u0002]\u0001\ra\u0018\u0005\b\u0003\u00179\u0002\u0019AA\b\u0011\u001d\tib\u0006a\u0001\u0003CASaFA0\u0003W\u0002B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0004\u0003K2\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011NA2\u0005\u0015\u0019\u0016N\\2fC\t\ti'A\u00031]ar\u0003\u0007\u0006\u0002\u0002>!*\u0001$a\u0018\u0002l\u0005!q-\u001a;LQ\u0015I\u0012qLA<C\t\tI(A\u00032]Qr\u0003'\u0001\u0003tKR\\E\u0003BA@\u0003\u0003k\u0011\u0001\u0001\u0005\u0006;j\u0001\ra\u0018\u0015\u00065\u0005}\u00131N\u0001\u0011O\u0016$X*\u0019=Ji\u0016\u0014\u0018\r^5p]NDSaGA0\u0003o\n\u0001c]3u\u001b\u0006D\u0018\n^3sCRLwN\\:\u0015\t\u0005}\u0014Q\u0012\u0005\u0006Ur\u0001\ra\u0018\u0015\u00069\u0005}\u00131N\u0001\u0016O\u0016$\u0018J\\5uS\u0006d\u0017N_1uS>tWj\u001c3fQ\u0015i\u0012qLA<\u0003U\u0019X\r^%oSRL\u0017\r\\5{CRLwN\\'pI\u0016$B!a \u0002\u001a\")qN\ba\u0001c\"*a$a\u0018\u0002l\u00059q-\u001a;Sk:\u001c\bfB\u0010\u0002\"\u0006\u001d\u00161\u0016\t\u0004\u001f\u0006\r\u0016bAAS!\nQA-\u001a9sK\u000e\fG/\u001a3\"\u0005\u0005%\u0016a\n+iSN\u0004\u0003.Y:!]>\u0004SM\u001a4fGR\u0004\u0013M\u001c3!C2<\u0018-_:!e\u0016$XO\u001d8tAE\n#!!,\u0002\u000bIr\u0013G\f\u0019)\u000b}\ty&a\u001e\u0002\u000fM,GOU;ogR!\u0011qPA[\u0011\u0019\t9\f\ta\u0001?\u0006!!/\u001e8tQ\u001d\u0001\u0013\u0011UA^\u0003W\u000b#!!0\u0002%QC\u0017n\u001d\u0011iCN\u0004cn\u001c\u0011fM\u001a,7\r\u001e\u0015\u0006A\u0005}\u00131N\u0001\u0017O\u0016$\u0018J\\5uS\u0006d\u0017N_1uS>t7\u000b^3qg\"*\u0011%a\u0018\u0002x\u000512/\u001a;J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Ti\u0016\u00048\u000f\u0006\u0003\u0002\u0000\u0005%\u0007BBA\u0001E\u0001\u0007q\fK\u0003#\u0003?\nY'\u0001\u0006hKR,\u0005o]5m_:DSaIA0\u0003o\n!b]3u\u000bB\u001c\u0018\u000e\\8o)\u0011\ty(!6\t\u000f\u0005-A\u00051\u0001\u0002\u0010!*A%a\u0018\u0002l\u00059q-\u001a;TK\u0016$\u0007&B\u0013\u0002`\u0005]\u0014aB:fiN+W\r\u001a\u000b\u0005\u0003\u007f\n\t\u000fC\u0004\u0002\u001e\u0019\u0002\r!!\t)\u000b\u0019\ny&a\u001e\u0002%\u001d,G\u000fR5ti\u0006t7-Z'fCN,(/\u001a\u0015\u0006O\u0005}\u0013\u0011^\u0011\u0003\u0003W\fQA\r\u00185]A\n!c]3u\t&\u001cH/\u00198dK6+\u0017m];sKR!\u0011qPAy\u0011\u0019\ty\u0003\u000ba\u0001c\"*\u0001&a\u0018\u0002j\u0006a\u0011N\\5uS\u0006dWj\u001c3fYV\u0011\u0011\u0011 \t\u0006\u001f\u0006m\u0018q`\u0005\u0004\u0003{\u0004&AB(qi&|g\u000e\u0005\u0003\u0002@\t\u0005\u0011b\u0001B\u0002\u0005\nY1*T3b]Nlu\u000eZ3m\u0003AIg.\u001b;jC2lu\u000eZ3m?\u0012*\u0017\u000fF\u0002e\u0005\u0013A\u0001\u0002\u001b\u0016\u0002\u0002\u0003\u0007\u0011\u0011`\u0001\u000eS:LG/[1m\u001b>$W\r\u001c\u0011\u0002\u001fM,G/\u00138ji&\fG.T8eK2$B!a \u0003\u0012!9!1\u0003\u0017A\u0002\u0005}\u0018!B7pI\u0016d\u0007&\u0002\u0017\u0002`\u0005]\u0014a\u0001:v]R!\u0011q B\u000e\u0011\u001d\u0011i\"\fa\u0001\u0005?\tA\u0001Z1uCB1!\u0011\u0005B\u0014\u0005Wi!Aa\t\u000b\u0007\t\u0015b)A\u0002sI\u0012LAA!\u000b\u0003$\t\u0019!\u000b\u0012#\u0011\t\t5\"1G\u0007\u0003\u0005_Q1A!\rE\u0003\u0019a\u0017N\\1mO&!!Q\u0007B\u0018\u0005\u00191Vm\u0019;pe\"*Q&a\u0018\u0002lQ1\u0011q B\u001e\u0005{AqA!\b/\u0001\u0004\u0011y\u0002C\u0004\u0003@9\u0002\rA!\u0011\u0002\u000b%t7\u000f\u001e:\u0011\u000b=\u000bYPa\u0011\u0011\t\t\u0015#qJ\u0007\u0003\u0005\u000fRAA!\u0013\u0003L\u0005!Q\u000f^5m\u0015\r\u0011iER\u0001\u0003[2LAA!\u0015\u0003H\ty\u0011J\\:ueVlWM\u001c;bi&|g.\u0001\u0007sk:\fEnZ8sSRDW\u000e\u0006\u0004\u0002\u0000\n]#\u0011\r\u0005\b\u0005;y\u0003\u0019\u0001B-!\u0019\u0011\tCa\n\u0003\\A!\u0011q\bB/\u0013\r\u0011yF\u0011\u0002\u000f-\u0016\u001cGo\u001c:XSRDgj\u001c:n\u0011\u001d\u0011yd\fa\u0001\u0005\u0003\n!\"\u001b8jiJ\u000bg\u000eZ8n)\u0011\u00119G!\u001c\u0011\u000b=\u0013IGa\u0017\n\u0007\t-\u0004KA\u0003BeJ\f\u0017\u0010C\u0004\u0003\u001eA\u0002\rA!\u0017\u0002%%t\u0017\u000e^&NK\u0006t7\u000fU1sC2dW\r\u001c\u000b\u0007\u0005O\u0012\u0019H!\u001e\t\u000f\tu\u0011\u00071\u0001\u0003Z!9!qO\u0019A\u0002\te\u0014a\u00063jgR\fgnY3NK\u0006\u001cXO]3J]N$\u0018M\\2f!\u0011\tyDa\u001f\n\u0007\tu$IA\bESN$\u0018M\\2f\u001b\u0016\f7/\u001e:fQ\u0015\u0001\u0011qLA6\u0003\u0019YU*Z1ogB\u0019\u0011qH\u001a\u0014\u0007MrE\u000b\u0006\u0002\u0003\u0004\u00061!+\u0011(E\u001f6+\"A!$\u0011\t\t=%\u0011T\u0007\u0003\u0005#SAAa%\u0003\u0016\u0006!A.\u00198h\u0015\t\u00119*\u0001\u0003kCZ\f\u0017b\u0001>\u0003\u0012\"*Q'a\u0018\u0002l\u00059!+\u0011(E\u001f6\u0003\u0003&\u0002\u001c\u0002`\u0005-\u0014\u0001E&`\u001b\u0016\u000bejU0Q\u0003J\u000bE\nT#MQ\u00159\u0014qLA6\u0003EYu,T#B\u001dN{\u0006+\u0011*B\u00192+E\n\t\u0015\u0006q\u0005}\u00131N\u0001\u0006iJ\f\u0017N\u001c\u000b\r\u0003\u007f\u0014iKa,\u00032\nM&Q\u0017\u0005\b\u0005;I\u0004\u0019\u0001B\u0010\u0011\u0015i\u0016\b1\u0001`\u0011\u0015Q\u0017\b1\u0001`\u0011\u0015y\u0017\b1\u0001r\u0011\u001d\ti\"\u000fa\u0001\u0003CAS!OA0\u0003W#\"\"a@\u0003<\nu&q\u0018Ba\u0011\u001d\u0011iB\u000fa\u0001\u0005?AQ!\u0018\u001eA\u0002}CQA\u001b\u001eA\u0002}CQa\u001c\u001eA\u0002EDSAOA0\u0003W#b\"a@\u0003H\n%'1\u001aBg\u0005\u001f\u0014\t\u000eC\u0004\u0003\u001em\u0002\rAa\b\t\u000bu[\u0004\u0019A0\t\u000b)\\\u0004\u0019A0\t\r\u0005]6\b1\u0001`\u0011\u0015y7\b1\u0001r\u0011\u001d\tib\u000fa\u0001\u0003CAsaOAQ\u0005+\fY+\t\u0002\u0003X\u0006yRk]3!iJ\f\u0017N\u001c\u0011nKRDw\u000e\u001a\u0011xSRDw.\u001e;!OI,hn]\u0014)\u000bm\nyFa7\"\u0005\tu\u0017!B\u0019/g9\u0002D\u0003DA\u0000\u0005C\u0014\u0019O!:\u0003h\n%\bb\u0002B\u000fy\u0001\u0007!q\u0004\u0005\u0006;r\u0002\ra\u0018\u0005\u0006Ur\u0002\ra\u0018\u0005\u0007\u0003oc\u0004\u0019A0\t\u000b=d\u0004\u0019A9)\u000fq\n\tK!6\u0002,\"*A(a\u0018\u0002lQA\u0011q By\u0005g\u0014)\u0010C\u0004\u0003\u001eu\u0002\rAa\b\t\u000buk\u0004\u0019A0\t\u000b)l\u0004\u0019A0)\u000bu\ny&a\u001b\u0015\u0015\u0005}(1 B\u007f\u0005\u007f\u001c\t\u0001C\u0004\u0003\u001ey\u0002\rAa\b\t\u000bus\u0004\u0019A0\t\u000b)t\u0004\u0019A0\t\r\u0005]f\b1\u0001`Q\u001dq\u0014\u0011\u0015Bk\u0003WCSAPA0\u0003W\n\u0001C^1mS\u0012\fG/Z%oSRlu\u000eZ3\u0015\t\r-1\u0011\u0003\t\u0004\u001f\u000e5\u0011bAB\b!\n9!i\\8mK\u0006t\u0007BBB\n\u007f\u0001\u0007\u0011/\u0001\u0005j]&$Xj\u001c3f\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\re\u0001\u0003\u0002BH\u00077IAa!\b\u0003\u0012\n1qJ\u00196fGRDSaMA0\u0003WBSAMA0\u0003W\u0002")
public class KMeans
implements scala.Serializable,
Logging {
    private int k;
    private int maxIterations;
    private String initializationMode;
    private int initializationSteps;
    private double epsilon;
    private long seed;
    private String distanceMeasure;
    private Option<KMeansModel> initialModel;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2) {
        return KMeans$.MODULE$.train(rDD, n, n2);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3, String string) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3, string);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3, String string, long l) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3, string, l);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, String string) {
        return KMeans$.MODULE$.train(rDD, n, n2, string);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, String string, long l) {
        return KMeans$.MODULE$.train(rDD, n, n2, string, l);
    }

    public static String K_MEANS_PARALLEL() {
        return KMeans$.MODULE$.K_MEANS_PARALLEL();
    }

    public static String RANDOM() {
        return KMeans$.MODULE$.RANDOM();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private String initializationMode() {
        return this.initializationMode;
    }

    private void initializationMode_$eq(String x$1) {
        this.initializationMode = x$1;
    }

    private int initializationSteps() {
        return this.initializationSteps;
    }

    private void initializationSteps_$eq(int x$1) {
        this.initializationSteps = x$1;
    }

    private double epsilon() {
        return this.epsilon;
    }

    private void epsilon_$eq(double x$1) {
        this.epsilon = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private String distanceMeasure() {
        return this.distanceMeasure;
    }

    private void distanceMeasure_$eq(String x$1) {
        this.distanceMeasure = x$1;
    }

    public int getK() {
        return this.k();
    }

    public KMeans setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Number of clusters must be positive but got ").append(k).toString());
        this.k_$eq(k);
        return this;
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public KMeans setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Maximum of iterations must be nonnegative but got ").append(maxIterations).toString());
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public String getInitializationMode() {
        return this.initializationMode();
    }

    public KMeans setInitializationMode(String initializationMode) {
        KMeans$.MODULE$.validateInitMode(initializationMode);
        this.initializationMode_$eq(initializationMode);
        return this;
    }

    public int getRuns() {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Getting number of runs has no effect since Spark 2.0.0.");
        return 1;
    }

    public KMeans setRuns(int runs) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Setting number of runs has no effect since Spark 2.0.0.");
        return this;
    }

    public int getInitializationSteps() {
        return this.initializationSteps();
    }

    public KMeans setInitializationSteps(int initializationSteps) {
        Predef$.MODULE$.require(initializationSteps > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Number of initialization steps must be positive but got ").append(initializationSteps).toString());
        this.initializationSteps_$eq(initializationSteps);
        return this;
    }

    public double getEpsilon() {
        return this.epsilon();
    }

    public KMeans setEpsilon(double epsilon) {
        Predef$.MODULE$.require(epsilon >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Distance threshold must be nonnegative but got ").append(epsilon).toString());
        this.epsilon_$eq(epsilon);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public KMeans setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public String getDistanceMeasure() {
        return this.distanceMeasure();
    }

    public KMeans setDistanceMeasure(String distanceMeasure) {
        DistanceMeasure$.MODULE$.validateDistanceMeasure(distanceMeasure);
        this.distanceMeasure_$eq(distanceMeasure);
        return this;
    }

    private Option<KMeansModel> initialModel() {
        return this.initialModel;
    }

    private void initialModel_$eq(Option<KMeansModel> x$1) {
        this.initialModel = x$1;
    }

    public KMeans setInitialModel(KMeansModel model) {
        Predef$.MODULE$.require(model.k() == this.k(), (Function0 & Serializable & scala.Serializable)() -> "mismatched cluster count");
        this.initialModel_$eq((Option<KMeansModel>)new Some((Object)model));
        return this;
    }

    public KMeansModel run(RDD<Vector> data) {
        return this.run(data, (Option<Instrumentation>)None$.MODULE$);
    }

    public KMeansModel run(RDD<Vector> data, Option<Instrumentation> instr) {
        KMeansModel model;
        block1: {
            StorageLevel storageLevel = data.getStorageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The input data is not directly cached, which may hurt performance if its parent RDDs are also uncached.");
            }
            RDD norms = data.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)Vectors$.MODULE$.norm(x$1, 2.0)), ClassTag$.MODULE$.Double());
            norms.persist();
            RDD zippedData = data.zip(norms, ClassTag$.MODULE$.Double()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector v = (Vector)tuple2._1();
                double norm = tuple2._2$mcD$sp();
                VectorWithNorm vectorWithNorm = new VectorWithNorm(v, norm);
                return vectorWithNorm;
            }, ClassTag$.MODULE$.apply(VectorWithNorm.class));
            model = this.runAlgorithm((RDD<VectorWithNorm>)zippedData, instr);
            norms.unpersist(norms.unpersist$default$1());
            StorageLevel storageLevel3 = data.getStorageLevel();
            StorageLevel storageLevel4 = StorageLevel$.MODULE$.NONE();
            if (storageLevel3 != null ? !storageLevel3.equals(storageLevel4) : storageLevel4 != null) break block1;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The input data was not directly cached, which may hurt performance if its parent RDDs are also uncached.");
        }
        return model;
    }

    private KMeansModel runAlgorithm(RDD<VectorWithNorm> data, Option<Instrumentation> instr) {
        VectorWithNorm[] vectorWithNormArray;
        SparkContext sc = data.sparkContext();
        long initStartTime = System.nanoTime();
        DistanceMeasure distanceMeasureInstance = DistanceMeasure$.MODULE$.decodeFromString(this.distanceMeasure());
        Option<KMeansModel> option = this.initialModel();
        if (option instanceof Some) {
            Some some = (Some)option;
            KMeansModel kMeansCenters = (KMeansModel)some.value();
            vectorWithNormArray = (VectorWithNorm[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kMeansCenters.clusterCenters())).map((Function1 & Serializable & scala.Serializable)x$2 -> new VectorWithNorm((Vector)x$2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(VectorWithNorm.class)));
        } else if (None$.MODULE$.equals(option)) {
            String string = this.initializationMode();
            String string2 = KMeans$.MODULE$.RANDOM();
            vectorWithNormArray = !(string != null ? !string.equals(string2) : string2 != null) ? this.initRandom(data) : this.initKMeansParallel(data, distanceMeasureInstance);
        } else {
            throw new MatchError(option);
        }
        VectorWithNorm[] centers = vectorWithNormArray;
        double initTimeInSeconds = (double)(System.nanoTime() - initStartTime) / 1.0E9;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            String arg$macro$1 = this.initializationMode();
            double arg$macro$2 = initTimeInSeconds;
            return new StringOps("Initialization with %s took %.3f seconds.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToDouble((double)arg$macro$2)}));
        });
        BooleanRef converged = BooleanRef.create((boolean)false);
        DoubleRef cost = DoubleRef.create((double)0.0);
        IntRef iteration = IntRef.create((int)0);
        long iterationStartTime = System.nanoTime();
        instr.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.logNumFeatures(((VectorWithNorm)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])centers)).head()).vector().size());
            return BoxedUnit.UNIT;
        });
        while (iteration.elem < this.maxIterations() && !converged.elem) {
            DoubleAccumulator costAccum = sc.doubleAccumulator();
            Broadcast bcCenters = sc.broadcast((Object)centers, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
            Map collected = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(data.mapPartitions((Function1 & Serializable & scala.Serializable)points -> {
                VectorWithNorm[] thisCenters = (VectorWithNorm[])bcCenters.value();
                int dims = ((VectorWithNorm)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])thisCenters)).head()).vector().size();
                Vector[] sums = (Vector[])Array$.MODULE$.fill(thisCenters.length, (Function0 & Serializable & scala.Serializable)() -> Vectors$.MODULE$.zeros(dims), ClassTag$.MODULE$.apply(Vector.class));
                long[] counts = (long[])Array$.MODULE$.fill(thisCenters.length, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L, ClassTag$.MODULE$.Long());
                points.foreach((Function1 & Serializable & scala.Serializable)point -> {
                    KMeans.$anonfun$runAlgorithm$7(distanceMeasureInstance, thisCenters, costAccum, sums, counts, point);
                    return BoxedUnit.UNIT;
                });
                return ((IndexedSeqLike)((TraversableLike)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(counts)).indices().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> counts[x$5] > 0L)).map((Function1 & Serializable & scala.Serializable)j -> KMeans.$anonfun$runAlgorithm$9(sums, counts, BoxesRunTime.unboxToInt((Object)j)), IndexedSeq$.MODULE$.canBuildFrom())).iterator();
            }, data.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                long count1;
                Vector sum1;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$1, x1$1);
                        if (tuple22 == null) break block2;
                        Tuple2 tuple23 = (Tuple2)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple23 == null) break block2;
                        sum1 = (Vector)tuple23._1();
                        count1 = tuple23._2$mcJ$sp();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Vector sum2 = (Vector)tuple2._1();
                long count2 = tuple2._2$mcJ$sp();
                BLAS$.MODULE$.axpy(1.0, sum2, sum1);
                Tuple2 tuple24 = new Tuple2((Object)sum1, (Object)BoxesRunTime.boxToLong((long)(count1 + count2)));
                return tuple24;
            }), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
            if (iteration.elem == 0) {
                instr.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                    x$6.logNumExamples(BoxesRunTime.unboxToLong((Object)((TraversableOnce)collected.values().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7._2$mcJ$sp()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
                    return BoxedUnit.UNIT;
                });
            }
            Map newCenters = collected.mapValues((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector sum = (Vector)tuple2._1();
                long count = tuple2._2$mcJ$sp();
                VectorWithNorm vectorWithNorm = distanceMeasureInstance.centroid(sum, count);
                return vectorWithNorm;
            });
            bcCenters.destroy(false);
            converged.elem = true;
            newCenters.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                KMeans.$anonfun$runAlgorithm$14(this, converged, distanceMeasureInstance, centers, x0$3);
                return BoxedUnit.UNIT;
            });
            cost.elem = Predef$.MODULE$.Double2double(costAccum.value());
            ++iteration.elem;
        }
        double iterationTimeInSeconds = (double)(System.nanoTime() - iterationStartTime) / 1.0E9;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            double arg$macro$3 = iterationTimeInSeconds;
            return new StringOps("Iterations took %.3f seconds.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$3)}));
        });
        if (iteration.elem == this.maxIterations()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("KMeans reached the max number of iterations: ").append(this.maxIterations()).append(".").toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("KMeans converged in ").append(iteration$1.elem).append(" iterations.").toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("The cost is ").append(cost$1.elem).append(".").toString());
        return new KMeansModel((Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])centers)).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.vector(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class))), this.distanceMeasure(), cost.elem, iteration.elem);
    }

    private VectorWithNorm[] initRandom(RDD<VectorWithNorm> data) {
        return (VectorWithNorm[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.takeSample(false, this.k(), (long)new XORShiftRandom(this.seed()).nextInt()))).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.vector(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class))))).distinct())).map((Function1 & Serializable & scala.Serializable)x$10 -> new VectorWithNorm((Vector)x$10), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(VectorWithNorm.class)));
    }

    public VectorWithNorm[] initKMeansParallel(RDD<VectorWithNorm> data, DistanceMeasure distanceMeasureInstance) {
        VectorWithNorm[] vectorWithNormArray;
        RDD costs = data.map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToDouble((double)KMeans.$anonfun$initKMeansParallel$1(x$11)), ClassTag$.MODULE$.Double());
        int seed = new XORShiftRandom(this.seed()).nextInt();
        VectorWithNorm[] sample = (VectorWithNorm[])data.takeSample(false, 1, (long)seed);
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sample)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("No samples available from ").append(data).toString());
        ArrayBuffer centers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq newCenters = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new VectorWithNorm[]{((VectorWithNorm)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sample)).head()).toDense()}));
        centers.$plus$plus$eq((TraversableOnce)newCenters);
        IntRef step = IntRef.create((int)0);
        ArrayBuffer bcNewCentersList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (step.elem < this.initializationSteps()) {
            Broadcast bcNewCenters = data.context().broadcast((Object)newCenters, ClassTag$.MODULE$.apply(Seq.class));
            bcNewCentersList.$plus$eq((Object)bcNewCenters);
            RDD preCosts = costs;
            costs = data.zip(preCosts, ClassTag$.MODULE$.Double()).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)KMeans.$anonfun$initKMeansParallel$3(distanceMeasureInstance, bcNewCenters, x0$1)), ClassTag$.MODULE$.Double()).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
            double sumCosts = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(costs).sum();
            bcNewCenters.unpersist(false);
            preCosts.unpersist(false);
            RDD qual$1 = data.zip(costs, ClassTag$.MODULE$.Double());
            Function2 & Serializable & scala.Serializable x$1 = (Function2 & Serializable & scala.Serializable)(index, pointCosts) -> KMeans.$anonfun$initKMeansParallel$4(this, seed, step, sumCosts, BoxesRunTime.unboxToInt((Object)index), pointCosts);
            boolean x$2 = qual$1.mapPartitionsWithIndex$default$2();
            VectorWithNorm[] chosen = (VectorWithNorm[])qual$1.mapPartitionsWithIndex((Function2)x$1, x$2, ClassTag$.MODULE$.apply(VectorWithNorm.class)).collect();
            newCenters = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chosen)).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.toDense(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            centers.$plus$plus$eq((TraversableOnce)newCenters);
            ++step.elem;
        }
        costs.unpersist(false);
        bcNewCentersList.foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.destroy(false);
            return BoxedUnit.UNIT;
        });
        ArrayBuffer distinctCenters = (ArrayBuffer)((TraversableLike)((SeqLike)centers.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.vector(), ArrayBuffer$.MODULE$.canBuildFrom())).distinct()).map((Function1 & Serializable & scala.Serializable)x$16 -> new VectorWithNorm((Vector)x$16), ArrayBuffer$.MODULE$.canBuildFrom());
        if (distinctCenters.size() <= this.k()) {
            vectorWithNormArray = (VectorWithNorm[])distinctCenters.toArray(ClassTag$.MODULE$.apply(VectorWithNorm.class));
        } else {
            Broadcast bcCenters = data.context().broadcast((Object)distinctCenters, ClassTag$.MODULE$.apply(ArrayBuffer.class));
            Map countMap = data.map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)KMeans.$anonfun$initKMeansParallel$11(distanceMeasureInstance, bcCenters, x$17)), ClassTag$.MODULE$.Int()).countByValue((Ordering)Ordering.Int$.MODULE$);
            bcCenters.destroy(false);
            double[] myWeights = (double[])((TraversableOnce)distinctCenters.indices().map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$18 -> BoxesRunTime.unboxToLong((Object)countMap.getOrElse((Object)BoxesRunTime.boxToInteger((int)x$18), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
            vectorWithNormArray = LocalKMeans$.MODULE$.kMeansPlusPlus(0, (VectorWithNorm[])distinctCenters.toArray(ClassTag$.MODULE$.apply(VectorWithNorm.class)), myWeights, this.k(), 30);
        }
        return vectorWithNormArray;
    }

    public static final /* synthetic */ void $anonfun$runAlgorithm$7(DistanceMeasure distanceMeasureInstance$1, VectorWithNorm[] thisCenters$1, DoubleAccumulator costAccum$1, Vector[] sums$1, long[] counts$1, VectorWithNorm point) {
        Tuple2<Object, Object> tuple2 = distanceMeasureInstance$1.findClosest((TraversableOnce<VectorWithNorm>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])thisCenters$1)), point);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int bestCenter = tuple2._1$mcI$sp();
        double cost = tuple2._2$mcD$sp();
        Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(bestCenter, cost);
        Tuple2.mcID.sp sp3 = sp2;
        int bestCenter2 = sp3._1$mcI$sp();
        double cost2 = sp3._2$mcD$sp();
        costAccum$1.add(cost2);
        distanceMeasureInstance$1.updateClusterSum(point, sums$1[bestCenter2]);
        counts$1[bestCenter2] = counts$1[bestCenter2] + 1L;
    }

    public static final /* synthetic */ Tuple2 $anonfun$runAlgorithm$9(Vector[] sums$1, long[] counts$1, int j) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)j), (Object)new Tuple2((Object)sums$1[j], (Object)BoxesRunTime.boxToLong((long)counts$1[j])));
    }

    public static final /* synthetic */ void $anonfun$runAlgorithm$14(KMeans $this, BooleanRef converged$1, DistanceMeasure distanceMeasureInstance$1, VectorWithNorm[] centers$1, Tuple2 x0$3) {
        VectorWithNorm newCenter;
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            int j = tuple2._1$mcI$sp();
            newCenter = (VectorWithNorm)tuple2._2();
            if (converged$1.elem && !distanceMeasureInstance$1.isCenterConverged(centers$1[j], newCenter, $this.epsilon())) {
                converged$1.elem = false;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        centers$1[j] = newCenter;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ double $anonfun$initKMeansParallel$1(VectorWithNorm x$11) {
        return Double.POSITIVE_INFINITY;
    }

    public static final /* synthetic */ double $anonfun$initKMeansParallel$3(DistanceMeasure distanceMeasureInstance$2, Broadcast bcNewCenters$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        VectorWithNorm point = (VectorWithNorm)tuple2._1();
        double cost = tuple2._2$mcD$sp();
        double d = package$.MODULE$.min(distanceMeasureInstance$2.pointCost((TraversableOnce<VectorWithNorm>)((TraversableOnce)bcNewCenters$1.value()), point), cost);
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$initKMeansParallel$5(KMeans $this, XORShiftRandom rand$1, double sumCosts$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double c = tuple2._2$mcD$sp();
        boolean bl = rand$1.nextDouble() < 2.0 * c * (double)$this.k() / sumCosts$1;
        return bl;
    }

    public static final /* synthetic */ Iterator $anonfun$initKMeansParallel$4(KMeans $this, int seed$1, IntRef step$1, double sumCosts$1, int index, Iterator pointCosts) {
        XORShiftRandom rand = new XORShiftRandom((long)(seed$1 ^ step$1.elem << 16 ^ index));
        return pointCosts.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)KMeans.$anonfun$initKMeansParallel$5($this, rand, sumCosts$1, x0$2))).map((Function1 & Serializable & scala.Serializable)x$12 -> (VectorWithNorm)x$12._1());
    }

    public static final /* synthetic */ int $anonfun$initKMeansParallel$11(DistanceMeasure distanceMeasureInstance$2, Broadcast bcCenters$2, VectorWithNorm x$17) {
        return distanceMeasureInstance$2.findClosest((TraversableOnce<VectorWithNorm>)((TraversableOnce)bcCenters$2.value()), x$17)._1$mcI$sp();
    }

    private KMeans(int k, int maxIterations, String initializationMode, int initializationSteps, double epsilon, long seed, String distanceMeasure) {
        this.k = k;
        this.maxIterations = maxIterations;
        this.initializationMode = initializationMode;
        this.initializationSteps = initializationSteps;
        this.epsilon = epsilon;
        this.seed = seed;
        this.distanceMeasure = distanceMeasure;
        Logging.$init$((Logging)this);
        this.initialModel = None$.MODULE$;
    }

    private KMeans(int k, int maxIterations, String initializationMode, int initializationSteps, double epsilon, long seed) {
        this(k, maxIterations, initializationMode, initializationSteps, epsilon, seed, DistanceMeasure$.MODULE$.EUCLIDEAN());
    }

    public KMeans() {
        this(2, 20, KMeans$.MODULE$.K_MEANS_PARALLEL(), 2, 1.0E-4, Utils$.MODULE$.random().nextLong(), DistanceMeasure$.MODULE$.EUCLIDEAN());
    }
}

