/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.evaluation.AreaUnderCurve$;
import org.apache.spark.mllib.evaluation.binary.BinaryClassificationMetricComputer;
import org.apache.spark.mllib.evaluation.binary.BinaryConfusionMatrix;
import org.apache.spark.mllib.evaluation.binary.BinaryConfusionMatrixImpl;
import org.apache.spark.mllib.evaluation.binary.BinaryLabelCounter;
import org.apache.spark.mllib.evaluation.binary.BinaryLabelCounter$;
import org.apache.spark.mllib.evaluation.binary.FMeasure;
import org.apache.spark.mllib.evaluation.binary.FalsePositiveRate$;
import org.apache.spark.mllib.evaluation.binary.Precision$;
import org.apache.spark.mllib.evaluation.binary.Recall$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.rdd.UnionRDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\f\u0019\u0001\rB\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!\r\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005e!A\u0011\n\u0001BC\u0002\u0013\u0005!\n\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u0015\t\u0006\u0001\"\u0001[\u0011\u0019\t\u0006\u0001\"\u0001\u001b?\")Q\u000f\u0001C\u0001m\")1\u0010\u0001C\u0001y\"1q\u0010\u0001C\u0001\u0003\u0003Aq!!\u0002\u0001\t\u0003\t9\u0001C\u0004\u0002\f\u0001!\t!!\u0001\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\b!9\u00111\u0003\u0001\u0005\u0002\u0005U\u0001bBA\n\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003?\u0001A\u0011AA\u0001\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003\u0003AA\"a\n\u0001!\u0003E9\u0019)C\u0005\u0003SA!\"a\u0012\u0001\u0011\u000b\u0007I\u0011BA%\u0011)\tY\u0005\u0001EC\u0002\u0013%\u0011Q\n\u0005\b\u0003\u001f\u0002A\u0011BA)\u0011\u001d\ty\u0005\u0001C\u0005\u0003;\u00121DQ5oCJL8\t\\1tg&4\u0017nY1uS>tW*\u001a;sS\u000e\u001c(BA\r\u001b\u0003))g/\u00197vCRLwN\u001c\u0006\u00037q\tQ!\u001c7mS\nT!!\b\u0010\u0002\u000bM\u0004\u0018M]6\u000b\u0005}\u0001\u0013AB1qC\u000eDWMC\u0001\"\u0003\ry'oZ\u0002\u0001'\r\u0001AE\u000b\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-rS\"\u0001\u0017\u000b\u00055b\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005=b#a\u0002'pO\u001eLgnZ\u0001\u000fg\u000e|'/Z!oI2\u000b'-\u001a7t+\u0005\u0011\u0004cA\u001a7q5\tAG\u0003\u000269\u0005\u0019!\u000f\u001a3\n\u0005]\"$a\u0001*E\tB!Q%O\u001e<\u0013\tQdE\u0001\u0004UkBdWM\r\t\u0003KqJ!!\u0010\u0014\u0003\r\u0011{WO\u00197fQ\r\tq(\u0012\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005r\t!\"\u00198o_R\fG/[8o\u0013\t!\u0015IA\u0003TS:\u001cW-I\u0001G\u0003\u0015\tdf\r\u00181\u0003=\u00198m\u001c:f\u0003:$G*\u00192fYN\u0004\u0003f\u0001\u0002@\u000b\u00069a.^7CS:\u001cX#A&\u0011\u0005\u0015b\u0015BA''\u0005\rIe\u000e\u001e\u0015\u0004\u0007}*\u0015\u0001\u00038v[\nKgn\u001d\u0011)\u0007\u0011yT)\u0001\u0004=S:LGO\u0010\u000b\u0004'V;\u0006C\u0001+\u0001\u001b\u0005A\u0002\"\u0002\u0019\u0006\u0001\u0004\u0011\u0004fA+@\u000b\")\u0011*\u0002a\u0001\u0017\"\u001aqkP#)\u0007\u0015yT\t\u0006\u0002T7\")\u0001G\u0002a\u0001e!\u001aaaP/\"\u0003y\u000bQ!\r\u00181]A\"\"a\u00151\t\u000bA:\u0001\u0019A1\u0011\u0005\t\u0014hBA2p\u001d\t!WN\u0004\u0002fY:\u0011am\u001b\b\u0003O*l\u0011\u0001\u001b\u0006\u0003S\n\na\u0001\u0010:p_Rt\u0014\"A\u0011\n\u0005}\u0001\u0013BA\u000f\u001f\u0013\tqG$A\u0002tc2L!\u0001]9\u0002\u000fA\f7m[1hK*\u0011a\u000eH\u0005\u0003gR\u0014\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005A\f\u0018!C;oa\u0016\u00148/[:u)\u00059\bCA\u0013y\u0013\tIhE\u0001\u0003V]&$\bf\u0001\u0005@;\u0006QA\u000f\u001b:fg\"|G\u000eZ:\u0015\u0003u\u00042a\r\u001c<Q\rIq(X\u0001\u0004e>\u001cG#\u0001\u001a)\u0007)yT,\u0001\u0007be\u0016\fWK\u001c3feJ{5\tF\u0001<Q\rYq(X\u0001\u0003aJD3\u0001D ^\u0003-\t'/Z1V]\u0012,'\u000f\u0015*)\u00075yT,A\ng\u001b\u0016\f7/\u001e:f\u0005f$\u0006N]3tQ>dG\rF\u00023\u0003/Aa!!\u0007\u000f\u0001\u0004Y\u0014\u0001\u00022fi\u0006D3AD ^Q\ryq(X\u0001\u0015aJ,7-[:j_:\u0014\u0015\u0010\u00165sKNDw\u000e\u001c3)\u0007AyT,A\tsK\u000e\fG\u000e\u001c\"z)\"\u0014Xm\u001d5pY\u0012D3!E ^\u0003\rAH\u0005N\u000b\u0003\u0003W\u0001b!J\u001d\u0002.\u0005u\u0002\u0003B\u001a7\u0003_\u0001R!J\u001d<\u0003c\u0001B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003oA\u0012A\u00022j]\u0006\u0014\u00180\u0003\u0003\u0002<\u0005U\"A\u0005\"j]\u0006\u0014\u0018\u0010T1cK2\u001cu.\u001e8uKJ\u0004Ba\r\u001c\u0002@A)Q%O\u001e\u0002BA!\u00111GA\"\u0013\u0011\t)%!\u000e\u0003+\tKg.\u0019:z\u0007>tg-^:j_:l\u0015\r\u001e:jq\u0006\u00012-^7vY\u0006$\u0018N^3D_VtGo]\u000b\u0003\u0003[\t!bY8oMV\u001c\u0018n\u001c8t+\t\ti$A\u0006de\u0016\fG/Z\"veZ,Gc\u0001\u001a\u0002T!9\u0011QK\u000bA\u0002\u0005]\u0013!A=\u0011\t\u0005M\u0012\u0011L\u0005\u0005\u00037\n)D\u0001\u0012CS:\f'/_\"mCN\u001c\u0018NZ5dCRLwN\\'fiJL7mQ8naV$XM\u001d\u000b\u0006e\u0005}\u00131\r\u0005\b\u0003C2\u0002\u0019AA,\u0003\u0005A\bbBA+-\u0001\u0007\u0011q\u000b\u0015\u0004\u0001}j\u0006")
public class BinaryClassificationMetrics
implements Logging {
    private Tuple2<RDD<Tuple2<Object, BinaryLabelCounter>>, RDD<Tuple2<Object, BinaryConfusionMatrix>>> x$4;
    private RDD<Tuple2<Object, BinaryLabelCounter>> cumulativeCounts;
    private RDD<Tuple2<Object, BinaryConfusionMatrix>> confusions;
    private final RDD<Tuple2<Object, Object>> scoreAndLabels;
    private final int numBins;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RDD<Tuple2<Object, Object>> scoreAndLabels() {
        return this.scoreAndLabels;
    }

    public int numBins() {
        return this.numBins;
    }

    public void unpersist() {
        this.cumulativeCounts().unpersist(this.cumulativeCounts().unpersist$default$1());
    }

    public RDD<Object> thresholds() {
        return this.cumulativeCounts().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1._1$mcD$sp()), ClassTag$.MODULE$.Double());
    }

    public RDD<Tuple2<Object, Object>> roc() {
        RDD<Tuple2<Object, Object>> rocCurve = this.createCurve(FalsePositiveRate$.MODULE$, Recall$.MODULE$);
        SparkContext sc = this.confusions().context();
        RDD first = sc.makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 0.0)})), 1, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD last = sc.makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(1.0, 1.0)})), 1, ClassTag$.MODULE$.apply(Tuple2.class));
        return new UnionRDD(sc, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RDD[]{first, rocCurve, last})), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public double areaUnderROC() {
        return AreaUnderCurve$.MODULE$.of(this.roc());
    }

    public RDD<Tuple2<Object, Object>> pr() {
        double firstPrecision;
        RDD<Tuple2<Object, Object>> prCurve = this.createCurve(Recall$.MODULE$, Precision$.MODULE$);
        Tuple2 tuple2 = (Tuple2)prCurve.first();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double d = firstPrecision = tuple2._2$mcD$sp();
        double firstPrecision2 = d;
        return this.confusions().context().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, firstPrecision2)})), 1, ClassTag$.MODULE$.apply(Tuple2.class)).union(prCurve);
    }

    public double areaUnderPR() {
        return AreaUnderCurve$.MODULE$.of(this.pr());
    }

    public RDD<Tuple2<Object, Object>> fMeasureByThreshold(double beta) {
        return this.createCurve(new FMeasure(beta));
    }

    public RDD<Tuple2<Object, Object>> fMeasureByThreshold() {
        return this.fMeasureByThreshold(1.0);
    }

    public RDD<Tuple2<Object, Object>> precisionByThreshold() {
        return this.createCurve(Precision$.MODULE$);
    }

    public RDD<Tuple2<Object, Object>> recallByThreshold() {
        return this.createCurve(Recall$.MODULE$);
    }

    private Tuple2<RDD<Tuple2<Object, BinaryLabelCounter>>, RDD<Tuple2<Object, BinaryConfusionMatrix>>> x$4$lzycompute() {
        block11: {
            BinaryClassificationMetrics binaryClassificationMetrics = this;
            synchronized (binaryClassificationMetrics) {
                RDD rDD;
                RDD confusions;
                block13: {
                    Tuple2 tuple2;
                    block12: {
                        RDD rDD2;
                        if ((byte)(this.bitmap$0 & 1) != 0) break block11;
                        OrderedRDDFunctions qual$1 = RDD$.MODULE$.rddToOrderedRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(this.scoreAndLabels(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Double$.MODULE$).combineByKey((Function1 & Serializable & scala.Serializable)label -> BinaryClassificationMetrics.$anonfun$x$4$1(BoxesRunTime.unboxToDouble((Object)label)), (Function2 & Serializable & scala.Serializable)(c, label) -> c.$plus$eq(BoxesRunTime.unboxToDouble((Object)label)), (Function2 & Serializable & scala.Serializable)(c1, c2) -> c1.$plus$eq((BinaryLabelCounter)c2)), (Ordering)Ordering.Double$.MODULE$, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(BinaryLabelCounter.class));
                        boolean x$1 = false;
                        int x$22 = qual$1.sortByKey$default$2();
                        RDD counts = qual$1.sortByKey(x$1, x$22);
                        if (this.numBins() == 0) {
                            rDD2 = counts;
                        } else {
                            long countsSize = counts.count();
                            LongRef grouping = LongRef.create((long)(countsSize / (long)this.numBins()));
                            if (grouping.elem < 2L) {
                                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Curve is too small (").append(countsSize).append(") for ").append(this.numBins()).append(" bins to be useful").toString());
                                rDD2 = counts;
                            } else {
                                if (grouping.elem >= Integer.MAX_VALUE) {
                                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Curve too large (").append(countsSize).append(") for ").append(this.numBins()).append(" bins; capping at ").append(Integer.MAX_VALUE).toString());
                                    grouping.elem = Integer.MAX_VALUE;
                                }
                                rDD2 = counts.mapPartitions((Function1 & Serializable & scala.Serializable)x$2 -> x$2.grouped((int)grouping$1.elem).map((Function1 & Serializable & scala.Serializable)pairs -> {
                                    double firstScore = ((Tuple2)pairs.head())._1$mcD$sp();
                                    BinaryLabelCounter agg = new BinaryLabelCounter(BinaryLabelCounter$.MODULE$.$lessinit$greater$default$1(), BinaryLabelCounter$.MODULE$.$lessinit$greater$default$2());
                                    pairs.foreach((Function1 & Serializable & scala.Serializable)pair -> agg.$plus$eq((BinaryLabelCounter)pair._2()));
                                    return new Tuple2((Object)BoxesRunTime.boxToDouble((double)firstScore), (Object)agg);
                                }), counts.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
                            }
                        }
                        RDD binnedCounts = rDD2;
                        RDD qual$2 = RDD$.MODULE$.rddToPairRDDFunctions(binnedCounts, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(BinaryLabelCounter.class), (Ordering)Ordering.Double$.MODULE$).values();
                        Function1 & Serializable & scala.Serializable x$3 = (Function1 & Serializable & scala.Serializable)iter -> {
                            BinaryLabelCounter agg = new BinaryLabelCounter(BinaryLabelCounter$.MODULE$.$lessinit$greater$default$1(), BinaryLabelCounter$.MODULE$.$lessinit$greater$default$2());
                            iter.foreach((Function1 & Serializable & scala.Serializable)x$3 -> agg.$plus$eq((BinaryLabelCounter)x$3));
                            return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BinaryLabelCounter[]{agg}));
                        };
                        boolean x$4 = qual$2.mapPartitions$default$2();
                        BinaryLabelCounter[] agg2 = (BinaryLabelCounter[])qual$2.mapPartitions((Function1)x$3, x$4, ClassTag$.MODULE$.apply(BinaryLabelCounter.class)).collect();
                        BinaryLabelCounter[] partitionwiseCumulativeCounts = (BinaryLabelCounter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])agg2)).scanLeft((Object)new BinaryLabelCounter(BinaryLabelCounter$.MODULE$.$lessinit$greater$default$1(), BinaryLabelCounter$.MODULE$.$lessinit$greater$default$2()), (Function2 & Serializable & scala.Serializable)(agg, c) -> agg.clone().$plus$eq((BinaryLabelCounter)c), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BinaryLabelCounter.class)));
                        BinaryLabelCounter totalCount = (BinaryLabelCounter)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionwiseCumulativeCounts)).last();
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Total counts: ").append(totalCount).toString());
                        RDD cumulativeCounts = binnedCounts.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(index, iter) -> BinaryClassificationMetrics.$anonfun$x$4$13(partitionwiseCumulativeCounts, BoxesRunTime.unboxToInt((Object)index), iter), true, ClassTag$.MODULE$.apply(Tuple2.class));
                        cumulativeCounts.persist();
                        RDD confusions2 = cumulativeCounts.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            Tuple2 tuple2 = x0$2;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            double score = tuple2._1$mcD$sp();
                            BinaryLabelCounter cumCount = (BinaryLabelCounter)tuple2._2();
                            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)score), (Object)new BinaryConfusionMatrixImpl(cumCount, totalCount));
                            return tuple22;
                        }, ClassTag$.MODULE$.apply(Tuple2.class));
                        tuple2 = new Tuple2((Object)cumulativeCounts, (Object)confusions2);
                        if (tuple2 == null) break block12;
                        RDD cumulativeCounts2 = (RDD)tuple2._1();
                        confusions = (RDD)tuple2._2();
                        if (cumulativeCounts2 == null) break block12;
                        rDD = cumulativeCounts2;
                        if (confusions != null) break block13;
                    }
                    throw new MatchError((Object)tuple2);
                }
                RDD rDD3 = confusions;
                Tuple2 tuple2 = new Tuple2((Object)rDD, (Object)rDD3);
                this.x$4 = tuple2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$4;
    }

    private /* synthetic */ Tuple2 x$4() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$4$lzycompute() : this.x$4;
    }

    private RDD<Tuple2<Object, BinaryLabelCounter>> cumulativeCounts$lzycompute() {
        BinaryClassificationMetrics binaryClassificationMetrics = this;
        synchronized (binaryClassificationMetrics) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.cumulativeCounts = (RDD)this.x$4()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.cumulativeCounts;
    }

    private RDD<Tuple2<Object, BinaryLabelCounter>> cumulativeCounts() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.cumulativeCounts$lzycompute() : this.cumulativeCounts;
    }

    private RDD<Tuple2<Object, BinaryConfusionMatrix>> confusions$lzycompute() {
        BinaryClassificationMetrics binaryClassificationMetrics = this;
        synchronized (binaryClassificationMetrics) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.confusions = (RDD)this.x$4()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.confusions;
    }

    private RDD<Tuple2<Object, BinaryConfusionMatrix>> confusions() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.confusions$lzycompute() : this.confusions;
    }

    private RDD<Tuple2<Object, Object>> createCurve(BinaryClassificationMetricComputer y) {
        return this.confusions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double s = tuple2._1$mcD$sp();
            BinaryConfusionMatrix c = (BinaryConfusionMatrix)tuple2._2();
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(s, y.apply(c));
            return sp2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private RDD<Tuple2<Object, Object>> createCurve(BinaryClassificationMetricComputer x, BinaryClassificationMetricComputer y) {
        return this.confusions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BinaryConfusionMatrix c = (BinaryConfusionMatrix)tuple2._2();
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x.apply(c), y.apply(c));
            return sp2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public static final /* synthetic */ BinaryLabelCounter $anonfun$x$4$1(double label) {
        return new BinaryLabelCounter(0L, 0L).$plus$eq(label);
    }

    public static final /* synthetic */ Iterator $anonfun$x$4$13(BinaryLabelCounter[] partitionwiseCumulativeCounts$1, int index, Iterator iter) {
        BinaryLabelCounter cumCount = partitionwiseCumulativeCounts$1[index];
        return iter.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double score = tuple2._1$mcD$sp();
            BinaryLabelCounter c = (BinaryLabelCounter)tuple2._2();
            cumCount.$plus$eq(c);
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)score), (Object)cumCount.clone());
            return tuple22;
        });
    }

    public BinaryClassificationMetrics(RDD<Tuple2<Object, Object>> scoreAndLabels, int numBins) {
        this.scoreAndLabels = scoreAndLabels;
        this.numBins = numBins;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(numBins >= 0, (Function0 & Serializable & scala.Serializable)() -> "numBins must be nonnegative");
    }

    public BinaryClassificationMetrics(RDD<Tuple2<Object, Object>> scoreAndLabels) {
        this(scoreAndLabels, 0);
    }

    public BinaryClassificationMetrics(Dataset<Row> scoreAndLabels) {
        this((RDD<Tuple2<Object, Object>>)scoreAndLabels.rdd().map((Function1)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Row r) {
                return new Tuple2.mcDD.sp(r.getDouble(0), r.getDouble(1));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
    }
}

