/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.LU;
import breeze.linalg.MatrixSingularException;
import breeze.linalg.NumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.Vector$;
import breeze.linalg.inv$;
import breeze.linalg.qr;
import breeze.linalg.svd;
import breeze.linalg.svd$;
import breeze.numerics.package;
import breeze.storage.Zero;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.EigenValueDecomposition$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.QRDecomposition;
import org.apache.spark.mllib.linalg.SingularValueDecomposition;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.DistributedMatrix;
import org.apache.spark.mllib.linalg.distributed.MatrixEntry;
import org.apache.spark.mllib.linalg.distributed.RowMatrix$;
import org.apache.spark.mllib.linalg.distributed.RowMatrix$SVDMode$1$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t]c\u0001B\u0013'\u0001MB\u0001\u0002\u0012\u0001\u0003\u0006\u0004%\t!\u0012\u0005\t3\u0002\u0011\t\u0011)A\u0005\r\"A1\f\u0001BA\u0002\u0013%A\f\u0003\u0005a\u0001\t\u0005\r\u0011\"\u0003b\u0011!9\u0007A!A!B\u0013i\u0006\u0002\u00035\u0001\u0005\u0003\u0007I\u0011B5\t\u00115\u0004!\u00111A\u0005\n9D\u0001\u0002\u001d\u0001\u0003\u0002\u0003\u0006KA\u001b\u0005\u0006c\u0002!\tA\u001d\u0005\u0006c\u0002!\t!\u001f\u0005\u0006y\u0002!\t% \u0005\u0006\u007f\u0002!\t% \u0005\t\u0003\u0007\u0001A\u0011\u0001\u0016\u0002\u0006!9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0002bBA\u0016\u0001\u0011%\u0011Q\u0006\u0005\b\u0003g\u0001A\u0011AA\u001b\u0011%\t\t\u0006AI\u0001\n\u0003\t\u0019\u0006C\u0005\u0002h\u0001\t\n\u0011\"\u0001\u0002j!A\u00111\u0007\u0001\u0005\u0002)\ni\u0007C\u0004\u0002\u0018\u0002!\t!!\t\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"9\u0011Q\u0016\u0001\u0005\u0002\u0005=\u0006bBA[\u0001\u0011\u0005\u0011q\u0017\u0005\b\u0003\u000f\u0004A\u0011AAe\u0011\u001d\t\t\u000e\u0001C\u0001\u0003'Dq!!5\u0001\t\u0003\t\t\u000fC\u0004\u0002j\u0002!\t!a;\t\u0013\u0005u\b!%A\u0005\u0002\u0005M\u0003\u0002CA\u0000\u0001\u0011\u0005!F!\u0001\t\u0011\tE\u0001\u0001\"\u0011+\u0005'AqAa\u0007\u0001\t\u0013\u0011ibB\u0004\u0003&\u0019B\tAa\n\u0007\r\u00152\u0003\u0012\u0001B\u0015\u0011\u0019\t\u0018\u0005\"\u0001\u00032!9!1G\u0011\u0005\n\tU\u0002\"\u0003B C\u0005\u0005I\u0011\u0002B!\u0005%\u0011vn^'biJL\u0007P\u0003\u0002(Q\u0005YA-[:ue&\u0014W\u000f^3e\u0015\tI#&\u0001\u0004mS:\fGn\u001a\u0006\u0003W1\nQ!\u001c7mS\nT!!\f\u0018\u0002\u000bM\u0004\u0018M]6\u000b\u0005=\u0002\u0014AB1qC\u000eDWMC\u00012\u0003\ry'oZ\u0002\u0001'\u0011\u0001AG\u000f \u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\r\u0005s\u0017PU3g!\tYD(D\u0001'\u0013\tidEA\tESN$(/\u001b2vi\u0016$W*\u0019;sSb\u0004\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u0017\u0002\u0011%tG/\u001a:oC2L!a\u0011!\u0003\u000f1{wmZ5oO\u0006!!o\\<t+\u00051\u0005cA$K\u00196\t\u0001J\u0003\u0002JY\u0005\u0019!\u000f\u001a3\n\u0005-C%a\u0001*E\tB\u0011QJT\u0007\u0002Q%\u0011q\n\u000b\u0002\u0007-\u0016\u001cGo\u001c:)\u0007\u0005\tv\u000b\u0005\u0002S+6\t1K\u0003\u0002UY\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Y\u001b&!B*j]\u000e,\u0017%\u0001-\u0002\u000bEr\u0003G\f\u0019\u0002\u000bI|wo\u001d\u0011)\u0007\t\tv+A\u0003o%><8/F\u0001^!\t)d,\u0003\u0002`m\t!Aj\u001c8h\u0003%q'k\\<t?\u0012*\u0017\u000f\u0006\u0002cKB\u0011QgY\u0005\u0003IZ\u0012A!\u00168ji\"9a\rBA\u0001\u0002\u0004i\u0016a\u0001=%c\u00051aNU8xg\u0002\nQA\\\"pYN,\u0012A\u001b\t\u0003k-L!\u0001\u001c\u001c\u0003\u0007%sG/A\u0005o\u0007>d7o\u0018\u0013fcR\u0011!m\u001c\u0005\bM\u001e\t\t\u00111\u0001k\u0003\u0019q7i\u001c7tA\u00051A(\u001b8jiz\"Ba\u001d;woB\u00111\b\u0001\u0005\u0006\t&\u0001\rA\u0012\u0015\u0004iF;\u0006\"B.\n\u0001\u0004i\u0006\"\u00025\n\u0001\u0004Q\u0007fA\u0005R/R\u00111O\u001f\u0005\u0006\t*\u0001\rA\u0012\u0015\u0004\u0015E;\u0016a\u00028v[\u000e{Gn\u001d\u000b\u0002;\"\u001a1\"U,\u0002\u000f9,XNU8xg\"\u001aA\"U,\u0002/5,H\u000e^5qYf<%/Y7jC:l\u0015\r\u001e:jq\nKH\u0003BA\u0004\u00037\u0001b!!\u0003\u0002\u0012\u0005UQBAA\u0006\u0015\rI\u0013Q\u0002\u0006\u0003\u0003\u001f\taA\u0019:fKj,\u0017\u0002BA\n\u0003\u0017\u00111\u0002R3og\u00164Vm\u0019;peB\u0019Q'a\u0006\n\u0007\u0005eaG\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0003;i\u0001\u0019AA\u0004\u0003\u00051\u0018\u0001F2p[B,H/Z$sC6L\u0017M\\'biJL\u0007\u0010\u0006\u0002\u0002$A\u0019Q*!\n\n\u0007\u0005\u001d\u0002F\u0001\u0004NCR\u0014\u0018\u000e\u001f\u0015\u0004\u001dE;\u0016aD2iK\u000e\\g*^7D_2,XN\\:\u0015\u0007\t\fy\u0003\u0003\u0004\u00022=\u0001\rA[\u0001\u0005G>d7/\u0001\u0006d_6\u0004X\u000f^3T-\u0012#\u0002\"a\u000e\u0002>\u0005\u0005\u00131\n\t\u0007\u001b\u0006e2/a\t\n\u0007\u0005m\u0002F\u0001\u000eTS:<W\u000f\\1s-\u0006dW/\u001a#fG>l\u0007o\\:ji&|g\u000e\u0003\u0004\u0002@A\u0001\rA[\u0001\u0002W\"I\u00111\t\t\u0011\u0002\u0003\u0007\u0011QI\u0001\tG>l\u0007/\u001e;f+B\u0019Q'a\u0012\n\u0007\u0005%cGA\u0004C_>dW-\u00198\t\u0013\u00055\u0003\u0003%AA\u0002\u0005U\u0011!\u0002:D_:$\u0007f\u0001\tR/\u0006!2m\\7qkR,7K\u0016#%I\u00164\u0017-\u001e7uII*\"!!\u0016+\t\u0005\u0015\u0013qK\u0016\u0003\u00033\u0002B!a\u0017\u0002d5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'A\u0005v]\u000eDWmY6fI*\u0011AKN\u0005\u0005\u0003K\niFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAcY8naV$Xm\u0015,EI\u0011,g-Y;mi\u0012\u001aTCAA6U\u0011\t)\"a\u0016\u0015\u001d\u0005]\u0012qNA9\u0003g\n)(!\u001f\u0002~!1\u0011qH\nA\u0002)Dq!a\u0011\u0014\u0001\u0004\t)\u0005C\u0004\u0002NM\u0001\r!!\u0006\t\r\u0005]4\u00031\u0001k\u0003\u001di\u0017\r_%uKJDq!a\u001f\u0014\u0001\u0004\t)\"A\u0002u_2Dq!a \u0014\u0001\u0004\t\t)\u0001\u0003n_\u0012,\u0007\u0003BAB\u0003#sA!!\"\u0002\u000eB\u0019\u0011q\u0011\u001c\u000e\u0005\u0005%%bAAFe\u00051AH]8pizJ1!a$7\u0003\u0019\u0001&/\u001a3fM&!\u00111SAK\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0012\u001c\u0002#\r|W\u000e];uK\u000e{g/\u0019:jC:\u001cW\rK\u0002\u0015#^\u000bafY8naV$X\r\u0015:j]\u000eL\u0007/\u00197D_6\u0004xN\\3oiN\fe\u000eZ#ya2\f\u0017N\\3e-\u0006\u0014\u0018.\u00198dKR!\u0011qTAS!\u0019)\u0014\u0011UA\u0012\u0019&\u0019\u00111\u0015\u001c\u0003\rQ+\b\u000f\\33\u0011\u0019\ty$\u0006a\u0001U\"\"Q#UAUC\t\tY+A\u00032]Yr\u0003'\u0001\u000ed_6\u0004X\u000f^3Qe&t7-\u001b9bY\u000e{W\u000e]8oK:$8\u000f\u0006\u0003\u0002$\u0005E\u0006BBA -\u0001\u0007!\u000eK\u0002\u0017#^\u000badY8naV$XmQ8mk6t7+^7nCJL8\u000b^1uSN$\u0018nY:\u0015\u0005\u0005e\u0006\u0003BA^\u0003\u0003l!!!0\u000b\u0007\u0005}&&\u0001\u0003ti\u0006$\u0018\u0002BAb\u0003{\u0013a$T;mi&4\u0018M]5bi\u0016\u001cF/\u0019;jgRL7-\u00197Tk6l\u0017M]=)\u0007]\tv+\u0001\u0005nk2$\u0018\u000e\u001d7z)\r\u0019\u00181\u001a\u0005\b\u0003\u001bD\u0002\u0019AA\u0012\u0003\u0005\u0011\u0005f\u0001\rR/\u0006\u00112m\u001c7v[:\u001c\u0016.\\5mCJLG/[3t)\t\t)\u000eE\u0002<\u0003/L1!!7'\u0005A\u0019un\u001c:eS:\fG/Z'biJL\u0007\u0010\u000b\u0003\u001a#\u0006u\u0017EAAp\u0003\u0015\tdF\r\u00181)\u0011\t).a9\t\u000f\u0005\u0015(\u00041\u0001\u0002\u0016\u0005IA\u000f\u001b:fg\"|G\u000e\u001a\u0015\u00055E\u000bi.\u0001\u0007uC2d7k[5o]f\f&\u000b\u0006\u0003\u0002n\u0006M\bCB'\u0002pN\f\u0019#C\u0002\u0002r\"\u0012q\"\u0015*EK\u000e|W\u000e]8tSRLwN\u001c\u0005\n\u0003k\\\u0002\u0013!a\u0001\u0003\u000b\n\u0001bY8naV$X-\u0015\u0015\u00057E\u000bI0\t\u0002\u0002|\u0006)\u0011GL\u001b/a\u00051B/\u00197m'.LgN\\=R%\u0012\"WMZ1vYR$\u0013'\u0001\rd_2,XN\\*j[&d\u0017M]5uS\u0016\u001cH)S'T+6#b!!6\u0003\u0004\t5\u0001b\u0002B\u0003;\u0001\u0007!qA\u0001\bG>dW*Y4t!\u0015)$\u0011BA\u000b\u0013\r\u0011YA\u000e\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0005\u001fi\u0002\u0019AA\u000b\u0003\u00159\u0017-\\7b\u0003!!xN\u0011:fKj,GC\u0001B\u000b!\u0019\tIAa\u0006\u0002\u0016%!!\u0011DA\u0006\u0005-!UM\\:f\u001b\u0006$(/\u001b=\u0002\u001bU\u0004H-\u0019;f\u001dVl'k\\<t)\r\u0011'q\u0004\u0005\u0007\u0005Cy\u0002\u0019A/\u0002\u00035D3\u0001A)X\u0003%\u0011vn^'biJL\u0007\u0010\u0005\u0002<CM!\u0011\u0005\u000eB\u0016!\r)$QF\u0005\u0004\u0005_1$\u0001D*fe&\fG.\u001b>bE2,GC\u0001B\u0014\u0003)!(/[;U_\u001a+H\u000e\u001c\u000b\u0007\u0003G\u00119Da\u000f\t\r\te2\u00051\u0001k\u0003\u0005q\u0007b\u0002B\u001fG\u0001\u0007!qA\u0001\u0002+\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\u0019\u0005\u0005\u0003\u0003F\t=SB\u0001B$\u0015\u0011\u0011IEa\u0013\u0002\t1\fgn\u001a\u0006\u0003\u0005\u001b\nAA[1wC&!!\u0011\u000bB$\u0005\u0019y%M[3di\"\u001a\u0011%U,)\u0007\u0001\nv\u000b")
public class RowMatrix
implements DistributedMatrix,
Logging {
    private final RDD<Vector> rows;
    private long nRows;
    private int nCols;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RDD<Vector> rows() {
        return this.rows;
    }

    private long nRows() {
        return this.nRows;
    }

    private void nRows_$eq(long x$1) {
        this.nRows = x$1;
    }

    private int nCols() {
        return this.nCols;
    }

    private void nCols_$eq(int x$1) {
        this.nCols = x$1;
    }

    @Override
    public long numCols() {
        if (this.nCols() <= 0) {
            try {
                this.nCols_$eq(((Vector)this.rows().first()).size());
            }
            catch (UnsupportedOperationException err) {
                throw scala.sys.package$.MODULE$.error("Cannot determine the number of cols because it is not specified in the constructor and the rows RDD is empty.");
            }
        }
        return this.nCols();
    }

    @Override
    public long numRows() {
        if (this.nRows() <= 0L) {
            this.nRows_$eq(this.rows().count());
            if (this.nRows() == 0L) {
                throw scala.sys.package$.MODULE$.error("Cannot determine the number of rows because it is not specified in the constructor and the rows RDD is empty.");
            }
        }
        return this.nRows();
    }

    public breeze.linalg.DenseVector<Object> multiplyGramianMatrixBy(breeze.linalg.DenseVector<Object> v) {
        int n = (int)this.numCols();
        Broadcast vbr = this.rows().context().broadcast(v, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
        breeze.linalg.DenseVector x$1 = breeze.linalg.DenseVector$.MODULE$.zeros$mDc$sp(n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        Function2 & Serializable & scala.Serializable x$2 = (Function2 & Serializable & scala.Serializable)(U, r) -> {
            breeze.linalg.Vector<Object> rBrz = r.asBreeze();
            double a = BoxesRunTime.unboxToDouble((Object)rBrz.dot(vbr.value(), Vector$.MODULE$.castOps(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double())));
            breeze.linalg.Vector<Object> vector = rBrz;
            if (vector instanceof breeze.linalg.DenseVector) {
                breeze.linalg.package$.MODULE$.axpy((Object)BoxesRunTime.boxToDouble((double)a), (Object)((breeze.linalg.DenseVector)rBrz), U, (UFunc.InPlaceImpl3)DenseVector.canDaxpy$.MODULE$);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (vector instanceof breeze.linalg.SparseVector) {
                breeze.linalg.package$.MODULE$.axpy((Object)BoxesRunTime.boxToDouble((double)a), (Object)((breeze.linalg.SparseVector)rBrz), U, breeze.linalg.SparseVector$.MODULE$.implScaleAdd_DVT_T_SVT_InPlace_Double());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new UnsupportedOperationException(new StringBuilder(43).append("Do not support vector operation from type ").append(rBrz.getClass().getName()).append(".").toString());
            }
            return U;
        };
        Function2 & Serializable & scala.Serializable x$3 = (Function2 & Serializable & scala.Serializable)(U1, U2) -> (breeze.linalg.DenseVector)U1.$plus$eq(U2, breeze.linalg.DenseVector$.MODULE$.canAddIntoD());
        int x$4 = this.rows().treeAggregate$default$4((Object)x$1);
        return (breeze.linalg.DenseVector)this.rows().treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
    }

    public Matrix computeGramianMatrix() {
        int n = (int)this.numCols();
        this.checkNumColumns(n);
        int nt = n % 2 == 0 ? n / 2 * (n + 1) : n * ((n + 1) / 2);
        Object x$1 = null;
        Function2 & Serializable & scala.Serializable x$2 = (Function2 & Serializable & scala.Serializable)(maybeU, v) -> {
            void var3_3;
            breeze.linalg.DenseVector U = maybeU == null ? new DenseVector.mcD.sp(nt, ClassTag$.MODULE$.Double()) : maybeU;
            BLAS$.MODULE$.spr(1.0, (Vector)v, U.data$mcD$sp());
            return var3_3;
        };
        Function2 & Serializable & scala.Serializable x$3 = (Function2 & Serializable & scala.Serializable)(U1, U2) -> U1 == null ? U2 : (U2 == null ? U1 : (breeze.linalg.DenseVector)U1.$plus$eq(U2, breeze.linalg.DenseVector$.MODULE$.canAddIntoD()));
        int x$4 = this.rows().treeAggregate$default$4(x$1);
        breeze.linalg.DenseVector GU = (breeze.linalg.DenseVector)this.rows().treeAggregate(x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
        return RowMatrix$.MODULE$.org$apache$spark$mllib$linalg$distributed$RowMatrix$$triuToFull(n, GU.data$mcD$sp());
    }

    private void checkNumColumns(int cols) {
        block1: {
            if (cols > 65535) {
                throw new IllegalArgumentException(new StringBuilder(36).append("Argument with more than 65535 cols: ").append(cols).toString());
            }
            if (cols <= 10000) break block1;
            long memMB = (long)cols * (long)cols / 125000L;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append(cols).append(" columns will require at least ").append(memMB).append(" megabytes of memory!").toString());
        }
    }

    public SingularValueDecomposition<RowMatrix, Matrix> computeSVD(int k, boolean computeU, double rCond) {
        int maxIter = package$.MODULE$.max(300, k * 3);
        double tol = 1.0E-10;
        return this.computeSVD(k, computeU, rCond, maxIter, tol, "auto");
    }

    public SingularValueDecomposition<RowMatrix, Matrix> computeSVD(int k, boolean computeU, double rCond, int maxIter, double tol, String mode) {
        SingularValueDecomposition<RowMatrix, Matrix> singularValueDecomposition;
        breeze.linalg.DenseVector denseVector;
        breeze.linalg.DenseMatrix u;
        Enumeration.Value computeMode;
        int n;
        LazyRef SVDMode$module;
        block33: {
            Tuple2 tuple2;
            block32: {
                Tuple2 tuple22;
                block28: {
                    Enumeration.Value value;
                    block29: {
                        breeze.linalg.DenseMatrix denseMatrix;
                        breeze.linalg.DenseVector sigmaSquaresFull;
                        block31: {
                            svd.SVD sVD;
                            block30: {
                                block27: {
                                    Enumeration.Value value2;
                                    SVDMode$module = new LazyRef();
                                    n = (int)this.numCols();
                                    Predef$.MODULE$.require(k > 0 && k <= n, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Requested k singular values but got k=").append(k).append(" and numCols=").append(n).append(".").toString());
                                    String string = mode;
                                    if ("auto".equals(string)) {
                                        if (k > 5000) {
                                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("computing svd with k=").append(k).append(" and n=").append(n).append(", please check necessity").toString());
                                        }
                                        value2 = n < 100 || k > n / 2 && n <= 15000 ? (k < n / 3 ? this.SVDMode$2(SVDMode$module).LocalARPACK() : this.SVDMode$2(SVDMode$module).LocalLAPACK()) : this.SVDMode$2(SVDMode$module).DistARPACK();
                                    } else if ("local-svd".equals(string)) {
                                        value2 = this.SVDMode$2(SVDMode$module).LocalLAPACK();
                                    } else if ("local-eigs".equals(string)) {
                                        value2 = this.SVDMode$2(SVDMode$module).LocalARPACK();
                                    } else if ("dist-eigs".equals(string)) {
                                        value2 = this.SVDMode$2(SVDMode$module).DistARPACK();
                                    } else {
                                        throw new IllegalArgumentException(new StringBuilder(21).append("Do not support mode ").append(mode).append(".").toString());
                                    }
                                    value = computeMode = value2;
                                    Enumeration.Value value3 = this.SVDMode$2(SVDMode$module).LocalARPACK();
                                    Enumeration.Value value4 = value;
                                    if (value3 != null ? !value3.equals(value4) : value4 != null) break block27;
                                    Predef$.MODULE$.require(k < n, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("k must be smaller than n in local-eigs mode but got k=").append(k).append(" and n=").append(n).append(".").toString());
                                    breeze.linalg.DenseMatrix G = (breeze.linalg.DenseMatrix)this.computeGramianMatrix().asBreeze();
                                    tuple22 = EigenValueDecomposition$.MODULE$.symmetricEigs((Function1<breeze.linalg.DenseVector<Object>, breeze.linalg.DenseVector<Object>>)(Function1 & Serializable & scala.Serializable)v -> (breeze.linalg.DenseVector)G.$times(v, (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD()), n, k, tol, maxIter);
                                    break block28;
                                }
                                Enumeration.Value value5 = this.SVDMode$2(SVDMode$module).LocalLAPACK();
                                Enumeration.Value value6 = value;
                                if (value5 != null ? !value5.equals(value6) : value6 != null) break block29;
                                Predef$.MODULE$.require(n < 17515, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append(n).append(" exceeds the breeze svd capability").toString());
                                breeze.linalg.DenseMatrix G = (breeze.linalg.DenseMatrix)this.computeGramianMatrix().asBreeze();
                                sVD = (svd.SVD)svd$.MODULE$.apply((Object)G, (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
                                if (sVD == null) break block30;
                                breeze.linalg.DenseMatrix uFull = (breeze.linalg.DenseMatrix)sVD.leftVectors();
                                sigmaSquaresFull = (breeze.linalg.DenseVector)sVD.singularValues();
                                if (uFull == null) break block30;
                                denseMatrix = uFull;
                                if (sigmaSquaresFull != null) break block31;
                            }
                            throw new MatchError((Object)sVD);
                        }
                        breeze.linalg.DenseVector denseVector2 = sigmaSquaresFull;
                        Tuple2 tuple23 = new Tuple2((Object)denseMatrix, (Object)denseVector2);
                        Tuple2 tuple24 = tuple23;
                        breeze.linalg.DenseMatrix uFull = (breeze.linalg.DenseMatrix)tuple24._1();
                        breeze.linalg.DenseVector sigmaSquaresFull2 = (breeze.linalg.DenseVector)tuple24._2();
                        tuple22 = new Tuple2((Object)sigmaSquaresFull2, (Object)uFull);
                        break block28;
                    }
                    Enumeration.Value value7 = this.SVDMode$2(SVDMode$module).DistARPACK();
                    Enumeration.Value value8 = value;
                    if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                        StorageLevel storageLevel = this.rows().getStorageLevel();
                        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
                        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The input data is not directly cached, which may hurt performance if its parent RDDs are also uncached.");
                        }
                        Predef$.MODULE$.require(k < n, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("k must be smaller than n in dist-eigs mode but got k=").append(k).append(" and n=").append(n).append(".").toString());
                        tuple22 = EigenValueDecomposition$.MODULE$.symmetricEigs((Function1<breeze.linalg.DenseVector<Object>, breeze.linalg.DenseVector<Object>>)(Function1 & Serializable & scala.Serializable)v -> this.multiplyGramianMatrixBy((breeze.linalg.DenseVector<Object>)v), n, k, tol, maxIter);
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
                tuple2 = tuple22;
                if (tuple2 == null) break block32;
                breeze.linalg.DenseVector sigmaSquares = (breeze.linalg.DenseVector)tuple2._1();
                u = (breeze.linalg.DenseMatrix)tuple2._2();
                if (sigmaSquares == null) break block32;
                denseVector = sigmaSquares;
                if (u != null) break block33;
            }
            throw new MatchError(tuple2);
        }
        breeze.linalg.DenseMatrix denseMatrix = u;
        Tuple2 tuple2 = new Tuple2((Object)denseVector, (Object)denseMatrix);
        Tuple2 tuple25 = tuple2;
        breeze.linalg.DenseVector sigmaSquares = (breeze.linalg.DenseVector)tuple25._1();
        breeze.linalg.DenseMatrix u2 = (breeze.linalg.DenseMatrix)tuple25._2();
        breeze.linalg.DenseVector sigmas = (breeze.linalg.DenseVector)package.sqrt$.MODULE$.apply((Object)sigmaSquares, package.sqrt$.MODULE$.fromLowOrderCanMapValues(breeze.linalg.DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.sqrt$.sqrtDoubleImpl$.MODULE$, breeze.linalg.DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())));
        double sigma0 = sigmas.apply$mcD$sp(0);
        double threshold = rCond * sigma0;
        int i = 0;
        if (sigmas.length() < k) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Requested ").append(k).append(" singular values but only found ").append(sigmas.length()).append(" converged.").toString());
        }
        while (i < package$.MODULE$.min(k, sigmas.length()) && sigmas.apply$mcD$sp(i) >= threshold) {
            ++i;
        }
        int sk = i;
        if (sk < k) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Requested ").append(k).append(" singular values but only found ").append(sk).append(" nonzeros.").toString());
        }
        Enumeration.Value value = computeMode;
        Enumeration.Value value9 = this.SVDMode$2(SVDMode$module).DistARPACK();
        if (!(value != null ? !value.equals(value9) : value9 != null)) {
            StorageLevel storageLevel = this.rows().getStorageLevel();
            StorageLevel storageLevel3 = StorageLevel$.MODULE$.NONE();
            if (!(storageLevel != null ? !storageLevel.equals(storageLevel3) : storageLevel3 != null)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The input data was not directly cached, which may hurt performance if its parent RDDs are also uncached.");
            }
        }
        Vector s = Vectors$.MODULE$.dense(Arrays.copyOfRange(sigmas.data$mcD$sp(), 0, sk));
        Matrix V = Matrices$.MODULE$.dense(n, sk, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * sk));
        if (computeU) {
            DenseMatrix.mcD.sp N = new DenseMatrix.mcD.sp(n, sk, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * sk));
            int i2 = 0;
            for (int j = 0; j < sk; ++j) {
                i2 = 0;
                double sigma = sigmas.apply$mcD$sp(j);
                while (i2 < n) {
                    int n2 = i2++;
                    int n3 = j;
                    N.update$mcD$sp(n2, n3, N.apply$mcD$sp(n2, n3) / sigma);
                }
            }
            RowMatrix U = this.multiply(Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)N));
            singularValueDecomposition = new SingularValueDecomposition<RowMatrix, Matrix>(U, s, V);
        } else {
            singularValueDecomposition = new SingularValueDecomposition<RowMatrix, Matrix>(null, s, V);
        }
        return singularValueDecomposition;
    }

    public boolean computeSVD$default$2() {
        return false;
    }

    public double computeSVD$default$3() {
        return 1.0E-9;
    }

    public Matrix computeCovariance() {
        int n = (int)this.numCols();
        this.checkNumColumns(n);
        MultivariateStatisticalSummary summary = this.computeColumnSummaryStatistics();
        long m = summary.count();
        Predef$.MODULE$.require(m > 1L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(122).append("RowMatrix.computeCovariance called on matrix with only ").append(m).append(" rows.").append("  Cannot compute the covariance of a RowMatrix with <= 1 row.").toString());
        Vector mean = summary.mean();
        breeze.linalg.Matrix<Object> G = this.computeGramianMatrix().asBreeze();
        int j = 0;
        double m1 = (double)m - 1.0;
        double alpha = 0.0;
        for (int i = 0; i < n; ++i) {
            alpha = (double)m / m1 * mean.apply(i);
            for (j = i; j < n; ++j) {
                double Gij = G.apply$mcD$sp(i, j) / m1 - alpha * mean.apply(j);
                G.update$mcD$sp(i, j, Gij);
                G.update$mcD$sp(j, i, Gij);
            }
        }
        return Matrices$.MODULE$.fromBreeze(G);
    }

    public Tuple2<Matrix, Vector> computePrincipalComponentsAndExplainedVariance(int k) {
        breeze.linalg.DenseMatrix denseMatrix;
        breeze.linalg.DenseVector s;
        int n;
        block3: {
            svd.SVD sVD;
            block2: {
                n = (int)this.numCols();
                Predef$.MODULE$.require(k > 0 && k <= n, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("k = ").append(k).append(" out of range (0, n = ").append(n).append("]").toString());
                breeze.linalg.DenseMatrix Cov = (breeze.linalg.DenseMatrix)this.computeCovariance().asBreeze();
                sVD = (svd.SVD)svd$.MODULE$.apply((Object)Cov, (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
                if (sVD == null) break block2;
                breeze.linalg.DenseMatrix u = (breeze.linalg.DenseMatrix)sVD.leftVectors();
                s = (breeze.linalg.DenseVector)sVD.singularValues();
                if (u == null) break block2;
                denseMatrix = u;
                if (s != null) break block3;
            }
            throw new MatchError((Object)sVD);
        }
        breeze.linalg.DenseVector denseVector = s;
        Tuple2 tuple2 = new Tuple2((Object)denseMatrix, (Object)denseVector);
        Tuple2 tuple22 = tuple2;
        breeze.linalg.DenseMatrix u = (breeze.linalg.DenseMatrix)tuple22._1();
        breeze.linalg.DenseVector s2 = (breeze.linalg.DenseVector)tuple22._2();
        double eigenSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(s2.data$mcD$sp())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double[] explainedVariance = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(s2.data$mcD$sp())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$4 -> x$4 / eigenSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return k == n ? new Tuple2((Object)Matrices$.MODULE$.dense(n, k, u.data$mcD$sp()), (Object)Vectors$.MODULE$.dense(explainedVariance)) : new Tuple2((Object)Matrices$.MODULE$.dense(n, k, Arrays.copyOfRange(u.data$mcD$sp(), 0, n * k)), (Object)Vectors$.MODULE$.dense(Arrays.copyOfRange(explainedVariance, 0, k)));
    }

    public Matrix computePrincipalComponents(int k) {
        return (Matrix)this.computePrincipalComponentsAndExplainedVariance(k)._1();
    }

    /*
     * WARNING - void declaration
     */
    public MultivariateStatisticalSummary computeColumnSummaryStatistics() {
        void var1_5;
        MultivariateOnlineSummarizer x$1 = new MultivariateOnlineSummarizer();
        Function2 & Serializable & scala.Serializable x$2 = (Function2 & Serializable & scala.Serializable)(aggregator, data) -> aggregator.add((Vector)data);
        Function2 & Serializable & scala.Serializable x$3 = (Function2 & Serializable & scala.Serializable)(aggregator1, aggregator2) -> aggregator1.merge((MultivariateOnlineSummarizer)aggregator2);
        int x$4 = this.rows().treeAggregate$default$4((Object)x$1);
        MultivariateOnlineSummarizer summary = (MultivariateOnlineSummarizer)this.rows().treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
        this.updateNumRows(summary.count());
        return var1_5;
    }

    public RowMatrix multiply(Matrix B) {
        int n = (int)this.numCols();
        int k = B.numCols();
        Predef$.MODULE$.require(n == B.numRows(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Dimension mismatch: ").append(n).append(" vs ").append(B.numRows()).toString());
        Predef$.MODULE$.require(B instanceof DenseMatrix, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Only support dense matrix at this time but found ").append(B.getClass().getName()).append(".").toString());
        Broadcast Bb = this.rows().context().broadcast((Object)((breeze.linalg.DenseMatrix)B.asBreeze()).toDenseVector$mcD$sp().toArray$mcD$sp(ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD AB = this.rows().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            double[] Bi = (double[])Bb.value();
            return iter.map((Function1 & Serializable & scala.Serializable)row -> {
                breeze.linalg.DenseVector v = breeze.linalg.DenseVector$.MODULE$.zeros$mDc$sp(k, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                for (int i = 0; i < k; ++i) {
                    v.update$mcD$sp(i, BoxesRunTime.unboxToDouble((Object)row.asBreeze().dot((Object)new DenseVector.mcD.sp(Bi, i * n, 1, n), Vector$.MODULE$.castOps(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double()))));
                }
                return Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)v);
            });
        }, this.rows().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Vector.class));
        return new RowMatrix((RDD<Vector>)AB, this.nRows(), B.numCols());
    }

    public CoordinateMatrix columnSimilarities() {
        return this.columnSimilarities(0.0);
    }

    public CoordinateMatrix columnSimilarities(double threshold) {
        Predef$.MODULE$.require(threshold >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Threshold cannot be negative: ").append(threshold).toString());
        if (threshold > 1.0) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(132).append("Threshold is greater than 1: ").append(threshold).append(" ").append("Computation will be more efficient with promoted sparsity, ").append(" however there is no correctness guarantee.").toString());
        }
        double gamma = threshold < 1.0E-6 ? Double.POSITIVE_INFINITY : (double)10 * package$.MODULE$.log((double)this.numCols()) / threshold;
        return this.columnSimilaritiesDIMSUM(this.computeColumnSummaryStatistics().normL2().toArray(), gamma);
    }

    public QRDecomposition<RowMatrix, Matrix> tallSkinnyQR(boolean computeQ) {
        RowMatrix rowMatrix;
        int col = (int)this.numCols();
        RDD blockQRs = this.rows().retag(Vector.class).glom().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)RowMatrix.$anonfun$tallSkinnyQR$1(x$5))).map((Function1 & Serializable & scala.Serializable)partRows -> {
            breeze.linalg.DenseMatrix bdm = DenseMatrix$.MODULE$.zeros$mDc$sp(((Vector[])partRows).length, col, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
            IntRef i = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partRows)).foreach((Function1 & Serializable & scala.Serializable)row -> {
                RowMatrix.$anonfun$tallSkinnyQR$3(bdm, i, row);
                return BoxedUnit.UNIT;
            });
            return (breeze.linalg.DenseMatrix)((qr.QR)qr.reduced$.MODULE$.apply((Object)bdm, (UFunc.UImpl)qr.reduced$.impl_reduced_DM_Double$.MODULE$)).r();
        }, ClassTag$.MODULE$.apply(breeze.linalg.DenseMatrix.class));
        breeze.linalg.DenseMatrix combinedR = (breeze.linalg.DenseMatrix)blockQRs.treeReduce((Function2 & Serializable & scala.Serializable)(r1, r2) -> {
            breeze.linalg.DenseMatrix stackedR = DenseMatrix$.MODULE$.vertcat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new breeze.linalg.DenseMatrix[]{r1, r2}), DenseMatrix$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
            return (breeze.linalg.DenseMatrix)((qr.QR)qr.reduced$.MODULE$.apply((Object)stackedR, (UFunc.UImpl)qr.reduced$.impl_reduced_DM_Double$.MODULE$)).r();
        }, blockQRs.treeReduce$default$2());
        Matrix finalR = Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)combinedR.toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$));
        if (computeQ) {
            try {
                breeze.linalg.DenseMatrix invR = (breeze.linalg.DenseMatrix)inv$.MODULE$.apply((Object)combinedR, inv$.MODULE$.canInvUsingLU_Double((UFunc.UImpl)LU.LU_DM_Impl_Double$.MODULE$));
                rowMatrix = this.multiply(Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)invR));
            }
            catch (MatrixSingularException err) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "R is not invertible and return Q as null");
                rowMatrix = null;
            }
        } else {
            rowMatrix = null;
        }
        RowMatrix finalQ = rowMatrix;
        return new QRDecomposition<Object, Matrix>(finalQ, finalR);
    }

    public boolean tallSkinnyQR$default$1() {
        return false;
    }

    public CoordinateMatrix columnSimilaritiesDIMSUM(double[] colMags, double gamma) {
        Predef$.MODULE$.require(gamma > 1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Oversampling should be greater than 1: ").append(gamma).toString());
        Predef$.MODULE$.require((long)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(colMags)).size() == this.numCols(), (Function0 & Serializable & scala.Serializable)() -> "Number of magnitudes didn't match column dimension");
        double sg = package$.MODULE$.sqrt(gamma);
        double[] colMagsCorrected = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(colMags)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> x == 0.0 ? 1.0 : x, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        SparkContext sc = this.rows().context();
        Broadcast pBV = sc.broadcast(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(colMagsCorrected)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)c -> sg / c, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast qBV = sc.broadcast(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(colMagsCorrected)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)c -> package$.MODULE$.min(sg, c), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD sims = RDD$.MODULE$.rddToPairRDDFunctions(this.rows().mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(indx, iter) -> RowMatrix.$anonfun$columnSimilaritiesDIMSUM$6(pBV, qBV, BoxesRunTime.unboxToInt((Object)indx), iter), this.rows().mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKey((Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x$6, x$7) -> x$6 + x$7).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            double sim;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    sim = tuple22._2$mcD$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int i = tuple2._1$mcI$sp();
            int j = tuple2._2$mcI$sp();
            MatrixEntry matrixEntry = new MatrixEntry(i, j, sim);
            return matrixEntry;
        }, ClassTag$.MODULE$.apply(MatrixEntry.class));
        return new CoordinateMatrix((RDD<MatrixEntry>)sims, this.numCols(), this.numCols());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public breeze.linalg.DenseMatrix<Object> toBreeze() {
        void var3_3;
        int m = (int)this.numRows();
        int n = (int)this.numCols();
        breeze.linalg.DenseMatrix mat = DenseMatrix$.MODULE$.zeros$mDc$sp(m, n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        IntRef i = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.rows().collect())).foreach((Function1 & Serializable & scala.Serializable)vector -> {
            RowMatrix.$anonfun$toBreeze$1(mat, i, vector);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    private void updateNumRows(long m) {
        if (this.nRows() <= 0L) {
            this.nRows_$eq(m);
        } else {
            Predef$.MODULE$.require(this.nRows() == m, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("The number of rows ").append(m).append(" is different from what specified or previously computed: ").append(this.nRows()).append(".").toString());
        }
    }

    private static final /* synthetic */ RowMatrix$SVDMode$1$ SVDMode$lzycompute$1(LazyRef SVDMode$module$1) {
        RowMatrix$SVDMode$1$ rowMatrix$SVDMode$1$;
        LazyRef lazyRef = SVDMode$module$1;
        synchronized (lazyRef) {
            rowMatrix$SVDMode$1$ = SVDMode$module$1.initialized() ? (RowMatrix$SVDMode$1$)((Object)SVDMode$module$1.value()) : (RowMatrix$SVDMode$1$)((Object)SVDMode$module$1.initialize((Object)new RowMatrix$SVDMode$1$(null)));
        }
        return rowMatrix$SVDMode$1$;
    }

    private final RowMatrix$SVDMode$1$ SVDMode$2(LazyRef SVDMode$module$1) {
        return SVDMode$module$1.initialized() ? (RowMatrix$SVDMode$1$)((Object)SVDMode$module$1.value()) : RowMatrix.SVDMode$lzycompute$1(SVDMode$module$1);
    }

    public static final /* synthetic */ boolean $anonfun$tallSkinnyQR$1(Vector[] x$5) {
        return x$5.length != 0;
    }

    public static final /* synthetic */ void $anonfun$tallSkinnyQR$3(breeze.linalg.DenseMatrix bdm$1, IntRef i$1, Vector row) {
        ((NumericOps)bdm$1.apply((Object)BoxesRunTime.boxToInteger((int)i$1.elem), (Object)scala.package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRow())).$colon$eq(row.asBreeze().t(Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.$conforms())), Transpose$.MODULE$.liftInPlaceOps((UFunc.InPlaceImpl2)breeze.linalg.DenseVector$.MODULE$.dv_v_InPlaceOp_Double_OpSet()));
        ++i$1.elem;
    }

    public static final /* synthetic */ ListBuffer $anonfun$columnSimilaritiesDIMSUM$8(int[] indices$1, double[] scaled$1, XORShiftRandom rand$1, double[] p$1, int nnz$1, int k) {
        ListBuffer buf = new ListBuffer();
        int i = indices$1[k];
        double iVal = scaled$1[k];
        if (iVal != 0.0 && rand$1.nextDouble() < p$1[i]) {
            for (int l = k + 1; l < nnz$1; ++l) {
                int j = indices$1[l];
                double jVal = scaled$1[l];
                Object object = jVal != 0.0 && rand$1.nextDouble() < p$1[j] ? buf.$plus$eq((Object)new Tuple2((Object)new Tuple2.mcII.sp(i, j), (Object)BoxesRunTime.boxToDouble((double)(iVal * jVal)))) : BoxedUnit.UNIT;
            }
        }
        return buf;
    }

    public static final /* synthetic */ ListBuffer $anonfun$columnSimilaritiesDIMSUM$9(double[] scaled$1, XORShiftRandom rand$1, double[] p$1, int n$4, int i) {
        ListBuffer buf = new ListBuffer();
        double iVal = scaled$1[i];
        if (iVal != 0.0 && rand$1.nextDouble() < p$1[i]) {
            for (int j = i + 1; j < n$4; ++j) {
                double jVal = scaled$1[j];
                Object object = jVal != 0.0 && rand$1.nextDouble() < p$1[j] ? buf.$plus$eq((Object)new Tuple2((Object)new Tuple2.mcII.sp(i, j), (Object)BoxesRunTime.boxToDouble((double)(iVal * jVal)))) : BoxedUnit.UNIT;
            }
        }
        return buf;
    }

    public static final /* synthetic */ Iterator $anonfun$columnSimilaritiesDIMSUM$6(Broadcast pBV$1, Broadcast qBV$1, int indx, Iterator iter) {
        double[] p = (double[])pBV$1.value();
        double[] q = (double[])qBV$1.value();
        XORShiftRandom rand = new XORShiftRandom((long)indx);
        double[] scaled = new double[new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(p)).size()];
        return iter.flatMap((Function1 & Serializable & scala.Serializable)row -> {
            DenseVector denseVector;
            Option<double[]> option;
            Iterator iterator;
            SparseVector sparseVector;
            Option<Tuple3<Object, int[], double[]>> option2;
            Vector vector = row;
            if (vector instanceof SparseVector && !(option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector)).isEmpty()) {
                int[] indices = (int[])((Tuple3)option2.get())._2();
                double[] values = (double[])((Tuple3)option2.get())._3();
                int nnz = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).size();
                for (int k2 = 0; k2 < nnz; ++k2) {
                    scaled$1[k2] = values[k2] / q[indices[k2]];
                }
                iterator = TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)scala.package$.MODULE$.Iterator().tabulate(nnz, (Function1 & Serializable & scala.Serializable)k -> RowMatrix.$anonfun$columnSimilaritiesDIMSUM$8(indices, scaled, rand, p, nnz, BoxesRunTime.unboxToInt((Object)k))), (Function1)Predef$.MODULE$.$conforms()).flatten();
            } else if (vector instanceof DenseVector && !(option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) {
                double[] values = (double[])option.get();
                int n = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(values)).size();
                for (int i2 = 0; i2 < n; ++i2) {
                    scaled$1[i2] = values[i2] / q[i2];
                }
                iterator = TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)scala.package$.MODULE$.Iterator().tabulate(n, (Function1 & Serializable & scala.Serializable)i -> RowMatrix.$anonfun$columnSimilaritiesDIMSUM$9(scaled, rand, p, n, BoxesRunTime.unboxToInt((Object)i))), (Function1)Predef$.MODULE$.$conforms()).flatten();
            } else {
                throw new MatchError((Object)vector);
            }
            return iterator;
        });
    }

    public static final /* synthetic */ void $anonfun$toBreeze$1(breeze.linalg.DenseMatrix mat$1, IntRef i$2, Vector vector) {
        vector.foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$1, x1$1);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int j = sp2._1$mcI$sp();
            double v = sp2._2$mcD$sp();
            mat$1.update$mcD$sp(i$2.elem, j, v);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        ++i$2.elem;
    }

    public RowMatrix(RDD<Vector> rows, long nRows, int nCols) {
        this.rows = rows;
        this.nRows = nRows;
        this.nCols = nCols;
        Logging.$init$((Logging)this);
    }

    public RowMatrix(RDD<Vector> rows) {
        this(rows, 0L, 0);
    }
}

