/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import com.github.fommil.netlib.BLAS;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$SaveLoadV1_0$;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t=e\u0001\u0002\u0015*\u0001QB\u0001B\u0013\u0001\u0003\u0006\u0004%\ta\u0013\u0005\t1\u0002\u0011\t\u0011)A\u0005\u0019\"A!\f\u0001BC\u0002\u0013\u00051\f\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003]\u0011!q\u0007A!b\u0001\n\u0003Y\u0006\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\t\u000bI\u0004A\u0011A:\t\u000bu\u0004A\u0011\u0002@\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!A\u0011\u0011\u0007\u0001!\n\u0013\t\u0019\u0004C\u0004\u0002$\u0001!\t!!\u0012\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002X!9\u0011Q\u0011\u0001\u0005\u0002\u0005\u001d\u0005bBAL\u0001\u0011\u0005\u0011\u0011\u0014\u0005\n\u0003C\u0003!\u0019!C)\u0003GC\u0001\"!*\u0001A\u0003%\u0011\u0011\u0002\u0005\b\u0003O\u0003A\u0011IAU\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0007Dq!!5\u0001\t\u0003\t\u0019nB\u0004\u0002\\&B\t!!8\u0007\r!J\u0003\u0012AAp\u0011\u0019\u0011X\u0003\"\u0001\u0002h\"9\u0011\u0011^\u000b\u0005\n\u0005-\bbBA~+\u0011%\u0011Q \u0005\b\u0005\u001f)B\u0011\u0002B\t\u0011%\u0011i#FI\u0001\n\u0013\u0011y\u0003C\u0004\u0003DU!\tE!\u0012\b\u0011\t5S\u0003#\u0001*\u0005\u001f2\u0001Ba\u0015\u0016\u0011\u0003I#Q\u000b\u0005\u0007ev!\tAa\u0016\t\u0013\teSD1A\u0005\n\tm\u0003\u0002\u0003B1;\u0001\u0006IA!\u0018\t\u0015\t\rTD1A\u0005\u0002%\u0012Y\u0006\u0003\u0005\u0003fu\u0001\u000b\u0011\u0002B/\u0011\u001d\t9+\bC\u0001\u0005OBqAa\u0011\u001e\t\u0003\u0011y\u0007C\u0004\u0003vu!IAa\u001e\t\u000f\tmT\u0004\"\u0003\u0003~!I!\u0011Q\u000b\u0002\u0002\u0013%!1\u0011\u0002\u0019\u001b\u0006$(/\u001b=GC\u000e$xN]5{CRLwN\\'pI\u0016d'B\u0001\u0016,\u00039\u0011XmY8n[\u0016tG-\u0019;j_:T!\u0001L\u0017\u0002\u000b5dG.\u001b2\u000b\u00059z\u0013!B:qCJ\\'B\u0001\u00192\u0003\u0019\t\u0007/Y2iK*\t!'A\u0002pe\u001e\u001c\u0001aE\u0003\u0001km\nE\t\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtG\u0001\u0004B]f\u0014VM\u001a\t\u0003y}j\u0011!\u0010\u0006\u0003}-\nA!\u001e;jY&\u0011\u0001)\u0010\u0002\t'\u00064X-\u00192mKB\u0011aGQ\u0005\u0003\u0007^\u0012AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"!\u0012%\u000e\u0003\u0019S!aR\u0017\u0002\u0011%tG/\u001a:oC2L!!\u0013$\u0003\u000f1{wmZ5oO\u0006!!/\u00198l+\u0005a\u0005C\u0001\u001cN\u0013\tquGA\u0002J]RD3!\u0001)W!\t\tF+D\u0001S\u0015\t\u0019V&\u0001\u0006b]:|G/\u0019;j_:L!!\u0016*\u0003\u000bMKgnY3\"\u0003]\u000bQ\u0001\r\u00189]A\nQA]1oW\u0002B3A\u0001)W\u00031)8/\u001a:GK\u0006$XO]3t+\u0005a\u0006cA/aE6\taL\u0003\u0002`[\u0005\u0019!\u000f\u001a3\n\u0005\u0005t&a\u0001*E\tB!ag\u0019'f\u0013\t!wG\u0001\u0004UkBdWM\r\t\u0004m\u0019D\u0017BA48\u0005\u0015\t%O]1z!\t1\u0014.\u0003\u0002ko\t1Ai\\;cY\u0016D3a\u0001)W\u00035)8/\u001a:GK\u0006$XO]3tA!\u001aA\u0001\u0015,\u0002\u001fA\u0014x\u000eZ;di\u001a+\u0017\r^;sKND3!\u0002)W\u0003A\u0001(o\u001c3vGR4U-\u0019;ve\u0016\u001c\b\u0005K\u0002\u0007!Z\u000ba\u0001P5oSRtD\u0003\u0002;wqj\u0004\"!\u001e\u0001\u000e\u0003%BQAS\u0004A\u00021C3A\u001e)W\u0011\u0015Qv\u00011\u0001]Q\rA\bK\u0016\u0005\u0006]\u001e\u0001\r\u0001\u0018\u0015\u0004uB3\u0006fA\u0004Q-\u0006\u0001b/\u00197jI\u0006$XMR3biV\u0014Xm\u001d\u000b\u0006\u007f\u0006\u0015\u0011q\u0004\t\u0004m\u0005\u0005\u0011bAA\u0002o\t!QK\\5u\u0011\u001d\t9\u0001\u0003a\u0001\u0003\u0013\tAA\\1nKB!\u00111BA\r\u001d\u0011\ti!!\u0006\u0011\u0007\u0005=q'\u0004\u0002\u0002\u0012)\u0019\u00111C\u001a\u0002\rq\u0012xn\u001c;?\u0013\r\t9bN\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0011Q\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]q\u0007\u0003\u0004\u0002\"!\u0001\r\u0001X\u0001\tM\u0016\fG/\u001e:fg\u00069\u0001O]3eS\u000e$H#\u00025\u0002(\u0005-\u0002BBA\u0015\u0013\u0001\u0007A*\u0001\u0003vg\u0016\u0014\bBBA\u0017\u0013\u0001\u0007A*A\u0004qe>$Wo\u0019;)\u0007%\u0001f+\u0001\u0010d_VtG/\u00119qe>DH)[:uS:\u001cG/V:feB\u0013x\u000eZ;diR!\u0011QGA\u001f!\u001914-a\u000e\u00028A\u0019a'!\u000f\n\u0007\u0005mrG\u0001\u0003M_:<\u0007bBA \u0015\u0001\u0007\u0011\u0011I\u0001\u000ekN,'o\u001d)s_\u0012,8\r^:\u0011\tu\u0003\u00171\t\t\u0005m\rdE\n\u0006\u0003\u0002H\u0005=\u0003\u0003B/a\u0003\u0013\u00022!^A&\u0013\r\ti%\u000b\u0002\u0007%\u0006$\u0018N\\4\t\u000f\u0005}2\u00021\u0001\u0002B!\"1\u0002UA*C\t\t)&A\u00031]er\u0003\u0007\u0006\u0003\u0002Z\u0005%\u0004CBA.\u0003K\nI%\u0004\u0002\u0002^)!\u0011qLA1\u0003\u0011Q\u0017M^1\u000b\u0007\u0005\rT&A\u0002ba&LA!a\u001a\u0002^\t9!*\u0019<b%\u0012#\u0005bBA \u0019\u0001\u0007\u00111\u000e\t\t\u00037\ni'!\u001d\u0002r%!\u0011qNA/\u0005-Q\u0015M^1QC&\u0014(\u000b\u0012#\u0011\t\u0005M\u00141P\u0007\u0003\u0003kRA!a\u001e\u0002z\u0005!A.\u00198h\u0015\t\ty&\u0003\u0003\u0002~\u0005U$aB%oi\u0016<WM\u001d\u0015\u0005\u0019A\u000b\t)\t\u0002\u0002\u0004\u0006)\u0011G\f\u001a/a\u0005\t\"/Z2p[6,g\u000e\u001a)s_\u0012,8\r^:\u0015\r\u0005%\u00151RAG!\u00111d-!\u0013\t\r\u0005%R\u00021\u0001M\u0011\u0019\ty)\u0004a\u0001\u0019\u0006\u0019a.^7)\t5\u0001\u00161S\u0011\u0003\u0003+\u000bQ!\r\u00182]A\naB]3d_6lWM\u001c3Vg\u0016\u00148\u000f\u0006\u0004\u0002\n\u0006m\u0015Q\u0014\u0005\u0007\u0003[q\u0001\u0019\u0001'\t\r\u0005=e\u00021\u0001MQ\u0011q\u0001+a%\u0002\u001b\u0019|'/\\1u-\u0016\u00148/[8o+\t\tI!\u0001\bg_Jl\u0017\r\u001e,feNLwN\u001c\u0011\u0002\tM\fg/\u001a\u000b\u0006\u007f\u0006-\u0016q\u0017\u0005\b\u0003[\u000b\u0002\u0019AAX\u0003\t\u00198\r\u0005\u0003\u00022\u0006MV\"A\u0017\n\u0007\u0005UVF\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0004\u0002:F\u0001\r!!\u0003\u0002\tA\fG\u000f\u001b\u0015\u0005#A\u000bi,\t\u0002\u0002@\u0006)\u0011GL\u001a/a\u0005I\"/Z2p[6,g\u000e\u001a)s_\u0012,8\r^:G_J,6/\u001a:t)\u0011\t)-!3\u0011\tu\u0003\u0017q\u0019\t\u0006m\rd\u0015\u0011\u0012\u0005\u0007\u0003\u001f\u0013\u0002\u0019\u0001')\tI\u0001\u0016QZ\u0011\u0003\u0003\u001f\fQ!\r\u00185]A\n\u0011D]3d_6lWM\u001c3Vg\u0016\u00148OR8s!J|G-^2ugR!\u0011QYAk\u0011\u0019\tyi\u0005a\u0001\u0019\"\"1\u0003UAgQ\r\u0001\u0001KV\u0001\u0019\u001b\u0006$(/\u001b=GC\u000e$xN]5{CRLwN\\'pI\u0016d\u0007CA;\u0016'\u0015)R'!9B!\u0011a\u00141\u001d;\n\u0007\u0005\u0015XH\u0001\u0004M_\u0006$WM\u001d\u000b\u0003\u0003;\f\u0011B]3d_6lWM\u001c3\u0015\u0011\u00055\u0018\u0011_A{\u0003s\u0004BA\u000e4\u0002pB!ag\u0019'i\u0011\u0019\t\u0019p\u0006a\u0001K\u0006\u0019\"/Z2p[6,g\u000e\u001a+p\r\u0016\fG/\u001e:fg\"1\u0011q_\fA\u0002q\u000bQC]3d_6lWM\u001c3bE2,g)Z1ukJ,7\u000f\u0003\u0004\u0002\u0010^\u0001\r\u0001T\u0001\u0010e\u0016\u001cw.\\7f]\u00124uN]!mYRQ\u0011q B\u0002\u0005\u000b\u0011IA!\u0004\u0011\tu\u0003'\u0011\u0001\t\u0006m\rd\u0015Q\u001e\u0005\u0006\u0015b\u0001\r\u0001\u0014\u0005\u0007\u0005\u000fA\u0002\u0019\u0001/\u0002\u0017M\u00148MR3biV\u0014Xm\u001d\u0005\u0007\u0005\u0017A\u0002\u0019\u0001/\u0002\u0017\u0011\u001cHOR3biV\u0014Xm\u001d\u0005\u0007\u0003\u001fC\u0002\u0019\u0001'\u0002\u0011\tdwnY6jMf$bAa\u0005\u0003(\t%\u0002\u0003B/a\u0005+\u0001RAa\u0006\u0003\"\ttAA!\u0007\u0003\u001e9!\u0011q\u0002B\u000e\u0013\u0005A\u0014b\u0001B\u0010o\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0012\u0005K\u00111aU3r\u0015\r\u0011yb\u000e\u0005\u0007\u0003CI\u0002\u0019\u0001/\t\u0011\t-\u0012\u0004%AA\u00021\u000b\u0011B\u00197pG.\u001c\u0016N_3\u0002%\tdwnY6jMf$C-\u001a4bk2$HEM\u000b\u0003\u0005cQ3\u0001\u0014B\u001aW\t\u0011)\u0004\u0005\u0003\u00038\t}RB\u0001B\u001d\u0015\u0011\u0011YD!\u0010\u0002\u0013Ut7\r[3dW\u0016$'BA*8\u0013\u0011\u0011\tE!\u000f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0003m_\u0006$G#\u0002;\u0003H\t%\u0003bBAW7\u0001\u0007\u0011q\u0016\u0005\b\u0003s[\u0002\u0019AA\u0005Q\u0011Y\u0002+!0\u0002\u0019M\u000bg/\u001a'pC\u00124\u0016g\u0018\u0019\u0011\u0007\tES$D\u0001\u0016\u00051\u0019\u0016M^3M_\u0006$g+M01'\tiR\u0007\u0006\u0002\u0003P\u0005\tB\u000f[5t\r>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8\u0016\u0005\tu\u0003\u0003BA:\u0005?JA!a\u0007\u0002v\u0005\u0011B\u000f[5t\r>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8!\u00035!\b.[:DY\u0006\u001c8OT1nK\u0006qA\u000f[5t\u00072\f7o\u001d(b[\u0016\u0004C#B@\u0003j\t5\u0004B\u0002B6G\u0001\u0007A/A\u0003n_\u0012,G\u000eC\u0004\u0002:\u000e\u0002\r!!\u0003\u0015\u000bQ\u0014\tHa\u001d\t\u000f\u00055F\u00051\u0001\u00020\"9\u0011\u0011\u0018\u0013A\u0002\u0005%\u0011\u0001C;tKJ\u0004\u0016\r\u001e5\u0015\t\u0005%!\u0011\u0010\u0005\b\u0003s+\u0003\u0019AA\u0005\u0003-\u0001(o\u001c3vGR\u0004\u0016\r\u001e5\u0015\t\u0005%!q\u0010\u0005\b\u0003s3\u0003\u0019AA\u0005\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u0015\u0005\u0003BA:\u0005\u000fKAA!#\u0002v\t1qJ\u00196fGRDC!\u0006)\u0002>\"\"A\u0003UA_\u0001")
public class MatrixFactorizationModel
implements Saveable,
scala.Serializable,
Logging {
    private final int rank;
    private final RDD<Tuple2<Object, double[]>> userFeatures;
    private final RDD<Tuple2<Object, double[]>> productFeatures;
    private final String formatVersion;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static MatrixFactorizationModel load(SparkContext sparkContext, String string) {
        return MatrixFactorizationModel$.MODULE$.load(sparkContext, string);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int rank() {
        return this.rank;
    }

    public RDD<Tuple2<Object, double[]>> userFeatures() {
        return this.userFeatures;
    }

    public RDD<Tuple2<Object, double[]>> productFeatures() {
        return this.productFeatures;
    }

    private void validateFeatures(String name, RDD<Tuple2<Object, double[]>> features) {
        block1: {
            Predef$.MODULE$.require(((double[])((Tuple2)features.first())._2()).length == this.rank(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append(name).append(" feature dimension does not match the rank ").append(this.rank()).append(".").toString());
            if (features.partitioner().isEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(84).append(name).append(" factor does not have a partitioner. ").append("Prediction on individual records could be slow.").toString());
            }
            StorageLevel storageLevel = features.getStorageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            if (storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null) break block1;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append(name).append(" factor is not cached. Prediction could be slow.").toString());
        }
    }

    public double predict(int user, int product) {
        Seq userFeatureSeq = RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)user));
        Predef$.MODULE$.require(userFeatureSeq.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("userId: ").append(user).append(" not found in the model").toString());
        Seq productFeatureSeq = RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)product));
        Predef$.MODULE$.require(productFeatureSeq.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("productId: ").append(product).append(" not found in the model").toString());
        double[] userVector = (double[])userFeatureSeq.head();
        double[] productVector = (double[])productFeatureSeq.head();
        return BLAS.getInstance().ddot(this.rank(), userVector, 1, productVector, 1);
    }

    private Tuple2<Object, Object> countApproxDistinctUserProduct(RDD<Tuple2<Object, Object>> usersProducts) {
        HyperLogLogPlus zeroCounterUser = new HyperLogLogPlus(4, 0);
        HyperLogLogPlus zeroCounterProduct = new HyperLogLogPlus(4, 0);
        Tuple2 aggregated = (Tuple2)usersProducts.aggregate((Object)new Tuple2((Object)zeroCounterUser, (Object)zeroCounterProduct), (Function2 & Serializable & scala.Serializable)(hllTuple, v) -> {
            ((HyperLogLogPlus)hllTuple._1()).offer((Object)BoxesRunTime.boxToInteger((int)v._1$mcI$sp()));
            ((HyperLogLogPlus)hllTuple._2()).offer((Object)BoxesRunTime.boxToInteger((int)v._2$mcI$sp()));
            return hllTuple;
        }, (Function2 & Serializable & scala.Serializable)(h1, h2) -> {
            ((HyperLogLogPlus)h1._1()).addAll((HyperLogLogPlus)h2._1());
            ((HyperLogLogPlus)h1._2()).addAll((HyperLogLogPlus)h2._2());
            return h1;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return new Tuple2.mcJJ.sp(((HyperLogLogPlus)aggregated._1()).cardinality(), ((HyperLogLogPlus)aggregated._2()).cardinality());
    }

    public RDD<Rating> predict(RDD<Tuple2<Object, Object>> usersProducts) {
        RDD rDD;
        Tuple2<Object, Object> tuple2 = this.countApproxDistinctUserProduct(usersProducts);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long usersCount = tuple2._1$mcJ$sp();
        long productsCount = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(usersCount, productsCount);
        Tuple2.mcJJ.sp sp3 = sp2;
        long usersCount2 = sp3._1$mcJ$sp();
        long productsCount2 = sp3._2$mcJ$sp();
        if (usersCount2 < productsCount2) {
            RDD users = RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).join(usersProducts).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                int user;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$1;
                        if (tuple22 == null) break block2;
                        user = tuple22._1$mcI$sp();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                double[] uFeatures = (double[])tuple2._1();
                int product = tuple2._2$mcI$sp();
                Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)uFeatures));
                return tuple23;
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            rDD = RDD$.MODULE$.rddToPairRDDFunctions(users, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).join(this.productFeatures()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                double[] pFeatures;
                Tuple2 tuple2;
                int product;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$2;
                        if (tuple22 == null) break block2;
                        product = tuple22._1$mcI$sp();
                        Tuple2 tuple23 = (Tuple2)tuple22._2();
                        if (tuple23 == null) break block2;
                        tuple2 = (Tuple2)tuple23._1();
                        pFeatures = (double[])tuple23._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                int user = tuple2._1$mcI$sp();
                double[] uFeatures = (double[])tuple2._2();
                Rating rating = new Rating(user, product, BLAS.getInstance().ddot(uFeatures.length, uFeatures, 1, pFeatures, 1));
                return rating;
            }, ClassTag$.MODULE$.apply(Rating.class));
        } else {
            RDD products = RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).join(usersProducts.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.swap$mcII$sp(), ClassTag$.MODULE$.apply(Tuple2.class))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2;
                int product;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$3;
                        if (tuple22 == null) break block2;
                        product = tuple22._1$mcI$sp();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                double[] pFeatures = (double[])tuple2._1();
                int user = tuple2._2$mcI$sp();
                Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)pFeatures));
                return tuple23;
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            rDD = RDD$.MODULE$.rddToPairRDDFunctions(products, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).join(this.userFeatures()).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                double[] uFeatures;
                Tuple2 tuple2;
                int user;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$4;
                        if (tuple22 == null) break block2;
                        user = tuple22._1$mcI$sp();
                        Tuple2 tuple23 = (Tuple2)tuple22._2();
                        if (tuple23 == null) break block2;
                        tuple2 = (Tuple2)tuple23._1();
                        uFeatures = (double[])tuple23._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                int product = tuple2._1$mcI$sp();
                double[] pFeatures = (double[])tuple2._2();
                Rating rating = new Rating(user, product, BLAS.getInstance().ddot(uFeatures.length, uFeatures, 1, pFeatures, 1));
                return rating;
            }, ClassTag$.MODULE$.apply(Rating.class));
        }
        return rDD;
    }

    public JavaRDD<Rating> predict(JavaPairRDD<Integer, Integer> usersProducts) {
        return this.predict((RDD<Tuple2<Object, Object>>)usersProducts.rdd()).toJavaRDD();
    }

    public Rating[] recommendProducts(int user, int num) {
        Seq userFeatureSeq = RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)user));
        Predef$.MODULE$.require(userFeatureSeq.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("userId: ").append(user).append(" not found in the model").toString());
        return (Rating[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommend((double[])userFeatureSeq.head(), this.productFeatures(), num))).map((Function1 & Serializable & scala.Serializable)t -> new Rating(user, t._1$mcI$sp(), t._2$mcD$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
    }

    public Rating[] recommendUsers(int product, int num) {
        Seq productFeatureSeq = RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)product));
        Predef$.MODULE$.require(productFeatureSeq.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("productId: ").append(product).append(" not found in the model").toString());
        return (Rating[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommend((double[])productFeatureSeq.head(), this.userFeatures(), num))).map((Function1 & Serializable & scala.Serializable)t -> new Rating(t._1$mcI$sp(), product, t._2$mcD$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
    }

    @Override
    public String formatVersion() {
        return this.formatVersion;
    }

    @Override
    public void save(SparkContext sc, String path) {
        MatrixFactorizationModel$SaveLoadV1_0$.MODULE$.save(this, path);
    }

    public RDD<Tuple2<Object, Rating[]>> recommendProductsForUsers(int num) {
        return MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommendForAll(this.rank(), this.userFeatures(), this.productFeatures(), num).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int user = tuple2._1$mcI$sp();
            Tuple2[] top = (Tuple2[])tuple2._2();
            Rating[] ratings = (Rating[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])top)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int product = tuple2._1$mcI$sp();
                double rating = tuple2._2$mcD$sp();
                Rating rating2 = new Rating(user, product, rating);
                return rating2;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)ratings);
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public RDD<Tuple2<Object, Rating[]>> recommendUsersForProducts(int num) {
        return MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommendForAll(this.rank(), this.productFeatures(), this.userFeatures(), num).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int product = tuple2._1$mcI$sp();
            Tuple2[] top = (Tuple2[])tuple2._2();
            Rating[] ratings = (Rating[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])top)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int user = tuple2._1$mcI$sp();
                double rating = tuple2._2$mcD$sp();
                Rating rating2 = new Rating(user, product, rating);
                return rating2;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)ratings);
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public MatrixFactorizationModel(int rank, RDD<Tuple2<Object, double[]>> userFeatures, RDD<Tuple2<Object, double[]>> productFeatures) {
        this.rank = rank;
        this.userFeatures = userFeatures;
        this.productFeatures = productFeatures;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(rank > 0);
        this.validateFeatures("User", userFeatures);
        this.validateFeatures("Product", productFeatures);
        this.formatVersion = "1.0";
    }
}

