/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import org.apache.spark.SparkContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@DeveloperApi
public final class LogisticRegressionDataGenerator$ {
    public static LogisticRegressionDataGenerator$ MODULE$;

    static {
        new LogisticRegressionDataGenerator$();
    }

    public RDD<LabeledPoint> generateLogisticRDD(SparkContext sc, int nexamples, int nfeatures, double eps, int nparts, double probOne) {
        RDD data = sc.parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nexamples), nparts, ClassTag$.MODULE$.Int()).map((Function1 & java.io.Serializable & Serializable)idx -> LogisticRegressionDataGenerator$.$anonfun$generateLogisticRDD$1(nfeatures, eps, BoxesRunTime.unboxToInt((Object)idx)), ClassTag$.MODULE$.apply(LabeledPoint.class));
        return data;
    }

    public int generateLogisticRDD$default$5() {
        return 2;
    }

    public double generateLogisticRDD$default$6() {
        return 0.5;
    }

    public void main(String[] args) {
        if (args.length != 5) {
            Predef$.MODULE$.println((Object)"Usage: LogisticRegressionGenerator <master> <output_dir> <num_examples> <num_features> <num_partitions>");
            System.exit(1);
        }
        String sparkMaster = args[0];
        String outputPath = args[1];
        int nexamples = args.length > 2 ? new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt() : 1000;
        int nfeatures = args.length > 3 ? new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt() : 2;
        int parts = args.length > 4 ? new StringOps(Predef$.MODULE$.augmentString(args[4])).toInt() : 2;
        int eps = 3;
        SparkContext sc = new SparkContext(sparkMaster, "LogisticRegressionDataGenerator");
        RDD<LabeledPoint> data = this.generateLogisticRDD(sc, nexamples, nfeatures, eps, parts, this.generateLogisticRDD$default$6());
        data.saveAsTextFile(outputPath);
        sc.stop();
    }

    public static final /* synthetic */ LabeledPoint $anonfun$generateLogisticRDD$1(int nfeatures$1, double eps$1, int idx) {
        Random rnd = new Random(42 + idx);
        double y = idx % 2 == 0 ? 0.0 : 1.0;
        double[] x = (double[])Array$.MODULE$.fill(nfeatures$1, (Function0)(JFunction0.mcD.sp & java.io.Serializable & Serializable)() -> rnd.nextGaussian() + y * eps$1, ClassTag$.MODULE$.Double());
        return new LabeledPoint(y, Vectors$.MODULE$.dense(x));
    }

    private LogisticRegressionDataGenerator$() {
        MODULE$ = this;
    }
}

