/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.StringSearch;
import com.ibm.icu.util.ULocale;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.ToLongFunction;
import org.apache.spark.SparkException;
import org.apache.spark.unsafe.types.UTF8String;

public final class CollationFactory {
    private static final Collation[] collationTable = new Collation[4];
    private static final HashMap<String, Integer> collationNameToIdMap = new HashMap();
    public static final int UTF8_BINARY_COLLATION_ID = 0;
    public static final int UTF8_BINARY_LCASE_COLLATION_ID = 1;
    public static final String PROVIDER_SPARK = "spark";
    public static final String PROVIDER_ICU = "icu";
    public static final List<String> SUPPORTED_PROVIDERS = List.of("spark", "icu");

    public static StringSearch getStringSearch(UTF8String targetUTF8String, UTF8String patternUTF8String, int collationId) {
        return CollationFactory.getStringSearch(targetUTF8String.toString(), patternUTF8String.toString(), collationId);
    }

    public static StringSearch getStringSearch(String targetString, String patternString, int collationId) {
        StringCharacterIterator target = new StringCharacterIterator(targetString);
        Collator collator = CollationFactory.fetchCollation((int)collationId).collator;
        return new StringSearch(patternString, (CharacterIterator)target, (RuleBasedCollator)collator);
    }

    public static boolean isValidCollation(String collationName) {
        return collationNameToIdMap.containsKey(collationName.toUpperCase());
    }

    public static String getClosestCollation(String collationName) {
        Collation suggestion = Collections.min(List.of(collationTable), Comparator.comparingInt(c -> UTF8String.fromString(c.collationName).levenshteinDistance(UTF8String.fromString(collationName.toUpperCase()))));
        return suggestion.collationName;
    }

    public static StringSearch getStringSearch(UTF8String targetUTF8String, UTF8String patternUTF8String) {
        return new StringSearch(patternUTF8String.toString(), targetUTF8String.toString());
    }

    public static int collationNameToId(String collationName) throws SparkException {
        String normalizedName = collationName.toUpperCase();
        if (collationNameToIdMap.containsKey(normalizedName)) {
            return collationNameToIdMap.get(normalizedName);
        }
        Collation suggestion = Collections.min(List.of(collationTable), Comparator.comparingInt(c -> UTF8String.fromString(c.collationName).levenshteinDistance(UTF8String.fromString(normalizedName))));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("collationName", collationName);
        params.put("proposal", suggestion.collationName);
        throw new SparkException("COLLATION_INVALID_NAME", SparkException.constructMessageParams(params), null);
    }

    public static void assertValidProvider(String provider) throws SparkException {
        if (!SUPPORTED_PROVIDERS.contains(provider.toLowerCase())) {
            Map<String, String> params = Map.of("provider", provider, "supportedProviders", String.join((CharSequence)", ", SUPPORTED_PROVIDERS));
            throw new SparkException("COLLATION_INVALID_PROVIDER", SparkException.constructMessageParams(params), null);
        }
    }

    public static Collation fetchCollation(int collationId) {
        return collationTable[collationId];
    }

    public static Collation fetchCollation(String collationName) throws SparkException {
        int collationId = CollationFactory.collationNameToId(collationName);
        return collationTable[collationId];
    }

    public static UTF8String getCollationKey(UTF8String input, int collationId) {
        Collation collation = CollationFactory.fetchCollation(collationId);
        if (collation.supportsBinaryEquality) {
            return input;
        }
        if (collation.supportsLowercaseEquality) {
            return input.toLowerCase();
        }
        CollationKey collationKey = collation.collator.getCollationKey(input.toString());
        return UTF8String.fromBytes(collationKey.toByteArray());
    }

    static {
        CollationFactory.collationTable[0] = new Collation("UTF8_BINARY", PROVIDER_SPARK, null, UTF8String::binaryCompare, "1.0", s -> s.hashCode(), true, true, false);
        CollationFactory.collationTable[1] = new Collation("UTF8_BINARY_LCASE", PROVIDER_SPARK, null, UTF8String::compareLowerCase, "1.0", s -> s.toLowerCase().hashCode(), false, false, true);
        CollationFactory.collationTable[2] = new Collation("UNICODE", PROVIDER_ICU, Collator.getInstance((ULocale)ULocale.ROOT), "153.120.0.0", true, false, false);
        CollationFactory.collationTable[2].collator.setStrength(2);
        CollationFactory.collationTable[2].collator.freeze();
        CollationFactory.collationTable[3] = new Collation("UNICODE_CI", PROVIDER_ICU, Collator.getInstance((ULocale)ULocale.ROOT), "153.120.0.0", false, false, false);
        CollationFactory.collationTable[3].collator.setStrength(1);
        CollationFactory.collationTable[3].collator.freeze();
        for (int i = 0; i < collationTable.length; ++i) {
            collationNameToIdMap.put(CollationFactory.collationTable[i].collationName, i);
        }
    }

    public static class Collation {
        public final String collationName;
        public final String provider;
        public final Collator collator;
        public final Comparator<UTF8String> comparator;
        public final String version;
        public final ToLongFunction<UTF8String> hashFunction;
        public final BiFunction<UTF8String, UTF8String, Boolean> equalsFunction;
        public final boolean supportsBinaryEquality;
        public final boolean supportsBinaryOrdering;
        public final boolean supportsLowercaseEquality;

        public Collation(String collationName, String provider, Collator collator, Comparator<UTF8String> comparator, String version, ToLongFunction<UTF8String> hashFunction, boolean supportsBinaryEquality, boolean supportsBinaryOrdering, boolean supportsLowercaseEquality) {
            this.collationName = collationName;
            this.provider = provider;
            this.collator = collator;
            this.comparator = comparator;
            this.version = version;
            this.hashFunction = hashFunction;
            this.supportsBinaryEquality = supportsBinaryEquality;
            this.supportsBinaryOrdering = supportsBinaryOrdering;
            this.supportsLowercaseEquality = supportsLowercaseEquality;
            assert (!supportsBinaryOrdering || supportsBinaryEquality);
            assert (!supportsBinaryEquality || !supportsLowercaseEquality);
            assert (SUPPORTED_PROVIDERS.contains(provider));
            this.equalsFunction = supportsBinaryEquality ? UTF8String::equals : (s1, s2) -> this.comparator.compare((UTF8String)s1, (UTF8String)s2) == 0;
        }

        public Collation(String collationName, String provider, Collator collator, String version, boolean supportsBinaryEquality, boolean supportsBinaryOrdering, boolean supportsLowercaseEquality) {
            this(collationName, provider, collator, (s1, s2) -> collator.compare(s1.toString(), s2.toString()), version, s -> collator.getCollationKey(s.toString()).hashCode(), supportsBinaryEquality, supportsBinaryOrdering, supportsLowercaseEquality);
        }

        public CollationIdentifier identifier() {
            return new CollationIdentifier(this.provider, this.collationName, this.version);
        }
    }

    public static class CollationIdentifier {
        private final String provider;
        private final String name;
        private final String version;

        public CollationIdentifier(String provider, String collationName, String version) {
            this.provider = provider;
            this.name = collationName;
            this.version = version;
        }

        public static CollationIdentifier fromString(String identifier) {
            long numDots = identifier.chars().filter(ch -> ch == 46).count();
            assert (numDots > 0L);
            if (numDots == 1L) {
                String[] parts = identifier.split("\\.", 2);
                return new CollationIdentifier(parts[0], parts[1], null);
            }
            String[] parts = identifier.split("\\.", 3);
            return new CollationIdentifier(parts[0], parts[1], parts[2]);
        }

        public String toStringWithoutVersion() {
            return String.format("%s.%s", this.provider, this.name);
        }

        public String getProvider() {
            return this.provider;
        }

        public String getName() {
            return this.name;
        }

        public Optional<String> getVersion() {
            return Optional.ofNullable(this.version);
        }
    }
}

