/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn.security;

import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.deploy.yarn.security.YARNHadoopDelegationTokenManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc!B\u0001\u0003\u0001\u0011q!aE!N\u0007J,G-\u001a8uS\u0006d'+\u001a8fo\u0016\u0014(BA\u0002\u0005\u0003!\u0019XmY;sSRL(BA\u0003\u0007\u0003\u0011I\u0018M\u001d8\u000b\u0005\u001dA\u0011A\u00023fa2|\u0017P\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h'\r\u0001q\"\u0006\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005YIR\"A\f\u000b\u0005aA\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005i9\"a\u0002'pO\u001eLgn\u001a\u0005\t9\u0001\u0011\t\u0011)A\u0005=\u0005I1\u000f]1sW\u000e{gNZ\u0002\u0001!\ty\u0002%D\u0001\t\u0013\t\t\u0003BA\u0005Ta\u0006\u00148nQ8oM\"A1\u0005\u0001B\u0001B\u0003%A%\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\t\r|gN\u001a\u0006\u0003S)\ta\u0001[1e_>\u0004\u0018BA\u0016'\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")Q\u0006\u0001C\u0001]\u00051A(\u001b8jiz\"2aL\u00193!\t\u0001\u0004!D\u0001\u0003\u0011\u0015aB\u00061\u0001\u001f\u0011\u0015\u0019C\u00061\u0001%\u0011\u001d!\u0004A1A\u0005\nU\n\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\u0016\u0003Y\u0002\"a\u000e\u001e\u000f\u0005AA\u0014BA\u001d\u0012\u0003\u0019\u0001&/\u001a3fM&\u00111\b\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e\n\u0002B\u0002 \u0001A\u0003%a'\u0001\u0006qe&t7-\u001b9bY\u0002Bq\u0001\u0011\u0001C\u0002\u0013%Q'\u0001\u0004lKf$\u0018M\u0019\u0005\u0007\u0005\u0002\u0001\u000b\u0011\u0002\u001c\u0002\u000f-,\u0017\u0010^1cA!9A\t\u0001b\u0001\n\u0013)\u0015!E2sK\u0012,g\u000e^5bY6\u000bg.Y4feV\ta\t\u0005\u00021\u000f&\u0011\u0001J\u0001\u0002!3\u0006\u0013f\nS1e_>\u0004H)\u001a7fO\u0006$\u0018n\u001c8U_.,g.T1oC\u001e,'\u000f\u0003\u0004K\u0001\u0001\u0006IAR\u0001\u0013GJ,G-\u001a8uS\u0006dW*\u00198bO\u0016\u0014\b\u0005C\u0004M\u0001\t\u0007I\u0011B'\u0002\u001fI,g.Z<bY\u0016CXmY;u_J,\u0012A\u0014\t\u0003\u001fZk\u0011\u0001\u0015\u0006\u0003#J\u000b!bY8oGV\u0014(/\u001a8u\u0015\t\u0019F+\u0001\u0003vi&d'\"A+\u0002\t)\fg/Y\u0005\u0003/B\u0013\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011\u0019I\u0006\u0001)A\u0005\u001d\u0006\u0001\"/\u001a8fo\u0006dW\t_3dkR|'\u000f\t\u0005\b7\u0002\u0011\r\u0011\"\u0003]\u0003%!'/\u001b<feJ+g-F\u0001^!\rq\u0016mY\u0007\u0002?*\u0011\u0001\rU\u0001\u0007CR|W.[2\n\u0005\t|&aD!u_6L7MU3gKJ,gnY3\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019D\u0011a\u0001:qG&\u0011\u0001.\u001a\u0002\u000f%B\u001cWI\u001c3q_&tGOU3g\u0011\u0019Q\u0007\u0001)A\u0005;\u0006QAM]5wKJ\u0014VM\u001a\u0011\t\u000f1\u0004!\u0019!C\u0005[\u0006Y!/\u001a8fo\u0006dG+Y:l+\u0005q'cA8ts\u001a!\u0001/\u001d\u0001o\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0011\u0019\u0011\b\u0001)A\u0005]\u0006a!/\u001a8fo\u0006dG+Y:lAA\u0011Ao^\u0007\u0002k*\u0011a\u000fV\u0001\u0005Y\u0006tw-\u0003\u0002yk\n1qJ\u00196fGR\u0004\"\u0001\u001e>\n\u0005m,(\u0001\u0003*v]:\f'\r\\3\t\u000bu\u0004A\u0011\u0001@\u0002\u0019M,G\u000f\u0012:jm\u0016\u0014(+\u001a4\u0015\u0007}\f)\u0001E\u0002\u0011\u0003\u0003I1!a\u0001\u0012\u0005\u0011)f.\u001b;\t\r\u0005\u001dA\u00101\u0001d\u0003\r\u0011XM\u001a\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0003\u0015\u0019H/\u0019:u)\t\ty\u0001\u0005\u0003\u0002\u0012\u0005UQBAA\n\u0015\t\u0019\u0001&\u0003\u0003\u0002\u0018\u0005M!\u0001F+tKJ<%o\\;q\u0013:4wN]7bi&|g\u000eC\u0004\u0002\u001c\u0001!I!!\b\u0002\u001bM$\u0018M\u001d;J]R,'O\\1m)\u0015y\u0018qDA\u0012\u0011!\t\t#!\u0007A\u0002\u0005=\u0011aA;hS\"A\u0011QEA\r\u0001\u0004\t9#A\u0007pe&<\u0017N\\1m\u0007J,Gm\u001d\t\u0005\u0003#\tI#\u0003\u0003\u0002,\u0005M!aC\"sK\u0012,g\u000e^5bYNDq!a\f\u0001\t\u0003\t\t$\u0001\u0003ti>\u0004H#A@\t\u000f\u0005U\u0002\u0001\"\u0003\u00028\u0005y1o\u00195fIVdWMU3oK^\fG\u000eF\u0002\u0000\u0003sA\u0001\"a\u000f\u00024\u0001\u0007\u0011QH\u0001\u0006I\u0016d\u0017-\u001f\t\u0004!\u0005}\u0012bAA!#\t!Aj\u001c8h\u0011\u001d\t)\u0005\u0001C\u0005\u0003c\t\u0001#\u001e9eCR,Gk\\6f]N$\u0016m]6\t\u000f\u0005%\u0003\u0001\"\u0003\u0002L\u0005qrN\u0019;bS:$vn[3og\u0006sGmU2iK\u0012,H.\u001a*f]\u0016<\u0018\r\u001c\u000b\u0005\u0003O\ti\u0005\u0003\u0005\u0002\"\u0005\u001d\u0003\u0019AA\b\u0011\u001d\t\t\u0006\u0001C\u0005\u0003\u001b\tq\u0001Z8M_\u001eLg\u000e")
public class AMCredentialRenewer
implements Logging {
    public final SparkConf org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$sparkConf;
    public final Configuration org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopConf;
    private final String org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$principal;
    private final String keytab;
    private final YARNHadoopDelegationTokenManager org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager;
    private final ScheduledExecutorService renewalExecutor;
    private final AtomicReference<RpcEndpointRef> driverRef;
    private final Runnable renewalTask;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public String org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$principal() {
        return this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$principal;
    }

    private String keytab() {
        return this.keytab;
    }

    public YARNHadoopDelegationTokenManager org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager() {
        return this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager;
    }

    private ScheduledExecutorService renewalExecutor() {
        return this.renewalExecutor;
    }

    private AtomicReference<RpcEndpointRef> driverRef() {
        return this.driverRef;
    }

    private Runnable renewalTask() {
        return this.renewalTask;
    }

    public void setDriverRef(RpcEndpointRef ref) {
        this.driverRef().set(ref);
    }

    /*
     * WARNING - void declaration
     */
    public UserGroupInformation start() {
        void var2_2;
        Credentials originalCreds = UserGroupInformation.getCurrentUser().getCredentials();
        UserGroupInformation ugi = this.doLogin();
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<BoxedUnit>(this, originalCreds, ugi){
            private final /* synthetic */ AMCredentialRenewer $outer;
            private final Credentials originalCreds$1;
            private final UserGroupInformation ugi$1;

            public void run() {
                this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$startInternal(this.ugi$1, this.originalCreds$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.originalCreds$1 = originalCreds$1;
                this.ugi$1 = ugi$1;
            }
        });
        return var2_2;
    }

    public void org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$startInternal(UserGroupInformation ugi, Credentials originalCreds) {
        Runnable tgtRenewalTask = new Runnable(this, ugi){
            private final UserGroupInformation ugi$2;

            public void run() {
                this.ugi$2.checkTGTAndReloginFromKeytab();
            }
            {
                this.ugi$2 = ugi$2;
            }
        };
        long tgtRenewalPeriod = BoxesRunTime.unboxToLong((Object)this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$sparkConf.get(package$.MODULE$.KERBEROS_RELOGIN_PERIOD()));
        this.renewalExecutor().scheduleAtFixedRate(tgtRenewalTask, tgtRenewalPeriod, tgtRenewalPeriod, TimeUnit.SECONDS);
        Credentials creds = this.obtainTokensAndScheduleRenewal(ugi);
        ugi.addCredentials(creds);
        Credentials existing = ugi.getCredentials();
        existing.mergeAll(originalCreds);
        ugi.addCredentials(existing);
    }

    public void stop() {
        this.renewalExecutor().shutdown();
    }

    public void org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$scheduleRenewal(long delay) {
        long _delay = scala.math.package$.MODULE$.max(0L, delay);
        this.logInfo((Function0<String>)new Serializable(this, delay){
            public static final long serialVersionUID = 0L;
            private final long delay$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scheduling login from keytab in ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UIUtils$.MODULE$.formatDuration(this.delay$1)}));
            }
            {
                this.delay$1 = delay$1;
            }
        });
        this.renewalExecutor().schedule(this.renewalTask(), _delay, TimeUnit.MILLISECONDS);
    }

    public void org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$updateTokensTask() {
        try {
            UserGroupInformation freshUGI = this.doLogin();
            Credentials creds = this.obtainTokensAndScheduleRenewal(freshUGI);
            byte[] tokens = SparkHadoopUtil$.MODULE$.get().serialize(creds);
            RpcEndpointRef driver = this.driverRef().get();
            if (driver == null) {
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Delegation tokens close to expiration but no driver has registered yet.";
                    }
                });
            } else {
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Updating delegation tokens.";
                    }
                });
                driver.send((Object)new CoarseGrainedClusterMessages.UpdateDelegationTokens(tokens));
            }
            SparkHadoopUtil$.MODULE$.get().addDelegationTokens(tokens, this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$sparkConf);
        }
        catch (Exception exception) {
            long delay = TimeUnit.SECONDS.toMillis(BoxesRunTime.unboxToLong((Object)this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.CREDENTIALS_RENEWAL_RETRY_WAIT())));
            this.logWarning((Function0<String>)new Serializable(this, delay){
                public static final long serialVersionUID = 0L;
                private final long delay$2;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to update tokens, will try again in ", "!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UIUtils$.MODULE$.formatDuration(this.delay$2)}))).append((Object)" If this happens too often tasks will fail.").toString();
                }
                {
                    this.delay$2 = delay$2;
                }
            }, exception);
            this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$scheduleRenewal(delay);
        }
    }

    private Credentials obtainTokensAndScheduleRenewal(UserGroupInformation ugi) {
        return (Credentials)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Credentials>(this){
            private final /* synthetic */ AMCredentialRenewer $outer;

            /*
             * WARNING - void declaration
             */
            public Credentials run() {
                void var1_1;
                Credentials creds = new Credentials();
                long nextRenewal = this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager().obtainDelegationTokens(this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopConf, creds);
                long timeToWait = SparkHadoopUtil$.MODULE$.nextCredentialRenewalTime(nextRenewal, this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$sparkConf) - System.currentTimeMillis();
                this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$scheduleRenewal(timeToWait);
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private UserGroupInformation doLogin() {
        void var1_1;
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AMCredentialRenewer $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to login to KDC using principal: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$principal()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$principal(), (String)this.keytab());
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Successfully logged into KDC.";
            }
        });
        return var1_1;
    }

    public AMCredentialRenewer(SparkConf sparkConf, Configuration hadoopConf) {
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$sparkConf = sparkConf;
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$hadoopConf = hadoopConf;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$principal = (String)((Option)sparkConf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.PRINCIPAL())).get();
        this.keytab = (String)((Option)sparkConf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.KEYTAB())).get();
        this.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$credentialManager = new YARNHadoopDelegationTokenManager(sparkConf, hadoopConf);
        this.renewalExecutor = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("Credential Refresh Thread");
        this.driverRef = new AtomicReference();
        this.renewalTask = new Runnable(this){
            private final /* synthetic */ AMCredentialRenewer $outer;

            public void run() {
                this.$outer.org$apache$spark$deploy$yarn$security$AMCredentialRenewer$$updateTokensTask();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

