/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import com.google.common.io.Files;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.TestUtils$;
import org.apache.spark.api.python.PythonUtils$;
import org.apache.spark.deploy.yarn.BaseYarnClusterSuite;
import org.apache.spark.deploy.yarn.ExecutorEnvTestApp$;
import org.apache.spark.deploy.yarn.SparkContextTimeoutApp$;
import org.apache.spark.deploy.yarn.YarnClasspathTest$;
import org.apache.spark.deploy.yarn.YarnClusterDriver$;
import org.apache.spark.deploy.yarn.YarnClusterDriverUseSparkHadoopUtilConf$;
import org.apache.spark.deploy.yarn.YarnClusterDriverWithFailure$;
import org.apache.spark.deploy.yarn.YarnLauncherTestApp$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkLauncher;
import org.apache.spark.tags.ExtendedYarnTest;
import org.apache.spark.util.Utils$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.time.Span$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ExtendedYarnTest
@ScalaSignature(bytes="\u0006\u0001Q4Aa\u0004\t\u00017!)\u0001\u0005\u0001C\u0001C!)1\u0005\u0001C!I!9a\u0006\u0001b\u0001\n\u0013y\u0003BB\u001f\u0001A\u0003%\u0001\u0007C\u0004?\u0001\t\u0007I\u0011B\u0018\t\r}\u0002\u0001\u0015!\u00031\u0011\u0015\u0001\u0005\u0001\"\u0003B\u0011\u001dy\u0005!%A\u0005\nACQa\u0017\u0001\u0005\nqCQA\u0018\u0001\u0005\n}Cq!\u001a\u0001\u0012\u0002\u0013%\u0001\u000bC\u0004g\u0001E\u0005I\u0011\u0002)\t\u000b\u001d\u0004A\u0011\u00025\t\u000b)\u0004A\u0011B6\u0003!e\u000b'O\\\"mkN$XM]*vSR,'BA\t\u0013\u0003\u0011I\u0018M\u001d8\u000b\u0005M!\u0012A\u00023fa2|\u0017P\u0003\u0002\u0016-\u0005)1\u000f]1sW*\u0011q\u0003G\u0001\u0007CB\f7\r[3\u000b\u0003e\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0005uqR\"\u0001\t\n\u0005}\u0001\"\u0001\u0006\"bg\u0016L\u0016M\u001d8DYV\u001cH/\u001a:Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u0011Q\u0004A\u0001\u000e]\u0016<\u0018,\u0019:o\u0007>tg-[4\u0015\u0003\u0015\u0002\"A\n\u0017\u000e\u0003\u001dR!\u0001K\u0015\u0002\t\r|gN\u001a\u0006\u0003#)R!a\u000b\f\u0002\r!\fGm\\8q\u0013\tisEA\tZCJt7i\u001c8gS\u001e,(/\u0019;j_:\f1\u0002V#T)~\u0003\u0016LR%M\u000bV\t\u0001\u0007\u0005\u00022u9\u0011!\u0007\u000f\t\u0003gYj\u0011\u0001\u000e\u0006\u0003ki\ta\u0001\u0010:p_Rt$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2\u0014A\u0002)sK\u0012,g-\u0003\u0002<y\t11\u000b\u001e:j]\u001eT!!\u000f\u001c\u0002\u0019Q+5\u000bV0Q3\u001aKE*\u0012\u0011\u0002\u001bQ+5\u000bV0Q36{E)\u0016'F\u00039!Vi\u0015+`!fku\nR+M\u000b\u0002\n\u0001\u0003^3ti\n\u000b7/[2ZCJt\u0017\t\u001d9\u0015\u0007\t35\n\u0005\u0002D\t6\ta'\u0003\u0002Fm\t!QK\\5u\u0011\u00159u\u00011\u0001I\u0003)\u0019G.[3oi6{G-\u001a\t\u0003\u0007&K!A\u0013\u001c\u0003\u000f\t{w\u000e\\3b]\"9\u0001f\u0002I\u0001\u0002\u0004a\u0005\u0003B\u0019NaAJ!A\u0014\u001f\u0003\u00075\u000b\u0007/\u0001\u000euKN$()Y:jGf\u000b'O\\!qa\u0012\"WMZ1vYR$#'F\u0001RU\ta%kK\u0001T!\t!\u0016,D\u0001V\u0015\t1v+A\u0005v]\u000eDWmY6fI*\u0011\u0001LN\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001.V\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fi\u0016\u001cHoV5uQ\u0006#GMS1s)\t\u0011U\fC\u0003H\u0013\u0001\u0007\u0001*A\u0006uKN$\b+_*qCJ\\G\u0003\u0002\"aC\u000eDQa\u0012\u0006A\u0002!CqA\u0019\u0006\u0011\u0002\u0003\u0007A*A\u0005fqR\u0014\u0018mQ8oM\"9AM\u0003I\u0001\u0002\u0004a\u0015\u0001C3yiJ\fWI\u001c<\u0002+Q,7\u000f\u001e)z'B\f'o\u001b\u0013eK\u001a\fW\u000f\u001c;%e\u0005)B/Z:u!f\u001c\u0006/\u0019:lI\u0011,g-Y;mi\u0012\u001a\u0014!\u0006;fgR,6/Z\"mCN\u001c\b+\u0019;i\r&\u00148\u000f\u001e\u000b\u0003\u0005&DQaR\u0007A\u0002!\u000bq\u0002^3ti\u0016CXmY;u_J,eN\u001e\u000b\u0003\u00052DQa\u0012\bA\u0002!C#\u0001\u00018\u0011\u0005=\u0014X\"\u00019\u000b\u0005E$\u0012\u0001\u0002;bONL!a\u001d9\u0003!\u0015CH/\u001a8eK\u0012L\u0016M\u001d8UKN$\b")
public class YarnClusterSuite
extends BaseYarnClusterSuite {
    private final String TEST_PYFILE = new StringOps(Predef$.MODULE$.augmentString("\n    |import mod1, mod2\n    |import sys\n    |from operator import add\n    |\n    |from pyspark import SparkConf , SparkContext\n    |if __name__ == \"__main__\":\n    |    if len(sys.argv) != 2:\n    |        print >> sys.stderr, \"Usage: test.py [result file]\"\n    |        exit(-1)\n    |    sc = SparkContext(conf=SparkConf())\n    |    status = open(sys.argv[1],'w')\n    |    result = \"failure\"\n    |    rdd = sc.parallelize(range(10)).map(lambda x: x * mod1.func() * mod2.func())\n    |    cnt = rdd.count()\n    |    if cnt == 10:\n    |        result = \"success\"\n    |    status.write(result)\n    |    status.close()\n    |    sc.stop()\n    ")).stripMargin();
    private final String TEST_PYMODULE = new StringOps(Predef$.MODULE$.augmentString("\n    |def func():\n    |    return 42\n    ")).stripMargin();

    @Override
    public YarnConfiguration newYarnConfig() {
        return new YarnConfiguration();
    }

    private String TEST_PYFILE() {
        return this.TEST_PYFILE;
    }

    private String TEST_PYMODULE() {
        return this.TEST_PYMODULE;
    }

    private void testBasicYarnApp(boolean clientMode, Map<String, String> conf) {
        File result = File.createTempFile("result", null, this.tempDir());
        boolean x$1 = clientMode;
        String x$2 = this.mainClassName(YarnClusterDriver$.MODULE$.getClass());
        Seq x$3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{result.getAbsolutePath()}));
        Map<String, String> x$4 = conf;
        Seq<Tuple2<String, String>> x$5 = this.runSpark$default$4();
        Seq<String> x$6 = this.runSpark$default$5();
        Seq<String> x$7 = this.runSpark$default$6();
        Map<String, String> x$8 = this.runSpark$default$8();
        Option<File> x$9 = this.runSpark$default$9();
        SparkAppHandle.State finalState = this.runSpark(x$1, x$2, (Seq<String>)x$3, x$5, x$6, x$7, x$4, x$8, x$9);
        this.checkResult(finalState, result, this.checkResult$default$3(), this.checkResult$default$4());
    }

    private Map<String, String> testBasicYarnApp$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private void testWithAddJar(boolean clientMode) {
        URL originalJar = TestUtils$.MODULE$.createJarWithFiles((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.resource"), (Object)"ORIGINAL")})), this.tempDir());
        File driverResult = File.createTempFile("driver", null, this.tempDir());
        File executorResult = File.createTempFile("executor", null, this.tempDir());
        boolean x$1 = clientMode;
        String x$2 = this.mainClassName(YarnClasspathTest$.MODULE$.getClass());
        Seq x$3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{driverResult.getAbsolutePath(), executorResult.getAbsolutePath()}));
        Seq x$4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{originalJar.getPath()}));
        Seq x$5 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(6).append("local:").append(originalJar.getPath()).toString()}));
        Seq<Tuple2<String, String>> x$6 = this.runSpark$default$4();
        Map<String, String> x$7 = this.runSpark$default$7();
        Map<String, String> x$8 = this.runSpark$default$8();
        Option<File> x$9 = this.runSpark$default$9();
        SparkAppHandle.State finalState = this.runSpark(x$1, x$2, (Seq<String>)x$3, x$6, (Seq<String>)x$4, (Seq<String>)x$5, x$7, x$8, x$9);
        this.checkResult(finalState, driverResult, "ORIGINAL", this.checkResult$default$4());
        this.checkResult(finalState, executorResult, "ORIGINAL", this.checkResult$default$4());
    }

    private void testPySpark(boolean clientMode, Map<String, String> extraConf, Map<String, String> extraEnv) {
        SparkAppHandle.State finalState;
        File primaryPyFile = new File(this.tempDir(), "test.py");
        Files.write((CharSequence)this.TEST_PYFILE(), (File)primaryPyFile, (Charset)StandardCharsets.UTF_8);
        String sparkHome = (String)scala.sys.package$.MODULE$.props().apply((Object)"spark.test.home");
        Seq pythonPath = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(12).append(sparkHome).append("/python/lib/").append(PythonUtils$.MODULE$.PY4J_ZIP_NAME()).toString(), new StringBuilder(7).append(sparkHome).append("/python").toString()}));
        Map extraEnvVars = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYSPARK_ARCHIVES_PATH"), (Object)((TraversableOnce)pythonPath.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(6).append("local:").append((String)x$1).toString(), Seq$.MODULE$.canBuildFrom())).mkString(File.pathSeparator)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)pythonPath.mkString(File.pathSeparator))}))).$plus$plus(extraEnv);
        File subdir = new File(this.tempDir(), "pyModules");
        subdir.mkdir();
        File moduleDir = subdir;
        File pyModule = new File(moduleDir, "mod1.py");
        Files.write((CharSequence)this.TEST_PYMODULE(), (File)pyModule, (Charset)StandardCharsets.UTF_8);
        URL mod2Archive = TestUtils$.MODULE$.createJarWithFiles((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mod2.py"), (Object)this.TEST_PYMODULE())})), moduleDir);
        String pyFiles = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{pyModule.getAbsolutePath(), mod2Archive.getPath()}))).mkString(",");
        File result = File.createTempFile("result", null, this.tempDir());
        Some outFile = new Some((Object)File.createTempFile("stdout", null, this.tempDir()));
        boolean x$12 = clientMode;
        String x$2 = primaryPyFile.getAbsolutePath();
        Seq x$3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"--py-files"), (Object)pyFiles)}));
        Seq x$4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{result.getAbsolutePath()}));
        Map x$5 = extraEnvVars;
        Map<String, String> x$6 = extraConf;
        Some x$7 = outFile;
        Seq<String> x$8 = this.runSpark$default$5();
        Seq<String> x$9 = this.runSpark$default$6();
        SparkAppHandle.State x$10 = finalState = this.runSpark(x$12, x$2, (Seq<String>)x$4, (Seq<Tuple2<String, String>>)x$3, x$8, x$9, x$6, (Map<String, String>)x$5, (Option<File>)x$7);
        File x$11 = result;
        Some x$122 = outFile;
        String x$13 = this.checkResult$default$3();
        this.checkResult(x$10, x$11, x$13, (Option<File>)x$122);
    }

    private Map<String, String> testPySpark$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private Map<String, String> testPySpark$default$3() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private void testUseClassPathFirst(boolean clientMode) {
        URL originalJar = TestUtils$.MODULE$.createJarWithFiles((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.resource"), (Object)"ORIGINAL")})), this.tempDir());
        URL userJar = TestUtils$.MODULE$.createJarWithFiles((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.resource"), (Object)"OVERRIDDEN")})), this.tempDir());
        File driverResult = File.createTempFile("driver", null, this.tempDir());
        File executorResult = File.createTempFile("executor", null, this.tempDir());
        boolean x$1 = clientMode;
        String x$2 = this.mainClassName(YarnClasspathTest$.MODULE$.getClass());
        Seq x$3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{driverResult.getAbsolutePath(), executorResult.getAbsolutePath()}));
        Seq x$4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{originalJar.getPath()}));
        Seq x$5 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(6).append("local:").append(userJar.getPath()).toString()}));
        Map x$6 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.userClassPathFirst"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.userClassPathFirst"), (Object)"true")}));
        Seq<Tuple2<String, String>> x$7 = this.runSpark$default$4();
        Map<String, String> x$8 = this.runSpark$default$8();
        Option<File> x$9 = this.runSpark$default$9();
        SparkAppHandle.State finalState = this.runSpark(x$1, x$2, (Seq<String>)x$3, x$7, (Seq<String>)x$4, (Seq<String>)x$5, (Map<String, String>)x$6, x$8, x$9);
        this.checkResult(finalState, driverResult, "OVERRIDDEN", this.checkResult$default$4());
        this.checkResult(finalState, executorResult, "OVERRIDDEN", this.checkResult$default$4());
    }

    private void testExecutorEnv(boolean clientMode) {
        File result = File.createTempFile("result", null, this.tempDir());
        boolean x$1 = clientMode;
        String x$2 = this.mainClassName(ExecutorEnvTestApp$.MODULE$.getClass());
        Seq x$3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{result.getAbsolutePath()}));
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.TEST_ENV"), (Object)"am_val"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.TEST_ENV"), (Object)"executor_val")}));
        Seq<Tuple2<String, String>> x$5 = this.runSpark$default$4();
        Seq<String> x$6 = this.runSpark$default$5();
        Seq<String> x$7 = this.runSpark$default$6();
        Map<String, String> x$8 = this.runSpark$default$8();
        Option<File> x$9 = this.runSpark$default$9();
        SparkAppHandle.State finalState = this.runSpark(x$1, x$2, (Seq<String>)x$3, x$5, x$6, x$7, (Map<String, String>)x$4, x$8, x$9);
        this.checkResult(finalState, result, "true", this.checkResult$default$4());
    }

    public YarnClusterSuite() {
        this.test("run Spark in yarn-client mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testBasicYarnApp(true, this.testBasicYarnApp$default$2()), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.test("run Spark in yarn-cluster mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testBasicYarnApp(false, this.testBasicYarnApp$default$2()), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        this.test("run Spark in yarn-client mode with unmanaged am", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testBasicYarnApp(true, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.YARN_UNMANAGED_AM().key()), (Object)"true")})))), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("run Spark in yarn-client mode with different configurations, ensuring redaction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testBasicYarnApp(true, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key()), (Object)"512m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().key()), (Object)"512m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.HADOOP_CREDSTORE_PASSWORD"), (Object)YarnClusterDriver$.MODULE$.SECRET_PASSWORD()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.HADOOP_CREDSTORE_PASSWORD"), (Object)YarnClusterDriver$.MODULE$.SECRET_PASSWORD())})))), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("run Spark in yarn-cluster mode with different configurations, ensuring redaction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testBasicYarnApp(false, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_MEMORY().key()), (Object)"512m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.DRIVER_CORES().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().key()), (Object)"512m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.HADOOP_CREDSTORE_PASSWORD"), (Object)YarnClusterDriver$.MODULE$.SECRET_PASSWORD()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.HADOOP_CREDSTORE_PASSWORD"), (Object)YarnClusterDriver$.MODULE$.SECRET_PASSWORD())})))), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        this.test("yarn-cluster should respect conf overrides in SparkHadoopUtil (SPARK-16414, SPARK-23630)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File customConf = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String coreSite = new StringOps(Predef$.MODULE$.augmentString("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n      |<configuration>\n      |  <property>\n      |    <name>spark.test.key</name>\n      |    <value>testvalue</value>\n      |  </property>\n      |</configuration>\n      |")).stripMargin();
            Files.write((CharSequence)coreSite, (File)new File(customConf, "core-site.xml"), (Charset)StandardCharsets.UTF_8);
            File result = File.createTempFile("result", null, this.tempDir());
            boolean x$1 = false;
            String x$2 = this.mainClassName(YarnClusterDriverUseSparkHadoopUtilConf$.MODULE$.getClass());
            Seq x$3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key=value", "spark.test.key=testvalue", result.getAbsolutePath()}));
            Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.hadoop.key"), (Object)"value")}));
            Map x$5 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_TEST_HADOOP_CONF_DIR"), (Object)customConf.getAbsolutePath())}));
            Seq<Tuple2<String, String>> x$6 = this.runSpark$default$4();
            Seq<String> x$7 = this.runSpark$default$5();
            Seq<String> x$8 = this.runSpark$default$6();
            Option<File> x$9 = this.runSpark$default$9();
            SparkAppHandle.State finalState = this.runSpark(x$1, x$2, (Seq<String>)x$3, x$6, x$7, x$8, (Map<String, String>)x$4, (Map<String, String>)x$5, x$9);
            this.checkResult(finalState, result, this.checkResult$default$3(), this.checkResult$default$4());
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        this.test("run Spark in yarn-client mode with additional jar", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testWithAddJar(true), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("run Spark in yarn-cluster mode with additional jar", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testWithAddJar(false), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.test("run Spark in yarn-cluster mode unsuccessfully", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkAppHandle.State finalState = this.runSpark(false, this.mainClassName(YarnClusterDriver$.MODULE$.getClass()), this.runSpark$default$3(), this.runSpark$default$4(), this.runSpark$default$5(), this.runSpark$default$6(), this.runSpark$default$7(), this.runSpark$default$8(), this.runSpark$default$9());
            return this.convertToAnyShouldWrapper(finalState, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155), Prettifier$.MODULE$.default()).should(this.be().apply((Object)SparkAppHandle.State.FAILED));
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("run Spark in yarn-cluster mode failure after sc initialized", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkAppHandle.State finalState = this.runSpark(false, this.mainClassName(YarnClusterDriverWithFailure$.MODULE$.getClass()), this.runSpark$default$3(), this.runSpark$default$4(), this.runSpark$default$5(), this.runSpark$default$6(), this.runSpark$default$7(), this.runSpark$default$8(), this.runSpark$default$9());
            return this.convertToAnyShouldWrapper(finalState, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160), Prettifier$.MODULE$.default()).should(this.be().apply((Object)SparkAppHandle.State.FAILED));
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("run Python application in yarn-client mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testPySpark(true, this.testPySpark$default$2(), this.testPySpark$default$3()), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        this.test("run Python application in yarn-cluster mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testPySpark(false, this.testPySpark$default$2(), this.testPySpark$default$3()), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test("run Python application in yarn-cluster mode using spark.yarn.appMasterEnv to override local envvar", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testPySpark(false, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.PYSPARK_DRIVER_PYTHON"), scala.sys.package$.MODULE$.env().getOrElse((Object)"PYSPARK_DRIVER_PYTHON", (Function0 & Serializable & scala.Serializable)() -> "python")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.appMasterEnv.PYSPARK_PYTHON"), scala.sys.package$.MODULE$.env().getOrElse((Object)"PYSPARK_PYTHON", (Function0 & Serializable & scala.Serializable)() -> "python"))}))), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYSPARK_DRIVER_PYTHON"), (Object)"not python"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYSPARK_PYTHON"), (Object)"not python")})))), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        this.test("user class path first in client mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testUseClassPathFirst(true), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
        this.test("user class path first in cluster mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testUseClassPathFirst(false), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        this.test("monitor app using launcher library", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("YARN_CONF_DIR", this.hadoopConfDir().getAbsolutePath());
            String propsFile = this.createConfFile(this.createConfFile$default$1(), this.createConfFile$default$2());
            SparkAppHandle handle = new SparkLauncher(env).setSparkHome((String)scala.sys.package$.MODULE$.props().apply((Object)"spark.test.home")).setConf(UI$.MODULE$.UI_ENABLED().key(), "false").setPropertiesFile(propsFile).setMaster("yarn").setDeployMode("client").setAppResource("spark-internal").setMainClass(this.mainClassName(YarnLauncherTestApp$.MODULE$.getClass())).startApplication(new SparkAppHandle.Listener[0]);
            try {
                Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).minutes())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).milliseconds())), (Function0 & Serializable & scala.Serializable)() -> this.convertToAnyShouldWrapper(handle.getState(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210), Prettifier$.MODULE$.default()).should(this.be().apply((Object)SparkAppHandle.State.RUNNING)), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
                this.convertToStringShouldWrapper(handle.getAppId(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213), Prettifier$.MODULE$.default()).should(this.not()).be(null, Predef$.MODULE$.$conforms());
                this.convertToStringShouldWrapper(handle.getAppId(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214), Prettifier$.MODULE$.default()).should(this.startWith().apply("application_"));
                handle.stop();
                object = Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).minutes())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).milliseconds())), (Function0 & Serializable & scala.Serializable)() -> this.convertToAnyShouldWrapper(handle.getState(), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218), Prettifier$.MODULE$.default()).should(this.be().apply((Object)SparkAppHandle.State.KILLED)), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
            }
            finally {
                handle.kill();
            }
            return object;
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        this.test("timeout to get SparkContext in cluster mode triggers failure", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int timeout = 2000;
            boolean x$10 = false;
            String x$11 = this.mainClassName(SparkContextTimeoutApp$.MODULE$.getClass());
            Seq x$12 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)(timeout * 4))).toString()}));
            Map x$13 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.AM_MAX_WAIT_TIME().key()), (Object)((Object)BoxesRunTime.boxToInteger((int)timeout)).toString())}));
            Seq<Tuple2<String, String>> x$14 = this.runSpark$default$4();
            Seq<String> x$15 = this.runSpark$default$5();
            Seq<String> x$16 = this.runSpark$default$6();
            Map<String, String> x$17 = this.runSpark$default$8();
            Option<File> x$18 = this.runSpark$default$9();
            SparkAppHandle.State finalState = this.runSpark(x$10, x$11, (Seq<String>)x$12, x$14, x$15, x$16, (Map<String, String>)x$13, x$17, x$18);
            return this.convertToAnyShouldWrapper(finalState, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230), Prettifier$.MODULE$.default()).should(this.be().apply((Object)SparkAppHandle.State.FAILED));
        }, new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        this.test("executor env overwrite AM env in client mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testExecutorEnv(true), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        this.test("executor env overwrite AM env in cluster mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testExecutorEnv(false), new Position("YarnClusterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
    }
}

