/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.yarn;

import com.codahale.metrics.MetricSet;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.api.ApplicationInitializationContext;
import org.apache.hadoop.yarn.server.api.ApplicationTerminationContext;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.network.shuffle.ExternalBlockHandler;
import org.apache.spark.network.shuffle.ExternalShuffleBlockResolver;
import org.apache.spark.network.shuffle.ShuffleTestAccessor$;
import org.apache.spark.network.shuffle.protocol.ExecutorShuffleInfo;
import org.apache.spark.network.yarn.YarnShuffleService;
import org.apache.spark.network.yarn.YarnShuffleServiceMetrics;
import org.apache.spark.util.Utils$;
import org.iq80.leveldb.DB;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality;
import org.scalactic.Explicitly;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.Tolerance;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Entry;
import org.scalatest.Matchers;
import org.scalatest.Matchers$AllCollected$;
import org.scalatest.Matchers$AtLeastCollected$;
import org.scalatest.Matchers$AtMostCollected$;
import org.scalatest.Matchers$BetweenCollected$;
import org.scalatest.Matchers$EveryCollected$;
import org.scalatest.Matchers$ExactlyCollected$;
import org.scalatest.Matchers$NoCollected$;
import org.scalatest.Matchers$ShouldMethodHelper$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.enablers.Collecting;
import org.scalatest.enablers.Emptiness$;
import org.scalatest.matchers.Matcher;
import org.scalatest.matchers.MatcherFactory1;
import org.scalatest.time.Span$;
import org.scalatest.words.BeWord;
import org.scalatest.words.CompileWord;
import org.scalatest.words.ContainWord;
import org.scalatest.words.DefinedWord;
import org.scalatest.words.EmptyWord;
import org.scalatest.words.EndWithWord;
import org.scalatest.words.ExistWord;
import org.scalatest.words.FullyMatchWord;
import org.scalatest.words.HaveWord;
import org.scalatest.words.IncludeWord;
import org.scalatest.words.LengthWord;
import org.scalatest.words.MatchPatternWord;
import org.scalatest.words.MatcherWords;
import org.scalatest.words.NoExceptionWord;
import org.scalatest.words.NotWord;
import org.scalatest.words.ReadableWord;
import org.scalatest.words.ResultOfATypeInvocation;
import org.scalatest.words.ResultOfAllElementsOfApplication;
import org.scalatest.words.ResultOfAllOfApplication;
import org.scalatest.words.ResultOfAnTypeInvocation;
import org.scalatest.words.ResultOfAtLeastOneElementOfApplication;
import org.scalatest.words.ResultOfAtLeastOneOfApplication;
import org.scalatest.words.ResultOfAtMostOneElementOfApplication;
import org.scalatest.words.ResultOfAtMostOneOfApplication;
import org.scalatest.words.ResultOfDefinedAt;
import org.scalatest.words.ResultOfGreaterThanComparison;
import org.scalatest.words.ResultOfGreaterThanOrEqualToComparison;
import org.scalatest.words.ResultOfInOrderApplication;
import org.scalatest.words.ResultOfInOrderElementsOfApplication;
import org.scalatest.words.ResultOfInOrderOnlyApplication;
import org.scalatest.words.ResultOfLessThanComparison;
import org.scalatest.words.ResultOfLessThanOrEqualToComparison;
import org.scalatest.words.ResultOfMessageWordApplication;
import org.scalatest.words.ResultOfNoElementsOfApplication;
import org.scalatest.words.ResultOfNoneOfApplication;
import org.scalatest.words.ResultOfOfTypeInvocation;
import org.scalatest.words.ResultOfOneElementOfApplication;
import org.scalatest.words.ResultOfOneOfApplication;
import org.scalatest.words.ResultOfOnlyApplication;
import org.scalatest.words.ResultOfTheSameElementsAsApplication;
import org.scalatest.words.ResultOfTheSameElementsInOrderAsApplication;
import org.scalatest.words.ResultOfTheTypeInvocation;
import org.scalatest.words.ResultOfThrownByApplication;
import org.scalatest.words.ShouldVerb;
import org.scalatest.words.SizeWord;
import org.scalatest.words.SortedWord;
import org.scalatest.words.StartWithWord;
import org.scalatest.words.TypeCheckWord;
import org.scalatest.words.WritableWord;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.GenTraversable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001\u0002\f\u0018\u0001\tBQ\u0001\r\u0001\u0005\u0002EB\u0001\u0002\u000e\u0001A\u0002\u0013\u0005q#\u000e\u0005\t\u007f\u0001\u0001\r\u0011\"\u0001\u0018\u0001\"1\u0011\n\u0001Q!\nYB\u0001B\u0013\u0001C\u0002\u0013\u0005qc\u0013\u0005\u0007)\u0002\u0001\u000b\u0011\u0002'\t\u0013U\u0003\u0001\u0019!a\u0001\n\u00131\u0006\"C/\u0001\u0001\u0004\u0005\r\u0011\"\u0003_\u0011%\u0001\u0007\u00011A\u0001B\u0003&q\u000bC\u0003b\u0001\u0011\u0005#\rC\u0004d\u0001\u0001\u0007I\u0011\u00013\t\u000f!\u0004\u0001\u0019!C\u0001S\"11\u000e\u0001Q!\n\u0015Dq\u0001\u001c\u0001A\u0002\u0013\u0005A\rC\u0004n\u0001\u0001\u0007I\u0011\u00018\t\rA\u0004\u0001\u0015)\u0003f\u0011\u001d\t\b\u00011A\u0005\u0002\u0011DqA\u001d\u0001A\u0002\u0013\u00051\u000f\u0003\u0004v\u0001\u0001\u0006K!\u001a\u0005\u0006m\u0002!\tE\u0019\u0005\u0006o\u0002!I\u0001\u001f\u0002\u00183\u0006\u0014hn\u00155vM\u001adWmU3sm&\u001cWmU;ji\u0016T!\u0001G\r\u0002\te\f'O\u001c\u0006\u00035m\tqA\\3uo>\u00148N\u0003\u0002\u001d;\u0005)1\u000f]1sW*\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u0012([A\u0011A%J\u0007\u00027%\u0011ae\u0007\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005!ZS\"A\u0015\u000b\u0005)z\u0012!C:dC2\fG/Z:u\u0013\ta\u0013F\u0001\u0005NCR\u001c\u0007.\u001a:t!\tAc&\u0003\u00020S\t\u0011\")\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014X)Y2i\u0003\u0019a\u0014N\\5u}Q\t!\u0007\u0005\u00024\u00015\tq#\u0001\u0006zCJt7i\u001c8gS\u001e,\u0012A\u000e\t\u0003ouj\u0011\u0001\u000f\u0006\u0003si\nAaY8oM*\u0011\u0001d\u000f\u0006\u0003yu\ta\u0001[1e_>\u0004\u0018B\u0001 9\u0005EI\u0016M\u001d8D_:4\u0017nZ;sCRLwN\\\u0001\u000fs\u0006\u0014hnQ8oM&<w\fJ3r)\t\tu\t\u0005\u0002C\u000b6\t1IC\u0001E\u0003\u0015\u00198-\u00197b\u0013\t15I\u0001\u0003V]&$\bb\u0002%\u0004\u0003\u0003\u0005\rAN\u0001\u0004q\u0012\n\u0014aC=be:\u001cuN\u001c4jO\u0002\nAbU(S)~k\u0015IT!H\u000bJ+\u0012\u0001\u0014\t\u0003\u001bJk\u0011A\u0014\u0006\u0003\u001fB\u000bA\u0001\\1oO*\t\u0011+\u0001\u0003kCZ\f\u0017BA*O\u0005\u0019\u0019FO]5oO\u0006i1k\u0014*U?6\u000be*Q$F%\u0002\n\u0001C]3d_Z,'/\u001f'pG\u0006dG)\u001b:\u0016\u0003]\u0003\"\u0001W.\u000e\u0003eS!A\u0017)\u0002\u0005%|\u0017B\u0001/Z\u0005\u00111\u0015\u000e\\3\u0002)I,7m\u001c<fefdunY1m\t&\u0014x\fJ3r)\t\tu\fC\u0004I\u0011\u0005\u0005\t\u0019A,\u0002#I,7m\u001c<fefdunY1m\t&\u0014\b%\u0001\u0006cK\u001a|'/Z#bG\"$\u0012!Q\u0001\u0003gF*\u0012!\u001a\t\u0003g\u0019L!aZ\f\u0003%e\u000b'O\\*ik\u001a4G.Z*feZL7-Z\u0001\u0007gFzF%Z9\u0015\u0005\u0005S\u0007b\u0002%\r\u0003\u0003\u0005\r!Z\u0001\u0004gF\u0002\u0013AA:3\u0003\u0019\u0019(g\u0018\u0013fcR\u0011\u0011i\u001c\u0005\b\u0011>\t\t\u00111\u0001f\u0003\r\u0019(\u0007I\u0001\u0003gN\naa]\u001a`I\u0015\fHCA!u\u0011\u001dA%#!AA\u0002\u0015\f1a]\u001a!\u0003%\tg\r^3s\u000b\u0006\u001c\u0007.A\u0006nC.,\u0017\t\u001d9J]\u001a|G#B=\u0002\u0004\u0005m\u0001C\u0001>\u0000\u001b\u0005Y(B\u0001?~\u0003\r\t\u0007/\u001b\u0006\u0003}j\naa]3sm\u0016\u0014\u0018bAA\u0001w\n\u0001\u0013\t\u001d9mS\u000e\fG/[8o\u0013:LG/[1mSj\fG/[8o\u0007>tG/\u001a=u\u0011\u001d\t)!\u0006a\u0001\u0003\u000f\tA!^:feB!\u0011\u0011BA\f\u001d\u0011\tY!a\u0005\u0011\u0007\u000551)\u0004\u0002\u0002\u0010)\u0019\u0011\u0011C\u0011\u0002\rq\u0012xn\u001c;?\u0013\r\t)bQ\u0001\u0007!J,G-\u001a4\n\u0007M\u000bIBC\u0002\u0002\u0016\rCq!!\b\u0016\u0001\u0004\ty\"A\u0003baBLE\r\u0005\u0003\u0002\"\u0005%RBAA\u0012\u0015\u0011\t)#a\n\u0002\u000fI,7m\u001c:eg*\u0011APO\u0005\u0005\u0003W\t\u0019CA\u0007BaBd\u0017nY1uS>t\u0017\n\u001a")
public class YarnShuffleServiceSuite
extends SparkFunSuite
implements Matchers {
    private YarnConfiguration yarnConfig;
    private final String SORT_MANAGER;
    private File recoveryLocalDir;
    private YarnShuffleService s1;
    private YarnShuffleService s2;
    private YarnShuffleService s3;
    private final Matchers.KeyWord key;
    private final Matchers.ValueWord value;
    private final Matchers.AWord a;
    private final Matchers.AnWord an;
    private final Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private final Matchers.RegexWord regex;
    private volatile Matchers$AllCollected$ AllCollected$module;
    private volatile Matchers$EveryCollected$ EveryCollected$module;
    private volatile Matchers$BetweenCollected$ BetweenCollected$module;
    private volatile Matchers$AtLeastCollected$ AtLeastCollected$module;
    private volatile Matchers$AtMostCollected$ AtMostCollected$module;
    private volatile Matchers$NoCollected$ NoCollected$module;
    private volatile Matchers$ExactlyCollected$ ExactlyCollected$module;
    private volatile Matchers$ShouldMethodHelper$ ShouldMethodHelper$module;
    private final Explicitly.DecidedWord decided;
    private final Explicitly.DeterminedWord determined;
    private final Explicitly.TheAfterWord after;
    private final FullyMatchWord fullyMatch;
    private final StartWithWord startWith;
    private final EndWithWord endWith;
    private final IncludeWord include;
    private final HaveWord have;
    private final BeWord be;
    private final ContainWord contain;
    private final NotWord not;
    private final LengthWord length;
    private final SizeWord size;
    private final SortedWord sorted;
    private final DefinedWord defined;
    private final ExistWord exist;
    private final ReadableWord readable;
    private final WritableWord writable;
    private final EmptyWord empty;
    private final CompileWord compile;
    private final TypeCheckWord typeCheck;
    private final MatchPatternWord matchPattern;

    public Matchers.HavePropertyMatcherGenerator convertSymbolToHavePropertyMatcherGenerator(Symbol symbol, Prettifier prettifier, Position pos) {
        return Matchers.convertSymbolToHavePropertyMatcherGenerator$((Matchers)this, (Symbol)symbol, (Prettifier)prettifier, (Position)pos);
    }

    public <T> Matcher<T> equal(TripleEqualsSupport.Spread<T> spread) {
        return Matchers.equal$((Matchers)this, spread);
    }

    public Matcher<Object> equal(Null$ o) {
        return Matchers.equal$((Matchers)this, (Null$)o);
    }

    public <T> ResultOfLessThanComparison<T> $less(T right, Ordering<T> evidence$1) {
        return Matchers.$less$((Matchers)this, right, evidence$1);
    }

    public <T> ResultOfGreaterThanComparison<T> $greater(T right, Ordering<T> evidence$2) {
        return Matchers.$greater$((Matchers)this, right, evidence$2);
    }

    public <T> ResultOfLessThanOrEqualToComparison<T> $less$eq(T right, Ordering<T> evidence$3) {
        return Matchers.$less$eq$((Matchers)this, right, evidence$3);
    }

    public <T> ResultOfGreaterThanOrEqualToComparison<T> $greater$eq(T right, Ordering<T> evidence$4) {
        return Matchers.$greater$eq$((Matchers)this, right, evidence$4);
    }

    public <T> ResultOfDefinedAt<T> definedAt(T right) {
        return Matchers.definedAt$((Matchers)this, right);
    }

    public ResultOfOneOfApplication oneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.oneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfOneElementOfApplication oneElementOf(GenTraversable<Object> elements) {
        return Matchers.oneElementOf$((Matchers)this, elements);
    }

    public ResultOfAtLeastOneOfApplication atLeastOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atLeastOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAtLeastOneElementOfApplication atLeastOneElementOf(GenTraversable<Object> elements) {
        return Matchers.atLeastOneElementOf$((Matchers)this, elements);
    }

    public ResultOfNoneOfApplication noneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.noneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfNoElementsOfApplication noElementsOf(GenTraversable<Object> elements) {
        return Matchers.noElementsOf$((Matchers)this, elements);
    }

    public ResultOfTheSameElementsAsApplication theSameElementsAs(GenTraversable<?> xs) {
        return Matchers.theSameElementsAs$((Matchers)this, xs);
    }

    public ResultOfTheSameElementsInOrderAsApplication theSameElementsInOrderAs(GenTraversable<?> xs) {
        return Matchers.theSameElementsInOrderAs$((Matchers)this, xs);
    }

    public ResultOfOnlyApplication only(Seq<Object> xs, Position pos) {
        return Matchers.only$((Matchers)this, xs, (Position)pos);
    }

    public <T> ResultOfInOrderOnlyApplication inOrderOnly(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrderOnly$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAllOfApplication allOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.allOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAllElementsOfApplication allElementsOf(GenTraversable<R> elements) {
        return Matchers.allElementsOf$((Matchers)this, elements);
    }

    public ResultOfInOrderApplication inOrder(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrder$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfInOrderElementsOfApplication inOrderElementsOf(GenTraversable<R> elements) {
        return Matchers.inOrderElementsOf$((Matchers)this, elements);
    }

    public ResultOfAtMostOneOfApplication atMostOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atMostOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAtMostOneElementOfApplication atMostOneElementOf(GenTraversable<R> elements) {
        return Matchers.atMostOneElementOf$((Matchers)this, elements);
    }

    public ResultOfThrownByApplication thrownBy(Function0<Object> fun) {
        return Matchers.thrownBy$((Matchers)this, fun);
    }

    public ResultOfMessageWordApplication message(String expectedMessage) {
        return Matchers.message$((Matchers)this, (String)expectedMessage);
    }

    public <T> Assertion doCollected(Matchers.Collected collected, GenTraversable<T> xs, Object original, Prettifier prettifier, Position pos, Function1<T, Assertion> fun) {
        return Matchers.doCollected$((Matchers)this, (Matchers.Collected)collected, xs, (Object)original, (Prettifier)prettifier, (Position)pos, fun);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> all(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends GenMap<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> all(MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> all(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> all(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atLeast(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends GenMap<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> atLeast(int num, MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atLeast(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atLeast(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> every(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> every(MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> every(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> every(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> exactly(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends GenMap<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> exactly(int num, MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> exactly(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> exactly(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> no(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> no(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> no(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> between(int from, int upTo, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> between(int from, int upTo, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> between(int from, int upTo, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atMost(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends GenMap<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> atMost(int num, MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atMost(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atMost(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <T> ResultOfATypeInvocation<T> a(ClassTag<T> evidence$5) {
        return Matchers.a$((Matchers)this, evidence$5);
    }

    public <T> ResultOfAnTypeInvocation<T> an(ClassTag<T> evidence$6) {
        return Matchers.an$((Matchers)this, evidence$6);
    }

    public <T> ResultOfTheTypeInvocation<T> the(ClassTag<T> evidence$7, Position pos) {
        return Matchers.the$((Matchers)this, evidence$7, (Position)pos);
    }

    public <T> Matchers.AnyShouldWrapper<T> convertToAnyShouldWrapper(T o, Position pos, Prettifier prettifier) {
        return Matchers.convertToAnyShouldWrapper$((Matchers)this, o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.StringShouldWrapper convertToStringShouldWrapper(String o, Position pos, Prettifier prettifier) {
        return Matchers.convertToStringShouldWrapper$((Matchers)this, (String)o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.RegexWrapper convertToRegexWrapper(Regex o) {
        return Matchers.convertToRegexWrapper$((Matchers)this, (Regex)o);
    }

    public <T> ResultOfOfTypeInvocation<T> of(ClassTag<T> ev) {
        return Matchers.of$((Matchers)this, ev);
    }

    public NoExceptionWord noException(Position pos) {
        return MatcherWords.noException$((MatcherWords)this, (Position)pos);
    }

    public MatcherFactory1<Object, Equality> equal(Object right) {
        return MatcherWords.equal$((MatcherWords)this, (Object)right);
    }

    public ShouldVerb.StringShouldWrapperForVerb convertToStringShouldWrapperForVerb(String o, Position position) {
        return ShouldVerb.convertToStringShouldWrapperForVerb$((ShouldVerb)this, (String)o, (Position)position);
    }

    public <T> Tolerance.PlusOrMinusWrapper<T> convertNumericToPlusOrMinusWrapper(T pivot, Numeric<T> evidence$2) {
        return Tolerance.convertNumericToPlusOrMinusWrapper$((Tolerance)this, pivot, evidence$2);
    }

    public Matchers.KeyWord key() {
        return this.key;
    }

    public Matchers.ValueWord value() {
        return this.value;
    }

    public Matchers.AWord a() {
        return this.a;
    }

    public Matchers.AnWord an() {
        return this.an;
    }

    public Matchers.TheSameInstanceAsPhrase theSameInstanceAs() {
        return this.theSameInstanceAs;
    }

    public Matchers.RegexWord regex() {
        return this.regex;
    }

    public Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected() {
        if (this.AllCollected$module == null) {
            this.org$scalatest$Matchers$$AllCollected$lzycompute$1();
        }
        return this.AllCollected$module;
    }

    public Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected() {
        if (this.EveryCollected$module == null) {
            this.org$scalatest$Matchers$$EveryCollected$lzycompute$1();
        }
        return this.EveryCollected$module;
    }

    public Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected() {
        if (this.BetweenCollected$module == null) {
            this.org$scalatest$Matchers$$BetweenCollected$lzycompute$1();
        }
        return this.BetweenCollected$module;
    }

    public Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected() {
        if (this.AtLeastCollected$module == null) {
            this.org$scalatest$Matchers$$AtLeastCollected$lzycompute$1();
        }
        return this.AtLeastCollected$module;
    }

    public Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected() {
        if (this.AtMostCollected$module == null) {
            this.org$scalatest$Matchers$$AtMostCollected$lzycompute$1();
        }
        return this.AtMostCollected$module;
    }

    public Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected() {
        if (this.NoCollected$module == null) {
            this.org$scalatest$Matchers$$NoCollected$lzycompute$1();
        }
        return this.NoCollected$module;
    }

    public Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected() {
        if (this.ExactlyCollected$module == null) {
            this.org$scalatest$Matchers$$ExactlyCollected$lzycompute$1();
        }
        return this.ExactlyCollected$module;
    }

    public Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper() {
        if (this.ShouldMethodHelper$module == null) {
            this.org$scalatest$Matchers$$ShouldMethodHelper$lzycompute$1();
        }
        return this.ShouldMethodHelper$module;
    }

    public void org$scalatest$Matchers$_setter_$key_$eq(Matchers.KeyWord x$1) {
        this.key = x$1;
    }

    public void org$scalatest$Matchers$_setter_$value_$eq(Matchers.ValueWord x$1) {
        this.value = x$1;
    }

    public void org$scalatest$Matchers$_setter_$a_$eq(Matchers.AWord x$1) {
        this.a = x$1;
    }

    public void org$scalatest$Matchers$_setter_$an_$eq(Matchers.AnWord x$1) {
        this.an = x$1;
    }

    public void org$scalatest$Matchers$_setter_$theSameInstanceAs_$eq(Matchers.TheSameInstanceAsPhrase x$1) {
        this.theSameInstanceAs = x$1;
    }

    public void org$scalatest$Matchers$_setter_$regex_$eq(Matchers.RegexWord x$1) {
        this.regex = x$1;
    }

    public Explicitly.DecidedWord decided() {
        return this.decided;
    }

    public Explicitly.DeterminedWord determined() {
        return this.determined;
    }

    public Explicitly.TheAfterWord after() {
        return this.after;
    }

    public void org$scalactic$Explicitly$_setter_$decided_$eq(Explicitly.DecidedWord x$1) {
        this.decided = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$determined_$eq(Explicitly.DeterminedWord x$1) {
        this.determined = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$after_$eq(Explicitly.TheAfterWord x$1) {
        this.after = x$1;
    }

    public FullyMatchWord fullyMatch() {
        return this.fullyMatch;
    }

    public StartWithWord startWith() {
        return this.startWith;
    }

    public EndWithWord endWith() {
        return this.endWith;
    }

    public IncludeWord include() {
        return this.include;
    }

    public HaveWord have() {
        return this.have;
    }

    public BeWord be() {
        return this.be;
    }

    public ContainWord contain() {
        return this.contain;
    }

    public NotWord not() {
        return this.not;
    }

    public LengthWord length() {
        return this.length;
    }

    public SizeWord size() {
        return this.size;
    }

    public SortedWord sorted() {
        return this.sorted;
    }

    public DefinedWord defined() {
        return this.defined;
    }

    public ExistWord exist() {
        return this.exist;
    }

    public ReadableWord readable() {
        return this.readable;
    }

    public WritableWord writable() {
        return this.writable;
    }

    public EmptyWord empty() {
        return this.empty;
    }

    public CompileWord compile() {
        return this.compile;
    }

    public TypeCheckWord typeCheck() {
        return this.typeCheck;
    }

    public MatchPatternWord matchPattern() {
        return this.matchPattern;
    }

    public void org$scalatest$words$MatcherWords$_setter_$fullyMatch_$eq(FullyMatchWord x$1) {
        this.fullyMatch = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$startWith_$eq(StartWithWord x$1) {
        this.startWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$endWith_$eq(EndWithWord x$1) {
        this.endWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$include_$eq(IncludeWord x$1) {
        this.include = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$have_$eq(HaveWord x$1) {
        this.have = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$be_$eq(BeWord x$1) {
        this.be = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$contain_$eq(ContainWord x$1) {
        this.contain = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$not_$eq(NotWord x$1) {
        this.not = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$length_$eq(LengthWord x$1) {
        this.length = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$size_$eq(SizeWord x$1) {
        this.size = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$sorted_$eq(SortedWord x$1) {
        this.sorted = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$defined_$eq(DefinedWord x$1) {
        this.defined = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$exist_$eq(ExistWord x$1) {
        this.exist = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$readable_$eq(ReadableWord x$1) {
        this.readable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$writable_$eq(WritableWord x$1) {
        this.writable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$empty_$eq(EmptyWord x$1) {
        this.empty = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$compile_$eq(CompileWord x$1) {
        this.compile = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$typeCheck_$eq(TypeCheckWord x$1) {
        this.typeCheck = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$matchPattern_$eq(MatchPatternWord x$1) {
        this.matchPattern = x$1;
    }

    public YarnConfiguration yarnConfig() {
        return this.yarnConfig;
    }

    public void yarnConfig_$eq(YarnConfiguration x$1) {
        this.yarnConfig = x$1;
    }

    public String SORT_MANAGER() {
        return this.SORT_MANAGER;
    }

    private File recoveryLocalDir() {
        return this.recoveryLocalDir;
    }

    private void recoveryLocalDir_$eq(File x$1) {
        this.recoveryLocalDir = x$1;
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        this.yarnConfig_$eq(new YarnConfiguration());
        this.yarnConfig().set("yarn.nodemanager.aux-services", "spark_shuffle");
        this.yarnConfig().set(new StringOps(Predef$.MODULE$.augmentString("yarn.nodemanager.aux-services.%s.class")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"spark_shuffle"})), YarnShuffleService.class.getCanonicalName());
        this.yarnConfig().setInt(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_PORT().key(), 0);
        this.yarnConfig().setBoolean("spark.yarn.shuffle.stopOnFailure", true);
        File localDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        this.yarnConfig().set("yarn.nodemanager.local-dirs", localDir.getAbsolutePath());
        this.recoveryLocalDir_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
    }

    public YarnShuffleService s1() {
        return this.s1;
    }

    public void s1_$eq(YarnShuffleService x$1) {
        this.s1 = x$1;
    }

    public YarnShuffleService s2() {
        return this.s2;
    }

    public void s2_$eq(YarnShuffleService x$1) {
        this.s2 = x$1;
    }

    public YarnShuffleService s3() {
        return this.s3;
    }

    public void s3_$eq(YarnShuffleService x$1) {
        this.s3 = x$1;
    }

    public void afterEach() {
        try {
            if (this.s1() != null) {
                this.s1().stop();
                this.s1_$eq(null);
            }
            if (this.s2() != null) {
                this.s2().stop();
                this.s2_$eq(null);
            }
            if (this.s3() != null) {
                this.s3().stop();
                this.s3_$eq(null);
            }
        }
        finally {
            BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
        }
    }

    private ApplicationInitializationContext makeAppInfo(String user, ApplicationId appId) {
        ByteBuffer secret = ByteBuffer.wrap(new byte[0]);
        return new ApplicationInitializationContext(user, appId, secret);
    }

    private final void org$scalatest$Matchers$$AllCollected$lzycompute$1() {
        YarnShuffleServiceSuite yarnShuffleServiceSuite = this;
        synchronized (yarnShuffleServiceSuite) {
            if (this.AllCollected$module == null) {
                this.AllCollected$module = new Matchers$AllCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$EveryCollected$lzycompute$1() {
        YarnShuffleServiceSuite yarnShuffleServiceSuite = this;
        synchronized (yarnShuffleServiceSuite) {
            if (this.EveryCollected$module == null) {
                this.EveryCollected$module = new Matchers$EveryCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$BetweenCollected$lzycompute$1() {
        YarnShuffleServiceSuite yarnShuffleServiceSuite = this;
        synchronized (yarnShuffleServiceSuite) {
            if (this.BetweenCollected$module == null) {
                this.BetweenCollected$module = new Matchers$BetweenCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$AtLeastCollected$lzycompute$1() {
        YarnShuffleServiceSuite yarnShuffleServiceSuite = this;
        synchronized (yarnShuffleServiceSuite) {
            if (this.AtLeastCollected$module == null) {
                this.AtLeastCollected$module = new Matchers$AtLeastCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$AtMostCollected$lzycompute$1() {
        YarnShuffleServiceSuite yarnShuffleServiceSuite = this;
        synchronized (yarnShuffleServiceSuite) {
            if (this.AtMostCollected$module == null) {
                this.AtMostCollected$module = new Matchers$AtMostCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$NoCollected$lzycompute$1() {
        YarnShuffleServiceSuite yarnShuffleServiceSuite = this;
        synchronized (yarnShuffleServiceSuite) {
            if (this.NoCollected$module == null) {
                this.NoCollected$module = new Matchers$NoCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$ExactlyCollected$lzycompute$1() {
        YarnShuffleServiceSuite yarnShuffleServiceSuite = this;
        synchronized (yarnShuffleServiceSuite) {
            if (this.ExactlyCollected$module == null) {
                this.ExactlyCollected$module = new Matchers$ExactlyCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$ShouldMethodHelper$lzycompute$1() {
        YarnShuffleServiceSuite yarnShuffleServiceSuite = this;
        synchronized (yarnShuffleServiceSuite) {
            if (this.ShouldMethodHelper$module == null) {
                this.ShouldMethodHelper$module = new Matchers$ShouldMethodHelper$((Matchers)this);
            }
        }
    }

    private final File findExistingParent$1(File file) {
        File file2;
        while (true) {
            if (file == null) {
                file2 = file;
                break;
            }
            if (file.exists()) {
                file2 = file;
                break;
            }
            file = file.getParentFile();
        }
        return file2;
    }

    public YarnShuffleServiceSuite() {
        Tolerance.$init$((Tolerance)this);
        ShouldVerb.$init$((ShouldVerb)this);
        MatcherWords.$init$((MatcherWords)this);
        Explicitly.$init$((Explicitly)this);
        Matchers.$init$((Matchers)this);
        this.yarnConfig = null;
        this.SORT_MANAGER = "org.apache.spark.shuffle.sort.SortShuffleManager";
        this.s1 = null;
        this.s2 = null;
        this.s3 = null;
        this.test("executor state kept across NM restart", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            this.s1_$eq(new YarnShuffleService());
            this.s1().setRecoveryPath(new Path(this.recoveryLocalDir().toURI()));
            this.yarnConfig().setBoolean(SecurityManager$.MODULE$.SPARK_AUTH_CONF(), true);
            this.s1().init((Configuration)this.yarnConfig());
            ApplicationId app1Id = ApplicationId.newInstance((long)0L, (int)1);
            ApplicationInitializationContext app1Data = this.makeAppInfo("user", app1Id);
            this.s1().initializeApplication(app1Data);
            ApplicationId app2Id = ApplicationId.newInstance((long)0L, (int)2);
            ApplicationInitializationContext app2Data = this.makeAppInfo("user", app2Id);
            this.s1().initializeApplication(app2Data);
            File execStateFile = $this.s1().registeredExecutorFile;
            this.convertToAnyShouldWrapper(execStateFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104), Prettifier$.MODULE$.default()).should(this.not()).be(null, Predef$.MODULE$.$conforms());
            File secretsFile = $this.s1().secretsFile;
            this.convertToAnyShouldWrapper(secretsFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106), Prettifier$.MODULE$.default()).should(this.not()).be(null, Predef$.MODULE$.$conforms());
            ExecutorShuffleInfo shuffleInfo1 = new ExecutorShuffleInfo((String[])((Object[])new String[]{"/foo", "/bar"}), 3, this.SORT_MANAGER());
            ExecutorShuffleInfo shuffleInfo2 = new ExecutorShuffleInfo((String[])((Object[])new String[]{"/bippy"}), 5, this.SORT_MANAGER());
            ExternalBlockHandler blockHandler = $this.s1().blockHandler;
            ExternalShuffleBlockResolver blockResolver = ShuffleTestAccessor$.MODULE$.getBlockResolver(blockHandler);
            this.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.registeredExecutorFile(blockResolver), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112), Prettifier$.MODULE$.default()).should(this.be().apply((Object)execStateFile));
            blockResolver.registerExecutor(app1Id.toString(), "exec-1", shuffleInfo1);
            blockResolver.registerExecutor(app2Id.toString(), "exec-2", shuffleInfo2);
            this.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app1Id, "exec-1", blockResolver), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)shuffleInfo1)));
            this.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app2Id, "exec-2", blockResolver), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)shuffleInfo2)));
            if (!execStateFile.exists()) {
                File existingParent = this.findExistingParent$1(execStateFile);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                boxedUnit = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(46).append(execStateFile).append(" does not exist -- closest existing parent is ").append(existingParent).toString(), Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(execStateFile.exists(), "execStateFile.exists()", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(14).append(execStateFile).append(" did not exist").toString(), Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            this.s1().stop();
            this.s2_$eq(new YarnShuffleService());
            this.s2().setRecoveryPath(new Path(this.recoveryLocalDir().toURI()));
            this.s2().init((Configuration)this.yarnConfig());
            this.convertToAnyShouldWrapper($this.s2().secretsFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137), Prettifier$.MODULE$.default()).should(this.be().apply((Object)secretsFile));
            this.convertToAnyShouldWrapper($this.s2().registeredExecutorFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138), Prettifier$.MODULE$.default()).should(this.be().apply((Object)execStateFile));
            ExternalBlockHandler handler2 = $this.s2().blockHandler;
            ExternalShuffleBlockResolver resolver2 = ShuffleTestAccessor$.MODULE$.getBlockResolver(handler2);
            this.s2().initializeApplication(app1Data);
            this.s2().stopApplication(new ApplicationTerminationContext(app2Id));
            this.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app1Id, "exec-1", resolver2), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)shuffleInfo1)));
            this.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app2Id, "exec-2", resolver2), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148), Prettifier$.MODULE$.default()).should(this.be().apply((Object)None$.MODULE$));
            this.s2().stop();
            this.s3_$eq(new YarnShuffleService());
            this.s3().setRecoveryPath(new Path(this.recoveryLocalDir().toURI()));
            this.s3().init((Configuration)this.yarnConfig());
            this.convertToAnyShouldWrapper($this.s3().registeredExecutorFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155), Prettifier$.MODULE$.default()).should(this.be().apply((Object)execStateFile));
            this.convertToAnyShouldWrapper($this.s3().secretsFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156), Prettifier$.MODULE$.default()).should(this.be().apply((Object)secretsFile));
            ExternalBlockHandler handler3 = $this.s3().blockHandler;
            ExternalShuffleBlockResolver resolver3 = ShuffleTestAccessor$.MODULE$.getBlockResolver(handler3);
            this.s3().initializeApplication(app1Data);
            this.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app1Id, "exec-1", resolver3), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)shuffleInfo1)));
            this.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app2Id, "exec-2", resolver3), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164), Prettifier$.MODULE$.default()).should(this.be().apply((Object)None$.MODULE$));
            this.s3().stop();
        }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("removed applications should not be in registered executor file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.s1_$eq(new YarnShuffleService());
            this.s1().setRecoveryPath(new Path(this.recoveryLocalDir().toURI()));
            this.yarnConfig().setBoolean(SecurityManager$.MODULE$.SPARK_AUTH_CONF(), false);
            this.s1().init((Configuration)this.yarnConfig());
            File secretsFile = $this.s1().secretsFile;
            this.convertToAnyShouldWrapper(secretsFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174), Prettifier$.MODULE$.default()).should(this.be().apply(null));
            ApplicationId app1Id = ApplicationId.newInstance((long)0L, (int)1);
            ApplicationInitializationContext app1Data = this.makeAppInfo("user", app1Id);
            this.s1().initializeApplication(app1Data);
            ApplicationId app2Id = ApplicationId.newInstance((long)0L, (int)2);
            ApplicationInitializationContext app2Data = this.makeAppInfo("user", app2Id);
            this.s1().initializeApplication(app2Data);
            File execStateFile = $this.s1().registeredExecutorFile;
            this.convertToAnyShouldWrapper(execStateFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183), Prettifier$.MODULE$.default()).should(this.not()).be(null, Predef$.MODULE$.$conforms());
            ExecutorShuffleInfo shuffleInfo1 = new ExecutorShuffleInfo((String[])((Object[])new String[]{"/foo", "/bar"}), 3, this.SORT_MANAGER());
            ExecutorShuffleInfo shuffleInfo2 = new ExecutorShuffleInfo((String[])((Object[])new String[]{"/bippy"}), 5, this.SORT_MANAGER());
            ExternalBlockHandler blockHandler = $this.s1().blockHandler;
            ExternalShuffleBlockResolver blockResolver = ShuffleTestAccessor$.MODULE$.getBlockResolver(blockHandler);
            this.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.registeredExecutorFile(blockResolver), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189), Prettifier$.MODULE$.default()).should(this.be().apply((Object)execStateFile));
            blockResolver.registerExecutor(app1Id.toString(), "exec-1", shuffleInfo1);
            blockResolver.registerExecutor(app2Id.toString(), "exec-2", shuffleInfo2);
            DB db = ShuffleTestAccessor$.MODULE$.shuffleServiceLevelDB(blockResolver);
            this.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.reloadRegisteredExecutors(db), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195), Prettifier$.MODULE$.default()).should(this.not()).be(this.empty(), Emptiness$.MODULE$.emptinessOfJavaMap());
            this.s1().stopApplication(new ApplicationTerminationContext(app1Id));
            this.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.reloadRegisteredExecutors(db), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198), Prettifier$.MODULE$.default()).should(this.not()).be(this.empty(), Emptiness$.MODULE$.emptinessOfJavaMap());
            this.s1().stopApplication(new ApplicationTerminationContext(app2Id));
            return this.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.reloadRegisteredExecutors(db), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200), Prettifier$.MODULE$.default()).shouldBe(this.empty(), Emptiness$.MODULE$.emptinessOfJavaMap());
        }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("shuffle service should be robust to corrupt registered executor file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.s1_$eq(new YarnShuffleService());
            this.s1().setRecoveryPath(new Path(this.recoveryLocalDir().toURI()));
            this.s1().init((Configuration)this.yarnConfig());
            ApplicationId app1Id = ApplicationId.newInstance((long)0L, (int)1);
            ApplicationInitializationContext app1Data = this.makeAppInfo("user", app1Id);
            this.s1().initializeApplication(app1Data);
            File execStateFile = $this.s1().registeredExecutorFile;
            ExecutorShuffleInfo shuffleInfo1 = new ExecutorShuffleInfo((String[])((Object[])new String[]{"/foo", "/bar"}), 3, this.SORT_MANAGER());
            ExternalBlockHandler blockHandler = $this.s1().blockHandler;
            ExternalShuffleBlockResolver blockResolver = ShuffleTestAccessor$.MODULE$.getBlockResolver(blockHandler);
            this.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.registeredExecutorFile(blockResolver), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216), Prettifier$.MODULE$.default()).should(this.be().apply((Object)execStateFile));
            blockResolver.registerExecutor(app1Id.toString(), "exec-1", shuffleInfo1);
            this.s1().stop();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])execStateFile.listFiles())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.delete()));
            DataOutputStream out = new DataOutputStream(new FileOutputStream(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)execStateFile), "/CURRENT")));
            out.writeInt(42);
            out.close();
            this.s2_$eq(new YarnShuffleService());
            this.s2().setRecoveryPath(new Path(this.recoveryLocalDir().toURI()));
            this.s2().init((Configuration)this.yarnConfig());
            this.convertToAnyShouldWrapper($this.s2().registeredExecutorFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233), Prettifier$.MODULE$.default()).should(this.be().apply((Object)execStateFile));
            ExternalBlockHandler handler2 = $this.s2().blockHandler;
            ExternalShuffleBlockResolver resolver2 = ShuffleTestAccessor$.MODULE$.getBlockResolver(handler2);
            this.s2().initializeApplication(app1Data);
            ApplicationId app2Id = ApplicationId.newInstance((long)0L, (int)2);
            ApplicationInitializationContext app2Data = this.makeAppInfo("user", app2Id);
            this.s2().initializeApplication(app2Data);
            ExecutorShuffleInfo shuffleInfo2 = new ExecutorShuffleInfo((String[])((Object[])new String[]{"/bippy"}), 5, this.SORT_MANAGER());
            resolver2.registerExecutor(app2Id.toString(), "exec-2", shuffleInfo2);
            this.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app2Id, "exec-2", resolver2), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)shuffleInfo2)));
            this.s2().stop();
            this.s3_$eq(new YarnShuffleService());
            this.s3().setRecoveryPath(new Path(this.recoveryLocalDir().toURI()));
            this.s3().init((Configuration)this.yarnConfig());
            this.convertToAnyShouldWrapper($this.s3().registeredExecutorFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253), Prettifier$.MODULE$.default()).should(this.be().apply((Object)execStateFile));
            ExternalBlockHandler handler3 = $this.s3().blockHandler;
            ExternalShuffleBlockResolver resolver3 = ShuffleTestAccessor$.MODULE$.getBlockResolver(handler3);
            this.s3().initializeApplication(app2Data);
            this.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app2Id, "exec-2", resolver3), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)shuffleInfo2)));
            this.s3().stop();
        }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        this.test("get correct recovery path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.s1_$eq(new YarnShuffleService());
            Path recoveryPath = new Path(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI());
            this.s1().setRecoveryPath(recoveryPath);
            this.s1().init((Configuration)this.yarnConfig());
            this.convertToAnyShouldWrapper($this.s1()._recoveryPath, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270), Prettifier$.MODULE$.default()).should(this.be().apply((Object)recoveryPath));
            this.s1().stop();
        }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        this.test("moving recovery file from NM local dir to recovery path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.s1_$eq(new YarnShuffleService());
            this.s1().setRecoveryPath(new Path(this.yarnConfig().getTrimmedStrings("yarn.nodemanager.local-dirs")[0]));
            this.yarnConfig().setBoolean(SecurityManager$.MODULE$.SPARK_AUTH_CONF(), true);
            this.s1().init((Configuration)this.yarnConfig());
            ApplicationId app1Id = ApplicationId.newInstance((long)0L, (int)1);
            ApplicationInitializationContext app1Data = this.makeAppInfo("user", app1Id);
            this.s1().initializeApplication(app1Data);
            ApplicationId app2Id = ApplicationId.newInstance((long)0L, (int)2);
            ApplicationInitializationContext app2Data = this.makeAppInfo("user", app2Id);
            this.s1().initializeApplication(app2Data);
            String $org_scalatest_assert_macro_left = $this.s1().secretManager.getSecretKey(app1Id.toString());
            Object $org_scalatest_assert_macro_right = null;
            String string = $org_scalatest_assert_macro_left;
            Object var8_7 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, string == null ? var8_7 != null : !string.equals(var8_7), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
            String $org_scalatest_assert_macro_left2 = $this.s1().secretManager.getSecretKey(app2Id.toString());
            Object $org_scalatest_assert_macro_right2 = null;
            String string2 = $org_scalatest_assert_macro_left2;
            Object var12_11 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", null, string2 == null ? var12_11 != null : !string2.equals(var12_11), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
            File execStateFile = $this.s1().registeredExecutorFile;
            this.convertToAnyShouldWrapper(execStateFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296), Prettifier$.MODULE$.default()).should(this.not()).be(null, Predef$.MODULE$.$conforms());
            File secretsFile = $this.s1().secretsFile;
            this.convertToAnyShouldWrapper(secretsFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298), Prettifier$.MODULE$.default()).should(this.not()).be(null, Predef$.MODULE$.$conforms());
            ExecutorShuffleInfo shuffleInfo1 = new ExecutorShuffleInfo((String[])((Object[])new String[]{"/foo", "/bar"}), 3, this.SORT_MANAGER());
            ExecutorShuffleInfo shuffleInfo2 = new ExecutorShuffleInfo((String[])((Object[])new String[]{"/bippy"}), 5, this.SORT_MANAGER());
            ExternalBlockHandler blockHandler = $this.s1().blockHandler;
            ExternalShuffleBlockResolver blockResolver = ShuffleTestAccessor$.MODULE$.getBlockResolver(blockHandler);
            this.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.registeredExecutorFile(blockResolver), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304), Prettifier$.MODULE$.default()).should(this.be().apply((Object)execStateFile));
            blockResolver.registerExecutor(app1Id.toString(), "exec-1", shuffleInfo1);
            blockResolver.registerExecutor(app2Id.toString(), "exec-2", shuffleInfo2);
            this.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app1Id, "exec-1", blockResolver), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)shuffleInfo1)));
            this.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app2Id, "exec-2", blockResolver), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)shuffleInfo2)));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(execStateFile.exists(), "execStateFile.exists()", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringBuilder(14).append(execStateFile).append(" did not exist").toString(), Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
            this.s1().stop();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(execStateFile.exists(), "execStateFile.exists()", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
            Path recoveryPath = new Path(this.recoveryLocalDir().toURI());
            this.s2_$eq(new YarnShuffleService());
            this.s2().setRecoveryPath(recoveryPath);
            this.s2().init((Configuration)this.yarnConfig());
            String $org_scalatest_assert_macro_left3 = $this.s2().secretManager.getSecretKey(app1Id.toString());
            Object $org_scalatest_assert_macro_right3 = null;
            String string3 = $org_scalatest_assert_macro_left3;
            Object var25_24 = null;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "!=", null, string3 == null ? var25_24 != null : !string3.equals(var25_24), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
            String $org_scalatest_assert_macro_left4 = $this.s2().secretManager.getSecretKey(app2Id.toString());
            Object $org_scalatest_assert_macro_right4 = null;
            String string4 = $org_scalatest_assert_macro_left4;
            Object var29_28 = null;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "!=", null, string4 == null ? var29_28 != null : !string4.equals(var29_28), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
            File execStateFile2 = $this.s2().registeredExecutorFile;
            File secretsFile2 = $this.s2().secretsFile;
            this.convertToStringShouldWrapper(recoveryPath.toString(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Path(execStateFile2.getParentFile().toURI()).toString()));
            this.convertToStringShouldWrapper(recoveryPath.toString(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Path(secretsFile2.getParentFile().toURI()).toString()));
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).milliseconds())), (Function0 & Serializable & scala.Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(execStateFile.exists(), "execStateFile.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
            }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).milliseconds())), (Function0 & Serializable & scala.Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(secretsFile.exists(), "secretsFile.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
            }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
            ExternalBlockHandler handler2 = $this.s2().blockHandler;
            ExternalShuffleBlockResolver resolver2 = ShuffleTestAccessor$.MODULE$.getBlockResolver(handler2);
            this.s2().initializeApplication(app1Data);
            this.s2().stopApplication(new ApplicationTerminationContext(app2Id));
            this.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app1Id, "exec-1", resolver2), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)shuffleInfo1)));
            this.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app2Id, "exec-2", resolver2), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349), Prettifier$.MODULE$.default()).should(this.be().apply((Object)None$.MODULE$));
            this.s2().stop();
        }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        this.test("service throws error if cannot start", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            File roDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            Files.setPosixFilePermissions(roDir.toPath(), EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_EXECUTE));
            YarnShuffleService service = new YarnShuffleService();
            service.setRecoveryPath(new Path(roDir.toURI()));
            try {
                ServiceStateException error = (ServiceStateException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.init((Configuration)this.yarnConfig()), ClassTag$.MODULE$.apply(ServiceStateException.class), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
                Throwable $org_scalatest_assert_macro_left = error.getCause();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "java.io.IOException", $org_scalatest_assert_macro_left instanceof IOException, Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
            }
            finally {
                service.stop();
                Files.setPosixFilePermissions(roDir.toPath(), EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE));
            }
            return assertion;
        }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
        this.test("recovery db should not be created if NM recovery is not enabled", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.s1_$eq(new YarnShuffleService());
            this.s1().init((Configuration)this.yarnConfig());
            this.convertToAnyShouldWrapper($this.s1()._recoveryPath, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383), Prettifier$.MODULE$.default()).should(this.be().apply(null));
            this.convertToAnyShouldWrapper($this.s1().registeredExecutorFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384), Prettifier$.MODULE$.default()).should(this.be().apply(null));
            return this.convertToAnyShouldWrapper($this.s1().secretsFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385), Prettifier$.MODULE$.default()).should(this.be().apply(null));
        }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
        this.test("SPARK-31646: metrics should be registered into Node Manager's metrics system", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.s1_$eq(new YarnShuffleService());
            this.s1().init((Configuration)this.yarnConfig());
            YarnShuffleServiceMetrics metricsSource = (YarnShuffleServiceMetrics)((MetricsSystemImpl)DefaultMetricsSystem.instance()).getSource("sparkShuffleService");
            Field metricSetRef = YarnShuffleServiceMetrics.class.getDeclaredField("metricSet");
            metricSetRef.setAccessible(true);
            java.util.Map metrics = ((MetricSet)metricSetRef.get(metricsSource)).getMetrics();
            Set $org_scalatest_assert_macro_left = (Set)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"blockTransferRateBytes", "numActiveConnections", "numCaughtExceptions", "numRegisteredConnections", "openBlockRequestLatencyMillis", "registeredExecutorsSize", "registerExecutorRequestLatencyMillis"}));
            Set set = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
        }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
    }
}

