/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.approvals;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.syncope.client.console.commons.MapChoiceRenderer;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxSpinnerFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.FieldPanel;
import org.apache.syncope.common.lib.to.WorkflowFormPropertyTO;
import org.apache.syncope.common.lib.to.WorkflowFormTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Approval
extends Panel {
    private static final long serialVersionUID = -8847854414429745216L;
    protected static final Logger LOG = LoggerFactory.getLogger(Approval.class);

    public Approval(PageReference pageRef, final WorkflowFormTO formTO) {
        super("first");
        LoadableDetachableModel<List<WorkflowFormPropertyTO>> formProps = new LoadableDetachableModel<List<WorkflowFormPropertyTO>>(){
            private static final long serialVersionUID = 3169142472626817508L;

            protected List<WorkflowFormPropertyTO> load() {
                return formTO.getProperties();
            }
        };
        ListView<WorkflowFormPropertyTO> propView = new ListView<WorkflowFormPropertyTO>("propView", (IModel)formProps){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem<WorkflowFormPropertyTO> item) {
                FieldPanel field;
                final WorkflowFormPropertyTO prop = (WorkflowFormPropertyTO)item.getModelObject();
                String label = StringUtils.isBlank((CharSequence)prop.getName()) ? prop.getId() : prop.getName();
                switch (prop.getType()) {
                    case Boolean: {
                        field = new AjaxDropDownChoicePanel<String>("value", label, (IModel<String>)new PropertyModel<String>((Object)prop, "value"){
                            private static final long serialVersionUID = -3743432456095828573L;

                            public String getObject() {
                                return StringUtils.isBlank((CharSequence)prop.getValue()) ? null : (prop.getValue().equals("true") ? "Yes" : "No");
                            }

                            public void setObject(String object) {
                                prop.setValue(String.valueOf(object.equalsIgnoreCase("yes")));
                            }
                        }, false).setChoices(Arrays.asList("Yes", "No"));
                        break;
                    }
                    case Date: {
                        final FastDateFormat formatter = FastDateFormat.getInstance((String)prop.getDatePattern());
                        field = new AjaxDateTimeFieldPanel("value", label, (IModel<Date>)new PropertyModel<Date>((Object)prop, "value"){
                            private static final long serialVersionUID = -3743432456095828573L;

                            public Date getObject() {
                                try {
                                    if (StringUtils.isBlank((CharSequence)prop.getValue())) {
                                        return null;
                                    }
                                    return formatter.parse(prop.getValue());
                                }
                                catch (ParseException e) {
                                    LOG.error("Unparsable date: {}", (Object)prop.getValue(), (Object)e);
                                    return null;
                                }
                            }

                            public void setObject(Date object) {
                                prop.setValue(formatter.format(object));
                            }
                        }, prop.getDatePattern());
                        break;
                    }
                    case Enum: {
                        MapChoiceRenderer enumCR = new MapChoiceRenderer(prop.getEnumValues());
                        field = new AjaxDropDownChoicePanel("value", label, new PropertyModel((Object)prop, "value"), false).setChoiceRenderer(enumCR).setChoices(new Model<ArrayList<String>>(){
                            private static final long serialVersionUID = -858521070366432018L;

                            public ArrayList<String> getObject() {
                                return new ArrayList<String>(prop.getEnumValues().keySet());
                            }
                        });
                        break;
                    }
                    case Long: {
                        field = new AjaxSpinnerFieldPanel.Builder<Long>().build("value", label, Long.class, (IModel<Long>)new PropertyModel<Long>((Object)prop, "value"){
                            private static final long serialVersionUID = -7688359318035249200L;

                            public Long getObject() {
                                return StringUtils.isBlank((CharSequence)prop.getValue()) ? null : Long.valueOf(NumberUtils.toLong((String)prop.getValue()));
                            }

                            public void setObject(Long object) {
                                prop.setValue(String.valueOf(object));
                            }
                        });
                        break;
                    }
                    default: {
                        field = new AjaxTextFieldPanel("value", label, (IModel<String>)new PropertyModel((Object)prop, "value"), false);
                    }
                }
                field.setReadOnly(!prop.isWritable());
                if (prop.isRequired()) {
                    field.addRequiredLabel();
                }
                item.add(new Component[]{field});
            }
        };
        AjaxLink<String> userDetails = new AjaxLink<String>("userDetails"){
            private static final long serialVersionUID = -4804368561204623354L;

            public void onClick(AjaxRequestTarget target) {
                Approval.this.viewDetails(formTO, target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)userDetails, (Action)ENABLE, (String)"USER_READ");
        boolean enabled = formTO.getUserTO() != null;
        userDetails.setVisible(enabled).setEnabled(enabled);
        this.add(new Component[]{propView});
        this.add(new Component[]{userDetails});
    }

    protected abstract void viewDetails(WorkflowFormTO var1, AjaxRequestTarget var2);
}

