/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.bulk;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.status.StatusBean;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.client.console.rest.RestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.BulkActionResultColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.common.lib.to.BulkAction;
import org.apache.syncope.common.lib.to.BulkActionResult;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class BulkContent<T extends Serializable, S>
extends MultilevelPanel.SecondLevel {
    private static final long serialVersionUID = 4114026480146090963L;
    protected static final Logger LOG = LoggerFactory.getLogger(BulkContent.class);

    public BulkContent(BaseModal<?> modal, Collection<T> items, List<IColumn<T, S>> columns, Collection<ActionLink.ActionType> actions, RestClient bulkActionExecutor, String keyFieldName) {
        this("second", modal, items, columns, actions, bulkActionExecutor, keyFieldName);
    }

    public BulkContent(String id, final BaseModal<?> modal, final Collection<T> items, final List<IColumn<T, S>> columns, Collection<ActionLink.ActionType> actions, final RestClient bulkActionExecutor, final String keyFieldName) {
        super(id);
        final WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        final SortableDataProvider dataProvider = new SortableDataProvider<T, S>(){
            private static final long serialVersionUID = 5291903859908641954L;

            public Iterator<? extends T> iterator(long first, long count) {
                return items.iterator();
            }

            public long size() {
                return items.size();
            }

            public IModel<T> model(T object) {
                return new CompoundPropertyModel(object);
            }
        };
        container.add(new Component[]{new AjaxFallbackDefaultDataTable("selectedObjects", columns, (ISortableDataProvider)dataProvider, Integer.MAX_VALUE).setMarkupId("selectedObjects").setVisible(items != null && !items.isEmpty())});
        final ActionsPanel<Serializable> actionPanel = new ActionsPanel<Serializable>("actions", null);
        container.add(new Component[]{actionPanel});
        Iterator<ActionLink.ActionType> iterator = actions.iterator();
        while (iterator.hasNext()) {
            ActionLink.ActionType action;
            final ActionLink.ActionType actionToBeAddresed = action = iterator.next();
            actionPanel.add(new ActionLink<Serializable>(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                protected boolean statusCondition(Serializable modelObject) {
                    return CollectionUtils.isNotEmpty((Collection)items);
                }

                @Override
                public void onClick(AjaxRequestTarget target, Serializable ignore) {
                    try {
                        if (CollectionUtils.isEmpty((Collection)items)) {
                            throw new IllegalArgumentException("Invalid items");
                        }
                        String fieldName = keyFieldName;
                        BulkActionResult res = null;
                        try {
                            if (items.iterator().next() instanceof StatusBean) {
                                throw new IllegalArgumentException("Invalid items");
                            }
                            BulkAction bulkAction = new BulkAction();
                            bulkAction.setType(BulkAction.Type.valueOf((String)actionToBeAddresed.name()));
                            for (Serializable item : items) {
                                try {
                                    bulkAction.getTargets().add(BulkContent.this.getTargetId(item, keyFieldName).toString());
                                }
                                catch (IllegalAccessException | InvocationTargetException e) {
                                    LOG.error("Error retrieving item id {}", (Object)keyFieldName, (Object)e);
                                }
                            }
                            res = (BulkActionResult)BulkActionResult.class.cast(bulkActionExecutor.getClass().getMethod("bulkAction", BulkAction.class).invoke((Object)bulkActionExecutor, bulkAction));
                        }
                        catch (IllegalArgumentException biae) {
                            if (!(items.iterator().next() instanceof StatusBean)) {
                                throw new IllegalArgumentException("Invalid items");
                            }
                            if (!(bulkActionExecutor instanceof AbstractAnyRestClient)) {
                                throw new IllegalArgumentException("Invalid bulk action executor");
                            }
                            AbstractAnyRestClient anyRestClient = (AbstractAnyRestClient)AbstractAnyRestClient.class.cast(bulkActionExecutor);
                            HashMap beans = new HashMap();
                            for (Serializable serializable : items) {
                                List<StatusBean> sblist;
                                StatusBean sb = (StatusBean)StatusBean.class.cast(serializable);
                                if (beans.containsKey(sb.getKey())) {
                                    sblist = (List)beans.get(sb.getKey());
                                } else {
                                    sblist = new ArrayList();
                                    beans.put(sb.getKey(), sblist);
                                }
                                sblist.add(sb);
                            }
                            for (Map.Entry entry : beans.entrySet()) {
                                String etag = anyRestClient.read((String)entry.getKey()).getETagValue();
                                switch (actionToBeAddresed.name()) {
                                    case "DEPROVISION": {
                                        res = anyRestClient.deprovision(etag, (String)entry.getKey(), (List)entry.getValue());
                                        break;
                                    }
                                    case "UNASSIGN": {
                                        res = anyRestClient.unassign(etag, (String)entry.getKey(), (List)entry.getValue());
                                        break;
                                    }
                                    case "UNLINK": {
                                        res = anyRestClient.unlink(etag, (String)entry.getKey(), (List)entry.getValue());
                                        break;
                                    }
                                    case "ASSIGN": {
                                        res = anyRestClient.assign(etag, (String)entry.getKey(), (List)entry.getValue());
                                        break;
                                    }
                                    case "LINK": {
                                        res = anyRestClient.link(etag, (String)entry.getKey(), (List)entry.getValue());
                                        break;
                                    }
                                    case "PROVISION": {
                                        res = anyRestClient.provision(etag, (String)entry.getKey(), (List)entry.getValue());
                                        break;
                                    }
                                    case "REACTIVATE": {
                                        res = ((UserRestClient)anyRestClient).reactivate(etag, (String)entry.getKey(), (List)entry.getValue());
                                        fieldName = "resource";
                                        break;
                                    }
                                    case "SUSPEND": {
                                        res = ((UserRestClient)anyRestClient).suspend(etag, (String)entry.getKey(), (List)entry.getValue());
                                        fieldName = "resource";
                                        break;
                                    }
                                }
                            }
                        }
                        if (modal != null) {
                            modal.changeCloseButtonLabel(BulkContent.this.getString("close", null, "Close"), target);
                        }
                        ArrayList newColumnList = new ArrayList(columns);
                        newColumnList.add(newColumnList.size(), new BulkActionResultColumn(res, fieldName));
                        container.addOrReplace(new Component[]{new AjaxFallbackDefaultDataTable("selectedObjects", newColumnList, (ISortableDataProvider)dataProvider, Integer.MAX_VALUE).setVisible(!items.isEmpty())});
                        actionPanel.setEnabled(false);
                        actionPanel.setVisible(false);
                        target.add(new Component[]{container});
                        target.add(new Component[]{actionPanel});
                        SyncopeConsoleSession.get().info((Serializable)((Object)BulkContent.this.getString("operation_succeeded")));
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        LOG.error("Bulk action failure", (Throwable)e);
                        SyncopeConsoleSession.get().error((Serializable)((Object)("Operation " + actionToBeAddresed.getActionId() + " not supported")));
                    }
                    ((BasePage)BulkContent.this.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                }
            }, action, "CONFIGURATION_LIST").hideLabel();
        }
    }

    private Object getTargetId(Object target, String idFieldName) throws IllegalAccessException, InvocationTargetException {
        return BeanUtils.getPropertyDescriptor(target.getClass(), (String)idFieldName).getReadMethod().invoke(target, new Object[0]);
    }
}

