/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.commons;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableAnyProviderComparator;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;

public class AnyDataProvider<A extends AnyTO>
extends DirectoryDataProvider<A> {
    private static final long serialVersionUID = 6267494272884913376L;
    private final SortableAnyProviderComparator<A> comparator;
    private final AbstractAnyRestClient<A, ?> restClient;
    protected String fiql;
    protected final boolean filtered;
    private final String realm;
    private final String type;

    public AnyDataProvider(AbstractAnyRestClient<A, ?> restClient, int paginatorRows, boolean filtered, String realm, String type) {
        super(paginatorRows);
        this.restClient = restClient;
        this.filtered = filtered;
        switch (type) {
            case "USER": {
                this.setSort("username", SortOrder.ASCENDING);
                break;
            }
            case "GROUP": {
                this.setSort("name", SortOrder.ASCENDING);
                break;
            }
            default: {
                this.setSort("key", SortOrder.ASCENDING);
            }
        }
        this.comparator = new SortableAnyProviderComparator(this);
        this.realm = realm;
        this.type = type;
    }

    public Iterator<A> iterator(long first, long count) {
        int page = (int)first / this.paginatorRows;
        List<Object> result = this.filtered ? (this.fiql == null ? Collections.emptyList() : this.restClient.search(this.realm, this.fiql, (page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort(), this.type)) : this.restClient.search(this.realm, null, (page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort(), this.type);
        Collections.sort(result, this.comparator);
        return result.iterator();
    }

    public long size() {
        long result = this.filtered ? (this.fiql == null ? 0L : (long)this.restClient.searchCount(this.realm, this.fiql, this.type)) : (long)this.restClient.searchCount(this.realm, null, this.type);
        return result;
    }

    public AnyDataProvider<A> setFIQL(String fiql) {
        this.fiql = fiql;
        return this;
    }

    public IModel<A> model(A object) {
        return new CompoundPropertyModel(object);
    }
}

