/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.commons;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.commons.status.ConnObjectWrapper;
import org.apache.syncope.client.console.commons.status.StatusBean;
import org.apache.syncope.client.console.commons.status.StatusUtils;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.client.console.rest.AnyObjectRestClient;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.search.UserFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;

public class ResourceStatusDataProvider
extends DirectoryDataProvider<StatusBean> {
    private static final long serialVersionUID = 6267494272884913376L;
    private final StatusUtils statusUtils = new StatusUtils();
    private final String resource;
    private final SortableDataProviderComparator<StatusBean> comparator;
    private final AbstractAnyRestClient<? extends AnyTO, ?> restClient;
    protected String fiql;
    private final String realm;
    private final String type;

    public ResourceStatusDataProvider(String type, String resource, int paginatorRows, String realm) {
        super(paginatorRows);
        this.resource = resource;
        if (StringUtils.isEmpty((CharSequence)type)) {
            this.fiql = null;
            this.restClient = null;
        } else {
            UserFiqlSearchConditionBuilder bld;
            switch (type) {
                case "USER": {
                    bld = SyncopeClient.getUserSearchConditionBuilder();
                    this.restClient = new UserRestClient();
                    break;
                }
                case "GROUP": {
                    bld = SyncopeClient.getGroupSearchConditionBuilder();
                    this.restClient = new GroupRestClient();
                    break;
                }
                default: {
                    bld = SyncopeClient.getAnyObjectSearchConditionBuilder((String)type);
                    this.restClient = new AnyObjectRestClient();
                }
            }
            this.fiql = bld.hasResources(resource, new String[0]).query();
        }
        this.setSort("connObjectLink", SortOrder.ASCENDING);
        this.comparator = new SortableDataProviderComparator<StatusBean>(this);
        this.realm = realm;
        this.type = type;
    }

    public Iterator<StatusBean> iterator(long first, long count) {
        if (this.fiql == null) {
            return Collections.emptyList().iterator();
        }
        int page = (int)first / this.paginatorRows;
        List<? extends AnyTO> result = this.restClient.search(this.realm, this.fiql, (page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort(), this.type);
        List res = (List)CollectionUtils.collect(result, (Transformer)new Transformer<AnyTO, StatusBean>(){

            public StatusBean transform(AnyTO input) {
                List<ConnObjectWrapper> connObjects = ResourceStatusDataProvider.this.statusUtils.getConnectorObjects(input, Collections.singletonList(ResourceStatusDataProvider.this.resource));
                return ResourceStatusDataProvider.this.statusUtils.getStatusBean(input, ResourceStatusDataProvider.this.resource, connObjects.isEmpty() ? null : connObjects.iterator().next().getConnObjectTO(), input instanceof GroupTO);
            }
        }, new ArrayList());
        Collections.sort(res, this.comparator);
        return res.iterator();
    }

    public long size() {
        if (this.fiql == null) {
            return 0L;
        }
        return this.restClient.searchCount(this.realm, this.fiql, this.type);
    }

    public IModel<StatusBean> model(StatusBean object) {
        return new CompoundPropertyModel((Object)object);
    }
}

