/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.layout;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.layout.AbstractAnyFormLayout;
import org.apache.syncope.client.console.layout.AnyForm;
import org.apache.syncope.client.console.layout.AnyObjectFormLayoutInfo;
import org.apache.syncope.client.console.layout.GroupFormLayoutInfo;
import org.apache.syncope.client.console.layout.UserFormLayoutInfo;
import org.apache.syncope.client.console.rest.RoleRestClient;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.PageReference;

public final class FormLayoutInfoUtils {
    private static final RoleRestClient ROLE_REST_CLIENT = new RoleRestClient();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static Triple<UserFormLayoutInfo, GroupFormLayoutInfo, Map<String, AnyObjectFormLayoutInfo>> fetch(Collection<String> anyTypes) {
        List ownedRoles = SyncopeConsoleSession.get().getSelfTO().getRoles();
        try {
            ObjectNode tree = null;
            for (int i = 0; i < ownedRoles.size() && tree == null; ++i) {
                String consoleLayoutInfo = ROLE_REST_CLIENT.readConsoleLayoutInfo((String)ownedRoles.get(i));
                if (!StringUtils.isNotBlank((CharSequence)consoleLayoutInfo)) continue;
                tree = MAPPER.readTree(consoleLayoutInfo);
            }
            if (tree == null) {
                tree = MAPPER.createObjectNode();
            }
            UserFormLayoutInfo userFormLayoutInfo = tree.has(AnyTypeKind.USER.name()) ? (UserFormLayoutInfo)MAPPER.treeToValue((TreeNode)tree.get(AnyTypeKind.USER.name()), UserFormLayoutInfo.class) : new UserFormLayoutInfo();
            GroupFormLayoutInfo groupFormLayoutInfo = tree.has(AnyTypeKind.USER.name()) ? (GroupFormLayoutInfo)MAPPER.treeToValue((TreeNode)tree.get(AnyTypeKind.GROUP.name()), GroupFormLayoutInfo.class) : new GroupFormLayoutInfo();
            HashMap<String, AnyObjectFormLayoutInfo> anyObjectFormLayoutInfos = new HashMap<String, AnyObjectFormLayoutInfo>();
            for (String anyType : anyTypes) {
                if (anyType.equals(AnyTypeKind.USER.name()) || anyType.equals(AnyTypeKind.GROUP.name())) continue;
                anyObjectFormLayoutInfos.put(anyType, tree.has(anyType) ? (AnyObjectFormLayoutInfo)MAPPER.treeToValue((TreeNode)tree.get(anyType), AnyObjectFormLayoutInfo.class) : new AnyObjectFormLayoutInfo());
            }
            return Triple.of((Object)userFormLayoutInfo, (Object)groupFormLayoutInfo, anyObjectFormLayoutInfos);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("While parsing console layout info for " + SyncopeConsoleSession.get().getSelfTO().getUsername(), e);
        }
    }

    public static String defaultConsoleLayoutInfoIfEmpty(String content, List<String> anyTypes) {
        String result;
        if (StringUtils.isBlank((CharSequence)content)) {
            try {
                ObjectNode tree = MAPPER.createObjectNode();
                tree.set(AnyTypeKind.USER.name(), MAPPER.valueToTree((Object)new UserFormLayoutInfo()));
                tree.set(AnyTypeKind.GROUP.name(), MAPPER.valueToTree((Object)new GroupFormLayoutInfo()));
                for (String anyType : anyTypes) {
                    if (anyType.equals(AnyTypeKind.USER.name()) || anyType.equals(AnyTypeKind.GROUP.name())) continue;
                    tree.set(anyType, MAPPER.valueToTree((Object)new AnyObjectFormLayoutInfo()));
                }
                result = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)tree);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("While generating default console layout info for " + SyncopeConsoleSession.get().getSelfTO().getUsername(), e);
            }
        }
        try {
            result = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)MAPPER.readTree(content));
        }
        catch (IOException e) {
            result = content;
        }
        return result;
    }

    public static <A extends AnyTO, F extends AnyForm<A>, FL extends AbstractAnyFormLayout<A, F>> F instantiate(A anyTO, List<String> anyTypeClasses, FL anyFormLayout, PageReference pageRef) {
        try {
            if (anyTO instanceof UserTO) {
                return (F)((AnyForm)anyFormLayout.getFormClass().getConstructor(anyTO.getClass(), anyTO.getClass(), List.class, anyFormLayout.getClass(), pageRef.getClass()).newInstance(null, anyTO, anyTypeClasses, anyFormLayout, pageRef));
            }
            return (F)((AnyForm)anyFormLayout.getFormClass().getConstructor(anyTO.getClass(), List.class, anyFormLayout.getClass(), pageRef.getClass()).newInstance(anyTO, anyTypeClasses, anyFormLayout, pageRef));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Could not instantiate " + anyFormLayout.getFormClass().getName(), e);
        }
    }

    private FormLayoutInfoUtils() {
    }
}

