/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.notifications;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.commons.TemplateContent;
import org.apache.syncope.client.console.notifications.TemplateModal;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.WizardModalPanel;
import org.apache.syncope.client.console.rest.NotificationRestClient;
import org.apache.syncope.client.console.rest.TemplateRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.XMLEditorPanel;
import org.apache.syncope.client.console.wizards.AbstractModalPanelBuilder;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.MailTemplateTO;
import org.apache.syncope.common.lib.types.MailTemplateFormat;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class MailTemplateDirectoryPanel
extends DirectoryPanel<MailTemplateTO, MailTemplateTO, MailTemplateProvider, NotificationRestClient> {
    private static final long serialVersionUID = -3789392431954221446L;
    protected final BaseModal<String> utilityModal = new BaseModal("outer");

    public MailTemplateDirectoryPanel(String id, final PageReference pageReference) {
        super(id, pageReference, true);
        this.disableCheckBoxes();
        this.modal.size(Modal.Size.Small);
        this.modal.addSubmitButton();
        this.setFooterVisibility(true);
        this.modal.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                MailTemplateDirectoryPanel.this.updateResultTable(target);
                MailTemplateDirectoryPanel.this.modal.show(false);
            }
        });
        this.addOuterObject(new Component[]{this.utilityModal});
        this.setWindowClosedReloadCallback(this.utilityModal);
        this.utilityModal.size(Modal.Size.Large);
        this.utilityModal.addSubmitButton();
        this.restClient = new NotificationRestClient();
        this.addNewItemPanelBuilder(new AbstractModalPanelBuilder<MailTemplateTO>(new MailTemplateTO(), this.pageRef){
            private static final long serialVersionUID = 1995192603527154740L;

            @Override
            public WizardModalPanel<MailTemplateTO> build(String id, int index, AjaxWizard.Mode mode) {
                return new TemplateModal(MailTemplateDirectoryPanel.this.modal, (TemplateRestClient)MailTemplateDirectoryPanel.this.restClient, new MailTemplateTO(), pageReference);
            }
        }, true);
        this.initResultTable();
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"MAIL_TEMPLATE_CREATE");
    }

    @Override
    protected List<IColumn<MailTemplateTO, String>> getColumns() {
        ArrayList<IColumn<MailTemplateTO, String>> columns = new ArrayList<IColumn<MailTemplateTO, String>>();
        columns.add((IColumn<MailTemplateTO, String>)new PropertyColumn((IModel)new StringResourceModel("key", (Component)this), (Object)"key", "key"));
        return columns;
    }

    @Override
    public ActionsPanel<MailTemplateTO> getActions(final IModel<MailTemplateTO> model) {
        ActionsPanel<MailTemplateTO> panel = super.getActions(model);
        panel.add(new ActionLink<MailTemplateTO>(){
            private static final long serialVersionUID = -7978723352517770645L;

            @Override
            public void onClick(AjaxRequestTarget target, MailTemplateTO ignore) {
                TemplateContent<MailTemplateFormat> content = new TemplateContent<MailTemplateFormat>(((MailTemplateTO)model.getObject()).getKey(), MailTemplateFormat.HTML);
                content.setContent(((NotificationRestClient)MailTemplateDirectoryPanel.this.restClient).readTemplateFormat(((MailTemplateTO)model.getObject()).getKey(), MailTemplateFormat.HTML));
                MailTemplateDirectoryPanel.this.utilityModal.header((IModel)new ResourceModel("mail.template.html", "HTML Content"));
                MailTemplateDirectoryPanel.this.utilityModal.setContent(new TemplateContentEditorPanel(content, MailTemplateDirectoryPanel.this.pageRef));
                MailTemplateDirectoryPanel.this.utilityModal.show(true);
                target.add(new Component[]{MailTemplateDirectoryPanel.this.utilityModal});
            }
        }, ActionLink.ActionType.HTML, "MAIL_TEMPLATE_UPDATE");
        panel.add(new ActionLink<MailTemplateTO>(){
            private static final long serialVersionUID = -7978723352517770645L;

            @Override
            public void onClick(AjaxRequestTarget target, MailTemplateTO ignore) {
                TemplateContent<MailTemplateFormat> content = new TemplateContent<MailTemplateFormat>(((MailTemplateTO)model.getObject()).getKey(), MailTemplateFormat.TEXT);
                content.setContent(((NotificationRestClient)MailTemplateDirectoryPanel.this.restClient).readTemplateFormat(((MailTemplateTO)model.getObject()).getKey(), MailTemplateFormat.TEXT));
                MailTemplateDirectoryPanel.this.utilityModal.header((IModel)new ResourceModel("mail.template.text", "TEXT Content"));
                MailTemplateDirectoryPanel.this.utilityModal.setContent(new TemplateContentEditorPanel(content, MailTemplateDirectoryPanel.this.pageRef));
                MailTemplateDirectoryPanel.this.utilityModal.show(true);
                target.add(new Component[]{MailTemplateDirectoryPanel.this.utilityModal});
            }
        }, ActionLink.ActionType.TEXT, "MAIL_TEMPLATE_UPDATE");
        panel.add(new ActionLink<MailTemplateTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, MailTemplateTO ignore) {
                try {
                    ((NotificationRestClient)MailTemplateDirectoryPanel.this.restClient).deleteTemplate(((MailTemplateTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().info((Serializable)((Object)MailTemplateDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{MailTemplateDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting object {}", (Object)((MailTemplateTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
                }
                ((BasePage)MailTemplateDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "MAIL_TEMPLATE_DELETE", true);
        return panel;
    }

    @Override
    protected MailTemplateProvider dataProvider() {
        return new MailTemplateProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "mail.template.paginator.rows";
    }

    @Override
    protected Collection<ActionLink.ActionType> getBulkActions() {
        return Collections.emptyList();
    }

    private class TemplateContentEditorPanel
    extends XMLEditorPanel {
        private static final long serialVersionUID = -3528875878627216097L;
        private final TemplateContent<MailTemplateFormat> content;

        TemplateContentEditorPanel(TemplateContent<MailTemplateFormat> content, PageReference pageRef) {
            super(MailTemplateDirectoryPanel.this.utilityModal, (IModel<String>)new PropertyModel(content, "content"), false, pageRef);
            this.content = content;
        }

        @Override
        public void onSubmit(AjaxRequestTarget target, Form<?> form) {
            if (StringUtils.isBlank((CharSequence)this.content.getContent())) {
                SyncopeConsoleSession.get().error((Serializable)((Object)"No content to save"));
            } else {
                try {
                    ((NotificationRestClient)MailTemplateDirectoryPanel.this.restClient).updateTemplateFormat(this.content.getKey(), this.content.getContent(), this.content.getFormat());
                    SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
                    this.modal.show(false);
                    this.modal.close((IPartialPageRequestHandler)target);
                }
                catch (Exception e) {
                    LOG.error("While updating template for {}", (Object)this.content.getKey(), (Object)e);
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage())));
                }
            }
            ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        }
    }

    protected final class MailTemplateProvider
    extends DirectoryDataProvider<MailTemplateTO> {
        private static final long serialVersionUID = -276043813563988590L;
        private final SortableDataProviderComparator<MailTemplateTO> comparator;

        public MailTemplateProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("key", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<MailTemplateTO>(this);
        }

        public Iterator<MailTemplateTO> iterator(long first, long count) {
            List<MailTemplateTO> list = ((NotificationRestClient)MailTemplateDirectoryPanel.this.restClient).listTemplates();
            Collections.sort(list, this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((NotificationRestClient)MailTemplateDirectoryPanel.this.restClient).listTemplates().size();
        }

        public IModel<MailTemplateTO> model(final MailTemplateTO mailTemplateTO) {
            return new AbstractReadOnlyModel<MailTemplateTO>(){
                private static final long serialVersionUID = 774694801558497248L;

                public MailTemplateTO getObject() {
                    return mailTemplateTO;
                }
            };
        }
    }
}

