/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.notifications;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.events.EventCategoryPanel;
import org.apache.syncope.client.console.notifications.NotificationWrapper;
import org.apache.syncope.client.console.panels.search.AbstractSearchPanel;
import org.apache.syncope.client.console.panels.search.AnyObjectSearchPanel;
import org.apache.syncope.client.console.panels.search.GroupSearchPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.UserSearchPanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.LoggerRestClient;
import org.apache.syncope.client.console.rest.NotificationRestClient;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiPanel;
import org.apache.syncope.client.console.wizards.AjaxWizardBuilder;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.to.MailTemplateTO;
import org.apache.syncope.common.lib.to.NotificationTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.lib.types.TraceLevel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.EmailAddressValidator;

public class NotificationWizardBuilder
extends AjaxWizardBuilder<NotificationWrapper> {
    private static final long serialVersionUID = -1975312550059578553L;
    private final NotificationRestClient restClient = new NotificationRestClient();
    private final SchemaRestClient schemaRestClient = new SchemaRestClient();
    private final LoggerRestClient loggerRestClient = new LoggerRestClient();

    public NotificationWizardBuilder(NotificationTO notificationTO, PageReference pageRef) {
        super(new NotificationWrapper(notificationTO), pageRef);
    }

    @Override
    protected Serializable onApplyInternal(NotificationWrapper modelObject) {
        boolean createFlag;
        modelObject.fillRecipientConditions();
        modelObject.fillAboutConditions();
        boolean bl = createFlag = modelObject.getInnerObject().getKey() == null;
        if (createFlag) {
            this.restClient.create(modelObject.getInnerObject());
        } else {
            this.restClient.update(modelObject.getInnerObject());
        }
        return null;
    }

    @Override
    protected WizardModel buildModelSteps(NotificationWrapper modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Details(modelObject));
        wizardModel.add((IWizardStep)new Recipients(modelObject));
        wizardModel.add((IWizardStep)new Events(modelObject));
        wizardModel.add((IWizardStep)new Abouts(modelObject));
        return wizardModel;
    }

    private List<String> getSchemaNames() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("username");
        CollectionUtils.collect(this.schemaRestClient.getSchemas(SchemaType.PLAIN, AnyTypeKind.USER.name()), (Transformer)EntityTOUtils.keyTransformer(), result);
        CollectionUtils.collect(this.schemaRestClient.getSchemas(SchemaType.DERIVED, AnyTypeKind.USER.name()), (Transformer)EntityTOUtils.keyTransformer(), result);
        CollectionUtils.collect(this.schemaRestClient.getSchemas(SchemaType.VIRTUAL, AnyTypeKind.USER.name()), (Transformer)EntityTOUtils.keyTransformer(), result);
        Collections.sort(result);
        return result;
    }

    public class Recipients
    extends WizardStep {
        private static final long serialVersionUID = -7709805590497687958L;
        private final IModel<List<String>> recipientProviders = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157447L;

            protected List<String> load() {
                return new ArrayList<String>(SyncopeConsoleSession.get().getPlatformInfo().getNotificationRecipientsProviders());
            }
        };

        public Recipients(NotificationWrapper modelObject) {
            this.setTitleModel((IModel)new ResourceModel("recipients"));
            NotificationTO notificationTO = modelObject.getInnerObject();
            AjaxTextFieldPanel recipientAttrName = new AjaxTextFieldPanel("recipientAttrName", new ResourceModel("recipientAttrName", "recipientAttrName").getObject(), (IModel<String>)new PropertyModel((Object)notificationTO, "recipientAttrName"));
            recipientAttrName.setChoices(NotificationWizardBuilder.this.getSchemaNames());
            recipientAttrName.addRequiredLabel();
            recipientAttrName.setTitle(this.getString("intAttrNameInfo.help") + "<div style=\"font-size: 10px;\"><code>groups[groupName].attribute</code>\n<code>anyObjects[anyObjectName].attribute</code>\n<code>memberships[groupName].attribute</code>\n</div>", true);
            this.add(new Component[]{recipientAttrName});
            AjaxTextFieldPanel staticRecipientsFieldPanel = new AjaxTextFieldPanel("panel", "staticRecipients", (IModel<String>)new Model());
            staticRecipientsFieldPanel.addValidator((IValidator<? super String>)EmailAddressValidator.getInstance());
            this.add(new Component[]{new MultiFieldPanel.Builder<String>((IModel<List<String>>)new PropertyModel((Object)notificationTO, "staticRecipients")).build("staticRecipients", "staticRecipients", staticRecipientsFieldPanel).hideLabel()});
            this.add(new Component[]{new UserSearchPanel.Builder((IModel<List<SearchClause>>)new PropertyModel((Object)modelObject, "recipientClauses")).required(false).build("recipients")});
            AjaxDropDownChoicePanel recipientsProviderClassName = new AjaxDropDownChoicePanel("recipientsProviderClassName", "recipientsProviderClassName", new PropertyModel((Object)notificationTO, "recipientsProviderClassName"), false);
            recipientsProviderClassName.setChoices((List)this.recipientProviders.getObject());
            this.add(new Component[]{recipientsProviderClassName});
            AjaxCheckBoxPanel selfAsRecipient = new AjaxCheckBoxPanel("selfAsRecipient", this.getString("selfAsRecipient"), (IModel<Boolean>)new PropertyModel((Object)notificationTO, "selfAsRecipient"));
            if (notificationTO.getKey() == null) {
                selfAsRecipient.getField().setDefaultModelObject((Object)Boolean.FALSE);
            }
            this.add(new Component[]{selfAsRecipient});
        }
    }

    public class Abouts
    extends WizardStep {
        private static final long serialVersionUID = -7709805590497687958L;

        public Abouts(NotificationWrapper modelObject) {
            this.setTitleModel((IModel)new ResourceModel("about"));
            WebMarkupContainer aboutContainer = new WebMarkupContainer("about");
            aboutContainer.setOutputMarkupId(true);
            this.add(new Component[]{aboutContainer});
            PropertyModel model = new PropertyModel((Object)modelObject, "aboutClauses");
            aboutContainer.add(new Component[]{new MultiPanel<Pair<String, List<SearchClause>>>("abouts", "abouts", (IModel)model){
                private static final long serialVersionUID = -2481579077338205547L;

                @Override
                protected Pair<String, List<SearchClause>> newModelObject() {
                    return Pair.of((Object)AnyTypeKind.USER.name(), new ArrayList());
                }

                protected About getItemPanel(final ListItem<Pair<String, List<SearchClause>>> item) {
                    return new About("panel", (IModel<Pair<String, List<SearchClause>>>)new Model<Pair<String, List<SearchClause>>>(){
                        private static final long serialVersionUID = 6799404673615637845L;

                        public Pair<String, List<SearchClause>> getObject() {
                            return (Pair)item.getModelObject();
                        }

                        public void setObject(Pair<String, List<SearchClause>> object) {
                            item.setModelObject(object);
                        }

                        public void detach() {
                        }
                    });
                }
            }.hideLabel()});
        }
    }

    public class About
    extends Panel {
        private static final long serialVersionUID = -9149543787708482882L;

        public About(String id, final IModel<Pair<String, List<SearchClause>>> model) {
            super(id, model);
            this.setOutputMarkupId(true);
            AjaxDropDownChoicePanel<String> type = new AjaxDropDownChoicePanel<String>("about", "anyType", (IModel<String>)new Model<String>(){
                private static final long serialVersionUID = -2350296434572623272L;

                public String getObject() {
                    return (String)((Pair)model.getObject()).getLeft();
                }

                public void setObject(String object) {
                    model.setObject((Object)Pair.of((Object)object, (Object)((Pair)model.getObject()).getRight()));
                }
            });
            type.setChoices(new AnyTypeRestClient().list());
            type.addRequiredLabel();
            this.add(new Component[]{type});
            ListModel<SearchClause> clauseModel = new ListModel<SearchClause>(){
                private static final long serialVersionUID = 3769540249683319782L;

                public List<SearchClause> getObject() {
                    return (List)((Pair)model.getObject()).getRight();
                }

                public void setObject(List<SearchClause> object) {
                    ((Pair)model.getObject()).setValue(object);
                }
            };
            WebMarkupContainer searchContainer = new WebMarkupContainer("search");
            this.add(new Component[]{searchContainer.setOutputMarkupId(true)});
            searchContainer.add(new Component[]{this.getClauseBuilder((String)((Pair)model.getObject()).getLeft(), clauseModel).build("clauses")});
            type.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change", (ListModel)clauseModel, searchContainer, type){
                private static final long serialVersionUID = -1107858522700306810L;
                final /* synthetic */ ListModel val$clauseModel;
                final /* synthetic */ WebMarkupContainer val$searchContainer;
                final /* synthetic */ AjaxDropDownChoicePanel val$type;
                {
                    this.val$clauseModel = listModel;
                    this.val$searchContainer = webMarkupContainer;
                    this.val$type = ajaxDropDownChoicePanel;
                    super(x0);
                }

                protected void onUpdate(AjaxRequestTarget target) {
                    ((List)this.val$clauseModel.getObject()).clear();
                    this.val$searchContainer.addOrReplace(new Component[]{About.this.getClauseBuilder((String)this.val$type.getModelObject(), (ListModel<SearchClause>)this.val$clauseModel).build("clauses").setRenderBodyOnly(true)});
                    target.add(new Component[]{this.val$searchContainer});
                }
            }});
        }

        private AbstractSearchPanel.Builder<?> getClauseBuilder(String type, ListModel<SearchClause> clauseModel) {
            AbstractSearchPanel.Builder clause;
            switch (type) {
                case "USER": {
                    clause = new UserSearchPanel.Builder((IModel<List<SearchClause>>)clauseModel);
                    break;
                }
                case "GROUP": {
                    clause = new GroupSearchPanel.Builder((IModel<List<SearchClause>>)clauseModel);
                    break;
                }
                default: {
                    clause = new AnyObjectSearchPanel.Builder(type, (IModel<List<SearchClause>>)clauseModel);
                }
            }
            return clause;
        }
    }

    public class Events
    extends WizardStep {
        private static final long serialVersionUID = -7709805590497687958L;

        public Events(NotificationWrapper modelObject) {
            this.setTitleModel((IModel)new ResourceModel("events"));
            this.add(new Component[]{new EventCategoryPanel("eventSelection", NotificationWizardBuilder.this.loggerRestClient.listEvents(), (IModel)new PropertyModel((Object)modelObject.getInnerObject(), "events")){
                private static final long serialVersionUID = 6429053774964787735L;

                @Override
                protected List<String> getListAuthRoles() {
                    return Collections.emptyList();
                }

                @Override
                protected List<String> getChangeAuthRoles() {
                    return Collections.emptyList();
                }
            }});
        }
    }

    public class Details
    extends WizardStep {
        private static final long serialVersionUID = -7709805590497687958L;

        public Details(NotificationWrapper modelObject) {
            NotificationTO notificationTO = modelObject.getInnerObject();
            boolean createFlag = notificationTO.getKey() == null;
            AjaxTextFieldPanel sender = new AjaxTextFieldPanel("sender", this.getString("sender"), (IModel<String>)new PropertyModel((Object)notificationTO, "sender"));
            sender.addRequiredLabel();
            sender.addValidator((IValidator<? super String>)EmailAddressValidator.getInstance());
            this.add(new Component[]{sender});
            AjaxTextFieldPanel subject = new AjaxTextFieldPanel("subject", this.getString("subject"), (IModel<String>)new PropertyModel((Object)notificationTO, "subject"));
            subject.addRequiredLabel();
            this.add(new Component[]{subject});
            AjaxDropDownChoicePanel template = new AjaxDropDownChoicePanel("template", this.getString("template"), new PropertyModel((Object)notificationTO, "template"));
            template.setChoices((List)CollectionUtils.collect(NotificationWizardBuilder.this.restClient.listTemplates(), (Transformer)new Transformer<MailTemplateTO, String>(){

                public String transform(MailTemplateTO input) {
                    return input.getKey();
                }
            }, new ArrayList()));
            template.addRequiredLabel();
            this.add(new Component[]{template});
            AjaxDropDownChoicePanel<TraceLevel> traceLevel = new AjaxDropDownChoicePanel<TraceLevel>("traceLevel", this.getString("traceLevel"), (IModel<TraceLevel>)new PropertyModel((Object)notificationTO, "traceLevel"));
            traceLevel.setChoices(Arrays.asList(TraceLevel.values()));
            traceLevel.addRequiredLabel();
            this.add(new Component[]{traceLevel});
            AjaxCheckBoxPanel isActive = new AjaxCheckBoxPanel("isActive", this.getString("isActive"), (IModel<Boolean>)new PropertyModel((Object)notificationTO, "active"));
            if (createFlag) {
                isActive.getField().setDefaultModelObject((Object)Boolean.TRUE);
            }
            this.add(new Component[]{isActive});
        }
    }
}

