/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.pages;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.console.SyncopeConsoleApplication;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.annotations.ExtPage;
import org.apache.syncope.client.console.commons.HttpResourceStream;
import org.apache.syncope.client.console.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.console.pages.Administration;
import org.apache.syncope.client.console.pages.Audit;
import org.apache.syncope.client.console.pages.BaseExtPage;
import org.apache.syncope.client.console.pages.Dashboard;
import org.apache.syncope.client.console.pages.Logout;
import org.apache.syncope.client.console.pages.Logs;
import org.apache.syncope.client.console.pages.Notifications;
import org.apache.syncope.client.console.pages.Parameters;
import org.apache.syncope.client.console.pages.Policies;
import org.apache.syncope.client.console.pages.Realms;
import org.apache.syncope.client.console.pages.Reports;
import org.apache.syncope.client.console.pages.SecurityQuestions;
import org.apache.syncope.client.console.pages.Types;
import org.apache.syncope.client.console.pages.Workflow;
import org.apache.syncope.client.console.panels.NotificationPanel;
import org.apache.syncope.client.console.rest.ConfRestClient;
import org.apache.syncope.client.console.topology.Topology;
import org.apache.syncope.client.console.wicket.markup.head.MetaHeaderItem;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.widgets.ApprovalsWidget;
import org.apache.syncope.common.lib.info.PlatformInfo;
import org.apache.syncope.common.lib.info.SystemInfo;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.util.resource.IResourceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePage
extends WebPage
implements IAjaxIndicatorAware {
    private static final long serialVersionUID = 1571997737305598502L;
    protected static final Logger LOG = LoggerFactory.getLogger(BasePage.class);
    protected static final HeaderItem META_IE_EDGE = new MetaHeaderItem("X-UA-Compatible", "IE=edge");
    protected final WebMarkupContainer body = new WebMarkupContainer("body");
    protected NotificationPanel notificationPanel;
    protected ApprovalsWidget approvalsWidget;

    public BasePage() {
        this(null);
    }

    public BasePage(PageParameters parameters) {
        super(parameters);
        Serializable leftMenuCollapse = SyncopeConsoleSession.get().getAttribute("MENU_COLLAPSE");
        if (leftMenuCollapse instanceof Boolean && ((Boolean)leftMenuCollapse).booleanValue()) {
            this.body.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)" sidebar-collapse"))});
        }
        this.add(new Component[]{this.body});
        this.notificationPanel = new NotificationPanel("feedback");
        this.body.addOrReplace(new Component[]{this.notificationPanel.setOutputMarkupId(true)});
        this.body.add(new Component[]{new Label("username", (Serializable)((Object)SyncopeConsoleSession.get().getSelfTO().getUsername()))});
        this.approvalsWidget = new ApprovalsWidget("approvalsWidget", this.getPageReference());
        this.body.add(new Component[]{this.approvalsWidget.setRenderBodyOnly(true)});
        PlatformInfo platformInfo = SyncopeConsoleSession.get().getPlatformInfo();
        Label version = new Label("version", (Serializable)((Object)platformInfo.getVersion()));
        String versionLink = StringUtils.isNotBlank((CharSequence)platformInfo.getBuildNumber()) && platformInfo.getVersion().endsWith("-SNAPSHOT") ? "https://git-wip-us.apache.org/repos/asf?p=syncope.git;a=commit;h=" + platformInfo.getBuildNumber() : "https://cwiki.apache.org/confluence/display/SYNCOPE/Jazz";
        version.add(new Behavior[]{new AttributeModifier("onclick", (Serializable)((Object)("window.open('" + versionLink + "', '_blank')")))});
        this.body.add(new Component[]{version});
        SystemInfo systemInfo = SyncopeConsoleSession.get().getSystemInfo();
        this.body.add(new Component[]{new Label("hostname", (Serializable)((Object)systemInfo.getHostname()))});
        this.body.add(new Component[]{new Label("processors", (Serializable)Integer.valueOf(systemInfo.getAvailableProcessors()))});
        this.body.add(new Component[]{new Label("os", (Serializable)((Object)systemInfo.getOs()))});
        this.body.add(new Component[]{new Label("jvm", (Serializable)((Object)systemInfo.getJvm()))});
        Link<Void> dbExportLink = new Link<Void>("dbExportLink"){
            private static final long serialVersionUID = -4331619903296515985L;

            public void onClick() {
                try {
                    HttpResourceStream stream = new HttpResourceStream(new ConfRestClient().dbExport());
                    ResourceStreamRequestHandler rsrh = new ResourceStreamRequestHandler((IResourceStream)stream);
                    rsrh.setFileName(stream.getFilename() == null ? SyncopeConsoleSession.get().getDomain() + "Content.xml" : stream.getFilename());
                    rsrh.setContentDisposition(ContentDisposition.ATTACHMENT);
                    this.getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)rsrh);
                }
                catch (Exception e) {
                    SyncopeConsoleSession.get().error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                }
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)dbExportLink, (Action)WebPage.RENDER, (String)"CONFIGURATION_EXPORT");
        this.body.add(new Component[]{dbExportLink});
        WebMarkupContainer liContainer = new WebMarkupContainer(this.getLIContainerId("dashboard"));
        this.body.add(new Component[]{liContainer});
        liContainer.add(new Component[]{BookmarkablePageLinkBuilder.build("dashboard", Dashboard.class)});
        liContainer = new WebMarkupContainer(this.getLIContainerId("realms"));
        this.body.add(new Component[]{liContainer});
        BookmarkablePageLink link = BookmarkablePageLinkBuilder.build("realms", Realms.class);
        MetaDataRoleAuthorizationStrategy.authorize(link, (Action)WebPage.RENDER, (String)"REALM_LIST");
        liContainer.add(new Component[]{link});
        liContainer = new WebMarkupContainer(this.getLIContainerId("topology"));
        this.body.add(new Component[]{liContainer});
        link = BookmarkablePageLinkBuilder.build("topology", Topology.class);
        StringBuilder bld = new StringBuilder();
        bld.append("CONNECTOR_LIST").append(",").append("RESOURCE_LIST").append(",");
        MetaDataRoleAuthorizationStrategy.authorize(link, (Action)WebPage.RENDER, (String)bld.toString());
        liContainer.add(new Component[]{link});
        liContainer = new WebMarkupContainer(this.getLIContainerId("reports"));
        this.body.add(new Component[]{liContainer});
        link = BookmarkablePageLinkBuilder.build("reports", Reports.class);
        MetaDataRoleAuthorizationStrategy.authorize(link, (Action)WebPage.RENDER, (String)"REPORT_LIST");
        liContainer.add(new Component[]{link});
        WebMarkupContainer confLIContainer = new WebMarkupContainer(this.getLIContainerId("configuration"));
        this.body.add(new Component[]{confLIContainer});
        WebMarkupContainer confULContainer = new WebMarkupContainer(this.getULContainerId("configuration"));
        confLIContainer.add(new Component[]{confULContainer});
        liContainer = new WebMarkupContainer(this.getLIContainerId("workflow"));
        liContainer.setOutputMarkupPlaceholderTag(true);
        liContainer.setVisible(platformInfo.isUserWorkflowAdapterSupportEdit());
        confULContainer.add(new Component[]{liContainer});
        link = BookmarkablePageLinkBuilder.build("workflow", Workflow.class);
        MetaDataRoleAuthorizationStrategy.authorize(link, (Action)WebPage.RENDER, (String)"WORKFLOW_DEF_GET");
        liContainer.add(new Component[]{link});
        liContainer = new WebMarkupContainer(this.getLIContainerId("audit"));
        confULContainer.add(new Component[]{liContainer});
        link = BookmarkablePageLinkBuilder.build("audit", Audit.class);
        MetaDataRoleAuthorizationStrategy.authorize(link, (Action)WebPage.RENDER, (String)"AUDIT_LIST");
        liContainer.add(new Component[]{link});
        liContainer = new WebMarkupContainer(this.getLIContainerId("logs"));
        confULContainer.add(new Component[]{liContainer});
        link = BookmarkablePageLinkBuilder.build("logs", Logs.class);
        MetaDataRoleAuthorizationStrategy.authorize(link, (Action)WebPage.RENDER, (String)"LOG_LIST");
        liContainer.add(new Component[]{link});
        liContainer = new WebMarkupContainer(this.getLIContainerId("securityquestions"));
        confULContainer.add(new Component[]{liContainer});
        bld = new StringBuilder();
        bld.append("SECURITY_QUESTION_CREATE").append(",").append("SECURITY_QUESTION_DELETE").append(",").append("SECURITY_QUESTION_UPDATE");
        link = BookmarkablePageLinkBuilder.build("securityquestions", SecurityQuestions.class);
        MetaDataRoleAuthorizationStrategy.authorize(link, (Action)WebPage.RENDER, (String)bld.toString());
        liContainer.add(new Component[]{link});
        liContainer = new WebMarkupContainer(this.getLIContainerId("types"));
        confULContainer.add(new Component[]{liContainer});
        link = BookmarkablePageLinkBuilder.build("types", Types.class);
        MetaDataRoleAuthorizationStrategy.authorize(link, (Action)WebPage.RENDER, (String)"SCHEMA_LIST");
        liContainer.add(new Component[]{link});
        liContainer = new WebMarkupContainer(this.getLIContainerId("administration"));
        confULContainer.add(new Component[]{liContainer});
        link = BookmarkablePageLinkBuilder.build("administration", Administration.class);
        MetaDataRoleAuthorizationStrategy.authorize(link, (Action)WebPage.RENDER, (String)"ROLE_LIST");
        liContainer.add(new Component[]{link});
        liContainer = new WebMarkupContainer(this.getLIContainerId("policies"));
        confULContainer.add(new Component[]{liContainer});
        link = BookmarkablePageLinkBuilder.build("policies", Policies.class);
        MetaDataRoleAuthorizationStrategy.authorize(link, (Action)WebPage.RENDER, (String)"POLICY_LIST");
        liContainer.add(new Component[]{link});
        liContainer = new WebMarkupContainer(this.getLIContainerId("notifications"));
        confULContainer.add(new Component[]{liContainer});
        link = BookmarkablePageLinkBuilder.build("notifications", Notifications.class);
        MetaDataRoleAuthorizationStrategy.authorize(link, (Action)WebPage.RENDER, (String)"NOTIFICATION_LIST");
        liContainer.add(new Component[]{link});
        liContainer = new WebMarkupContainer(this.getLIContainerId("parameters"));
        confULContainer.add(new Component[]{liContainer});
        link = BookmarkablePageLinkBuilder.build("parameters", Parameters.class);
        MetaDataRoleAuthorizationStrategy.authorize(link, (Action)WebPage.RENDER, (String)"CONFIGURATION_LIST");
        liContainer.add(new Component[]{link});
        this.body.add(new Component[]{new AjaxLink<Void>("collapse"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                SyncopeConsoleSession.get().setAttribute("MENU_COLLAPSE", Boolean.valueOf(SyncopeConsoleSession.get().getAttribute("MENU_COLLAPSE") == null ? true : (Boolean)SyncopeConsoleSession.get().getAttribute("MENU_COLLAPSE") == false));
            }
        }});
        this.body.add(new Component[]{new Label("domain", (Serializable)((Object)SyncopeConsoleSession.get().getDomain()))});
        final Class beforeLogout = (Class)SyncopeConsoleSession.get().getAttribute("beforeLogoutPage");
        if (beforeLogout == null) {
            this.body.add(new Component[]{new BookmarkablePageLink("logout", Logout.class)});
        } else {
            this.body.add(new Component[]{new AjaxLink<Page>("logout"){
                private static final long serialVersionUID = -7978723352517770644L;

                protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                    super.updateAjaxAttributes(attributes);
                    AjaxCallListener ajaxCallListener = new AjaxCallListener();
                    ajaxCallListener.onPrecondition((CharSequence)("return confirm('" + this.getString("confirmGlobalLogout") + "');"));
                    attributes.getAjaxCallListeners().add(ajaxCallListener);
                }

                public void onClick(AjaxRequestTarget target) {
                    this.setResponsePage(beforeLogout);
                }
            }});
        }
        Component containingLI = this.body.get(this.getLIContainerId(((Object)((Object)this)).getClass().getSimpleName().toLowerCase()));
        if (containingLI == null) {
            containingLI = confULContainer.get(this.getLIContainerId(((Object)((Object)this)).getClass().getSimpleName().toLowerCase()));
        }
        if (containingLI != null) {
            containingLI.add(new Behavior[]{new Behavior(){
                private static final long serialVersionUID = 1469628524240283489L;

                public void onComponentTag(Component component, ComponentTag tag) {
                    tag.put("class", (CharSequence)"active");
                }
            }});
            if (confULContainer.getId().equals(containingLI.getParent().getId())) {
                confULContainer.add(new Behavior[]{new Behavior(){
                    private static final long serialVersionUID = 3109256773218160485L;

                    public void onComponentTag(Component component, ComponentTag tag) {
                        tag.put("class", (CharSequence)"treeview-menu menu-open");
                        tag.put("style", (CharSequence)"display: block;");
                    }
                }});
                confLIContainer.add(new Behavior[]{new Behavior(){
                    private static final long serialVersionUID = 3109256773218160485L;

                    public void onComponentTag(Component component, ComponentTag tag) {
                        tag.put("class", (CharSequence)"treeview active");
                    }
                }});
            }
        }
        ClassPathScanImplementationLookup classPathScanImplementationLookup = (ClassPathScanImplementationLookup)SyncopeConsoleApplication.get().getServletContext().getAttribute("CLASSPATH_LOOKUP");
        List<Class<? extends BaseExtPage>> extPageClasses = classPathScanImplementationLookup.getExtPageClasses();
        WebMarkupContainer extensionsLI = new WebMarkupContainer(this.getLIContainerId("extensions"));
        extensionsLI.setOutputMarkupPlaceholderTag(true);
        extensionsLI.setVisible(!extPageClasses.isEmpty());
        this.body.add(new Component[]{extensionsLI});
        ListView<Class<? extends BaseExtPage>> extPages = new ListView<Class<? extends BaseExtPage>>("extPages", extPageClasses){
            private static final long serialVersionUID = 4949588177564901031L;

            protected void populateItem(ListItem<Class<? extends BaseExtPage>> item) {
                WebMarkupContainer containingLI = new WebMarkupContainer("extPageLI");
                item.add(new Component[]{containingLI});
                if (((Class)item.getModelObject()).equals(((Object)((Object)BasePage.this)).getClass())) {
                    containingLI.add(new Behavior[]{new Behavior(){
                        private static final long serialVersionUID = 1469628524240283489L;

                        public void onComponentTag(Component component, ComponentTag tag) {
                            tag.put("class", (CharSequence)"active");
                        }
                    }});
                }
                ExtPage ann = ((Class)item.getModelObject()).getAnnotation(ExtPage.class);
                BookmarkablePageLink link = new BookmarkablePageLink("extPage", (Class)item.getModelObject());
                link.add(new Component[]{new Label("extPageLabel", (Serializable)((Object)ann.label()))});
                if (StringUtils.isNotBlank((CharSequence)ann.listEntitlement())) {
                    MetaDataRoleAuthorizationStrategy.authorize((Component)link, (Action)WebPage.RENDER, (String)ann.listEntitlement());
                }
                containingLI.add(new Component[]{link});
                Label extPageIcon = new Label("extPageIcon");
                extPageIcon.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)("fa " + ann.icon())))});
                link.add(new Component[]{extPageIcon});
            }
        };
        extPages.setOutputMarkupId(true);
        extensionsLI.add(new Component[]{extPages});
        if (this.getPage() instanceof BaseExtPage) {
            extPages.add(new Behavior[]{new Behavior(){
                private static final long serialVersionUID = 1469628524240283489L;

                public void onComponentTag(Component component, ComponentTag tag) {
                    tag.put("class", (CharSequence)"treeview-menu menu-open");
                    tag.put("style", (CharSequence)"display: block;");
                }
            }});
            extensionsLI.add(new Behavior[]{new Behavior(){
                private static final long serialVersionUID = 1469628524240283489L;

                public void onComponentTag(Component component, ComponentTag tag) {
                    tag.put("class", (CharSequence)"treeview active");
                }
            }});
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)new PriorityHeaderItem(META_IE_EDGE));
    }

    private String getLIContainerId(String linkId) {
        return linkId + "LI";
    }

    private String getULContainerId(String linkId) {
        return linkId + "UL";
    }

    public String getAjaxIndicatorMarkupId() {
        return "veil";
    }

    public NotificationPanel getNotificationPanel() {
        return this.notificationPanel;
    }

    public ApprovalsWidget getApprovalsWidget() {
        return this.approvalsWidget;
    }

    public void setWindowClosedCallback(BaseModal<?> modal, final WebMarkupContainer container) {
        modal.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                if (container != null) {
                    target.add(new Component[]{container});
                }
            }
        });
    }
}

