/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.AccessTokenRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AccessTokenTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class AccessTokenDirectoryPanel
extends DirectoryPanel<AccessTokenTO, AccessTokenTO, AccessTokenDataProvider, AccessTokenRestClient> {
    private static final long serialVersionUID = -6903586269155682961L;

    protected AccessTokenDirectoryPanel(String id, Builder builder) {
        super(id, builder);
        this.setShowResultPage(true);
        this.modal.size(Modal.Size.Large);
        this.initResultTable();
    }

    @Override
    protected AccessTokenDataProvider dataProvider() {
        return new AccessTokenDataProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "accessToken.paginator.rows";
    }

    @Override
    protected List<IColumn<AccessTokenTO, String>> getColumns() {
        ArrayList<IColumn<AccessTokenTO, String>> columns = new ArrayList<IColumn<AccessTokenTO, String>>();
        columns.add((IColumn<AccessTokenTO, String>)new KeyPropertyColumn((IModel<String>)new StringResourceModel("key", (Component)this), "key", "key"));
        columns.add((IColumn<AccessTokenTO, String>)new PropertyColumn((IModel)new ResourceModel("owner"), (Object)"owner", "owner"));
        columns.add((IColumn<AccessTokenTO, String>)new AbstractColumn<AccessTokenTO, String>((IModel)new ResourceModel("issuedAt", "")){
            private static final long serialVersionUID = -1822504503325964706L;

            public void populateItem(Item<ICellPopulator<AccessTokenTO>> cellItem, String componentId, IModel<AccessTokenTO> model) {
                JwsJwtCompactConsumer consumer = new JwsJwtCompactConsumer(((AccessTokenTO)model.getObject()).getBody());
                cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)SyncopeConsoleSession.get().getDateFormat().format(new Date(consumer.getJwtClaims().getIssuedAt()))))});
            }
        });
        columns.add((IColumn<AccessTokenTO, String>)new DatePropertyColumn((IModel<String>)new ResourceModel("expiryTime"), "expiryTime", "expiryTime"));
        return columns;
    }

    @Override
    public ActionsPanel<AccessTokenTO> getActions(final IModel<AccessTokenTO> model) {
        ActionsPanel<AccessTokenTO> panel = super.getActions(model);
        panel.add(new ActionLink<AccessTokenTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, AccessTokenTO ignore) {
                try {
                    ((AccessTokenRestClient)AccessTokenDirectoryPanel.this.restClient).delete(((AccessTokenTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().info((Serializable)((Object)AccessTokenDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{AccessTokenDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting object {}", (Object)((AccessTokenTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
                }
                ((BasePage)AccessTokenDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "TASK_DELETE", true);
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBulkActions() {
        return Collections.emptyList();
    }

    protected class AccessTokenDataProvider
    extends DirectoryDataProvider<AccessTokenTO> {
        private static final long serialVersionUID = 6267494272884913376L;
        private final SortableDataProviderComparator<AccessTokenTO> comparator;
        private final AccessTokenRestClient restClient;

        public AccessTokenDataProvider(int paginatorRows) {
            super(paginatorRows);
            this.restClient = new AccessTokenRestClient();
            this.setSort("owner", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<AccessTokenTO>(this);
        }

        public Iterator<AccessTokenTO> iterator(long first, long count) {
            int page = (int)first / this.paginatorRows;
            List<AccessTokenTO> tasks = this.restClient.list((page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort());
            Collections.sort(tasks, this.comparator);
            return tasks.iterator();
        }

        public long size() {
            return this.restClient.count();
        }

        public IModel<AccessTokenTO> model(AccessTokenTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }

    public static abstract class Builder
    extends DirectoryPanel.Builder<AccessTokenTO, AccessTokenTO, AccessTokenRestClient> {
        private static final long serialVersionUID = 5088962796986706805L;

        public Builder(PageReference pageRef) {
            super(new AccessTokenRestClient(), pageRef);
        }

        @Override
        protected WizardMgtPanel<AccessTokenTO> newInstance(String id, boolean wizardInModal) {
            return new AccessTokenDirectoryPanel(id, this);
        }
    }
}

