/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.syncope.client.console.bulk.BulkActionModal;
import org.apache.syncope.client.console.bulk.BulkContent;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DataTablePanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.client.console.rest.RestClient;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormChoiceComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.AjaxFallbackDataTable;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.CheckGroupColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLinksTogglePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.CheckGroupSelector;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public final class AjaxDataTablePanel<T extends Serializable, S>
extends DataTablePanel<T, S> {
    private static final long serialVersionUID = -7264400471578272966L;

    private AjaxDataTablePanel(String id, final Builder<T, S> builder) {
        super(id);
        final BaseModal bulkModal = new BaseModal("bulkModal");
        this.add(new Component[]{bulkModal});
        bulkModal.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487149L;

            public void onClose(AjaxRequestTarget target) {
                bulkModal.show(false);
                DirectoryPanel.EventDataWrapper data = new DirectoryPanel.EventDataWrapper();
                data.setTarget(target);
                data.setRows(builder.rowsPerPage);
                AjaxDataTablePanel.this.send((IEventSink)builder.pageRef.getPage(), Broadcast.BREADTH, data);
                BasePage page = (BasePage)AjaxDataTablePanel.this.findPage();
                if (page != null) {
                    page.getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                }
            }
        });
        Fragment fragment = new Fragment("tablePanel", "bulkAvailable", (MarkupContainer)this);
        this.add(new Component[]{fragment});
        Form bulkActionForm = new Form("groupForm");
        fragment.add(new Component[]{bulkActionForm});
        this.group = new CheckGroup("checkgroup", this.model);
        this.group.add(new Behavior[]{new IndicatorAjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = -151291731388673682L;

            protected void onUpdate(final AjaxRequestTarget target) {
                AjaxDataTablePanel.this.group.visitChildren(CheckGroupSelector.class, (IVisitor)new IVisitor<CheckGroupSelector, List<CheckGroupSelector>>(){

                    public void component(CheckGroupSelector t, IVisit<List<CheckGroupSelector>> ivisit) {
                        target.focusComponent((Component)t);
                        ivisit.stop();
                    }
                });
            }
        }});
        bulkActionForm.add(new Component[]{this.group});
        if (((Builder)builder).checkBoxEnabled) {
            ((Builder)builder).columns.add(0, new CheckGroupColumn(this.group));
        }
        this.dataTable = new AjaxFallbackDataTable<T, S>("dataTable", ((Builder)builder).columns, ((Builder)builder).dataProvider, ((Builder)builder).rowsPerPage, ((Builder)builder).container){
            private static final long serialVersionUID = -7370603907251344224L;

            @Override
            protected ActionsPanel<T> getActions(IModel<T> model) {
                return builder.getActions(model);
            }

            @Override
            protected ActionLinksTogglePanel<T> getTogglePanel() {
                return builder.getTogglePanel();
            }
        };
        this.dataTable.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"table table-bordered table-hover dataTable"))});
        this.group.add(new Component[]{this.dataTable});
        fragment.add(new Component[]{new IndicatingAjaxButton("bulkActionLink", bulkActionForm){
            private static final long serialVersionUID = 382302811235019988L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                if (builder.getTogglePanel() != null) {
                    builder.getTogglePanel().close(target);
                }
                if (builder.multiLevelPanel == null) {
                    bulkModal.header((IModel)new ResourceModel("bulk.action", "Bulk action"));
                    bulkModal.changeCloseButtonLabel(this.getString("cancel", null, "Cancel"), target);
                    target.add(new Component[]{bulkModal.setContent(new BulkActionModal(bulkModal, builder.pageRef, new ArrayList((Collection)AjaxDataTablePanel.this.group.getModelObject()), new ArrayList(builder.columns.subList(1, builder.columns.size())), builder.bulkActions, builder.bulkActionExecutor, builder.itemKeyField))});
                    bulkModal.show(true);
                } else {
                    builder.multiLevelPanel.next(this.getString("bulk.action"), new BulkContent(builder.baseModal, new ArrayList((Collection)AjaxDataTablePanel.this.group.getModelObject()), new ArrayList(builder.columns.subList(1, builder.columns.size() - 1)), builder.bulkActions, builder.bulkActionExecutor, builder.itemKeyField), target);
                }
                AjaxDataTablePanel.this.group.setModelObject(Collections.emptyList());
                target.add(new Component[]{AjaxDataTablePanel.this.group});
            }
        }.setEnabled(((Builder)builder).isBulkEnabled()).setVisible(((Builder)builder).isBulkEnabled())});
    }

    public static class Builder<T extends Serializable, S>
    implements Serializable {
        private static final long serialVersionUID = 8876232177473972722L;
        private boolean checkBoxEnabled = true;
        private final List<IColumn<T, S>> columns = new ArrayList<IColumn<T, S>>();
        private final ISortableDataProvider<T, S> dataProvider;
        private int rowsPerPage = 10;
        private final Collection<ActionLink.ActionType> bulkActions = new ArrayList<ActionLink.ActionType>();
        private RestClient bulkActionExecutor;
        private String itemKeyField;
        private final PageReference pageRef;
        private WebMarkupContainer container;
        private MultilevelPanel multiLevelPanel;
        private BaseModal<?> baseModal;

        public Builder(ISortableDataProvider<T, S> provider, PageReference pageRef) {
            this.dataProvider = provider;
            this.pageRef = pageRef;
        }

        public AjaxDataTablePanel<T, S> build(String id) {
            return new AjaxDataTablePanel(id, this);
        }

        public Builder<T, S> setContainer(WebMarkupContainer container) {
            this.container = container;
            return this;
        }

        public Builder<T, S> addBulkAction(ActionLink.ActionType actionType) {
            this.bulkActions.add(actionType);
            return this;
        }

        public Builder<T, S> setBulkActionExecutor(BaseRestClient bulkActionExecutor) {
            this.bulkActionExecutor = bulkActionExecutor;
            return this;
        }

        public Builder<T, S> setItemKeyField(String itemKeyField) {
            this.itemKeyField = itemKeyField;
            return this;
        }

        public Builder<T, S> setBulkActions(Collection<ActionLink.ActionType> bulkActions, RestClient bulkActionExecutor, String itemKeyField) {
            this.bulkActions.clear();
            if (bulkActions != null) {
                this.bulkActions.addAll(bulkActions);
            }
            this.bulkActionExecutor = bulkActionExecutor;
            this.itemKeyField = itemKeyField;
            return this;
        }

        public Builder<T, S> addColumn(IColumn<T, S> column) {
            this.columns.add(column);
            return this;
        }

        public Builder<T, S> setColumns(List<IColumn<T, S>> columns) {
            this.columns.clear();
            if (columns != null) {
                this.columns.addAll(columns);
            }
            return this;
        }

        public Builder<T, S> setRowsPerPage(int rowsPerPage) {
            this.rowsPerPage = rowsPerPage;
            return this;
        }

        public Builder<T, S> disableCheckBoxes() {
            this.checkBoxEnabled = false;
            return this;
        }

        private boolean isBulkEnabled() {
            return this.checkBoxEnabled && this.bulkActionExecutor != null && !this.bulkActions.isEmpty();
        }

        public void setMultiLevelPanel(BaseModal<?> baseModal, MultilevelPanel multiLevelPanel) {
            this.multiLevelPanel = multiLevelPanel;
            this.baseModal = baseModal;
        }

        protected ActionsPanel<T> getActions(IModel<T> model) {
            return null;
        }

        protected ActionLinksTogglePanel<T> getTogglePanel() {
            return null;
        }
    }
}

