/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.client.console.annotations.ExtWidget;
import org.apache.syncope.client.console.widgets.BaseExtWidget;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class DashboardExtensionsPanel
extends Panel {
    private static final long serialVersionUID = 6381578992589664490L;
    protected static final Logger LOG = LoggerFactory.getLogger(DashboardExtensionsPanel.class);

    public DashboardExtensionsPanel(String id, List<Class<? extends BaseExtWidget>> extWidgetClasses, PageReference pageRef) {
        super(id);
        ArrayList instances = new ArrayList();
        for (Class<? extends BaseExtWidget> clazz : extWidgetClasses) {
            Constructor constructor = ClassUtils.getConstructorIfAvailable(clazz, (Class[])new Class[]{String.class, PageReference.class});
            if (constructor == null) {
                LOG.error("Could not find required construtor in {}, ignoring", clazz);
                continue;
            }
            try {
                instances.add(constructor.newInstance("widget", pageRef));
            }
            catch (Exception e) {
                LOG.error("While creating instance of {}", clazz, (Object)e);
            }
        }
        ListView<BaseExtWidget> widgets = new ListView<BaseExtWidget>("widgets", instances){
            private static final long serialVersionUID = 4949588177564901031L;

            protected void populateItem(ListItem<BaseExtWidget> item) {
                WebMarkupContainer widgetContainer = new WebMarkupContainer("widgetContainer");
                widgetContainer.setOutputMarkupId(true);
                ExtWidget ann = ((Object)((Object)((BaseExtWidget)((Object)item.getModelObject())))).getClass().getAnnotation(ExtWidget.class);
                if (ann != null) {
                    widgetContainer.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)ann.cssClass()))});
                }
                item.add(new Component[]{widgetContainer});
                ((BaseExtWidget)((Object)item.getModelObject())).setOutputMarkupId(true);
                widgetContainer.add(new Component[]{(Component)item.getModelObject()});
            }
        };
        this.add(new Component[]{widgets});
    }
}

