/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.syncope.client.console.PreferenceManager;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.common.lib.search.SearchableFields;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;

public abstract class DisplayAttributesModalPanel<T extends Serializable>
extends AbstractModalPanel<T> {
    private static final long serialVersionUID = -4274117450918385110L;
    private static final int MAX_SELECTIONS = 9;
    private final PreferenceManager prefMan = new PreferenceManager();
    private final List<String> selectedDetails;
    private final List<String> selectedPlainSchemas;
    private final List<String> selectedDerSchemas;
    protected final String type;

    public DisplayAttributesModalPanel(BaseModal<T> modal, PageReference pageRef, final List<String> pSchemaNames, final List<String> dSchemaNames, String type) {
        super(modal, pageRef);
        this.type = type;
        final List detailslList = SearchableFields.get(DisplayAttributesModalPanel.getTOClass(type));
        Collections.sort(detailslList);
        Collections.sort(pSchemaNames);
        Collections.sort(dSchemaNames);
        LoadableDetachableModel<List<String>> fnames = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return detailslList;
            }
        };
        LoadableDetachableModel<List<String>> psnames = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return pSchemaNames;
            }
        };
        LoadableDetachableModel<List<String>> dsnames = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return dSchemaNames;
            }
        };
        this.selectedDetails = this.prefMan.getList(this.getRequest(), DisplayAttributesModalPanel.getPrefDetailView(type));
        this.selectedPlainSchemas = this.prefMan.getList(this.getRequest(), DisplayAttributesModalPanel.getPrefPlainAttributeView(type));
        this.selectedDerSchemas = this.prefMan.getList(this.getRequest(), DisplayAttributesModalPanel.getPrefDerivedAttributeView(type));
        WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        AjaxPalettePanel details = new AjaxPalettePanel.Builder().setAllowOrder(true).setAllowMoveAll(true).build("details", new PropertyModel((Object)this, "selectedDetails"), new ListModel((List)fnames.getObject()));
        details.hideLabel();
        details.setOutputMarkupId(true);
        container.add(new Component[]{details});
        AjaxPalettePanel plainSchemas = new AjaxPalettePanel.Builder().setAllowOrder(true).setAllowMoveAll(true).build("plainSchemas", new PropertyModel((Object)this, "selectedPlainSchemas"), new ListModel((List)psnames.getObject()));
        plainSchemas.hideLabel();
        plainSchemas.setOutputMarkupId(true);
        container.add(new Component[]{plainSchemas});
        AjaxPalettePanel derSchemas = new AjaxPalettePanel.Builder().setAllowOrder(true).setAllowMoveAll(true).build("derSchemas", new PropertyModel((Object)this, "selectedDerSchemas"), new ListModel((List)dsnames.getObject()));
        derSchemas.hideLabel();
        derSchemas.setOutputMarkupId(true);
        container.add(new Component[]{derSchemas});
    }

    @Override
    public void onSubmit(AjaxRequestTarget target, Form<?> form) {
        if (this.selectedDetails.size() + this.selectedPlainSchemas.size() + this.selectedDerSchemas.size() > 9) {
            SyncopeConsoleSession.get().error((Serializable)((Object)this.getString("tooManySelections")));
            this.onError(target, form);
        } else {
            HashMap<String, List<String>> prefs = new HashMap<String, List<String>>();
            prefs.put(DisplayAttributesModalPanel.getPrefDetailView(this.type), this.selectedDetails);
            prefs.put(DisplayAttributesModalPanel.getPrefPlainAttributeView(this.type), this.selectedPlainSchemas);
            prefs.put(DisplayAttributesModalPanel.getPrefDerivedAttributeView(this.type), this.selectedDerSchemas);
            this.prefMan.setList(this.getRequest(), this.getResponse(), prefs);
            SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
            this.modal.close((IPartialPageRequestHandler)target);
            ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        }
    }

    protected static final String getPrefDetailView(String type) {
        return String.format("any.%s.details.view", type);
    }

    protected static final String getPrefPlainAttributeView(String type) {
        return String.format("any.%s.plain.attrs.view", type);
    }

    protected static final String getPrefDerivedAttributeView(String type) {
        return String.format("any.%s.der.attrs.view", type);
    }

    protected static final Class<? extends AnyTO> getTOClass(String type) {
        if (type.equalsIgnoreCase(AnyTypeKind.USER.name())) {
            return UserTO.class;
        }
        if (type.equalsIgnoreCase(AnyTypeKind.USER.name())) {
            return GroupTO.class;
        }
        return AnyObjectTO.class;
    }
}

