/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.ui.JQueryUIBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Alert;
import de.agilecoders.wicket.core.util.Attributes;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.syncope.common.lib.log.LogStatementTO;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class LogStatementPanel
extends Panel {
    private static final long serialVersionUID = 1610867968070669922L;
    private static final FastDateFormat FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final String labelCssClass;

    public LogStatementPanel(String id, LogStatementTO statement) {
        super(id);
        Alert.Type type;
        switch (statement.getLevel()) {
            case DEBUG: {
                type = Alert.Type.Success;
                break;
            }
            case INFO: {
                type = Alert.Type.Info;
                break;
            }
            case ERROR: {
                type = Alert.Type.Danger;
                break;
            }
            case WARN: {
                type = Alert.Type.Warning;
                break;
            }
            default: {
                type = Alert.Type.Info;
            }
        }
        this.labelCssClass = "label-" + type.name().toLowerCase();
        this.add(new Component[]{new Label("logger", (IModel)Model.of((Serializable)((Object)statement.getLoggerName())))});
        this.add(new Component[]{new Label("instant", (IModel)Model.of((Serializable)((Object)FORMAT.format(statement.getTimeMillis()))))});
        this.add(new Component[]{new Label("message", (IModel)Model.of((Serializable)((Object)statement.getMessage())))});
        WebMarkupContainer collapse = new WebMarkupContainer("collapse");
        collapse.setOutputMarkupId(true);
        collapse.setOutputMarkupPlaceholderTag(true);
        collapse.setVisible(StringUtils.isNotBlank((CharSequence)statement.getStackTrace()));
        collapse.add(new Behavior[]{new JQueryUIBehavior("#" + collapse.getMarkupId(), "accordion", new Options("active", (Object)false).set("collapsible", (Object)true))});
        this.add(new Component[]{collapse});
        Label stacktrace = new Label("stacktrace", (IModel)Model.of((Serializable)((Object)statement.getStackTrace())));
        stacktrace.setOutputMarkupId(true);
        collapse.add(new Component[]{stacktrace});
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "div");
        Attributes.addClass((ComponentTag)tag, (String[])new String[]{this.labelCssClass});
    }
}

