/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.util.Arrays;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleApplication;
import org.apache.syncope.client.console.commons.PropertyList;
import org.apache.syncope.client.console.init.MIMETypesLoader;
import org.apache.syncope.client.console.panels.ParametersCreateWizardPanel;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class ParametersCreateWizardSchemaStep
extends WizardStep {
    private static final long serialVersionUID = -7843275202297616553L;
    private static final MIMETypesLoader MIME_TYPES_LOADER = (MIMETypesLoader)SyncopeConsoleApplication.get().getServletContext().getAttribute("MIMETYPES_LOADER");

    public ParametersCreateWizardSchemaStep(final ParametersCreateWizardPanel.ParametersForm modelObject) {
        modelObject.getPlainSchemaTO().setMandatoryCondition("false");
        final WebMarkupContainer content = new WebMarkupContainer("content");
        this.setOutputMarkupId(true);
        content.setOutputMarkupId(true);
        this.add(new Component[]{content});
        final AjaxDropDownChoicePanel<AttrSchemaType> type = new AjaxDropDownChoicePanel<AttrSchemaType>("type", this.getString("type"), (IModel<AttrSchemaType>)new PropertyModel((Object)modelObject.getPlainSchemaTO(), "type"));
        type.setChoices(Arrays.asList(AttrSchemaType.values()));
        content.add(new Component[]{type});
        final MultiFieldPanel<String> panel = new MultiFieldPanel.Builder<String>((IModel)new PropertyModel<List<String>>((Object)modelObject.getPlainSchemaTO(), "enumerationValues"){
            private static final long serialVersionUID = 3985215199105092649L;

            public PropertyList<PlainSchemaTO> getObject() {
                return new PropertyList<PlainSchemaTO>(){

                    @Override
                    public String getValues() {
                        return modelObject.getPlainSchemaTO().getEnumerationValues();
                    }

                    @Override
                    public void setValues(List<String> list) {
                        modelObject.getPlainSchemaTO().setEnumerationValues(1.getEnumValuesAsString(list));
                    }
                };
            }

            public void setObject(List<String> object) {
                modelObject.getPlainSchemaTO().setEnumerationValues(PropertyList.getEnumValuesAsString(object));
            }
        }){
            private static final long serialVersionUID = -8752965211744734798L;

            @Override
            protected String newModelObject() {
                return "";
            }
        }.build("values", this.getString("values"), new AjaxTextFieldPanel("panel", this.getString("values"), (IModel<String>)new Model(), false));
        panel.setVisible(false);
        content.add(new Component[]{panel});
        final AjaxTextFieldPanel mimeType = new AjaxTextFieldPanel("mimeType", "MIME-Type", (IModel<String>)new PropertyModel((Object)modelObject.getPlainSchemaTO(), "mimeType"));
        mimeType.setVisible(false);
        content.add(new Component[]{mimeType});
        final AjaxTextFieldPanel secretKey = new AjaxTextFieldPanel("secretKey", "Secret-key", (IModel<String>)new PropertyModel((Object)modelObject.getPlainSchemaTO(), "secretKey"));
        final AjaxDropDownChoicePanel<CipherAlgorithm> cipherAlgorithm = new AjaxDropDownChoicePanel<CipherAlgorithm>("cipherAlgorithm", "Cipher-algorithm", (IModel<CipherAlgorithm>)new PropertyModel((Object)modelObject.getPlainSchemaTO(), "cipherAlgorithm"));
        cipherAlgorithm.setChoices(Arrays.asList(CipherAlgorithm.values()));
        secretKey.setVisible(false);
        cipherAlgorithm.setVisible(false);
        content.add(new Component[]{secretKey});
        content.add(new Component[]{cipherAlgorithm});
        this.showHide(type, secretKey, cipherAlgorithm, mimeType);
        type.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if ("enum".equalsIgnoreCase(((AttrSchemaType)type.getField().getModelObject()).name())) {
                    panel.setVisible(true);
                    content.add(new Component[]{panel});
                    target.add(new Component[]{content});
                } else {
                    panel.setVisible(false);
                    content.add(new Component[]{panel});
                    target.add(new Component[]{content});
                }
                ParametersCreateWizardSchemaStep.this.showHide(type, secretKey, cipherAlgorithm, mimeType);
            }
        }});
        AjaxCheckBoxPanel multiValue = new AjaxCheckBoxPanel("panel", this.getString("multivalue"), (IModel<Boolean>)new PropertyModel((Object)modelObject.getPlainSchemaTO(), "multivalue"), false);
        content.add(new Component[]{multiValue});
    }

    private void showHide(AjaxDropDownChoicePanel<AttrSchemaType> type, AjaxTextFieldPanel secretKey, AjaxDropDownChoicePanel<CipherAlgorithm> cipherAlgorithm, AjaxTextFieldPanel mimeType) {
        int typeOrdinal = Integer.parseInt(type.getField().getValue());
        if (AttrSchemaType.Encrypted.ordinal() == typeOrdinal) {
            mimeType.setVisible(false);
            secretKey.setVisible(true);
            secretKey.addRequiredLabel();
            cipherAlgorithm.setVisible(true);
            cipherAlgorithm.addRequiredLabel();
        } else if (AttrSchemaType.Binary.ordinal() == typeOrdinal) {
            secretKey.setVisible(false);
            cipherAlgorithm.setVisible(false);
            mimeType.setVisible(true);
            mimeType.setChoices(MIME_TYPES_LOADER.getMimeTypes());
        }
    }
}

