/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleApplication;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.Constants;
import org.apache.syncope.client.console.commons.PropertyList;
import org.apache.syncope.client.console.init.MIMETypesLoader;
import org.apache.syncope.client.console.panels.AbstractSchemaDetailsPanel;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.common.lib.to.AbstractSchemaTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.string.Strings;

public class PlainSchemaDetails
extends AbstractSchemaDetailsPanel {
    private static final long serialVersionUID = 5378100729213456451L;
    private static final MIMETypesLoader MIME_TYPES_LOADER = (MIMETypesLoader)SyncopeConsoleApplication.get().getServletContext().getAttribute("MIMETYPES_LOADER");
    private final MultiFieldPanel<String> enumerationValues;
    private final MultiFieldPanel<String> enumerationKeys;

    public PlainSchemaDetails(String id, PageReference pageReference, final AbstractSchemaTO schemaTO) {
        super(id, pageReference, schemaTO);
        final AjaxDropDownChoicePanel<AttrSchemaType> type = new AjaxDropDownChoicePanel<AttrSchemaType>("type", this.getString("type"), (IModel<AttrSchemaType>)new PropertyModel((Object)schemaTO, "type"));
        type.setChoices(Arrays.asList(AttrSchemaType.values()));
        type.setEnabled(schemaTO == null || schemaTO.getKey() == null || schemaTO.getKey().isEmpty());
        type.addRequiredLabel();
        this.schemaForm.add(new Component[]{type});
        final AjaxTextFieldPanel conversionPattern = new AjaxTextFieldPanel("conversionPattern", this.getString("conversionPattern"), (IModel<String>)new PropertyModel((Object)schemaTO, "conversionPattern"));
        this.schemaForm.add(new Component[]{conversionPattern});
        final WebMarkupContainer conversionParams = new WebMarkupContainer("conversionParams");
        conversionParams.setOutputMarkupPlaceholderTag(true);
        conversionParams.add(new Component[]{conversionPattern});
        this.schemaForm.add(new Component[]{conversionParams});
        final WebMarkupContainer typeParams = new WebMarkupContainer("typeParams");
        typeParams.setOutputMarkupPlaceholderTag(true);
        final AjaxTextFieldPanel enumerationValuesPanel = new AjaxTextFieldPanel("panel", "enumerationValues", (IModel<String>)new Model(null));
        this.enumerationValues = new MultiFieldPanel.Builder<String>((IModel)new PropertyModel<List<String>>((Object)schemaTO, "enumerationValues"){
            private static final long serialVersionUID = -4953564762272833993L;

            public PropertyList<PlainSchemaTO> getObject() {
                return new PropertyList<PlainSchemaTO>(){

                    @Override
                    public String getValues() {
                        return ((PlainSchemaTO)PlainSchemaTO.class.cast(schemaTO)).getEnumerationValues();
                    }

                    @Override
                    public void setValues(List<String> list) {
                        ((PlainSchemaTO)PlainSchemaTO.class.cast(schemaTO)).setEnumerationValues(1.getEnumValuesAsString(list));
                    }
                };
            }

            public void setObject(List<String> object) {
                ((PlainSchemaTO)PlainSchemaTO.class.cast(schemaTO)).setEnumerationValues(PropertyList.getEnumValuesAsString(object));
            }
        }){
            private static final long serialVersionUID = -8752965211744734798L;

            @Override
            protected String newModelObject() {
                return "";
            }
        }.build("enumerationValues", "enumerationValues", enumerationValuesPanel);
        this.enumerationKeys = new MultiFieldPanel.Builder<String>((IModel)new PropertyModel<List<String>>((Object)schemaTO, "enumerationKeys"){
            private static final long serialVersionUID = -4953564762272833993L;

            public PropertyList<PlainSchemaTO> getObject() {
                return new PropertyList<PlainSchemaTO>(){

                    @Override
                    public String getValues() {
                        return ((PlainSchemaTO)PlainSchemaTO.class.cast(schemaTO)).getEnumerationKeys();
                    }

                    @Override
                    public void setValues(List<String> list) {
                        ((PlainSchemaTO)PlainSchemaTO.class.cast(schemaTO)).setEnumerationKeys(PropertyList.getEnumValuesAsString(list));
                    }
                };
            }

            public void setObject(List<String> object) {
                ((PlainSchemaTO)PlainSchemaTO.class.cast(schemaTO)).setEnumerationKeys(PropertyList.getEnumValuesAsString(object));
            }
        }){
            private static final long serialVersionUID = -8752965211744734798L;

            @Override
            protected String newModelObject() {
                return "";
            }
        }.build("enumerationKeys", "enumerationKeys", new AjaxTextFieldPanel("panel", "enumerationKeys", (IModel<String>)new Model()));
        final WebMarkupContainer enumParams = new WebMarkupContainer("enumParams");
        enumParams.setOutputMarkupPlaceholderTag(true);
        enumParams.add(new Component[]{this.enumerationValues});
        enumParams.add(new Component[]{this.enumerationKeys});
        typeParams.add(new Component[]{enumParams});
        final AjaxTextFieldPanel secretKey = new AjaxTextFieldPanel("secretKey", this.getString("secretKey"), (IModel<String>)new PropertyModel((Object)schemaTO, "secretKey"));
        final AjaxDropDownChoicePanel<CipherAlgorithm> cipherAlgorithm = new AjaxDropDownChoicePanel<CipherAlgorithm>("cipherAlgorithm", this.getString("cipherAlgorithm"), (IModel<CipherAlgorithm>)new PropertyModel((Object)schemaTO, "cipherAlgorithm"));
        cipherAlgorithm.setChoices(Arrays.asList(CipherAlgorithm.values()));
        final WebMarkupContainer encryptedParams = new WebMarkupContainer("encryptedParams");
        encryptedParams.setOutputMarkupPlaceholderTag(true);
        encryptedParams.add(new Component[]{secretKey});
        encryptedParams.add(new Component[]{cipherAlgorithm});
        typeParams.add(new Component[]{encryptedParams});
        final AjaxTextFieldPanel mimeType = new AjaxTextFieldPanel("mimeType", this.getString("mimeType"), (IModel<String>)new PropertyModel((Object)schemaTO, "mimeType"));
        final WebMarkupContainer binaryParams = new WebMarkupContainer("binaryParams");
        binaryParams.setOutputMarkupPlaceholderTag(true);
        binaryParams.add(new Component[]{mimeType});
        typeParams.add(new Component[]{binaryParams});
        this.schemaForm.add(new Component[]{typeParams});
        this.showHide(schemaTO, type, conversionParams, conversionPattern, enumParams, enumerationValuesPanel, this.enumerationValues, this.enumerationKeys, encryptedParams, secretKey, cipherAlgorithm, binaryParams, mimeType);
        type.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                PlainSchemaDetails.this.showHide(schemaTO, type, conversionParams, conversionPattern, enumParams, enumerationValuesPanel, PlainSchemaDetails.this.enumerationValues, PlainSchemaDetails.this.enumerationKeys, encryptedParams, secretKey, cipherAlgorithm, binaryParams, mimeType);
                target.add(new Component[]{conversionParams});
                target.add(new Component[]{typeParams});
            }
        }});
        LoadableDetachableModel<List<String>> validatorsList = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return new ArrayList<String>(SyncopeConsoleSession.get().getPlatformInfo().getValidators());
            }
        };
        AjaxDropDownChoicePanel validatorClass = new AjaxDropDownChoicePanel("validatorClass", this.getString("validatorClass"), new PropertyModel((Object)schemaTO, "validatorClass"));
        ((DropDownChoice)validatorClass.getField()).setNullValid(true);
        validatorClass.setChoices((List)validatorsList.getObject());
        this.schemaForm.add(new Component[]{validatorClass});
        AutoCompleteTextField<String> mandatoryCondition = new AutoCompleteTextField<String>("mandatoryCondition"){
            private static final long serialVersionUID = -2428903969518079100L;

            protected Iterator<String> getChoices(String input) {
                List<Object> choices = new ArrayList();
                if (Strings.isEmpty((CharSequence)input)) {
                    choices = Collections.emptyList();
                } else if ("true".startsWith(input.toLowerCase())) {
                    choices.add("true");
                } else if ("false".startsWith(input.toLowerCase())) {
                    choices.add("false");
                }
                return choices.iterator();
            }
        };
        mandatoryCondition.add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
            }
        }});
        this.schemaForm.add(new Component[]{mandatoryCondition});
        this.schemaForm.add(new Component[]{Constants.getJEXLPopover((Component)this, TooltipConfig.Placement.right)});
        this.schemaForm.add(new Component[]{new AjaxCheckBoxPanel("multivalue", this.getString("multivalue"), (IModel<Boolean>)new PropertyModel((Object)schemaTO, "multivalue"))});
        this.schemaForm.add(new Component[]{new AjaxCheckBoxPanel("readonly", this.getString("readonly"), (IModel<Boolean>)new PropertyModel((Object)schemaTO, "readonly"))});
        this.schemaForm.add(new Component[]{new AjaxCheckBoxPanel("uniqueConstraint", this.getString("uniqueConstraint"), (IModel<Boolean>)new PropertyModel((Object)schemaTO, "uniqueConstraint"))});
    }

    private void showHide(AbstractSchemaTO schema, AjaxDropDownChoicePanel<AttrSchemaType> type, WebMarkupContainer conversionParams, AjaxTextFieldPanel conversionPattern, WebMarkupContainer enumParams, AjaxTextFieldPanel enumerationValuesPanel, MultiFieldPanel<String> enumerationValues, MultiFieldPanel<String> enumerationKeys, WebMarkupContainer encryptedParams, AjaxTextFieldPanel secretKey, AjaxDropDownChoicePanel<CipherAlgorithm> cipherAlgorithm, WebMarkupContainer binaryParams, AjaxTextFieldPanel mimeType) {
        int typeOrdinal = Integer.parseInt(type.getField().getValue());
        if (AttrSchemaType.Long.ordinal() == typeOrdinal || AttrSchemaType.Double.ordinal() == typeOrdinal || AttrSchemaType.Date.ordinal() == typeOrdinal) {
            conversionParams.setVisible(true);
            enumParams.setVisible(false);
            if (enumerationValuesPanel.isRequired()) {
                enumerationValuesPanel.removeRequiredLabel();
            }
            enumerationValues.setModelObject(PropertyList.getEnumValuesAsList(null));
            enumerationKeys.setModelObject(PropertyList.getEnumValuesAsList(null));
            encryptedParams.setVisible(false);
            if (secretKey.isRequired()) {
                secretKey.removeRequiredLabel();
            }
            secretKey.setModelObject(null);
            if (cipherAlgorithm.isRequired()) {
                cipherAlgorithm.removeRequiredLabel();
            }
            cipherAlgorithm.setModelObject(null);
            binaryParams.setVisible(false);
            mimeType.setModelObject(null);
            mimeType.setChoices(null);
        } else if (AttrSchemaType.Enum.ordinal() == typeOrdinal) {
            conversionParams.setVisible(false);
            conversionPattern.setModelObject(null);
            enumParams.setVisible(true);
            if (!enumerationValuesPanel.isRequired()) {
                enumerationValuesPanel.addRequiredLabel();
            }
            enumerationValues.setModelObject(PropertyList.getEnumValuesAsList(((PlainSchemaTO)schema).getEnumerationValues()));
            enumerationKeys.setModelObject(PropertyList.getEnumValuesAsList(((PlainSchemaTO)schema).getEnumerationKeys()));
            encryptedParams.setVisible(false);
            if (secretKey.isRequired()) {
                secretKey.removeRequiredLabel();
            }
            secretKey.setModelObject(null);
            if (cipherAlgorithm.isRequired()) {
                cipherAlgorithm.removeRequiredLabel();
            }
            cipherAlgorithm.setModelObject(null);
            binaryParams.setVisible(false);
            mimeType.setModelObject(null);
            mimeType.setChoices(null);
        } else if (AttrSchemaType.Encrypted.ordinal() == typeOrdinal) {
            conversionParams.setVisible(false);
            conversionPattern.setModelObject(null);
            enumParams.setVisible(false);
            if (enumerationValuesPanel.isRequired()) {
                enumerationValuesPanel.removeRequiredLabel();
            }
            enumerationValues.setModelObject(PropertyList.getEnumValuesAsList(null));
            enumerationKeys.setModelObject(PropertyList.getEnumValuesAsList(null));
            encryptedParams.setVisible(true);
            if (!secretKey.isRequired()) {
                secretKey.addRequiredLabel();
            }
            if (cipherAlgorithm.isRequired()) {
                cipherAlgorithm.addRequiredLabel();
            }
            binaryParams.setVisible(false);
            mimeType.setModelObject(null);
            mimeType.setChoices(null);
        } else if (AttrSchemaType.Binary.ordinal() == typeOrdinal) {
            conversionParams.setVisible(false);
            conversionPattern.setModelObject(null);
            enumParams.setVisible(false);
            if (enumerationValuesPanel.isRequired()) {
                enumerationValuesPanel.removeRequiredLabel();
            }
            enumerationValues.setModelObject(PropertyList.getEnumValuesAsList(null));
            enumerationKeys.setModelObject(PropertyList.getEnumValuesAsList(null));
            encryptedParams.setVisible(false);
            if (secretKey.isRequired()) {
                secretKey.removeRequiredLabel();
            }
            secretKey.setModelObject(null);
            if (cipherAlgorithm.isRequired()) {
                cipherAlgorithm.removeRequiredLabel();
            }
            cipherAlgorithm.setModelObject(null);
            binaryParams.setVisible(true);
            mimeType.setChoices(MIME_TYPES_LOADER.getMimeTypes());
        } else {
            conversionParams.setVisible(false);
            conversionPattern.setModelObject(null);
            enumParams.setVisible(false);
            if (enumerationValuesPanel.isRequired()) {
                enumerationValuesPanel.removeRequiredLabel();
            }
            enumerationValues.setModelObject(PropertyList.getEnumValuesAsList(null));
            enumerationKeys.setModelObject(PropertyList.getEnumValuesAsList(null));
            encryptedParams.setVisible(false);
            if (secretKey.isRequired()) {
                secretKey.removeRequiredLabel();
            }
            secretKey.setModelObject(null);
            if (cipherAlgorithm.isRequired()) {
                cipherAlgorithm.removeRequiredLabel();
            }
            cipherAlgorithm.setModelObject(null);
            binaryParams.setVisible(false);
            mimeType.setModelObject(null);
            mimeType.setChoices(null);
        }
    }
}

