/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.AlignmentBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonList;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.DropDownButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.GlyphIconType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.common.lib.to.DynRealmTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public class RealmChoicePanel
extends Panel {
    private static final long serialVersionUID = -1100228004207271270L;
    private final RealmRestClient realmRestClient = new RealmRestClient();
    private final PageReference pageRef;
    private final LoadableDetachableModel<List<Pair<String, RealmTO>>> realmTree;
    private final LoadableDetachableModel<List<DynRealmTO>> dynRealmTree;
    private final WebMarkupContainer container;
    private Model<RealmTO> model;
    private final Collection<String> availableRealms;
    private final Map<String, Pair<RealmTO, List<RealmTO>>> tree;
    private final List<AbstractLink> links = new ArrayList<AbstractLink>();

    public RealmChoicePanel(String id, PageReference pageRef) {
        super(id);
        this.pageRef = pageRef;
        this.tree = new HashMap<String, Pair<RealmTO, List<RealmTO>>>();
        RealmTO fakeRootRealm = new RealmTO();
        fakeRootRealm.setName("/");
        fakeRootRealm.setFullPath("/");
        this.model = Model.of((Serializable)fakeRootRealm);
        this.realmTree = new LoadableDetachableModel<List<Pair<String, RealmTO>>>(){
            private static final long serialVersionUID = -7688359318035249200L;

            private void getChildren(List<Pair<String, RealmTO>> full, String key, Map<String, Pair<RealmTO, List<RealmTO>>> tree, String indent) {
                if (tree.containsKey(key)) {
                    Pair<RealmTO, List<RealmTO>> subtree = tree.get(key);
                    for (RealmTO child : (List)subtree.getValue()) {
                        full.add((Pair<String, RealmTO>)Pair.of((Object)(indent + child.getName()), (Object)child));
                        this.getChildren(full, child.getKey(), tree, "     " + indent + (indent.isEmpty() ? "|--- " : ""));
                    }
                }
            }

            protected List<Pair<String, RealmTO>> load() {
                Map map = RealmChoicePanel.this.reloadRealmParentMap();
                RealmChoicePanel.this.model.setObject((Serializable)((Pair)map.get(null)).getKey());
                ArrayList<Pair<String, RealmTO>> full = new ArrayList<Pair<String, RealmTO>>();
                this.getChildren(full, null, map, "");
                return full;
            }
        };
        this.dynRealmTree = new LoadableDetachableModel<List<DynRealmTO>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<DynRealmTO> load() {
                List<DynRealmTO> dynRealms = RealmChoicePanel.this.realmRestClient.listDynReams();
                Collections.sort(dynRealms, new Comparator<DynRealmTO>(){

                    @Override
                    public int compare(DynRealmTO left, DynRealmTO right) {
                        if (left == null) {
                            return -1;
                        }
                        if (right == null) {
                            return 1;
                        }
                        return left.getKey().compareTo(right.getKey());
                    }
                });
                return dynRealms;
            }
        };
        this.container = new WebMarkupContainer("container", this.realmTree);
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.availableRealms = SyncopeConsoleSession.get().getAuthRealms();
        this.reloadRealmTree();
    }

    public final void reloadRealmTree() {
        final Label realmLabel = new Label("realmLabel", (IModel)new Model());
        realmLabel.setOutputMarkupId(true);
        this.container.addOrReplace(new Component[]{realmLabel});
        if (((RealmTO)this.model.getObject()).getFullPath().startsWith("/")) {
            realmLabel.setDefaultModel((IModel)new ResourceModel("realmLabel", "Realm"));
        } else {
            realmLabel.setDefaultModel((IModel)new ResourceModel("dynRealmLabel", "Dynamic Realm"));
        }
        final Label label = new Label("realm", (Serializable)((Object)((RealmTO)this.model.getObject()).getFullPath()));
        label.setOutputMarkupId(true);
        this.container.addOrReplace(new Component[]{label});
        DropDownButton realms = new DropDownButton("realms", (IModel)new ResourceModel("select", ""), (IModel)new Model((Serializable)GlyphIconType.folderopen)){
            private static final long serialVersionUID = -5560086780455361131L;

            protected List<AbstractLink> newSubMenuButtons(String buttonMarkupId) {
                RealmTO realmTO;
                RealmChoicePanel.this.links.clear();
                RealmChoicePanel.this.links.add(new BootstrapAjaxLink<RealmTO>(ButtonList.getButtonMarkupId(), (IModel)new Model(), Buttons.Type.Link, (IModel)new ResourceModel("realms", "Realms")){
                    private static final long serialVersionUID = -7978723352517770744L;

                    public void onClick(AjaxRequestTarget target) {
                    }

                    public boolean isEnabled() {
                        return false;
                    }

                    protected void onComponentTag(ComponentTag tag) {
                        tag.put("class", (CharSequence)"panel box box-primary box-header with-border");
                        tag.put("style", (CharSequence)"margin: 20px 5px 0px 5px; width: 90%");
                    }
                });
                for (Pair link : (List)RealmChoicePanel.this.realmTree.getObject()) {
                    realmTO = (RealmTO)link.getValue();
                    RealmChoicePanel.this.links.add(new BootstrapAjaxLink<RealmTO>(ButtonList.getButtonMarkupId(), (IModel)Model.of((Serializable)realmTO), Buttons.Type.Link, (IModel)new Model((Serializable)link.getKey())){
                        private static final long serialVersionUID = -7978723352517770644L;

                        public void onClick(AjaxRequestTarget target) {
                            RealmChoicePanel.this.model.setObject((Serializable)realmTO);
                            label.setDefaultModelObject((Object)((RealmTO)RealmChoicePanel.this.model.getObject()).getFullPath());
                            realmLabel.setDefaultModel((IModel)new ResourceModel("realmLabel", "Realm"));
                            target.add(new Component[]{label});
                            this.send((IEventSink)RealmChoicePanel.this.pageRef.getPage(), Broadcast.EXACT, new ChosenRealm<RealmTO>(realmTO, target));
                        }

                        public boolean isEnabled() {
                            return IterableUtils.matchesAny((Iterable)RealmChoicePanel.this.availableRealms, (Predicate)new Predicate<String>(){

                                public boolean evaluate(String availableRealm) {
                                    return realmTO.getFullPath().startsWith(availableRealm);
                                }
                            });
                        }
                    });
                }
                if (!((List)RealmChoicePanel.this.dynRealmTree.getObject()).isEmpty()) {
                    RealmChoicePanel.this.links.add(new BootstrapAjaxLink<RealmTO>(ButtonList.getButtonMarkupId(), (IModel)new Model(), Buttons.Type.Link, (IModel)new ResourceModel("dynrealms", "Dynamic Realms")){
                        private static final long serialVersionUID = -7978723352517770744L;

                        public void onClick(AjaxRequestTarget target) {
                        }

                        public boolean isEnabled() {
                            return false;
                        }

                        protected void onComponentTag(ComponentTag tag) {
                            tag.put("class", (CharSequence)"panel box box-primary box-header with-border");
                            tag.put("style", (CharSequence)"margin: 20px 5px 0px 5px; width: 90%");
                        }
                    });
                    for (DynRealmTO dynRealmTO : (List)RealmChoicePanel.this.dynRealmTree.getObject()) {
                        realmTO = new RealmTO();
                        realmTO.setKey(dynRealmTO.getKey());
                        realmTO.setName(dynRealmTO.getKey());
                        realmTO.setFullPath(dynRealmTO.getKey());
                        RealmChoicePanel.this.links.add(new BootstrapAjaxLink<RealmTO>(ButtonList.getButtonMarkupId(), (IModel)new Model(), Buttons.Type.Link, (IModel)new Model((Serializable)((Object)realmTO.getKey()))){
                            private static final long serialVersionUID = -7978723352517770644L;

                            public void onClick(AjaxRequestTarget target) {
                                RealmChoicePanel.this.model.setObject((Serializable)realmTO);
                                label.setDefaultModelObject((Object)realmTO.getKey());
                                realmLabel.setDefaultModel((IModel)new ResourceModel("dynRealmLabel", "Dynamic Realm"));
                                target.add(new Component[]{label});
                                this.send((IEventSink)RealmChoicePanel.this.pageRef.getPage(), Broadcast.EXACT, new ChosenRealm<RealmTO>(realmTO, target));
                            }

                            public boolean isEnabled() {
                                return IterableUtils.matchesAny((Iterable)RealmChoicePanel.this.availableRealms, (Predicate)new Predicate<String>(){

                                    public boolean evaluate(String availableRealm) {
                                        return "/".equals(availableRealm) || realmTO.getKey().equals(availableRealm);
                                    }
                                });
                            }
                        });
                    }
                }
                return RealmChoicePanel.this.links;
            }
        };
        realms.setOutputMarkupId(true);
        realms.setAlignment(AlignmentBehavior.Alignment.RIGHT);
        realms.setType(Buttons.Type.Menu);
        MetaDataRoleAuthorizationStrategy.authorize((Component)realms, (Action)ENABLE, (String)"REALM_LIST");
        this.container.addOrReplace(new Component[]{realms});
    }

    public final RealmChoicePanel reloadRealmTree(AjaxRequestTarget target) {
        this.reloadRealmTree();
        target.add(new Component[]{this.container});
        return this;
    }

    public final RealmChoicePanel reloadRealmTree(AjaxRequestTarget target, Model<RealmTO> newModel) {
        this.model = newModel;
        this.reloadRealmTree(target);
        return this;
    }

    private Map<String, Pair<RealmTO, List<RealmTO>>> reloadRealmParentMap() {
        List<RealmTO> realms = this.realmRestClient.list();
        Collections.sort(realms, new RealmNameComparator());
        return this.reloadRealmParentMap(realms);
    }

    private Map<String, Pair<RealmTO, List<RealmTO>>> reloadRealmParentMap(List<RealmTO> realms) {
        this.tree.clear();
        this.tree.put(null, (Pair<RealmTO, List<RealmTO>>)Pair.of((Object)realms.get(0), new ArrayList()));
        HashMap<String, ArrayList<RealmTO>> cache = new HashMap<String, ArrayList<RealmTO>>();
        for (RealmTO realm : realms) {
            ArrayList children = new ArrayList();
            this.tree.put(realm.getKey(), (Pair<RealmTO, List<RealmTO>>)Pair.of((Object)realm, children));
            if (cache.containsKey(realm.getKey())) {
                children.addAll((Collection)cache.get(realm.getKey()));
                cache.remove(realm.getKey());
            }
            if (this.tree.containsKey(realm.getParent())) {
                ((List)this.tree.get(realm.getParent()).getRight()).add(realm);
                continue;
            }
            if (cache.containsKey(realm.getParent())) {
                ((List)cache.get(realm.getParent())).add(realm);
                continue;
            }
            cache.put(realm.getParent(), new ArrayList<RealmTO>(Collections.singleton(realm)));
        }
        return this.tree;
    }

    public RealmTO getCurrentRealm() {
        return (RealmTO)this.model.getObject();
    }

    public void setCurrentRealm(RealmTO realmTO) {
        this.model.setObject((Serializable)realmTO);
    }

    public RealmTO moveToParentRealm(String key) {
        for (Pair<RealmTO, List<RealmTO>> subtree : this.tree.values()) {
            for (RealmTO child : (List)subtree.getRight()) {
                if (child.getKey() == null || !child.getKey().equals(key)) continue;
                this.model.setObject((Serializable)subtree.getLeft());
                return (RealmTO)subtree.getLeft();
            }
        }
        return null;
    }

    public List<AbstractLink> getLinks() {
        return this.links;
    }

    public static class ChosenRealm<T> {
        private final AjaxRequestTarget target;
        private final T obj;

        public ChosenRealm(T obj, AjaxRequestTarget target) {
            this.obj = obj;
            this.target = target;
        }

        public T getObj() {
            return this.obj;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }
    }

    private static class RealmNameComparator
    implements Comparator<RealmTO>,
    Serializable {
        private static final long serialVersionUID = 7085057398406518811L;

        private RealmNameComparator() {
        }

        @Override
        public int compare(RealmTO r1, RealmTO r2) {
            if (r1 == null && r2 == null) {
                return 0;
            }
            if (r1 != null && r2 != null) {
                return r1.getName().compareTo(r2.getName());
            }
            if (r1 == null && r2 != null) {
                return -1;
            }
            return 1;
        }
    }
}

