/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.util.Arrays;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.panels.AbstractSchemaDetailsPanel;
import org.apache.syncope.client.console.panels.DerSchemaDetails;
import org.apache.syncope.client.console.panels.PlainSchemaDetails;
import org.apache.syncope.client.console.panels.VirSchemaDetails;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.common.lib.to.AbstractSchemaTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.Model;

public class SchemaModalPanel
extends AbstractModalPanel<AbstractSchemaTO> {
    private static final long serialVersionUID = -4681998932778822125L;
    private final AbstractSchemaDetailsPanel schemaPanel;
    private final AbstractSchemaTO schemaTO;

    public SchemaModalPanel(BaseModal<AbstractSchemaTO> modal, AbstractSchemaTO schemaTO, PageReference pageRef) {
        super(modal, pageRef);
        this.schemaTO = schemaTO;
        Form kindForm = new Form("kindForm");
        this.add(new Component[]{kindForm});
        AjaxDropDownChoicePanel kind = new AjaxDropDownChoicePanel("kind", this.getString("kind"), new Model());
        kind.setChoices(Arrays.asList(SchemaType.values()));
        kind.setOutputMarkupId(true);
        kind.setModelObject(SchemaType.fromToClass(schemaTO.getClass()));
        kind.setEnabled(false);
        kindForm.add(new Component[]{kind});
        this.schemaPanel = this.getSchemaPanel("details", SchemaType.fromToClass(schemaTO.getClass()), modal);
        this.schemaPanel.setOutputMarkupId(true);
        this.addOrReplace(new Component[]{this.schemaPanel});
    }

    private AbstractSchemaDetailsPanel getSchemaPanel(String id, SchemaType schemaType, BaseModal<AbstractSchemaTO> modal) {
        AbstractSchemaDetailsPanel panel;
        if (this.schemaTO.getKey() != null) {
            try {
                Class schemaTOClass = schemaType.getToClass();
                modal.setFormModel((AbstractSchemaTO)schemaTOClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException ex) {
                LOG.error("SchemaType not found", (Throwable)ex);
            }
        }
        switch (schemaType) {
            case DERIVED: {
                panel = new DerSchemaDetails(id, this.pageRef, this.schemaTO);
                break;
            }
            case VIRTUAL: {
                panel = new VirSchemaDetails(id, this.pageRef, this.schemaTO);
                break;
            }
            default: {
                panel = new PlainSchemaDetails(id, this.pageRef, this.schemaTO);
            }
        }
        panel.setOutputMarkupId(true);
        return panel;
    }
}

