/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.SchemaModalPanel;
import org.apache.syncope.client.console.panels.TypesDirectoryPanel;
import org.apache.syncope.client.console.panels.WizardModalPanel;
import org.apache.syncope.client.console.rest.ConfRestClient;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.BooleanPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.AbstractModalPanelBuilder;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.common.lib.to.AbstractSchemaTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.springframework.util.ReflectionUtils;

public class SchemaTypePanel
extends TypesDirectoryPanel<AbstractSchemaTO, SchemaProvider, SchemaRestClient> {
    private static final long serialVersionUID = 3905038169553185171L;
    private static final Map<SchemaType, List<String>> COL_NAMES = new HashMap<SchemaType, List<String>>(){
        private static final long serialVersionUID = 3109256773218160485L;
        {
            this.put(SchemaType.PLAIN, Arrays.asList("key", "type", "mandatoryCondition", "uniqueConstraint", "multivalue", "readonly"));
            this.put(SchemaType.DERIVED, Arrays.asList("key", "expression"));
            this.put(SchemaType.VIRTUAL, Arrays.asList("key", "resource", "anyType", "extAttrName", "readonly"));
        }
    };
    private final SchemaType schemaType;

    public SchemaTypePanel(String id, final SchemaType schemaType, PageReference pageRef) {
        super(id, pageRef);
        this.restClient = new SchemaRestClient();
        this.disableCheckBoxes();
        this.schemaType = schemaType;
        try {
            this.addNewItemPanelBuilder(new AbstractModalPanelBuilder<AbstractSchemaTO>((AbstractSchemaTO)schemaType.getToClass().newInstance(), pageRef){
                private static final long serialVersionUID = -6388405037134399367L;

                @Override
                public WizardModalPanel<AbstractSchemaTO> build(String id, int index, AjaxWizard.Mode mode) {
                    final AbstractSchemaTO modelObject = (AbstractSchemaTO)this.newModelObject();
                    return new SchemaModalPanel(SchemaTypePanel.this.modal, modelObject, this.pageRef){
                        private static final long serialVersionUID = -6227956682141146095L;

                        @Override
                        public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                            try {
                                if (this.getOriginalItem() == null || StringUtils.isBlank((CharSequence)((AbstractSchemaTO)this.getOriginalItem()).getKey())) {
                                    ((SchemaRestClient)SchemaTypePanel.this.restClient).create(schemaType, modelObject);
                                } else {
                                    ((SchemaRestClient)SchemaTypePanel.this.restClient).update(schemaType, modelObject);
                                }
                                SchemaTypePanel.this.updateResultTable(target);
                                SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
                                this.modal.close((IPartialPageRequestHandler)target);
                            }
                            catch (Exception e) {
                                LOG.error("While creating or updating {}", (Object)modelObject, (Object)e);
                                SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage())));
                            }
                            ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                        }
                    };
                }
            }, true);
            this.initResultTable();
            MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"SCHEMA_LIST");
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.error("Error create new schema", (Throwable)e);
        }
    }

    @Override
    protected SchemaProvider dataProvider() {
        return new SchemaProvider(this.rows, this.schemaType);
    }

    @Override
    protected String paginatorRowsKey() {
        return "anytype.paginator.rows";
    }

    @Override
    protected Collection<ActionLink.ActionType> getBulkActions() {
        return Collections.emptyList();
    }

    @Override
    protected List<IColumn<AbstractSchemaTO, String>> getColumns() {
        ArrayList<IColumn<AbstractSchemaTO, String>> columns = new ArrayList<IColumn<AbstractSchemaTO, String>>();
        for (final String field : COL_NAMES.get(this.schemaType)) {
            Field clazzField = ReflectionUtils.findField((Class)this.schemaType.getToClass(), (String)field);
            if (clazzField == null) continue;
            if (clazzField.getType().equals(Boolean.class) || clazzField.getType().equals(Boolean.TYPE)) {
                columns.add((IColumn<AbstractSchemaTO, String>)new BooleanPropertyColumn((IModel<String>)new ResourceModel(field), field, field));
                continue;
            }
            PropertyColumn<AbstractSchemaTO, String> column = new PropertyColumn<AbstractSchemaTO, String>((IModel)new ResourceModel(field), field, field){
                private static final long serialVersionUID = 3282547854226892169L;

                public String getCssClass() {
                    String css = super.getCssClass();
                    if ("key".equals(field)) {
                        css = StringUtils.isBlank((CharSequence)css) ? "col-xs-1" : css + " col-xs-1";
                    }
                    return css;
                }
            };
            columns.add((IColumn<AbstractSchemaTO, String>)column);
        }
        return columns;
    }

    @Override
    public ActionsPanel<AbstractSchemaTO> getActions(final IModel<AbstractSchemaTO> model) {
        ActionsPanel<AbstractSchemaTO> panel = super.getActions(model);
        panel.add(new ActionLink<AbstractSchemaTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, AbstractSchemaTO ignore) {
                SchemaTypePanel.this.send((IEventSink)SchemaTypePanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent<Serializable>((Serializable)model.getObject(), target));
            }
        }, ActionLink.ActionType.EDIT, "SCHEMA_UPDATE");
        panel.add(new ActionLink<AbstractSchemaTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, AbstractSchemaTO ignore) {
                try {
                    switch (SchemaTypePanel.this.schemaType) {
                        case DERIVED: {
                            ((SchemaRestClient)SchemaTypePanel.this.restClient).deleteDerSchema(((AbstractSchemaTO)model.getObject()).getKey());
                            break;
                        }
                        case VIRTUAL: {
                            ((SchemaRestClient)SchemaTypePanel.this.restClient).deleteVirSchema(((AbstractSchemaTO)model.getObject()).getKey());
                            break;
                        }
                        default: {
                            ((SchemaRestClient)SchemaTypePanel.this.restClient).deletePlainSchema(((AbstractSchemaTO)model.getObject()).getKey());
                        }
                    }
                    SyncopeConsoleSession.get().info((Serializable)((Object)SchemaTypePanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{SchemaTypePanel.this.container});
                }
                catch (Exception e) {
                    DirectoryPanel.LOG.error("While deleting {}", model.getObject(), (Object)e);
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage())));
                }
                ((BasePage)SchemaTypePanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "SCHEMA_DELETE", true);
        return panel;
    }

    protected final class SchemaProvider
    extends DirectoryDataProvider<AbstractSchemaTO> {
        private static final long serialVersionUID = -185944053385660794L;
        private final SortableDataProviderComparator<AbstractSchemaTO> comparator;
        private final SchemaType schemaType;
        private final ConfRestClient confRestClient;

        private SchemaProvider(int paginatorRows, SchemaType schemaType) {
            super(paginatorRows);
            this.confRestClient = new ConfRestClient();
            this.schemaType = schemaType;
            this.setSort("key", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<AbstractSchemaTO>(this);
        }

        public Iterator<AbstractSchemaTO> iterator(long first, long count) {
            List list = ((SchemaRestClient)SchemaTypePanel.this.restClient).getSchemas(this.schemaType, new String[0]);
            Collections.sort(list, this.comparator);
            if (SchemaType.PLAIN == this.schemaType) {
                ArrayList configurations = new ArrayList();
                CollectionUtils.collect(this.confRestClient.list(), (Transformer)new Transformer<AttrTO, String>(){

                    public String transform(AttrTO attrTO) {
                        return attrTO.getSchema();
                    }
                }, configurations);
                ArrayList<AbstractSchemaTO> res = new ArrayList<AbstractSchemaTO>();
                for (AbstractSchemaTO item : list) {
                    if (configurations.contains(item.getKey())) continue;
                    res.add(item);
                }
                return res.subList((int)first, (int)first + (int)count).iterator();
            }
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            int size = ((SchemaRestClient)SchemaTypePanel.this.restClient).getSchemas(this.schemaType, new String[0]).size();
            return SchemaType.PLAIN == this.schemaType ? (long)(size - this.confRestClient.list().size()) : (long)size;
        }

        public IModel<AbstractSchemaTO> model(AbstractSchemaTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

