/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TogglePanel<T extends Serializable>
extends WizardMgtPanel<T> {
    private static final long serialVersionUID = -2025535531121434056L;
    protected static final Logger LOG = LoggerFactory.getLogger(TogglePanel.class);
    private final WebMarkupContainer container;
    private Status status = Status.INACTIVE;
    private final Label header;
    private final String activeId;

    public TogglePanel(String id, PageReference pageRef) {
        this(id, id, pageRef);
    }

    public TogglePanel(String id, String markupId, PageReference pageRef) {
        super(id, true);
        this.activeId = markupId;
        this.setRenderBodyOnly(true);
        this.setOutputMarkupId(true);
        this.disableContainerAutoRefresh();
        this.setPageRef(pageRef);
        this.container = new WebMarkupContainer("togglePanelContainer");
        super.addInnerObject(this.container.setMarkupId(markupId == null ? id : markupId));
        this.header = new Label("label", (Serializable)((Object)""));
        this.header.setOutputMarkupId(true);
        this.container.add(new Component[]{this.header});
        this.container.add(new Component[]{new AjaxLink<Void>("close"){
            private static final long serialVersionUID = 5538299138211283825L;

            public void onClick(AjaxRequestTarget target) {
                TogglePanel.this.toggle(target, false);
            }
        }.add(new Behavior[]{new AjaxEventBehavior("click"){
            private static final long serialVersionUID = -9027652037484739586L;

            protected String findIndicatorId() {
                return "";
            }

            protected void onEvent(AjaxRequestTarget target) {
            }
        }})});
    }

    public TogglePanel<T> addInnerObject(Component ... childs) {
        this.container.addOrReplace(childs);
        return this;
    }

    protected void setHeader(AjaxRequestTarget target, String header) {
        this.header.setDefaultModelObject((Object)(header == null ? "" : (header.length() >= 40 ? header.substring(0, 30) + " ... " : header)));
        target.add(new Component[]{this.header});
    }

    public void close(AjaxRequestTarget target) {
        this.toggle(target, false);
    }

    public void toggle(AjaxRequestTarget target, boolean toggle) {
        String selector = String.format("$(\"div#%s\")", this.activeId);
        if (toggle) {
            if (this.status == Status.INACTIVE) {
                target.add(new Component[]{this.container});
                target.appendJavaScript((CharSequence)(selector + ".toggle(\"slow\");" + selector + ".attr(\"class\", \"toggle-menu active-toggle-menu\");"));
                this.status = Status.ACTIVE;
            } else if (this.status == Status.ACTIVE) {
                target.appendJavaScript((CharSequence)(selector + ".not(':visible').toggle(\"slow\").removeClass(\"inactive-toggle-menu\").addClass(\"active-toggle-menu\");"));
            }
        } else if (this.status == Status.ACTIVE) {
            target.appendJavaScript((CharSequence)(selector + ".toggle(\"slow\");" + selector + ".attr(\"class\", \"toggle-menu inactive-toggle-menu\");"));
            this.status = Status.INACTIVE;
        }
    }

    private static enum Status {
        INACTIVE,
        ACTIVE;

    }
}

