/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleApplication;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.pages.ModelerPopupPage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.NewWorkflowProcess;
import org.apache.syncope.client.console.rest.WorkflowRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.BooleanPropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ImageModalPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.XMLEditorPanel;
import org.apache.syncope.client.console.wizards.AjaxWizardBuilder;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.WorkflowDefinitionTO;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.io.IOUtils;

public class WorkflowDirectoryPanel
extends DirectoryPanel<WorkflowDefinitionTO, WorkflowDefinitionTO, WorkflowDefinitionDataProvider, WorkflowRestClient> {
    private static final long serialVersionUID = 2705668831139984998L;
    private final BaseModal<String> utility;
    private String modelerCtx;

    protected WorkflowDirectoryPanel(String id, Builder builder) {
        super(id, builder);
        this.addNewItemPanelBuilder(new AjaxWizardBuilder<WorkflowDefinitionTO>(new WorkflowDefinitionTO(), this.pageRef){
            private static final long serialVersionUID = 1633859795677053912L;

            @Override
            protected WizardModel buildModelSteps(WorkflowDefinitionTO modelObject, WizardModel wizardModel) {
                return wizardModel;
            }
        }, false);
        final NewWorkflowProcess newWorkflowProcess = new NewWorkflowProcess("newWorkflowProcess", this.container, this.pageRef);
        this.addInnerObject(new Component[]{newWorkflowProcess});
        AjaxLink<Void> newWorkflowProcessLink = new AjaxLink<Void>("add"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                newWorkflowProcess.toggle(target, true);
            }
        };
        ((WebMarkupContainer)this.get("container:content")).addOrReplace(new Component[]{newWorkflowProcessLink});
        this.setShowResultPage(true);
        this.modal.size(Modal.Size.Large);
        this.utility = new BaseModal("outer");
        this.addOuterObject(new Component[]{this.utility});
        this.utility.size(Modal.Size.Large);
        AjaxSubmitLink xmlEditorSubmit = this.utility.addSubmitButton();
        MetaDataRoleAuthorizationStrategy.authorize((Component)xmlEditorSubmit, (Action)RENDER, (String)"WORKFLOW_DEF_SET");
        this.utility.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                WorkflowDirectoryPanel.this.utility.show(false);
                WorkflowDirectoryPanel.this.utility.close((IPartialPageRequestHandler)target);
            }
        });
        this.initResultTable();
        this.modelerCtx = null;
        try {
            File baseDir;
            if (SyncopeConsoleApplication.get().getActivitiModelerDirectory() != null && (baseDir = new File(SyncopeConsoleApplication.get().getActivitiModelerDirectory())).exists() && baseDir.canRead() && baseDir.isDirectory()) {
                this.modelerCtx = "activiti-modeler";
            }
            if (SyncopeConsoleApplication.get().getFlowableModelerDirectory() != null && (baseDir = new File(SyncopeConsoleApplication.get().getFlowableModelerDirectory())).exists() && baseDir.canRead() && baseDir.isDirectory()) {
                this.modelerCtx = "flowable-modeler";
            }
        }
        catch (Exception e) {
            LOG.error("Could not check for Modeler directory", (Throwable)e);
        }
    }

    @Override
    protected WorkflowDefinitionDataProvider dataProvider() {
        return new WorkflowDefinitionDataProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "workflow.paginator.rows";
    }

    @Override
    protected List<IColumn<WorkflowDefinitionTO, String>> getColumns() {
        ArrayList<IColumn<WorkflowDefinitionTO, String>> columns = new ArrayList<IColumn<WorkflowDefinitionTO, String>>();
        columns.add((IColumn<WorkflowDefinitionTO, String>)new KeyPropertyColumn((IModel<String>)new ResourceModel("key"), "key"));
        columns.add((IColumn<WorkflowDefinitionTO, String>)new PropertyColumn((IModel)new ResourceModel("name"), (Object)"name", "name"));
        columns.add((IColumn<WorkflowDefinitionTO, String>)new BooleanPropertyColumn((IModel<String>)new ResourceModel("main"), null, "main"));
        return columns;
    }

    @Override
    public ActionsPanel<WorkflowDefinitionTO> getActions(final IModel<WorkflowDefinitionTO> model) {
        ActionsPanel<WorkflowDefinitionTO> panel = super.getActions(model);
        panel.add(new ActionLink<WorkflowDefinitionTO>(){
            private static final long serialVersionUID = -184018732772021627L;

            @Override
            public void onClick(AjaxRequestTarget target, WorkflowDefinitionTO ignore) {
                Model wfDefinition = new Model();
                try {
                    wfDefinition.setObject((Object)IOUtils.toString((InputStream)((WorkflowRestClient)WorkflowDirectoryPanel.this.restClient).getDefinition(MediaType.APPLICATION_XML_TYPE, ((WorkflowDefinitionTO)model.getObject()).getKey())));
                }
                catch (IOException e) {
                    DirectoryPanel.LOG.error("Could not get workflow definition", (Throwable)e);
                }
                WorkflowDirectoryPanel.this.utility.header((IModel)Model.of((Serializable)((Object)((WorkflowDefinitionTO)model.getObject()).getKey())));
                WorkflowDirectoryPanel.this.utility.setContent(new XMLEditorPanel(WorkflowDirectoryPanel.this.utility, (IModel)wfDefinition, false, WorkflowDirectoryPanel.this.pageRef, (IModel)wfDefinition){
                    private static final long serialVersionUID = -7688359318035249200L;
                    final /* synthetic */ IModel val$wfDefinition;
                    {
                        this.val$wfDefinition = iModel;
                        super(modal, (IModel<String>)content, readOnly, pageRef);
                    }

                    @Override
                    public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                        if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.val$wfDefinition.getObject()))) {
                            try {
                                ((WorkflowRestClient)WorkflowDirectoryPanel.this.restClient).setDefinition(MediaType.APPLICATION_XML_TYPE, ((WorkflowDefinitionTO)model.getObject()).getKey(), (String)this.val$wfDefinition.getObject());
                                SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
                                target.add(new Component[]{WorkflowDirectoryPanel.this.container});
                                WorkflowDirectoryPanel.this.utility.show(false);
                                WorkflowDirectoryPanel.this.utility.close((IPartialPageRequestHandler)target);
                            }
                            catch (SyncopeClientException e) {
                                SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
                            }
                            ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                        }
                    }
                });
                WorkflowDirectoryPanel.this.utility.show((IPartialPageRequestHandler)target);
                target.add(new Component[]{WorkflowDirectoryPanel.this.utility});
            }
        }, ActionLink.ActionType.EDIT, "WORKFLOW_DEF_SET");
        panel.add(new ActionLink<WorkflowDefinitionTO>(){
            private static final long serialVersionUID = 3109256773218160485L;

            @Override
            public void onClick(AjaxRequestTarget target, WorkflowDefinitionTO ignore) {
                WorkflowDirectoryPanel.this.modal.header((IModel)Model.of((Serializable)((Object)((WorkflowDefinitionTO)model.getObject()).getKey())));
                WorkflowDirectoryPanel.this.modal.setContent(new ImageModalPanel(WorkflowDirectoryPanel.this.modal, ((WorkflowRestClient)WorkflowDirectoryPanel.this.restClient).getDiagram(((WorkflowDefinitionTO)model.getObject()).getKey()), WorkflowDirectoryPanel.this.pageRef));
                WorkflowDirectoryPanel.this.modal.show((IPartialPageRequestHandler)target);
                target.add(new Component[]{WorkflowDirectoryPanel.this.modal});
            }
        }, ActionLink.ActionType.VIEW, "WORKFLOW_DEF_GET");
        panel.add(new ActionLink<WorkflowDefinitionTO>(){
            private static final long serialVersionUID = -184018732772021627L;

            @Override
            public Class<? extends Page> getPageClass() {
                return ModelerPopupPage.class;
            }

            @Override
            public PageParameters getPageParameters() {
                PageParameters parameters = new PageParameters();
                if (WorkflowDirectoryPanel.this.modelerCtx != null) {
                    parameters.add("modelerContext", (Object)WorkflowDirectoryPanel.this.modelerCtx);
                }
                parameters.add("modelId", (Object)((WorkflowDefinitionTO)model.getObject()).getModelId());
                return parameters;
            }

            @Override
            protected boolean statusCondition(WorkflowDefinitionTO modelObject) {
                return WorkflowDirectoryPanel.this.modelerCtx != null;
            }

            @Override
            public void onClick(AjaxRequestTarget target, WorkflowDefinitionTO ignore) {
            }
        }, ActionLink.ActionType.WORKFLOW_MODELER, "WORKFLOW_DEF_SET");
        panel.add(new ActionLink<WorkflowDefinitionTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            protected boolean statusCondition(WorkflowDefinitionTO modelObject) {
                return !modelObject.isMain();
            }

            @Override
            public void onClick(AjaxRequestTarget target, WorkflowDefinitionTO ignore) {
                try {
                    ((WorkflowRestClient)WorkflowDirectoryPanel.this.restClient).deleteDefinition(((WorkflowDefinitionTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().info((Serializable)((Object)WorkflowDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{WorkflowDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting workflow definition {}", (Object)((WorkflowDefinitionTO)model.getObject()).getName(), (Object)e);
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
                }
                ((BasePage)WorkflowDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "WORKFLOW_DEF_DELETE", true);
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBulkActions() {
        return Collections.emptyList();
    }

    protected class WorkflowDefinitionDataProvider
    extends DirectoryDataProvider<WorkflowDefinitionTO> {
        private static final long serialVersionUID = 1764153405387687592L;
        private final SortableDataProviderComparator<WorkflowDefinitionTO> comparator;
        private final WorkflowRestClient restClient;

        public WorkflowDefinitionDataProvider(int paginatorRows) {
            super(paginatorRows);
            this.restClient = new WorkflowRestClient();
            this.comparator = new SortableDataProviderComparator<WorkflowDefinitionTO>(this);
            this.setSort("main", SortOrder.DESCENDING);
        }

        public Iterator<WorkflowDefinitionTO> iterator(long first, long count) {
            List<WorkflowDefinitionTO> result = this.restClient.getDefinitions();
            Collections.sort(result, this.comparator);
            return result.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return this.restClient.getDefinitions().size();
        }

        public IModel<WorkflowDefinitionTO> model(WorkflowDefinitionTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }

    public static abstract class Builder
    extends DirectoryPanel.Builder<WorkflowDefinitionTO, WorkflowDefinitionTO, WorkflowRestClient> {
        private static final long serialVersionUID = 5088962796986706805L;

        public Builder(PageReference pageRef) {
            super(new WorkflowRestClient(), pageRef);
        }

        @Override
        protected WizardMgtPanel<WorkflowDefinitionTO> newInstance(String id, boolean wizardInModal) {
            return new WorkflowDirectoryPanel(id, this);
        }
    }
}

